/*
 * Decompiled with CFR 0.152.
 */
package inferno.geom;

import inferno.geom.IDensityField;
import inferno.sim.OccAgent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector2d;
import thunderheadeng.delaunay.DnyUtil;
import thunderheadeng.delaunay.Mesh;
import thunderheadeng.delaunay.TriangulatorInfo;
import thunderheadeng.delaunay.VoronoiInfo;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.Inter2D;
import thunderheadeng.geometry.LineSeg3D;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.RTree;
import thunderheadeng.geometry.Util;
import thunderheadeng.geometry.Util2D;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.nmt.Face;
import thunderheadeng.geometry.nmt.Model;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.geometry.search.CollResult;
import thunderheadeng.util.theUtil;

public class VorDensityField
implements IDensityField {
    static final long serialVersionUID = 1L;
    public static final boolean DEF_FAST_SEARCHES = true;
    public static final Interpolation DEF_INTERP = Interpolation.SWENSON_AVERAGE;
    private static final double HIDW_P = 2.0;
    private static final double HIDW_FALLOFF_BEGIN = Util.feetToMeters(2.0);
    private static final double HIDW_FALLOFF_END = Util.feetToMeters(4.0);
    private static final double SIDW_MAX_RADIUS = Util.feetToMeters(4.0);
    private static final double SIDW_P = 2.0;
    private static final double SMIDW_MAX_RADIUS = Util.feetToMeters(4.0);
    private static final double SA_MAX_RADIUS = Util.feetToMeters(4.0);
    private final Vertex[] d_verts;
    private final int[] d_tris;
    private final int[] d_adj;
    private final Point2d[] d_vorVerts;
    private final int[][] d_vorPolys;
    private final Map<OccAgent, Face> d_occAreas;
    private Interpolation d_interpolation;
    private boolean d_fastSearches;
    private transient AABox d_geomBounds;
    private transient RTree<Vertex> d_vertSearch;
    private transient int d_lastSearchTri;

    public VorDensityField(Vertex[] verts, int[] tris, int[] adj, Point2d[] vorVerts, int[][] vorCells, AABox geomBounds, Map<OccAgent, Face> occAreas) {
        this.d_verts = verts;
        this.d_tris = tris;
        this.d_adj = adj;
        this.d_vorVerts = vorVerts;
        this.d_vorPolys = vorCells;
        this.d_geomBounds = geomBounds;
        this.d_occAreas = occAreas;
        this.d_fastSearches = true;
        this.d_interpolation = DEF_INTERP;
        this.d_lastSearchTri = -1;
    }

    public Map<OccAgent, Face> getOccAreas() {
        return this.d_occAreas;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.d_lastSearchTri = -1;
    }

    public boolean getFastSearchesEnabled() {
        return this.d_fastSearches;
    }

    public void setFastSearchesEnabled(boolean enabled) {
        this.d_fastSearches = enabled;
        if (this.d_fastSearches) {
            this.d_vertSearch = null;
        }
    }

    public Interpolation getInterpolation() {
        return this.d_interpolation;
    }

    public void setInterpolation(Interpolation interp) {
        this.d_interpolation = interp;
    }

    protected RTree<Vertex> getVertSearch() {
        if (this.d_vertSearch == null) {
            this.d_vertSearch = new RTree();
            for (Vertex v : this.d_verts) {
                Point3d p = new Point3d(v.p.x, v.p.y, 0.0);
                AABox bb = new AABox(p, p);
                this.d_vertSearch.insert(bb, v);
            }
        }
        return this.d_vertSearch;
    }

    public Vertex[] getVerts() {
        return this.d_verts;
    }

    public int[] getTris() {
        return this.d_tris;
    }

    public VoronoiInfo getVoronoiInfo() {
        VoronoiInfo vi = new VoronoiInfo();
        vi.points = this.d_vorVerts;
        vi.polys = this.d_vorPolys;
        return vi;
    }

    public double[] getDensityBounds() {
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        for (Vertex v : this.d_verts) {
            double dens = v.getDensity();
            if (dens < min) {
                min = dens;
            }
            if (!(dens > max)) continue;
            max = dens;
        }
        return new double[]{min, max};
    }

    public AABox getGeometryBounds() {
        if (this.d_geomBounds == null) {
            this.d_geomBounds = new AABox();
            for (Vertex v : this.d_verts) {
                this.d_geomBounds.add(new Point3d(v.p.x, v.p.y, 0.0));
            }
        }
        return this.d_geomBounds;
    }

    @Override
    public double getDensity(Point2d p) {
        switch (this.d_interpolation) {
            case HARDEMAN_IDW: {
                return this.getDensityHardemanIDW(p);
            }
            case LINEAR: {
                return this.getDensityLinear(p);
            }
            case SHEPARD_IDW: {
                return this.getDensityShepardIDW(p);
            }
            case SHEPARD_MODIFIED_IDW: {
                return this.getDensityShepardModifiedIDW(p);
            }
            case SWENSON_AVERAGE: {
                return this.getDensitySwensonAverage(p);
            }
        }
        return Double.NaN;
    }

    private double getDensityLinear(Point2d p) {
        int tri = this.findTri(p);
        if (tri < 0) {
            assert (false);
            return 0.0;
        }
        int toffset = tri * 3;
        Vertex v1 = this.d_verts[this.d_tris[toffset + 0]];
        Vertex v2 = this.d_verts[this.d_tris[toffset + 1]];
        Vertex v3 = this.d_verts[this.d_tris[toffset + 2]];
        double d1 = v1.getDensity();
        double d2 = v2.getDensity();
        double d3 = v3.getDensity();
        double[] interp = Util2D.getInterpolateParams(v1.p, v2.p, v3.p, p);
        double val = Util2D.interpolate(d1, d2, d3, interp);
        return val;
    }

    private double getDensitySwensonAverage(Point2d p) {
        Collection<Vertex> nearVerts = this.getNearVerts(p, SA_MAX_RADIUS);
        double maxRadiusSq = SA_MAX_RADIUS * SA_MAX_RADIUS;
        double densSum = 0.0;
        double numSamples = 0.0;
        for (Vertex v : nearVerts) {
            double distsq = p.distanceSquared(v.p);
            if (distsq > maxRadiusSq) continue;
            double density = v.getDensity();
            densSum += density;
            numSamples += 1.0;
        }
        if (numSamples == 0.0 || densSum == 0.0) {
            return 0.0;
        }
        double v = densSum / numSamples;
        return v;
    }

    private double getDensityShepardModifiedIDW(Point2d p) {
        Collection<Vertex> nearVerts = this.getNearVerts(p, SMIDW_MAX_RADIUS);
        double maxRadiusSq = SMIDW_MAX_RADIUS * SMIDW_MAX_RADIUS;
        double weightedDensity = 0.0;
        double totWeight = 0.0;
        for (Vertex v : nearVerts) {
            double distsq = p.distanceSquared(v.p);
            if (distsq > maxRadiusSq) continue;
            double density = v.getDensity();
            double dist = Math.sqrt(distsq);
            double weight = (SMIDW_MAX_RADIUS - dist) / (SMIDW_MAX_RADIUS * dist);
            weight *= weight;
            totWeight += weight;
            weightedDensity += weight * density;
        }
        if (totWeight == 0.0) {
            return 0.0;
        }
        double v = weightedDensity / totWeight;
        return v;
    }

    private double getDensityShepardIDW(Point2d p) {
        Collection<Vertex> nearVerts = this.getNearVerts(p, SIDW_MAX_RADIUS);
        double maxRadiusSq = SIDW_MAX_RADIUS * SIDW_MAX_RADIUS;
        double weightedDensity = 0.0;
        double totWeight = 0.0;
        for (Vertex v : nearVerts) {
            double distsq = p.distanceSquared(v.p);
            if (distsq > maxRadiusSq) continue;
            double density = v.getDensity();
            double dist = Math.sqrt(distsq);
            double weight = 1.0 / Math.pow(dist, 2.0);
            totWeight += weight;
            weightedDensity += weight * density;
        }
        if (totWeight == 0.0) {
            return 0.0;
        }
        double v = weightedDensity / totWeight;
        return v;
    }

    private double getDensityHardemanIDW(Point2d p) {
        Collection<Vertex> nearVerts = this.getNearVerts(p, HIDW_FALLOFF_END);
        double maxRadiusSq = HIDW_FALLOFF_END * HIDW_FALLOFF_END;
        double weightedDensity = 0.0;
        double totWeight = 0.0;
        for (Vertex v : nearVerts) {
            double distsq = p.distanceSquared(v.p);
            if (distsq > maxRadiusSq) continue;
            double density = v.getDensity();
            double dist = Math.sqrt(distsq);
            double weight = 1.0 / Math.pow(dist, 2.0);
            double falloff = VorDensityField.falloff(dist);
            totWeight += weight;
            weightedDensity += falloff * weight * density;
        }
        if (totWeight == 0.0) {
            return 0.0;
        }
        double v = weightedDensity / totWeight;
        return v;
    }

    private static double falloff(double dist) {
        return dist < HIDW_FALLOFF_BEGIN ? 1.0 : Math.max(0.0, (HIDW_FALLOFF_END - dist) / (HIDW_FALLOFF_END - HIDW_FALLOFF_BEGIN));
    }

    private Collection<Vertex> getNearVerts(Point2d p, double maxRadius) {
        if (this.d_fastSearches) {
            int tri = this.findTri(p);
            if (tri < 0) {
                assert (false);
                return Collections.EMPTY_LIST;
            }
            int triOffset = tri * 3;
            return Arrays.asList(this.d_verts[this.d_tris[triOffset + 0]], this.d_verts[this.d_tris[triOffset + 1]], this.d_verts[this.d_tris[triOffset + 2]]);
        }
        return this.findNearVerts(p, maxRadius);
    }

    private int findTri(Point2d p) {
        DnyUtil.FindResult triResult = DnyUtil.findTriangle(new VertPointList(this.d_verts), this.d_tris, this.d_adj, p, this.d_lastSearchTri);
        if (triResult != null) {
            this.d_lastSearchTri = triResult.tri;
        }
        return triResult == null ? -1 : triResult.tri;
    }

    private Collection<Vertex> findNearVerts(Point2d p, double maxRadius) {
        AABox test = new AABox(new Point3d(p.x - maxRadius, p.y - maxRadius, 0.0), new Point3d(p.x + maxRadius, p.y + maxRadius, 0.0));
        ArrayList<Vertex> result = new ArrayList<Vertex>();
        this.getVertSearch().find(test, new CollResult(result));
        return result;
    }

    public static class Vertex
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final Point2d p;
        public double val;
        public double area;
        public int index;

        public Vertex(Point2d p, double val, int index) {
            this.p = p;
            this.val = val;
            this.area = Double.NaN;
            this.index = index;
        }

        public String toString() {
            return String.format("Vertex: (%g, %g): %g, %g", this.p.x, this.p.y, this.val, this.area);
        }

        public double getDensity() {
            return this.area == 0.0 ? 0.0 : this.val / this.area;
        }
    }

    public static enum Interpolation {
        HARDEMAN_IDW,
        LINEAR,
        SHEPARD_IDW,
        SHEPARD_MODIFIED_IDW,
        SWENSON_AVERAGE;

    }

    private static class VertPointList
    extends AbstractList<Point2d> {
        private final Vertex[] d_verts;

        public VertPointList(Vertex[] verts) {
            this.d_verts = verts;
        }

        @Override
        public Point2d get(int index) {
            return this.d_verts[index].p;
        }

        @Override
        public int size() {
            return this.d_verts.length;
        }
    }

    public static class Builder {
        private final Mesh d_mesh = new Mesh();
        private final Map<Point2d, Vertex> d_verts = new LinkedHashMap<Point2d, Vertex>();
        private final Collection<OccAgent> d_agents = new HashSet<OccAgent>();

        public Builder(Collection<LineSeg> boundary) {
            int[] edges = new int[boundary.size() * 2];
            int eix = 0;
            for (LineSeg seg : boundary) {
                edges[eix++] = this.add(new Point2d(seg.p1.x, seg.p1.y), 0.0, null);
                edges[eix++] = this.add(new Point2d(seg.p2.x, seg.p2.y), 0.0, null);
            }
            this.d_mesh.addEdges(edges);
        }

        public int add(Point2d p, double value, OccAgent agent) {
            Vertex existing = this.d_verts.get(p);
            if (existing == null) {
                existing = new Vertex(p, value, this.d_verts.size());
                this.d_verts.put(p, existing);
                this.d_mesh.addPoint(p.x, p.y);
            } else {
                existing.val += value;
            }
            if (agent != null) {
                this.d_agents.add(agent);
            }
            return existing.index;
        }

        public VorDensityField build(Collection<LineSeg> nodeGeom) {
            this.d_mesh.setMinAngle(0.0);
            if (!this.d_mesh.triangulateEvenOdd(0)) {
                return null;
            }
            TriangulatorInfo ti = this.d_mesh.getOutput(1);
            VoronoiInfo vi = this.d_mesh.getVoronoiOutput();
            if (vi.polys.length == 0) {
                return null;
            }
            int VPOLYS = 100;
            int CUTEDGES = 101;
            Model m = new Model();
            for (int[] poly : vi.polys) {
                Point3d[] polyPts = new Point3d[poly.length];
                for (int i = 0; i < poly.length; ++i) {
                    Point2d pt = vi.points[poly[i]];
                    polyPts[i] = new Point3d(pt.x, pt.y, 0.0);
                }
                Plane3d plane = Util3D.simplePolygonPlane(Arrays.asList(polyPts), true, 1.0E-6);
                if (plane == null) continue;
                m.addPolygonFace(100, plane, polyPts);
            }
            if (m.getFaces().isEmpty()) {
                return null;
            }
            Object object = nodeGeom.iterator();
            while (object.hasNext()) {
                LineSeg edge = (LineSeg)object.next();
                m.addEdge(101, new LineSeg3D(new Point3d(edge.p1.x, edge.p1.y, 0.0), new Point3d(edge.p2.x, edge.p2.y, 0.0)));
            }
            HashMap<OccAgent, Face> occFaces = new HashMap<OccAgent, Face>();
            for (OccAgent oa : this.d_agents) {
                Face f = m.findFace(new Point3d(oa.getPos().x, oa.getPos().y, 0.0));
                if (f != null) {
                    occFaces.put(oa, f);
                    continue;
                }
                Point3d pt = oa.getPos();
                Point3d min = new Point3d(pt.x - 0.05, pt.y - 0.05, 0.05);
                Point3d max = new Point3d(pt.x + 0.05, pt.y + 0.05, 0.05);
                List<Face> faces = m.findFaces(new AABox(min, max));
                if (faces.size() == 0) {
                    System.err.printf("unable to find face at %s%n", pt);
                    continue;
                }
                occFaces.put(oa, faces.get(0));
            }
            assert (ti.points.length == vi.polys.length);
            for (Point2d p : ti.points) {
                this.d_verts.computeIfAbsent(p, p2 -> new Vertex(p, 0.0, -1));
            }
            int polyix = 0;
            for (Vertex vert : this.d_verts.values()) {
                int[] vorPoly = vi.polys[polyix];
                vert.area = Builder.getCPolyArea(vi.points, vorPoly);
                ++polyix;
            }
            return new VorDensityField(this.d_verts.values().toArray(new Vertex[this.d_verts.size()]), ti.triangles, ti.adjTris, vi.points, vi.polys, null, occFaces);
        }

        private static double getCPolyArea(Point2d[] points, int[] ixes) {
            Point2d[] cpoints = new Point2d[ixes.length];
            for (int m = 0; m < ixes.length; ++m) {
                cpoints[m] = points[ixes[m]];
            }
            return Math.abs(Util2D.simplePolygonArea(cpoints));
        }

        private static double[] getTestValues(int minCount, int maxCount, double min, double max) {
            if (minCount > 0 && maxCount > 0) {
                return new double[]{min, max};
            }
            if (minCount > 0) {
                return new double[]{min};
            }
            if (maxCount > 0) {
                return new double[]{max};
            }
            return new double[0];
        }

        private static Point2d[] clipPoly(Point2d[] poly, AABox clipBounds) {
            double minx = clipBounds.getMinX();
            double miny = clipBounds.getMinY();
            double maxx = clipBounds.getMaxX();
            double maxy = clipBounds.getMaxY();
            int mxCount = 0;
            int MxCount = 0;
            int myCount = 0;
            int MyCount = 0;
            for (int m = 0; m < poly.length; ++m) {
                Point2d p = poly[m];
                if (p.x <= minx) {
                    ++mxCount;
                } else if (p.x >= maxx) {
                    ++MxCount;
                }
                if (p.y <= miny) {
                    ++myCount;
                    continue;
                }
                if (!(p.y >= maxy)) continue;
                ++MyCount;
            }
            int outCount = mxCount + myCount + MxCount + MyCount;
            if (outCount == 0) {
                return poly;
            }
            double[] testx = Builder.getTestValues(mxCount, MxCount, minx, maxx);
            double[] testy = Builder.getTestValues(myCount, MyCount, miny, maxy);
            ArrayList<Point2d> result = new ArrayList<Point2d>(poly.length);
            for (double tx : testx) {
                result.clear();
                double keepSig = tx == minx ? -1.0 : 1.0;
                for (int m = 0; m < poly.length; ++m) {
                    double clipt;
                    Point2d p1 = poly[m];
                    Point2d p2 = poly[(m + 1) % poly.length];
                    double sig1 = Math.signum(tx - p1.x);
                    double sig2 = Math.signum(tx - p2.x);
                    if (sig1 == keepSig) {
                        result.add(p1);
                    }
                    if (sig1 == sig2 || Double.isNaN(clipt = Builder.isectx(p1, p2, tx)) || clipt <= 0.0 || clipt > 1.0) continue;
                    Point2d isect = Util2D.linePoint(p1, p2, clipt);
                    result.add(isect);
                }
                if (result.isEmpty()) {
                    return new Point2d[0];
                }
                poly = result.toArray(new Point2d[result.size()]);
            }
            for (double ty : testy) {
                result.clear();
                for (int m = 0; m < poly.length; ++m) {
                    double clipt;
                    Point2d p1 = poly[m];
                    Point2d p2 = poly[(m + 1) % poly.length];
                    double sig1 = Math.signum(ty - p1.y);
                    double sig2 = Math.signum(ty - p2.y);
                    if (ty == miny && sig1 < 0.0 || ty == maxy && sig1 > 0.0) {
                        result.add(p1);
                    }
                    if (sig1 == sig2 || Double.isNaN(clipt = Builder.isecty(p1, p2, ty)) || clipt <= 0.0 || clipt > 1.0) continue;
                    Point2d isect = Util2D.linePoint(p1, p2, clipt);
                    result.add(isect);
                }
                if (result.isEmpty()) {
                    return new Point2d[0];
                }
                poly = result.toArray(new Point2d[result.size()]);
            }
            return poly;
        }

        private static double isectx(Point2d p1, Point2d p2, double x) {
            double method1 = Builder.isectx1(p1, p2, x);
            double method2 = Builder.isectx2(p1, p2, x);
            assert (Double.isNaN(method1) && Double.isNaN(method2) || theUtil.eq(method1, method2, 1.0E-9)) : String.format("%s -> %s: %g ; %g %g%n", p1, p2, x, method1, method2);
            return method2;
        }

        private static double isectx1(Point2d p1, Point2d p2, double x) {
            double[] isect = Inter2D.isectLineLine(p1, Util2D.vector(p1, p2), new Point2d(x, 0.0), new Vector2d(0.0, 1.0), 1.0E-9);
            return isect == null ? Double.NaN : isect[0];
        }

        private static double isectx2(Point2d p1, Point2d p2, double x) {
            double dx = p2.x - p1.x;
            if (dx == 0.0) {
                return Double.NaN;
            }
            return (x - p1.x) / dx;
        }

        private static double isecty(Point2d p1, Point2d p2, double y) {
            double method1 = Builder.isecty1(p1, p2, y);
            double method2 = Builder.isecty2(p1, p2, y);
            assert (Double.isNaN(method1) && Double.isNaN(method2) || theUtil.eq(method1, method2, 1.0E-9)) : String.format("%s -> %s: %g ; %g %g%n", p1, p2, y, method1, method2);
            return method2;
        }

        private static double isecty1(Point2d p1, Point2d p2, double y) {
            double[] isect = Inter2D.isectLineLine(p1, Util2D.vector(p1, p2), new Point2d(0.0, y), new Vector2d(1.0, 0.0), 1.0E-9);
            return isect == null ? Double.NaN : isect[0];
        }

        private static double isecty2(Point2d p1, Point2d p2, double y) {
            double dy = p2.y - p1.y;
            if (dy == 0.0) {
                return Double.NaN;
            }
            return (y - p1.y) / dy;
        }
    }
}

