/*
 * Decompiled with CFR 0.152.
 */
package inferno.geom;

import java.io.Serializable;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.IParametric2D;
import thunderheadeng.geometry.IParametric3D;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util3D;

public class LineCurve
implements IParametric3D,
Serializable {
    static final long serialVersionUID = 1L;
    public final Point3d p;
    public final Vector3d dir;

    public LineCurve(Point3d p, Vector3d dir) {
        this.p = p;
        this.dir = dir;
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof LineCurve && ((LineCurve)obj).p.equals(this.p) && ((LineCurve)obj).dir.equals(this.dir);
    }

    @Override
    public Point3d get(double t) {
        return Util3D.linePoint(this.p, this.dir, t);
    }

    @Override
    public Vector3d getTangent(double t) {
        return new Vector3d(this.dir);
    }

    @Override
    public double length() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public double getClosestT(Point3d point) {
        return Inter3D.nearestTOnLine(this.p, this.dir, point);
    }

    @Override
    public double[] getIsects(Plane3d plane, double tol) {
        return new double[]{Inter3D.linePlaneIntersectionT(this.p, this.dir, plane, tol)};
    }

    @Override
    public IParametric2D projectToPlane(Plane3d plane, Matrix4d wlXform) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IParametric3D transform(Matrix4d xform) {
        Point3d p2 = Util3D.xform(xform, this.p);
        Vector3d v2 = Util3D.xform(xform, this.dir);
        return new LineCurve(p2, v2);
    }

    @Override
    public IParametric2D transform2D(Matrix4d xform) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IParametric3D reverse() {
        return new LineCurve(this.p, Util3D.negate(this.dir));
    }

    @Override
    public boolean isLinear() {
        return true;
    }

    @Override
    public boolean isFinite() {
        return false;
    }
}

