/*
 * Decompiled with CFR 0.152.
 */
package inferno.geom;

import inferno.data2.TriPoint;
import inferno.geom.Plane3d;
import inferno.geom.PreciseGeom;
import inferno.geom.Util;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.BoundingSphere;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.RTree;
import thunderheadeng.geometry.Util2D;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.theUtil;

public class ConnectedMesh
implements Serializable {
    static final long serialVersionUID = 1L;
    public final Vertex[] verts;
    public final Tri[] tris;
    public final Edge[] edges;
    private transient AABox modelBounds;
    private transient RTree<Tri> triSearch;

    public ConnectedMesh(Vertex[] verts, Edge[] edges, Tri[] tris) {
        this.verts = verts;
        this.edges = edges;
        this.tris = tris;
        this.triSearch = this.calcTriSearch(tris);
        this.modelBounds = this.triSearch.getBoundingBox();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        for (Vertex vertex : this.verts) {
            vertex.writeAdjacency(out);
        }
        for (Serializable serializable : this.edges) {
            ((Edge)serializable).writeAdjacency(out);
        }
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        for (Vertex vertex : this.verts) {
            vertex.readAdjacency(ois);
        }
        for (Serializable serializable : this.edges) {
            ((Edge)serializable).readAdjacency(ois);
        }
        this.triSearch = this.calcTriSearch(this.tris);
        this.modelBounds = this.triSearch.getBoundingBox();
    }

    private RTree<Tri> calcTriSearch(Tri[] tris) {
        RTree<Tri> result = new RTree<Tri>();
        for (int m = 0; m < tris.length; ++m) {
            Tri ctri = tris[m];
            AABox bounds = new AABox(ctri.verts[0].p, ctri.verts[1].p, ctri.verts[2].p);
            result.insert(bounds, ctri);
        }
        return result;
    }

    public Tri find(Point3d p) {
        double[] nearestDist = new double[]{1.0E-6};
        Tri[] nearestTri = new Tri[]{null};
        this.triSearch.find(new BoundingSphere(p, 1.0E-6), (tri, ctmt) -> {
            double dist = tri.plane.distance(p);
            if (dist <= nearestDist[0] && Inter3D.classifyConvexPolyPoint((double)1.0E-6, (Point3d)p, (Point3d[])new Point3d[]{tri.verts[0].p, tri.verts[1].p, tri.verts[2].p}).positive) {
                nearestTri[0] = tri;
                nearestDist[0] = dist;
            }
        });
        return nearestTri[0];
    }

    public EdgeCrossing getCrossedEdges(Tri tri, Point3d source, Vector3d dir, double maxT) throws CrossedEdgesException {
        Point3d dest;
        if (maxT == Double.MAX_VALUE) {
            double extent = this.modelBounds.getMin().distance(this.modelBounds.getMax()) * 1.5;
            maxT = extent / dir.length();
        }
        if (tri.containsExact(dest = Util3D.linePoint(source, dir, maxT))) {
            return null;
        }
        double[] st = new double[2];
        IdentityHashSet traversedTris = new IdentityHashSet();
        ArrayDeque<EdgeCrossNode> open = new ArrayDeque<EdgeCrossNode>();
        open.add(new EdgeCrossNode(tri, null));
        while (!open.isEmpty()) {
            EdgeCrossNode node = (EdgeCrossNode)open.pop();
            tri = node.tri;
            if (!traversedTris.add(tri)) continue;
            for (int m = 0; m < 3; ++m) {
                Tri adjTri = tri.adj(m);
                if (adjTri != null && traversedTris.contains(adjTri)) continue;
                Edge eu = tri.edges[m];
                Util.CopLineLine isectTest = node.crossing == null ? Util.copLineSegLineSegExact(source, dest, eu.n1.p, eu.n2.p, st) : Util.copLineLineSegExact(source, dest, eu.n1.p, eu.n2.p, st);
                if (isectTest != Util.CopLineLine.INTERSECT) {
                    if (isectTest != Util.CopLineLine.COLINEAR) continue;
                    traversedTris.add(adjTri);
                    continue;
                }
                double dirCrossT = st[0] * maxT;
                if (dirCrossT < 0.0) {
                    dirCrossT = 0.0;
                }
                double edgeCrossT = st[1];
                Point3d crossLoc = Util3D.linesegPoint(eu.n1.p, eu.n2.p, edgeCrossT);
                boolean boundary = ConnectedMesh.isBoundaryHit(eu, adjTri, source, dir, dirCrossT);
                if (!boundary && adjTri == null) continue;
                EdgeCrossing.Type ctype = boundary ? EdgeCrossing.Type.BOUNDARY : EdgeCrossing.Type.CROSS;
                Tri crossedTri = adjTri == null ? tri : adjTri;
                EdgeCrossing crossing = new EdgeCrossing(node.crossing, eu, crossLoc, crossedTri, dest, new Vector3d(dir), dirCrossT, ctype);
                if (ctype.terminal || adjTri.containsExact(dest)) {
                    crossing.finalizeCrossings();
                    return crossing;
                }
                if (node.crossing == null && st[0] == 0.0) {
                    Point3d l1 = eu.n1.p;
                    Point3d l2 = eu.n2.p;
                    double orient = PreciseGeom.orient2d(l1.x, l1.y, l2.x, l2.y, dest.x, dest.y);
                    boolean eorient = tri.getEdgeOrient(m);
                    if (eorient && orient > 0.0 || !eorient && orient < 0.0) continue;
                }
                EdgeCrossNode newNode = new EdgeCrossNode(adjTri, crossing);
                open.push(newNode);
            }
        }
        throw new CrossedEdgesException();
    }

    private static boolean isBoundaryHit(Edge edge, Tri enterTri, Point3d p, Vector3d dir, double edgeEnterT) {
        double side;
        if (theUtil.lt0(edgeEnterT, 1.0E-6)) {
            return false;
        }
        boolean boundary = edge.isBoundary();
        if (boundary && theUtil.eq0(edgeEnterT, 1.0E-6) && (side = edge.whichSide(dir, 1.0E-9)) != 0.0) {
            enterTri = edge.getTri(side);
            return enterTri == null;
        }
        return boundary;
    }

    public static class Vertex
    implements Serializable {
        static final long serialVersionUID = 1L;
        public final int id;
        public final Point3d p;
        public transient Tri[] tris;

        public Vertex(int id, Point3d p) {
            this.id = id;
            this.p = p;
        }

        public String toString() {
            return this.p.toString();
        }

        public void writeAdjacency(ObjectOutputStream out) throws IOException {
            out.writeObject(this.tris);
        }

        public void readAdjacency(ObjectInputStream ois) throws IOException, ClassNotFoundException {
            this.tris = (Tri[])ois.readObject();
        }
    }

    public static class Edge
    implements Serializable {
        static final long serialVersionUID = 1L;
        public final int id;
        public Vertex n1;
        public Vertex n2;
        public transient Tri t1;
        public transient Tri t2;

        public Edge(int id, Vertex v1, Vertex v2) {
            this.id = id;
            this.n1 = v1;
            this.n2 = v2;
        }

        public void writeAdjacency(ObjectOutputStream out) throws IOException {
            out.writeObject(this.t1);
            out.writeObject(this.t2);
        }

        public void readAdjacency(ObjectInputStream ois) throws IOException, ClassNotFoundException {
            this.t1 = (Tri)ois.readObject();
            this.t2 = (Tri)ois.readObject();
        }

        public Tri getAdjTri(Tri tri) {
            return tri == this.t1 ? this.t2 : this.t1;
        }

        public double whichSide(Vector3d dir, double tol) {
            double cross = Util2D.cross(this.n2.p.x - this.n1.p.x, this.n2.p.y - this.n1.p.y, dir.x, dir.y);
            return theUtil.eq0(cross, tol) ? 0.0 : cross;
        }

        public Tri getTri(double side) {
            return side >= 0.0 ? this.t1 : this.t2;
        }

        public boolean isBoundary() {
            return this.t1 == null || this.t2 == null;
        }
    }

    public static class Tri
    implements Serializable {
        static final long serialVersionUID = 1L;
        public final int id;
        public final Vertex[] verts;
        public final Plane3d plane;
        public final Edge[] edges;

        public Tri(int id, Vertex[] verts, Edge[] edges) {
            this.id = id;
            this.verts = verts;
            this.edges = edges;
            this.plane = new Plane3d(verts[0].p, verts[1].p, verts[2].p);
        }

        public boolean containsExact(Point3d p) {
            Point3d t1 = this.verts[0].p;
            Point3d t2 = this.verts[1].p;
            Point3d t3 = this.verts[2].p;
            return PreciseGeom.orient2d(t1.x, t1.y, t2.x, t2.y, p.x, p.y) >= 0.0 && PreciseGeom.orient2d(t2.x, t2.y, t3.x, t3.y, p.x, p.y) >= 0.0 && PreciseGeom.orient2d(t3.x, t3.y, t1.x, t1.y, p.x, p.y) >= 0.0;
        }

        public Tri adj(int ix) {
            return this.edges[ix].getAdjTri(this);
        }

        public boolean getEdgeOrient(int ix) {
            Edge e = this.edges[ix];
            return e.n1 == this.verts[ix];
        }
    }

    private static class EdgeCrossNode {
        public final Tri tri;
        public final EdgeCrossing crossing;

        public EdgeCrossNode(Tri tri, EdgeCrossing crossing) {
            this.tri = tri;
            this.crossing = crossing;
        }
    }

    public static class EdgeCrossing
    implements Comparable<EdgeCrossing> {
        public EdgeCrossing parent;
        public final Edge edge;
        public final Tri enterTri;
        public final Point3d enterLoc;
        public final Vector3d tangentVel;
        public final Point3d destPt;
        public final double t;
        public final Type type;

        public EdgeCrossing(EdgeCrossing parent, Edge edge, Point3d loc, Tri dstTri, Point3d dstPt, Vector3d tangentVel, double t, Type type) {
            this.parent = parent;
            this.enterTri = dstTri;
            this.enterLoc = loc;
            this.destPt = dstPt;
            this.edge = edge;
            this.t = t;
            this.tangentVel = tangentVel;
            this.type = type;
        }

        @Override
        public int compareTo(EdgeCrossing o) {
            return Double.compare(this.t, o.t);
        }

        public Point3d traverseInTriangle(double t) {
            return Util3D.linePoint(this.enterLoc, this.tangentVel, t - this.t);
        }

        public static EdgeCrossing find(TriPoint start, Vector3d startDir, EdgeCrossing lastCrossing, double t) {
            EdgeCrossing crossing = lastCrossing;
            while (crossing != null && t < crossing.t) {
                crossing = crossing.parent;
            }
            return crossing;
        }

        public List<EdgeCrossing> flatten() {
            ArrayDeque<EdgeCrossing> queue = new ArrayDeque<EdgeCrossing>();
            EdgeCrossing currcross = this;
            while (currcross != null) {
                queue.addFirst(currcross);
                currcross = currcross.parent;
            }
            return new ArrayList<EdgeCrossing>(queue);
        }

        public void finalizeCrossings() {
            EdgeCrossing crossing = this;
            Util.projectAlongZ(crossing.destPt, crossing.destPt, crossing.enterTri.plane);
            Util.projectAlongZEq(crossing.enterTri.plane, crossing.tangentVel);
            EdgeCrossing nextCrossing = crossing;
            crossing = crossing.parent;
            while (crossing != null) {
                double tdiff = nextCrossing.t - crossing.t;
                if (theUtil.gt0(tdiff, 1.0E-6)) {
                    crossing.tangentVel.sub(nextCrossing.enterLoc, crossing.enterLoc);
                    crossing.tangentVel.scale(1.0 / tdiff);
                } else {
                    crossing.tangentVel.set(0.0, 0.0, 0.0);
                }
                nextCrossing = crossing;
                crossing = crossing.parent;
            }
        }

        public static enum Type {
            BOUNDARY(true),
            CROSS(false);

            public final boolean terminal;

            private Type(boolean terminal) {
                this.terminal = terminal;
            }
        }
    }

    public static class CrossedEdgesException
    extends Exception {
        private static final long serialVersionUID = -6392981793385238755L;

        @Override
        public String getLocalizedMessage() {
            return "Could not finish edge crossing";
        }
    }
}

