/*
 * Decompiled with CFR 0.152.
 */
package inferno.elevator;

import inferno.elevator.Elevator;
import inferno.elevator.ElevatorLevel;
import inferno.elevator.IElevatorSorter;
import java.util.Collections;
import java.util.List;

public class ClosestSorter
implements IElevatorSorter {
    private static final long serialVersionUID = 1L;
    private final Elevator elevator;
    public final List<Integer> d_priorityFloors = Collections.EMPTY_LIST;

    public ClosestSorter(Elevator elevator) {
        this.elevator = elevator;
    }

    @Override
    public int compare(ElevatorLevel elevLvl1, ElevatorLevel elevLvl2) {
        Elevator.Direction lastDir = this.elevator.getLastMovingTravelDir();
        Elevator.Direction l1Dir = this.elevator.getDirection(this.elevator.getCurrentLevel().levelId, elevLvl1.levelId);
        assert (l1Dir != Elevator.Direction.INDETERMINATE);
        Elevator.Direction l2Dir = this.elevator.getDirection(this.elevator.getCurrentLevel().levelId, elevLvl2.levelId);
        assert (l2Dir != Elevator.Direction.INDETERMINATE);
        int l1Diff = this.elevator.getCurrentLevel().levelId - elevLvl1.levelId;
        int l2Diff = this.elevator.getCurrentLevel().levelId - elevLvl2.levelId;
        if (!l1Dir.moving) {
            return -1;
        }
        if (!l2Dir.moving) {
            return 1;
        }
        if (l1Dir == l2Dir || !lastDir.moving) {
            if (Math.abs(l1Diff) < Math.abs(l2Diff)) {
                return -1;
            }
            if (Math.abs(l1Diff) > Math.abs(l2Diff)) {
                return 1;
            }
            return 0;
        }
        if (l1Dir == lastDir) {
            return -1;
        }
        if (l2Dir == lastDir) {
            return 1;
        }
        return 0;
    }

    @Override
    public List<Integer> getPriorityFloors() {
        return this.d_priorityFloors;
    }
}

