/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2.value;

import inferno.data2.value.IFunction1d;
import inferno.sim.KnownFuncs;
import java.io.Serializable;
import java.util.Arrays;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class PiecewiseFunction1d
implements IFunction1d,
Serializable {
    static final long serialVersionUID = 1L;
    public final double[] x;
    public final double[] y;
    public final boolean extrapolate;

    public PiecewiseFunction1d(double[] x, double[] y, boolean extrapolate) {
        assert (x.length >= 2 && x.length == y.length);
        this.x = x;
        this.y = y;
        this.extrapolate = extrapolate;
    }

    public static PiecewiseFunction1d fromPacked(double[] xy, boolean extrapolate) {
        assert (xy.length > 1);
        assert (xy.length % 2 == 0);
        int n = xy.length / 2;
        double[] xs = new double[n];
        double[] ys = new double[n];
        for (int i = 0; i < xy.length; i += 2) {
            xs[i / 2] = xy[i];
            ys[i / 2] = xy[i + 1];
        }
        assert (xy[0] == xs[0]);
        assert (xy[1] == ys[0]);
        assert (xy[xy.length - 2] == xs[xs.length - 1]);
        assert (xy[xy.length - 1] == ys[ys.length - 1]);
        return new PiecewiseFunction1d(xs, ys, extrapolate);
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof PiecewiseFunction1d && ((PiecewiseFunction1d)obj).extrapolate == this.extrapolate && Arrays.equals(((PiecewiseFunction1d)obj).x, this.x) && Arrays.equals(((PiecewiseFunction1d)obj).y, this.y);
    }

    public int hashCode() {
        return 0x5324AEEF ^ Arrays.hashCode(this.x) + Arrays.hashCode(this.y) + Boolean.hashCode(this.extrapolate);
    }

    @Override
    public double getEndX() {
        PiecewiseFunction1d func = this;
        if (func.y.length == 0) {
            return 0.0;
        }
        if (func.y[func.y.length - 1] != 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        for (int i = func.y.length - 1; i >= 0; --i) {
            if (func.y[i] == 0.0) continue;
            return func.x[i + 1];
        }
        return 0.0;
    }

    public static PiecewiseFunction1d newFunction(boolean extrapolate, double ... vals) {
        assert (vals.length % 2 == 0);
        double[] x = new double[vals.length / 2];
        double[] y = new double[vals.length / 2];
        int m = 0;
        while (m < vals.length) {
            int ix = m / 2;
            x[ix] = vals[m++];
            y[ix] = vals[m++];
        }
        return new PiecewiseFunction1d(x, y, extrapolate);
    }

    private final double extrapolate(double t, int i0, int i1) {
        double x0 = this.x[i0];
        double y0 = this.y[i0];
        double m = (this.y[i1] - y0) / (this.x[i1] - x0);
        double b = y0 - m * x0;
        return m * t + b;
    }

    @Override
    public double get(double t) {
        int i = Arrays.binarySearch(this.x, t);
        if (i < 0) {
            if ((i = -i - 1) == 0) {
                return this.extrapolate ? this.extrapolate(t, 0, 1) : this.y[0];
            }
            if (i == this.x.length) {
                return this.extrapolate ? this.extrapolate(t, this.x.length - 2, this.x.length - 1) : this.y[this.y.length - 1];
            }
            return KnownFuncs.linInterp(this.x[i - 1], this.y[i - 1], this.x[i], this.y[i], t);
        }
        return this.y[i];
    }

    @Override
    public JSONObject toJson() {
        JSONObject json = new JSONObject();
        JSONArray jx = new JSONArray();
        for (int i = 0; i < this.x.length; ++i) {
            jx.add(this.x[i]);
        }
        JSONArray jy = new JSONArray();
        for (int i = 0; i < this.y.length; ++i) {
            jy.add(this.y[i]);
        }
        json.put("type", "pw");
        json.put("x", jx);
        json.put("y", jy);
        json.put("extrapolate", this.extrapolate);
        return json;
    }

    @Override
    public double getAUC(double from, double to) {
        assert (to >= from);
        int xStart = this.getXAfter(from);
        if (xStart == -1) {
            if (!this.extrapolate) {
                return this.y[this.y.length - 1] * (to - from);
            }
            return (this.get(from) + this.get(to)) / 2.0 * (to - from);
        }
        int xEnd = this.getXBefore(to);
        if (xEnd == -1) {
            if (!this.extrapolate) {
                return this.y[0] * (to - from);
            }
            return (this.get(from) + this.get(to)) / 2.0 * (to - from);
        }
        if (xStart == xEnd + 1) {
            return (this.get(from) + this.get(to)) / 2.0 * (to - from);
        }
        double auc = 0.0;
        for (int i = xStart; i <= xEnd - 1; ++i) {
            auc += (this.y[i] + this.y[i + 1]) / 2.0 * (this.x[i + 1] - this.x[i]);
        }
        auc += (this.get(from) + this.y[xStart]) / 2.0 * (this.x[xStart] - from);
        return auc += (this.y[xEnd] + this.get(to)) / 2.0 * (to - this.x[xEnd]);
    }

    private int getXAfter(double t) {
        int i = Arrays.binarySearch(this.x, t);
        if (i < 0) {
            return (i = -i - 1) >= this.x.length - 1 ? -1 : i;
        }
        return i >= this.x.length - 1 ? -1 : i + 1;
    }

    private int getXBefore(double t) {
        int i = Arrays.binarySearch(this.x, t);
        if (i < 0) {
            i = -i - 1;
        }
        return i == 0 ? -1 : i - 1;
    }
}

