/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2.seekarea;

import inferno.data2.ANode;
import inferno.data2.SplitEdge;
import inferno.data2.Tri;
import inferno.data2.TriPoint;
import inferno.data2.WingedEdge;
import inferno.data2.ai.GoalUtil;
import inferno.data2.seekarea.ASeekArea;
import inferno.data2.seekarea.ISeekArea;
import inferno.data2.seekarea.IdleParams;
import inferno.data2.seekarea.RoomSeekArea;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.steering.ISteeringBehavior;
import inferno.sim.steering.ITpSource;
import inferno.sim.steering.SteerUtil;
import inferno.sim.steering.inverse.ISeekCalc;
import java.util.Collection;
import java.util.Collections;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Pair;

public class EdgeSeekArea
extends ASeekArea {
    private static final long serialVersionUID = 1L;
    public final Collection<WingedEdge> edges;

    public EdgeSeekArea(Collection<WingedEdge> edges) {
        this(edges, 0);
    }

    public EdgeSeekArea(Collection<WingedEdge> edges, int options) {
        super(options);
        this.edges = edges;
    }

    @Override
    public boolean isEqual(ISeekArea obj) {
        if (obj == this) {
            return true;
        }
        if (!super.isEqual(obj)) {
            return false;
        }
        EdgeSeekArea esa = (EdgeSeekArea)obj;
        return GoalUtil.setsEqual(this.edges, esa.edges);
    }

    @Override
    public ISteeringBehavior getIdleSteer(KB kb, OccAgent agent, IdleParams idleParams) {
        return SteerUtil.newIdleSteer(kb, agent, idleParams, () -> this.getIdleSeek(kb, agent, idleParams), () -> this.getSfpeBackupPoint(kb, agent));
    }

    protected ISeekCalc getIdleSeek(KB kb, OccAgent occ, IdleParams idleParams) {
        LinkedIdentityHashSet<ANode> nodes = new LinkedIdentityHashSet<ANode>();
        for (WingedEdge edge : this.edges) {
            ANode n1 = edge.getNode1();
            ANode n2 = edge.getNode2();
            if (n1 != null) {
                nodes.add(n1);
            }
            if (n2 == null || n2 == n1) continue;
            nodes.add(n2);
        }
        return new RoomSeekArea(nodes).getIdleSeek(kb, occ, idleParams);
    }

    @Override
    public Collection<ANode> getDestinationRooms() {
        return Collections.emptyList();
    }

    @Override
    public TriPoint getDestinationLoc(KB kb, OccAgent occ) {
        return null;
    }

    protected Pair<ITpSource, Vector3d> getSfpeBackupPoint(KB kb, OccAgent occ) {
        SplitEdge[] sedges = kb.getMesh().getShortenedEdges(occ.getGeometryRadius());
        double closestDistSq = Double.MAX_VALUE;
        TriPoint closestPt = null;
        for (WingedEdge we : this.edges) {
            double distSq;
            TriPoint tp;
            SplitEdge se = sedges[we.id];
            if (se == null) {
                Point3d p = Inter3D.nearestPointOnLineSeg(we.p1(), we.p2(), occ.getLoc().p);
                Tri tri = we.isAdjacent(occ.getOcc().tri) ? occ.getOcc().tri : (we.t1 != null ? we.t1 : we.t2);
                tp = new TriPoint(tri, p, we);
            } else {
                tp = se.findClosest(occ.getLoc());
            }
            if (tp == null || !((distSq = occ.getLoc().p.distanceSquared(tp.p)) < closestDistSq)) continue;
            closestDistSq = distSq;
            closestPt = tp;
        }
        return new Pair<TriPoint, Object>(closestPt != null ? closestPt : occ.getLoc(), null);
    }

    @Override
    public boolean contains(KB kb, TriPoint p) {
        return false;
    }
}

