/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2.ai;

import common.data.WaitMode;
import inferno.data2.ai.GoalUtil;
import inferno.data2.ai.IIdleGoal;
import inferno.data2.ai.IIdleGoalInstance;
import inferno.data2.seekarea.ISeekArea;
import inferno.sim.DoorQueue;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.steering.ISteeringBehavior;
import inferno.sim.steering.SteerUtil;
import java.io.Serializable;
import thunderheadeng.util.Pair;

class WaitGoalInstance
implements IIdleGoalInstance,
Serializable {
    static final long serialVersionUID = 1L;
    private final IIdleGoal d_goal;
    private final WaitMode d_mode;
    private final double d_tEnd;

    public WaitGoalInstance(IIdleGoal goal, WaitMode mode, double tEnd) {
        this.d_goal = goal;
        this.d_tEnd = tEnd;
        this.d_mode = mode;
    }

    @Override
    public IIdleGoal getGoal() {
        return this.d_goal;
    }

    public double getTEnd() {
        return this.d_tEnd;
    }

    public WaitMode getWaitMode() {
        return this.d_mode;
    }

    @Override
    public ISteeringBehavior generateSteeringBehavior(KB kb, OccAgent agent) {
        return SteerUtil.newIdleSteer(kb, agent, GoalUtil.toIdleParams(this.d_mode));
    }

    @Override
    public boolean isReached(KB kb, OccAgent agent) {
        return kb.getCurrentSimTime() >= this.d_tEnd;
    }

    @Override
    public void doorCrossed(OccAgent agent, DoorQueue crossedDoor) {
    }

    @Override
    public double getEndTime(KB kb) {
        return this.d_tEnd;
    }

    @Override
    public boolean canInterrupt(KB kb, OccAgent agent) {
        return true;
    }

    @Override
    public Pair<ISeekArea, Serializable> interrupt(KB kb, OccAgent agent) {
        return new Pair<Object, WaitGoalInstance>(null, this);
    }

    @Override
    public boolean resume(KB kb, OccAgent agent, Object resumePacket) {
        return true;
    }
}

