/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2.ai;

import inferno.data2.ai.IGoalInstance;
import inferno.data2.ai.IIdleGoal;
import inferno.data2.ai.IProgressNote;
import inferno.data2.seekarea.ISeekArea;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.steering.ISteeringBehavior;
import java.io.Serializable;

public interface IIdleGoalInstance
extends IGoalInstance,
Serializable {
    public static final long serialVersionUID = 1L;

    @Override
    public IIdleGoal getGoal();

    @Override
    public ISteeringBehavior generateSteeringBehavior(KB var1, OccAgent var2);

    @Override
    default public ISeekArea end(KB kb, OccAgent occ) {
        if (!this.isSeeking(kb, occ)) {
            return null;
        }
        return IGoalInstance.getCurrentAreaAsRoom(kb, occ);
    }

    @Override
    default public IGoalInstance.IdleInfo getIdleInfo(KB kb, OccAgent agent) {
        double endTime = this.getEndTime(kb);
        return Double.isFinite(endTime) ? IGoalInstance.idleStatus(endTime) : IGoalInstance.unknownIdleStatus();
    }

    @Override
    default public ISeekArea getSeekArea(KB kb, OccAgent occ) {
        return null;
    }

    @Override
    default public IProgressNote getProgress(KB kb, OccAgent occ) {
        return IProgressNote.PROGRESSING;
    }

    public double getEndTime(KB var1);
}

