/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2.ai;

import inferno.data2.ANode;
import inferno.data2.OccPriority;
import inferno.data2.ai.IGoal;
import inferno.data2.ai.IGoalInstance;
import inferno.data2.ai.IProgressNote;
import inferno.data2.seekarea.EdgeSeekArea;
import inferno.data2.seekarea.ISeekArea;
import inferno.data2.seekarea.PointSeekArea;
import inferno.geom.SeekCurve;
import inferno.geom.Util;
import inferno.sim.DoorQueue;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.path.EdgeFilters;
import inferno.sim.steering.ISteeringBehavior;
import inferno.sim.steering.LostException;
import inferno.sim.steering.PathFollow;
import inferno.sim.steering.Steer;
import java.io.Serializable;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.LineSeg3D;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.util.Filters;
import thunderheadeng.util.Pair;

public class ControlledOccGoal
implements IGoal,
Serializable {
    static final long serialVersionUID = 1L;
    public static final ControlledOccGoal INSTANCE = new ControlledOccGoal();

    protected ControlledOccGoal() {
    }

    @Override
    public IGoalInstance begin(KB kb, OccAgent agent) {
        return new ControlledOccGoalInstance();
    }

    @Override
    public boolean isImmediate() {
        return false;
    }

    protected static class ControlledOccGoalInstance
    implements IGoalInstance,
    Serializable {
        static final long serialVersionUID = 1L;
        private ANode d_crossedExit = null;

        protected ControlledOccGoalInstance() {
        }

        @Override
        public IGoal getGoal() {
            return INSTANCE;
        }

        @Override
        public boolean canInterrupt(KB kb, OccAgent agent) {
            return false;
        }

        @Override
        public ISeekArea end(KB kb, OccAgent agent) {
            return new EdgeSeekArea(this.d_crossedExit.getDoorEdges());
        }

        @Override
        public boolean isReached(KB kb, OccAgent agent) {
            return this.d_crossedExit != null;
        }

        @Override
        public IGoalInstance.IdleInfo getIdleInfo(KB kb, OccAgent agent) {
            return null;
        }

        @Override
        public void doorCrossed(OccAgent agent, DoorQueue crossedDoor) {
            this.d_crossedExit = crossedDoor != null && crossedDoor.isExitDoor() ? crossedDoor.getNode() : null;
        }

        @Override
        public IProgressNote getProgress(KB kb, OccAgent occ) {
            return IProgressNote.PROGRESSING;
        }

        @Override
        public ISteeringBehavior generateSteeringBehavior(KB kb, OccAgent occ) {
            return new Controls(occ);
        }

        @Override
        public ISeekArea getSeekArea(KB kb, OccAgent occ) {
            return IGoalInstance.getCurrentAreaAsPoint(kb, occ);
        }

        @Override
        public Pair<ISeekArea, Serializable> interrupt(KB kb, OccAgent agent) {
            return new Pair<PointSeekArea, Object>(IGoalInstance.getCurrentAreaAsPoint(kb, agent), null);
        }
    }

    public static class Controls
    implements ISteeringBehavior,
    Serializable {
        private static final long serialVersionUID = 3317538669897715875L;
        private Steer d_steer;

        public Controls(OccAgent oa) {
            this.d_steer = new Steer(null, new Vector3d(), oa.getDirFacing(), OccPriority.init(1, 0.0), 1.0, Filters.acceptAll(), false, true, new OccAgent[0]);
        }

        @Override
        public void done(KB kb, OccAgent occ, boolean interrupted) {
        }

        @Override
        public double getTimeLimit(KB kb, OccAgent agent) {
            return Double.POSITIVE_INFINITY;
        }

        @Override
        public void doorCrossed(double t, OccAgent agent, DoorQueue door) {
        }

        @Override
        public PathFollow getPathFollow(OccAgent agent) {
            return null;
        }

        @Override
        public SeekCurve generateSeekCurve(KB kb, OccAgent agent) throws LostException {
            LineSeg3D curve = new LineSeg3D(agent.getPos(), Util3D.add(agent.getPos(), (Tuple3d)agent.getOcc().orient));
            return Util.generateSeekCurve(kb, agent, curve, true, EdgeFilters.rejectAllExits());
        }

        @Override
        public synchronized Steer steer(KB world, OccAgent agent, SeekCurve seek) {
            return this.d_steer;
        }

        public synchronized void set(Vector3d vel, double turnVel) {
            this.d_steer = new Steer(null, vel, turnVel, this.d_steer.priority, 1.0, this.d_steer.collisionFilter, false, true, new OccAgent[0]);
        }
    }
}

