/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2;

import inferno.data2.QBaseQueue;
import inferno.data2.QPath;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.Set;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.stat.IUrn;

public class QMetaQueue
implements Serializable {
    static final long serialVersionUID = 1L;
    private QBalancingType d_balancingType = QBalancingType.TIME;
    private IUrn<Integer> d_sortUrn = null;
    private QMetaQueue d_parent = null;
    private QMetaQueue d_next = null;
    private Set<QMetaQueue> d_children = new LinkedIdentityHashSet<QMetaQueue>();
    private QMetaQueue d_exit;
    private List<QMetaQueue> d_entries;

    public QMetaQueue(QBalancingType bType, IUrn<Integer> distUrn) {
        this.d_sortUrn = distUrn;
        this.d_balancingType = bType;
    }

    public void setParent(QMetaQueue newParent) {
        this.d_parent = newParent;
    }

    public Set<QMetaQueue> getChildren() {
        return Collections.unmodifiableSet(this.d_children);
    }

    public void addChildren(Collection<? extends QMetaQueue> children) {
        for (QMetaQueue qMetaQueue : children) {
            this.addChild(qMetaQueue);
        }
    }

    public void addChild(QMetaQueue newChild) {
        this.d_children.add(newChild);
    }

    public void changeNext(QMetaQueue next) {
        this.d_next = next;
    }

    public QMetaQueue getNext() {
        return this.d_next;
    }

    public IUrn<Integer> getDistributionUrn() {
        return this.d_sortUrn;
    }

    public QBalancingType getBalancingType() {
        return this.d_balancingType;
    }

    public double getProcessTime(KB kb, OccAgent occ) {
        int numPaths = this.getNumPaths();
        if (numPaths <= 1) {
            return kb.getCurrentSimTime();
        }
        Random rnd = kb.getTimeBasedRandom(occ.getOcc(), 32648477071L);
        int dtInterval = 4 * numPaths;
        int idt = rnd.nextInt(dtInterval);
        return kb.getCurrentSimTime() + kb.getDt() * (double)idt;
    }

    public int getNumPaths() {
        return this.d_children.stream().mapToInt(QMetaQueue::getNumPaths).sum();
    }

    public ProcessOption processOccupant(KB kb, OccAgent occ) {
        ProcessOption chosenOp = null;
        double waitTime = Double.MAX_VALUE;
        switch (this.d_balancingType) {
            case TIME: {
                for (QMetaQueue child : this.d_children) {
                    ProcessOption thisOp = child.processOccupant(kb, occ);
                    if (thisOp == null || chosenOp != null && !(thisOp.waitTime < waitTime)) continue;
                    chosenOp = thisOp;
                    waitTime = chosenOp.waitTime;
                    if (waitTime != 0.0 && (chosenOp.temporary || chosenOp.leader == null || chosenOp.chosenQ == null)) continue;
                    return chosenOp;
                }
                break;
            }
        }
        return chosenOp;
    }

    public static final class QBalancingType
    extends Enum<QBalancingType> {
        public static final /* enum */ QBalancingType TIME = new QBalancingType("auto");
        public static final /* enum */ QBalancingType PROBABILITY = new QBalancingType("prob");
        public static final /* enum */ QBalancingType PROFILE = new QBalancingType("profile");
        public final String type;
        private static final /* synthetic */ QBalancingType[] $VALUES;

        public static QBalancingType[] values() {
            return (QBalancingType[])$VALUES.clone();
        }

        public static QBalancingType valueOf(String name) {
            return Enum.valueOf(QBalancingType.class, name);
        }

        private QBalancingType(String type) {
            this.type = type;
        }

        public static QBalancingType getTypeForString(String typeStr) {
            for (QBalancingType type : QBalancingType.values()) {
                if (!type.type.equalsIgnoreCase(typeStr)) continue;
                return type;
            }
            assert (false);
            return TIME;
        }

        private static /* synthetic */ QBalancingType[] $values() {
            return new QBalancingType[]{TIME, PROBABILITY, PROFILE};
        }

        static {
            $VALUES = QBalancingType.$values();
        }
    }

    public static class ProcessOption
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public boolean temporary;
        public OccAgent leader;
        public QPath chosenQ;
        public QBaseQueue parentQ;
        public double waitTime;

        ProcessOption(boolean temporary, OccAgent leader, QPath cQ, double t) {
            this.temporary = temporary;
            this.leader = leader;
            this.chosenQ = cQ;
            this.parentQ = cQ != null ? cQ.getParentQueue() : null;
            this.waitTime = t;
        }
    }
}

