/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import thunderheadeng.util.theUtil;

public abstract class ABoundedHistory<T>
implements Serializable {
    static final long serialVersionUID = 1L;
    private final BoundedArrayList<Entry<T>> d_history;
    private final double d_tPeriod;

    public ABoundedHistory(double maxTimeHint, double maxFreq) {
        this((int)Math.ceil(maxTimeHint * maxFreq), maxFreq);
    }

    public ABoundedHistory(int maxCount, double maxFreq) {
        this.d_history = new BoundedArrayList(maxCount, 1);
        this.d_tPeriod = 1.0 / maxFreq;
    }

    public double getRecordFrequency() {
        return 1.0 / this.d_tPeriod;
    }

    public double getTMin() {
        if (this.d_history.isEmpty()) {
            return Double.NaN;
        }
        return this.d_history.get((int)0).t;
    }

    public double getTLength(double tCurr) {
        if (this.d_history.isEmpty()) {
            return 0.0;
        }
        return tCurr - this.getTMin();
    }

    protected int getCount() {
        return this.d_history.size();
    }

    protected Entry<T> getEntry(int m) {
        return this.d_history.get(m);
    }

    protected boolean isOverflowed() {
        return this.d_history.isOverflowed();
    }

    public void record(double t, T v) {
        if (this.d_history.isEmpty()) {
            this.d_history.add(new Entry<T>(t, v));
            return;
        }
        Entry curr = this.d_history.get(this.d_history.size() - 1);
        double tNext = curr.t + this.d_tPeriod;
        if (theUtil.lt(t, tNext, 1.0E-4f)) {
            curr.set(this.combine(curr.val, v));
            return;
        }
        if (this.canAddEntry(curr, t, v)) {
            this.d_history.add(new Entry<T>(t, v));
        }
    }

    protected abstract boolean canAddEntry(Entry<T> var1, double var2, T var4);

    protected int findEntry(double t, boolean lowerBound) {
        if (this.d_history.isEmpty()) {
            return -1;
        }
        if (t <= this.getTMin()) {
            return 0;
        }
        int hix = Collections.binarySearch(this.d_history, t);
        if (hix < 0) {
            hix = lowerBound ? -hix - 2 : -hix - 1;
        }
        return hix;
    }

    public boolean isEmpty() {
        return this.d_history.isEmpty();
    }

    protected abstract T combine(T var1, T var2);

    protected static final class BoundedArrayList<T>
    extends ArrayList<T> {
        static final long serialVersionUID = 1L;
        private final int d_max;
        private int d_start;
        private boolean d_overflowed;

        public BoundedArrayList(int max) {
            this.d_max = max;
            this.d_start = 0;
            this.d_overflowed = false;
        }

        public BoundedArrayList(int max, int initialCapacity) {
            super(initialCapacity);
            this.d_max = max;
            this.d_start = 0;
            this.d_overflowed = false;
        }

        public int getMax() {
            return this.d_max;
        }

        public boolean isOverflowed() {
            return this.d_overflowed;
        }

        @Override
        public boolean add(T e) {
            if (this.size() == this.d_max) {
                this.d_overflowed = true;
                int recordIndex = (this.d_start + this.size()) % this.d_max;
                super.set(recordIndex, e);
                this.d_start = (this.d_start + 1) % this.d_max;
            } else {
                if (!super.add(e)) {
                    return false;
                }
                if (this.size() == this.d_max) {
                    this.trimToSize();
                }
            }
            return true;
        }

        @Override
        public T remove(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(int index, T element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            super.clear();
            this.d_start = 0;
        }

        @Override
        public T get(int index) {
            return (T)super.get((this.d_start + index) % this.size());
        }

        @Override
        public T set(int index, T element) {
            return super.set((this.d_start + index) % this.size(), element);
        }

        @Override
        public int indexOf(Object o) {
            int ix = super.indexOf(o);
            return ix < this.d_start ? ix - this.d_start + this.size() : ix - this.d_start;
        }
    }

    protected static final class Entry<T>
    implements Serializable,
    Comparable<Double> {
        static final long serialVersionUID = 1L;
        public final double t;
        public T val;

        public Entry(double t, T val) {
            this.t = t;
            this.val = val;
        }

        public void set(T v) {
            this.val = v;
        }

        @Override
        public int compareTo(Double o) {
            return Double.compare(this.t, o);
        }
    }
}

