/*
 * Decompiled with CFR 0.152.
 */
package inferno;

import inferno.parse2.SimpleParser;
import inferno.sim.Engine;
import inferno.sim.KB;
import inferno.sim.Param;
import inferno.sim.profiling.TimeAccum;
import inferno.test.ParsePth;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Optional;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import merlin.MerlinApp;
import merlin.unitsystem.EnglishUS;
import merlin.unitsystem.SIUS;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.guiJFXFileChooser;
import thunderheadeng.io.FilenameManager;
import thunderheadeng.io.TeciLogging;
import thunderheadeng.util.FileFilters;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.TeciProps;

public class TestSim
extends Application {
    private static Logger LOGGER;

    public TestSim(String[] args) {
        super("TestSim", args, 0);
    }

    public static void main(String[] args) throws Throwable {
        TestSim app = new TestSim(args);
        app.run(args);
    }

    public void handle(Throwable t) {
        t.printStackTrace();
        System.exit(0);
    }

    private void run(String[] args) throws Throwable {
        SIUS.getInstance();
        EnglishUS.getInstance();
        File inFile = null;
        if (args.length > 0) {
            inFile = new File(args[0]);
        }
        if (inFile != null && inFile.isDirectory()) {
            this.runAll(inFile);
            return;
        }
        if (inFile == null || !inFile.exists()) {
            Properties props = new Properties();
            File f = new File("inferno.props");
            if (!f.exists()) {
                f.createNewFile();
            }
            props.load(new FileInputStream(f));
            File lastFile = new File(props.getProperty("last_dir", ""));
            guiJFXFileChooser chooser = new guiJFXFileChooser(lastFile.getName(), lastFile.getParent(), null, (Boolean)true, (Boolean)true, (Boolean)false, FileFilters.EXT_FILTER_INFERNO, FileFilters.EXT_FILTER_PATHFINDER, FileFilters.EXT_FILTER_ZIP);
            inFile = chooser.showOpenDialog();
            if (inFile == null) {
                return;
            }
            props.setProperty("last_dir", inFile.getAbsolutePath());
            props.store(new FileOutputStream("inferno.props"), "");
        }
        assert (inFile != null);
        Optional<PrintStream> output = Optional.empty();
        if (args.length > 1) {
            output = Optional.of(new PrintStream(new File(inFile.getParentFile(), args[1])));
        }
        this.runSingle(inFile, output, true);
    }

    private void runSingle(File inFile, Optional<PrintStream> output, final boolean exitAfterCompletion) throws Throwable {
        TimeAccum ticks = new TimeAccum();
        ticks.begin("INFERNO");
        ticks.begin("STARTUP");
        final Engine engine = TestSim.loadEngine(inFile, ticks);
        KB kb = engine.getKB();
        Param p = kb.getParams();
        if (output.isPresent()) {
            p.err = p.out = output.get();
        }
        if (engine.getGLView() != null) {
            engine.getGLView().addWindowListener(new WindowAdapter(this){

                @Override
                public void windowClosed(WindowEvent e) {
                    int option;
                    if (engine.isFinished()) {
                        System.exit(0);
                    }
                    if ((option = JOptionPane.showConfirmDialog(null, "Would you like to exit inferno?", "Exit?", 0)) == 0 && exitAfterCompletion) {
                        System.exit(0);
                    }
                }
            });
        }
        ticks.end("STARTUP");
        engine.addObserver(new EngineObserver(inFile.getName()));
        engine.run(TestSim.loadPrefs());
        engine.waitUntilFinished(100L);
        ticks.end("INFERNO");
        if (engine.getGLView() == null && exitAfterCompletion) {
            System.exit(0);
        }
    }

    private void runAll(File variationsDir) throws Throwable {
        assert (variationsDir.isDirectory());
        File[] variations = variationsDir.listFiles((dir, name) -> name.endsWith(".pth"));
        ArrayList<Path> paths = new ArrayList<Path>();
        for (File file : variations) {
            paths.add(Paths.get(file.getAbsolutePath(), new String[0]));
        }
        TestSim.sortModelPaths(paths);
        for (Path path : paths) {
            System.out.printf("Running %s%n", path.toString());
            this.runSingle(path.toFile(), Optional.empty(), false);
        }
        System.exit(0);
    }

    private static Engine loadEngine(File inFile, TimeAccum ticks) throws FileNotFoundException, Throwable {
        File dir = inFile.getAbsoluteFile().getParentFile();
        String ext = FilenameManager.splitFilename(inFile.getName())[1].toLowerCase();
        if (ext.equals("zip")) {
            try (ZipFile zfile = new ZipFile(inFile);){
                Engine engine;
                block18: {
                    if (zfile.size() != 1) {
                        throw new IOException(String.format("Expected \"%s\" to contain exactly one file but contains %d.", inFile.getName(), zfile.size()));
                    }
                    ZipEntry entry = zfile.entries().nextElement();
                    InputStream in = zfile.getInputStream(entry);
                    try {
                        engine = TestSim.loadEngine(dir, entry.getName(), ticks, in);
                        if (in == null) break block18;
                    }
                    catch (Throwable throwable) {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    in.close();
                }
                return engine;
            }
        }
        try (FileInputStream in = new FileInputStream(inFile);){
            Engine engine = TestSim.loadEngine(dir, inFile.getName(), ticks, in);
            return engine;
        }
    }

    private static Engine loadEngine(File dir, String probName, TimeAccum ticks, InputStream stream) throws FileNotFoundException, Throwable {
        String ext;
        switch (ext = FilenameManager.splitFilename(probName)[1].toLowerCase()) {
            case "txt": {
                KB kb = TestSim.createKbFromTxt(dir, probName, stream);
                TestSim.initGraphics(kb.getParams());
                return new Engine(kb, kb.getParams(), ticks);
            }
            case "pth": {
                int options = 1;
                KB kb = ParsePth.load(stream, dir, probName, null, options);
                kb.init();
                TestSim.initGraphics(kb.getParams());
                return new Engine(kb, kb.getParams(), ticks);
            }
        }
        throw new IOException(String.format("Unsupported file type for file: %s", probName));
    }

    private static TeciProps loadPrefs() {
        try {
            return MerlinApp.loadAppPreferences();
        }
        catch (IOException e) {
            return new TeciProps();
        }
    }

    private static void initGraphics(Param p) {
        if (p.show_vis) {
            if (p.slower == 0) {
                p.slower = 15;
            }
            System.loadLibrary("FreeImage");
            try {
                TestSim.loadLib("Pathfinder_jni", new String[0]);
            }
            catch (Throwable t) {
                TestSim.loadLib("jawt", new String[0]);
                TestSim.loadLib("Pathfinder_jni", new String[0]);
            }
        }
    }

    private static KB createKbFromTxt(File parent, String name, InputStream is) throws FileNotFoundException {
        SimpleParser sp = new SimpleParser(is, parent, name);
        try {
            sp.run();
        }
        catch (Exception t) {
            LOGGER.severe("parse error [line " + sp.getLastLineN() + "]: " + sp.getLastLine());
            LOGGER.severe(t.getLocalizedMessage());
            t.printStackTrace();
            System.exit(1);
        }
        Param p = sp.getParam();
        String baseName = name;
        baseName = baseName.substring(0, baseName.lastIndexOf(46));
        p.set("out_occ_cumulative", new File(parent, baseName + "_occupants.csv").getPath());
        p.set("out_occ_detailed", new File(parent, baseName + "_occupants_detailed.csv").getPath());
        p.set("out_occ_individual", new File(parent, baseName + "_occupant_{id}.csv").getPath());
        p.set("out_occ_params", new File(parent, baseName + "_occupant_params.csv").getPath());
        return sp.getKB();
    }

    @Override
    protected void loadLibraries() {
    }

    @Override
    public boolean isInstallFolder(File folder) {
        return this.isInstallFolderDefault(folder);
    }

    private static void sortModelPaths(List<Path> paths) {
        try {
            paths.sort((p1, p2) -> {
                String[] filename1 = p1.getFileName().toString().split("_");
                String[] filename2 = p2.getFileName().toString().split("_");
                int id1 = Integer.parseInt(filename1[filename1.length - 1].split("\\.")[0]);
                int id2 = Integer.parseInt(filename2[filename2.length - 1].split("\\.")[0]);
                return Integer.compare(id1, id2);
            });
        }
        catch (NumberFormatException e) {
            paths.sort(Comparator.comparing(p -> p.getFileName()));
        }
    }

    static {
        System.setProperty("sun.awt.exception.handler", TestSim.class.getName());
        TeciLogging.init(Level.INFO);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        LOGGER = Logger.getLogger(TestSim.class.getName());
    }

    private static class EngineObserver
    implements Observer {
        private final String d_probId;

        public EngineObserver(String probId) {
            this.d_probId = probId;
        }

        @Override
        public void update(Observable o, Object arg) {
            IPropertySet meta = (IPropertySet)arg;
            long ts = meta.get(Engine.META_TIME_TS);
            double t = meta.get(Engine.META_TIME_SIM);
            double tWall = meta.get(Engine.META_TIME_WALL);
            int occs = meta.get(Engine.META_OCCS_REM);
            String msg = String.format("TS=%5d  T=%8.3f  T_WALL=%8.3f  OCCS=%5d INPUT=%s%n", ts, t, tWall, occs, this.d_probId);
            LOGGER.info(msg);
        }
    }
}

