/*
 * Decompiled with CFR 0.152.
 */
package fpserver;

import inferno.parse2.SimpleParser;
import inferno.sim.Engine;
import inferno.sim.KB;
import inferno.sim.OccTracker;
import inferno.sim.Param;
import inferno.sim.profiling.TimeAccum;
import inferno.test.ParsePth;
import inferno.test.ParseTxt;
import inferno.test.Tweaks;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import thunderheadeng.util.TeciProps;

public class Prob
extends Thread {
    public static final int STATUS_PASS = 0;
    public static final int STATUS_FAILINTERVALTEST = 1;
    public static final int STATUS_FAILFINALTEST = 2;
    public static final int STATUS_NOSTART = 3;
    public static final int STATUS_FAILTIME = 4;
    public static final int STATUS_FAILINT = 5;
    private final TeciProps d_prefs;
    private File d_inputFile;
    private int d_status;
    private Engine d_engine;
    private Tweaks.ITweak d_tweaks;
    private OccTracker d_occTracker;

    public Prob(TeciProps prefs, String name, File inputFile, Tweaks.ITweak tweaks) throws FileNotFoundException {
        super(name);
        this.d_prefs = prefs;
        this.d_inputFile = inputFile;
        this.d_status = -1;
        this.d_engine = null;
        this.d_tweaks = tweaks;
        this.init();
    }

    private void init() throws FileNotFoundException {
        KB kb;
        SimpleParser parser = null;
        String fn = this.d_inputFile.getName();
        String fileType = fn.substring(fn.lastIndexOf(".") + 1);
        Param p = null;
        try {
            if (fileType.equals("txt")) {
                BufferedInputStream istrm = new BufferedInputStream(new FileInputStream(this.d_inputFile));
                parser = new ParseTxt(istrm, this.d_inputFile.getParentFile(), this.d_inputFile.getName(), this.d_tweaks);
                parser.run();
                kb = parser.getKB();
                p = kb.getParams();
            } else if (fileType.equals("pth")) {
                int options = 1;
                kb = ParsePth.load(this.d_inputFile.getPath(), this.d_inputFile.getParentFile(), this.d_inputFile.getName(), this.d_tweaks, options);
                p = kb.getParams();
                kb.init();
            } else {
                kb = null;
            }
        }
        catch (Throwable t) {
            System.err.println("error loading: " + String.valueOf(this.d_inputFile));
            if (parser != null) {
                System.err.println("parse error [line " + parser.getLastLineN() + "]: " + parser.getLastLine());
            }
            t.printStackTrace();
            this.d_status = 3;
            return;
        }
        assert (p != null && kb != null);
        if (p != null && p.show_vis) {
            System.loadLibrary("FreeImage");
            System.loadLibrary("Pathfinder_jni");
        }
        if (p != null && kb != null) {
            this.d_engine = new Engine(kb, p, new TimeAccum());
            this.d_occTracker = new OccTracker(kb);
            this.d_engine.pause();
            this.d_engine.run(this.d_prefs);
        }
    }

    public int getStatus() {
        return this.d_status;
    }

    public Engine getEngine() {
        return this.d_engine;
    }

    public OccTracker getOccTracker() {
        return this.d_occTracker;
    }
}

