/*
 * Decompiled with CFR 0.152.
 */
package merlin.test;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.swing.JFrame;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;
import merlin.MerlinApp;
import merlin.MerlinPrefs;
import merlin.actions.AMerlinOp;
import merlin.actions.CancelledException;
import merlin.actions.Open;
import merlin.actions.RunInferno;
import merlin.actions.UIHook;
import merlin.data.MerlinData;
import merlin.gui.RunSimDlg;
import thunderheadeng.gui.guiInputDlg;
import thunderheadeng.gui.guiJFXFileChooser;
import thunderheadeng.util.FileFilters;
import thunderheadeng.util.IntVR;
import thunderheadeng.util.TypedProp;

public class BatchFileTest {
    private static final TypedProp<String> DIR_PREF = new TypedProp<String>((Object)"BatchFile.prevdir", String.class);
    private static final MerlinApp s_app = new MerlinApp(new String[0]);
    private static final String STEER_EXT = "steering";
    private static final String SFPE_EXT = "sfpe";
    private static final String SFPE_PLUS_EXT = "sfpe+";

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> BatchFileTest.run(args));
    }

    private static void run(String[] args) {
        guiJFXFileChooser chooser = new guiJFXFileChooser(null, MerlinPrefs.get(DIR_PREF), null, (Boolean)false, (Boolean)false, (Boolean)false, FileFilters.EXT_FILTER_TEXT);
        File f = chooser.showOpenDialog();
        if (f == null) {
            return;
        }
        MerlinPrefs.set(DIR_PREF, f.getParent());
        guiInputDlg<Integer> numProcDlg = new guiInputDlg<Integer>(null, "Num Processors", "Enter the number of concurrent simulations you would like to run.", 2, IntVR.above(0, false), Integer.class);
        if (numProcDlg.doModal() != 1) {
            return;
        }
        int numProc = Math.min(Runtime.getRuntime().availableProcessors(), numProcDlg.getValue());
        boolean showResults = s_app.getBooleanPreference("RunSimDlg_show_results");
        RunInferno.d_closeOnFinish = true;
        s_app.setPreference("RunSimDlg_show_results", Boolean.FALSE.toString());
        File[] pffiles = BatchFileTest.getPFFiles(f);
        PthFilter pthFilter = new PthFilter();
        System.out.println("Deleting old files...");
        for (File pfFile : pffiles) {
            File parent = pfFile.getParentFile();
            File[] files = parent.listFiles(pthFilter);
            if (files == null) continue;
            for (File otherFile : files) {
                BatchFileTest.delete(otherFile);
            }
        }
        JFrame parentFrame = s_app.getMainFrame();
        JFrame newFrame = new JFrame("Progress");
        final ProgressMonitor pm = new ProgressMonitor(newFrame, "Batch Simulation Progress", "", 0, pffiles.length - 1);
        newFrame.setLocationRelativeTo(parentFrame);
        newFrame.setLocation(0, 0);
        newFrame.setVisible(true);
        final int[] numCompleted = new int[]{0};
        final ExecutorService infernoExecutor = Executors.newFixedThreadPool(numProc);
        final Set<String> inQueue = Collections.synchronizedSet(new LinkedHashSet());
        numProc = Math.min(pffiles.length, numProc);
        final ConcurrentLinkedQueue<File> fullFileQueue = new ConcurrentLinkedQueue<File>(Arrays.asList(pffiles));
        final ConcurrentLinkedQueue<File> activeFileQueue = new ConcurrentLinkedQueue<File>();
        for (int m = 0; m < numProc; ++m) {
            activeFileQueue.add((File)fullFileQueue.remove());
        }
        while (!fullFileQueue.isEmpty() || !activeFileQueue.isEmpty()) {
            if (activeFileQueue.isEmpty()) {
                try {
                    Thread.sleep(200L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            File pfFile = (File)activeFileQueue.remove();
            System.out.println("Opening " + pfFile.getAbsolutePath() + "...");
            OpenOp open = new OpenOp(pfFile);
            UIHook.run(null, null, open, 2);
            if (!open.d_result) {
                System.err.println("Could not open " + pfFile.getAbsolutePath());
                BatchFileTest.nextFile(pm, numCompleted, inQueue, fullFileQueue, activeFileQueue);
                continue;
            }
            System.out.println("Preparing to run inferno: " + pfFile.getAbsolutePath() + "...");
            final PrepareInfernoOp prepareOp = new PrepareInfernoOp();
            UIHook.run(null, null, prepareOp, 2);
            if (prepareOp.d_inferno != null) {
                infernoExecutor.submit(new Runnable(){

                    @Override
                    public void run() {
                        if (pm.isCanceled()) {
                            try {
                                infernoExecutor.shutdownNow();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        inQueue.add(prepareOp.d_inferno.filename);
                        BatchFileTest.updateNote(pm, numCompleted, inQueue);
                        RunInferno.run(new RunSimDlg(null), prepareOp.d_inferno.filename, prepareOp.d_inferno.dir, prepareOp.d_inferno.engine, new RunSimDlg.DlgListener[0]);
                        inQueue.remove(prepareOp.d_inferno.filename);
                        BatchFileTest.nextFile(pm, numCompleted, inQueue, fullFileQueue, activeFileQueue);
                    }
                });
                continue;
            }
            BatchFileTest.nextFile(pm, numCompleted, inQueue, fullFileQueue, activeFileQueue);
        }
        infernoExecutor.shutdown();
        try {
            infernoExecutor.awaitTermination(Long.MAX_VALUE, TimeUnit.DAYS);
        }
        catch (Exception exception) {
            // empty catch block
        }
        s_app.setPreference("RunSimDlg_show_results", Boolean.toString(showResults));
        s_app.quit(true);
    }

    private static void nextFile(ProgressMonitor pm, int[] numCompleted, Set<String> queuedNames, Queue<File> fullQueue, Queue<File> activeQueue) {
        int n = numCompleted[0];
        numCompleted[0] = n + 1;
        int progress = n;
        pm.setProgress(progress);
        BatchFileTest.updateNote(pm, numCompleted, queuedNames);
        BatchFileTest.queueNext(fullQueue, activeQueue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void queueNext(Queue<File> fullQueue, Queue<File> activeQueue) {
        Queue<File> queue = fullQueue;
        synchronized (queue) {
            if (!fullQueue.isEmpty()) {
                File next = fullQueue.remove();
                activeQueue.add(next);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateNote(ProgressMonitor pm, int[] numCompleted, Set<String> inQueue) {
        Object message = String.format("Finished %d/%d    ", numCompleted[0] + 1, pm.getMaximum() + 1);
        message = (String)message + "Running:   ";
        Set<String> set = inQueue;
        synchronized (set) {
            for (String queued : inQueue) {
                message = (String)message + new File(queued).getName() + "    ";
            }
        }
        pm.setNote((String)message);
    }

    private static void delete(File f) {
        File[] files;
        if (f.isDirectory() && (files = f.listFiles()) != null) {
            for (File child : files) {
                BatchFileTest.delete(child);
            }
        }
        f.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File[] getPFFiles(File listFile) {
        ArrayList<File> files = new ArrayList<File>();
        BufferedReader reader = null;
        try {
            File dir = listFile.getParentFile();
            reader = new BufferedReader(new FileReader(listFile));
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (line.length() < 5 || line.substring(0, 2).equals("//")) continue;
                char steerFlag = line.charAt(0);
                char sfpeFlag = line.charAt(1);
                char sfpePlusFlag = line.charAt(2);
                String baseName = line.substring(4);
                BatchFileTest.addFile(dir, baseName, steerFlag, STEER_EXT, files);
                BatchFileTest.addFile(dir, baseName, sfpeFlag, SFPE_EXT, files);
                BatchFileTest.addFile(dir, baseName, sfpePlusFlag, SFPE_PLUS_EXT, files);
            }
            File[] steerFlag = files.toArray(new File[files.size()]);
            return steerFlag;
        }
        catch (Exception e) {
            e.printStackTrace();
            File[] fileArray = new File[]{};
            return fileArray;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static void addFile(File dir, String baseName, char mode, String modeExt, List<File> files) {
        if (mode == '1') {
            String name = baseName + "/" + baseName + "_" + modeExt + ".pth";
            File f = new File(dir, name);
            if (!f.exists() && !(f = new File(dir, name = baseName + "_" + modeExt + ".pth")).exists()) {
                f = new File(name);
            }
            if (f.exists() && f.isFile()) {
                files.add(f);
            } else {
                System.err.println("could not find file for " + baseName + " : " + modeExt);
            }
        }
    }

    static {
        s_app.getMainFrame().setVisible(true);
    }

    private static class PrepareInfernoOp
    extends AMerlinOp {
        public RunInferno.InfernoData d_inferno = null;

        private PrepareInfernoOp() {
        }

        @Override
        public void run(MerlinApp app, MerlinData md) {
            try {
                this.d_inferno = RunInferno.prepareEngine(app, md, null, false);
            }
            catch (CancelledException cancelledException) {
                // empty catch block
            }
        }
    }

    private static class OpenOp
    extends AMerlinOp {
        private boolean d_result = true;
        private final File d_pfFile;

        public OpenOp(File pfFile) {
            this.d_pfFile = pfFile;
        }

        @Override
        public void run(MerlinApp app, MerlinData md) {
            this.d_result = Open.open(app, md, this.d_pfFile.getAbsolutePath());
        }
    }

    private static class PthFilter
    implements FileFilter {
        private PthFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            String ext;
            String path = pathname.getAbsolutePath();
            int extix = path.lastIndexOf(46);
            return extix < 0 || extix >= path.length() - 1 || !(ext = path.substring(extix + 1)).equals("pth");
        }
    }
}

