/*
 * Decompiled with CFR 0.152.
 */
package merlin.mv.tools;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import merlin.data.MerlinData;
import merlin.data.egress.geom.IEgressOccupiable;
import merlin.mv.tools.RoomToolUtil;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.scene3d.picking.ISnapConstraint;
import thunderheadeng.scene3d.picking.IsectInfo;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;

public class RoomSnapConstraint
implements ISnapConstraint {
    public final MerlinData md;
    public final ISnapConstraint backupConstraint;
    public final Predicate<IsectInfo> snapFilter;

    public RoomSnapConstraint(MerlinData md, ISnapConstraint backupConstraint) {
        this(md, backupConstraint, isect -> isect.searchType.fromFace && isect.getFaceNormal != null && isect.getFaceNormal.get().lengthSquared() > 0.0);
    }

    public RoomSnapConstraint(MerlinData md, ISnapConstraint backupConstraint, Predicate<IsectInfo> snapFilter) {
        this.md = md;
        this.backupConstraint = backupConstraint;
        this.snapFilter = snapFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Pair<Point3d, Collection<IsectInfo>> snapRay(Runnable validateProgress, Point3d rayBegin, Vector3d rayDir) {
        this.md.beginRead();
        try {
            Collection<IsectInfo> iis = this.findRoomIsects(validateProgress, rayBegin, rayDir);
            if (iis.isEmpty()) {
                Pair<Point3d, Collection<IsectInfo>> pair = this.backupConstraint != null ? this.backupConstraint.snapRay(validateProgress, rayBegin, rayDir) : null;
                return pair;
            }
            Point3d rayPoint = iis.iterator().next().isectPoint;
            Pair<Point3d, Collection<IsectInfo>> pair = new Pair<Point3d, Collection<IsectInfo>>(rayPoint, iis);
            return pair;
        }
        finally {
            this.md.endRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<IsectInfo> snapPoint(Runnable validateProgress, Point3d p) {
        this.md.beginRead();
        try {
            Collection<IsectInfo> isects = this.findRoomIsects(validateProgress, p, GeomConstants.VEC3D_ZNEG);
            if (!isects.isEmpty()) {
                Collection<IsectInfo> collection = isects;
                return collection;
            }
            List<IsectInfo> list = this.backupConstraint != null ? this.backupConstraint.snapPoint(validateProgress, p) : Collections.emptyList();
            return list;
        }
        finally {
            this.md.endRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<IsectInfo> snapPoint(Runnable validateProgress, Collection<IsectInfo> snaps, Vector3d projectionDir) {
        this.md.beginRead();
        try {
            Collection<IsectInfo> roomSnaps = theUtil.preFilter(snaps, IsectInfo.class, snap -> {
                validateProgress.run();
                return snap.obj instanceof IEgressOccupiable && this.snapFilter.test((IsectInfo)snap);
            });
            if (!roomSnaps.isEmpty()) {
                Collection<IsectInfo> collection = roomSnaps;
                return collection;
            }
            Vector3d searchDir = projectionDir != null ? projectionDir : GeomConstants.VEC3D_ZNEG;
            Collection<IsectInfo> roomIsects = this.findRoomIsects(validateProgress, snaps.iterator().next().isectPoint, searchDir);
            if (!roomIsects.isEmpty()) {
                Collection<IsectInfo> collection = roomIsects;
                return collection;
            }
            if (this.backupConstraint != null) {
                roomIsects = this.backupConstraint.snapPoint(validateProgress, snaps, projectionDir);
                if (!roomIsects.isEmpty()) {
                    Collection<IsectInfo> collection = roomIsects;
                    return collection;
                }
                Collection<IsectInfo> collection = snaps;
                return collection;
            }
            List<IsectInfo> list = Collections.emptyList();
            return list;
        }
        finally {
            this.md.endRead();
        }
    }

    private Collection<IsectInfo> findRoomIsects(Runnable validateProgress, Point3d rayBegin, Vector3d rayDir) {
        return RoomToolUtil.findRoomIsects(this.md, validateProgress, rayBegin, rayDir);
    }

    @Override
    public ISnapConstraint transform(Matrix4d xform) {
        return this;
    }
}

