/*
 * Decompiled with CFR 0.152.
 */
package merlin.mv.gui.queues;

import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.builders.queues.QueuePathBuilder;
import merlin.data.MerlinData;
import merlin.data.egress.geom.IEgressOccupiable;
import merlin.geom.GeomUtil;
import merlin.geom.Geometry;
import merlin.gui.APropEditPanel;
import merlin.mv.gui.LocationPanel;
import merlin.mv.gui.queues.NewQueueElemPnl;
import merlin.mv.gui.queues.QueueElemCreatePnl;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.guiButtonGroup;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiRadioButton;
import thunderheadeng.units.UnitPoint3D;

public class NewQueuePathPnl
extends APropEditPanel<QueuePathBuilder> {
    private static final long serialVersionUID = 6114736350988611227L;

    public NewQueuePathPnl() {
        super(new Object[0]);
        guiPanel locPnl = new guiPanel();
        GridBagHelper gbh = new GridBagHelper(locPnl);
        gbh.addRow(new NodeLocationPanel());
        guiPanel newElemPnl = new guiPanel();
        gbh = new GridBagHelper(newElemPnl);
        gbh.addRow(new NewQueueElemPnl());
        guiPanel dirPnl = new guiPanel();
        gbh = new GridBagHelper(dirPnl);
        gbh.addRow(new PathDirectionPanel());
        this.addSection(new NewQueueElemPnl());
        this.addSeparator();
        this.addSection(locPnl);
        this.addSeparator();
        this.addSection(dirPnl);
        this.addSeparator();
        this.addSection(new QueueElemCreatePnl());
    }

    private static class NodeLocationPanel
    extends LocationPanel<QueuePathBuilder> {
        private static final long serialVersionUID = 3480110231025411926L;

        public NodeLocationPanel() {
            super(1, QueuePathBuilder.TEMP_LOC_CHANGED);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void updateToProps(QueuePathBuilder props) {
            MerlinData md = MerlinApp.getApp().getData();
            md.beginRead();
            try {
                UnitPoint3D specPoint = this.getValue();
                Point3d p1 = specPoint.getPoint3dValue(Geometry.LENGTH_UNIT);
                p1.z += 1.0E-6;
                AABox modelBounds = MerlinApp.getApp().getData().geomLocation.getBounds();
                Point3d p2 = new Point3d(p1.x, p1.y, modelBounds.getMinZ() - 1.0E-6);
                GeomUtil.FindResult findResult = GeomUtil.findRoom(MerlinApp.getApp().getData(), p1, p2, 1);
                IEgressOccupiable room = findResult != null ? findResult.room : null;
                UnitPoint3D p = findResult != null ? new UnitPoint3D(findResult.p, Geometry.LENGTH_UNIT) : specPoint;
                Vector3d norm = findResult != null ? findResult.faceNormal : GeomConstants.VEC3D_ZPOS;
                props.setTempLocation(p, room, norm);
            }
            finally {
                md.endRead();
            }
        }

        @Override
        protected void updateFromProps(QueuePathBuilder props) {
            this.setValue(props.getTempLocation());
        }
    }

    private static class PathDirectionPanel
    extends APropEditPanel<QueuePathBuilder> {
        private static final long serialVersionUID = -6538841516650771350L;
        private guiRadioButton d_fromHeadBtn = new guiRadioButton(Intl.intl("Draw from Path Entry"));
        private guiRadioButton d_fromTailBtn = new guiRadioButton(Intl.intl("Draw from Path Exit"));

        public PathDirectionPanel() {
            super(QueuePathBuilder.DIRECTION_CHANGED);
            this.addDefaultListener(this.d_fromHeadBtn);
            this.addDefaultListener(this.d_fromTailBtn);
            new guiButtonGroup(this.d_fromHeadBtn, this.d_fromTailBtn);
            this.d_fromHeadBtn.setSelected(true);
            GridBagHelper gbh = new GridBagHelper(this, false);
            gbh.rowSpace = 6;
            gbh.addRow(this.d_fromHeadBtn);
            gbh.addRow(this.d_fromTailBtn);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void updateToProps(QueuePathBuilder props) {
            MerlinData md = MerlinApp.getApp().getData();
            md.beginRead();
            try {
                QueuePathBuilder.DRAW_DIRECTION dir = this.d_fromHeadBtn.isSelected() ? QueuePathBuilder.DRAW_DIRECTION.FROM_HEAD : QueuePathBuilder.DRAW_DIRECTION.FROM_TAIL;
                props.setDrawDirection(dir);
            }
            finally {
                md.endRead();
            }
        }

        @Override
        protected void updateFromProps(QueuePathBuilder props) {
            boolean fromHead = props.getDrawDirection().equals((Object)QueuePathBuilder.DRAW_DIRECTION.FROM_HEAD);
            this.d_fromHeadBtn.setSelected(fromHead);
            this.d_fromTailBtn.setSelected(!fromHead);
        }
    }
}

