/*
 * Decompiled with CFR 0.152.
 */
package merlin.mv.gui.behaviors;

import java.util.Collection;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.builders.GotoActionBuilder;
import merlin.data.MerlinData;
import merlin.data.egress.Floor;
import merlin.data.egress.elevators.Elevator;
import merlin.gui.APropEditPanel;
import merlin.gui.ElevatorChooser;
import merlin.gui.ElevatorFloorComboBox;
import merlin.mv.gui.behaviors.ANewBehaviorActionPnl;
import merlin.mv.gui.behaviors.ActionCreatePnl;
import merlin.mv.gui.behaviors.BehaviorPnl;
import thunderheadeng.gui.GridBagHelper;

public class NewGotoElevatorsPnl
extends ANewBehaviorActionPnl<GotoActionBuilder> {
    private static final long serialVersionUID = 1L;

    public NewGotoElevatorsPnl() {
        super(new Object[0]);
        MerlinData md = MerlinApp.getApp().getData();
        this.addSection(new BehaviorPnl());
        this.addSeparator();
        this.addSection(new ElevatorPanel(md));
        this.addSeparator();
        this.addSection(new ActionCreatePnl());
    }

    private class ElevatorPanel
    extends APropEditPanel<GotoActionBuilder> {
        private static final long serialVersionUID = 1L;
        private final ElevatorChooser d_chooser;
        private final ElevatorFloorComboBox d_floor;

        public ElevatorPanel(MerlinData md) {
            super(GotoActionBuilder.DEST_CHANGED);
            this.d_chooser = new ElevatorChooser(md);
            this.d_floor = new ElevatorFloorComboBox(md, (Collection<Elevator>)this.d_chooser.getElevators());
            this.d_chooser.setButtonLabel(8, ANewBehaviorActionPnl.GO_BACK);
            GridBagHelper gb = new GridBagHelper(this);
            gb.addRow(Intl.intl("Elevators:"), this.d_chooser);
            gb.addRow(Intl.intl("Target Floor:"), this.d_floor);
            this.initComboBox(this.d_floor);
            this.d_chooser.addValueListener(e -> this.d_floor.setElevators(this.d_chooser.getElevators()));
            this.d_chooser.addPropertyChangeListener("edit", e -> {
                if (((Boolean)e.getNewValue()).booleanValue()) {
                    this.d_floor.setElevators(this.d_chooser.getElevators());
                    this.getUpdateToCommand().updateProp(this, true);
                }
            });
        }

        @Override
        protected void updateFromProps(GotoActionBuilder props) {
            this.d_chooser.setObjs(props.getElevators());
            this.d_floor.setSelectedItem(props.getTargetFloor());
        }

        @Override
        protected void updateToProps(GotoActionBuilder props) {
            props.setElevatorDest(this.d_chooser.getElevators());
            props.setFloorDest((Floor)this.d_floor.getSelectedItem());
        }
    }
}

