/*
 * Decompiled with CFR 0.152.
 */
package merlin.mv.gui;

import common.data.ElevatorType;
import common.data.IElevatorTimingModel;
import common.data.WaitMode;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Observable;
import java.util.Observer;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Semaphore;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import merlin.EntryPointFactory;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.CompElementActions;
import merlin.actions.CreateElevator;
import merlin.actions.Delete;
import merlin.actions.MerlinOpImpl;
import merlin.actions.NewGroup;
import merlin.actions.RenameAction;
import merlin.actions.SetWorkingGroup;
import merlin.actions.SimpleOp;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.actions.Visibility;
import merlin.actions.floorextract.GenerateModelFromBIM;
import merlin.data.AssistedEvacTeam;
import merlin.data.Composite;
import merlin.data.GeomComposite;
import merlin.data.ICompElement;
import merlin.data.IMerlinObj;
import merlin.data.INamed;
import merlin.data.IOpacity;
import merlin.data.IRestorable;
import merlin.data.ImportType;
import merlin.data.ImportedGeom;
import merlin.data.MeasurementRegionObj;
import merlin.data.MerlinData;
import merlin.data.MerlinSelectionModel;
import merlin.data.NamedMerlinObj;
import merlin.data.OccGroupObj;
import merlin.data.OccGroupTypeObj;
import merlin.data.OccSourceObj;
import merlin.data.Opacity;
import merlin.data.PredefTags;
import merlin.data.Proxy;
import merlin.data.SimParams;
import merlin.data.camera.Camera;
import merlin.data.egress.Floor;
import merlin.data.egress.FloorComposite;
import merlin.data.egress.FloorSort;
import merlin.data.egress.agents.ConstOccCount;
import merlin.data.egress.agents.EgressAgent;
import merlin.data.egress.agents.EgressAgentComp;
import merlin.data.egress.agents.IOccArea;
import merlin.data.egress.agents.IOccCount;
import merlin.data.egress.agents.OccProfile;
import merlin.data.egress.agents.OccTarget;
import merlin.data.egress.agents.OccTargetComp;
import merlin.data.egress.blockages.EgressBlockage;
import merlin.data.egress.elevators.Elevator;
import merlin.data.egress.elevators.ElevatorRoom;
import merlin.data.egress.geom.AEgressComp;
import merlin.data.egress.geom.DoorUtil;
import merlin.data.egress.geom.EgressCorridor;
import merlin.data.egress.geom.EgressDoor;
import merlin.data.egress.geom.EgressDoorDir;
import merlin.data.egress.geom.EgressRoom;
import merlin.data.egress.geom.EgressStair;
import merlin.data.egress.geom.IEgressComp;
import merlin.data.egress.geom.IEgressConnector;
import merlin.data.egress.geom.IEgressFlowrate;
import merlin.data.egress.geom.IEgressOccupiable;
import merlin.data.egress.geom.SpeedModifier;
import merlin.data.egress.scripting.AbandonOccTargets;
import merlin.data.egress.scripting.AssistOccupants;
import merlin.data.egress.scripting.Behavior;
import merlin.data.egress.scripting.ChangeBehavior;
import merlin.data.egress.scripting.ChangeProfile;
import merlin.data.egress.scripting.ChangeProfileProp;
import merlin.data.egress.scripting.ChangeTags;
import merlin.data.egress.scripting.CreateAttractor;
import merlin.data.egress.scripting.DestroyAttractor;
import merlin.data.egress.scripting.GotoCurrentAttractor;
import merlin.data.egress.scripting.GotoElevators;
import merlin.data.egress.scripting.GotoExits;
import merlin.data.egress.scripting.GotoOcc;
import merlin.data.egress.scripting.GotoOccTarget;
import merlin.data.egress.scripting.GotoQueue;
import merlin.data.egress.scripting.GotoRooms;
import merlin.data.egress.scripting.GotoWaypoint;
import merlin.data.egress.scripting.IBehaviorAction;
import merlin.data.egress.scripting.IWaitAction;
import merlin.data.egress.scripting.IWaitUntilSrc;
import merlin.data.egress.scripting.JoinOccGroup;
import merlin.data.egress.scripting.RefugeFilter;
import merlin.data.egress.scripting.RevertProfileProp;
import merlin.data.egress.scripting.Wait;
import merlin.data.egress.scripting.WaitForAssistance;
import merlin.data.egress.scripting.WaitUntil;
import merlin.data.egress.scripting.attractors.Attractor;
import merlin.data.egress.scripting.attractors.IAttractorTime;
import merlin.data.egress.scripting.queues.IGotoQueueDestination;
import merlin.data.egress.scripting.queues.IQueueElement;
import merlin.data.egress.scripting.queues.QueueObject;
import merlin.data.egress.scripting.queues.QueuePath;
import merlin.data.egress.scripting.queues.QueueService;
import merlin.data.material.Material;
import merlin.data.property.Function1dProp;
import merlin.data.property.INamedProp;
import merlin.data.value.IFunction1d;
import merlin.data.value.IVariant;
import merlin.geom.GeomUtil;
import merlin.geom.Geometry;
import merlin.geom.IMerlinGeomSrc;
import merlin.gui.AETeamsChooser;
import merlin.gui.APropEditPanel;
import merlin.gui.AttractorBehaviorChooser;
import merlin.gui.BasicFloorComboBox;
import merlin.gui.DiscreteChooser;
import merlin.gui.DistributionEditor;
import merlin.gui.ElevatorChooser;
import merlin.gui.ElevatorFloorComboBox;
import merlin.gui.ElevatorLevelDlg;
import merlin.gui.ExitChooser;
import merlin.gui.MaterialBtn;
import merlin.gui.MerlinComboBox;
import merlin.gui.MerlinUDF;
import merlin.gui.MerlinValueFields;
import merlin.gui.NewElevatorDlg;
import merlin.gui.NodeComboBox;
import merlin.gui.NodeComboModel;
import merlin.gui.OccGroupsPanel;
import merlin.gui.OccTargetsChooser;
import merlin.gui.OccupancyPanel;
import merlin.gui.PriorityChooser;
import merlin.gui.QueueChooser;
import merlin.gui.RoomChooser;
import merlin.gui.SetChooser;
import merlin.gui.TagsField;
import merlin.gui.UnitUpdator;
import merlin.gui.guiUtil;
import merlin.gui.stat.CompactDistributedValPnl;
import merlin.gui.value.DiscreteVarEditor;
import merlin.gui.value.UDVarEditor;
import merlin.gui.value.VariantButton;
import merlin.mv.ModelView;
import merlin.mv.gui.OccEditorPanel;
import merlin.mv.gui.OccSourcePanel;
import merlin.mv.gui.behaviors.NewChangeProfilePropPnl;
import merlin.mv.gui.behaviors.NewRevertProfilePropPnl;
import merlin.mv.gui.behaviors.WaitUntilSrcPnl;
import merlin.mv.gui.queues.QueueObjectPanel;
import merlin.mv.tools.IPointPickListener;
import merlin.unitsystem.SIUS;
import merlin.unitsystem.UnitSystem;
import merlin.unitsystem.UnitUpdatableComponent;
import merlin.util.Dependencies;
import merlin.util.MerlinProps;
import merlin.util.MerlinUtil;
import merlin.util.OccAreaListCellRenderer;
import merlin.util.Property;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.ITransform;
import thunderheadeng.geometry.objs.transform.TransformUtil;
import thunderheadeng.gui.DropDownButton;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.HTMLBtn;
import thunderheadeng.gui.IListenerStripper;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.Modifiable;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.Validateable;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.colorscheme.ColorButton;
import thunderheadeng.gui.guiAction;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiDoubleField;
import thunderheadeng.gui.guiFormattedFld;
import thunderheadeng.gui.guiIntField;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiMultiStateCheckBox;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiTextArea;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.gui.guiUnitDoubleField;
import thunderheadeng.gui.guiValueField;
import thunderheadeng.gui.value.AValEditor;
import thunderheadeng.gui.value.IValEditor;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IMaterial;
import thunderheadeng.scene3d.navtools.CursorTool;
import thunderheadeng.scene3d.navtools.SnapMode;
import thunderheadeng.scene3d.picking.DefaultFilter;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitDoubleVR;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.DoubleVR;
import thunderheadeng.util.EventChannel;
import thunderheadeng.util.Events;
import thunderheadeng.util.Filters;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.IObservable;
import thunderheadeng.util.IObserver;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.TriConsumer;
import thunderheadeng.util.stat.IDistributedVal;
import thunderheadeng.util.stat.IUrn;
import thunderheadeng.util.theMath;
import thunderheadeng.util.theUtil;

public class SelectionEditorPanel
extends APropEditPanel<MerlinProps>
implements IEventObserver {
    private static final long serialVersionUID = 9219945208404511010L;
    public static final IPropertySet.Prop<Boolean> PROP_BEHAVIOR_ACTION_TERMINAL = new IPropertySet.Prop<Boolean>("BEHAVIOR_TOOL", false);
    private MerlinData d_md;
    private List<EditorPanel> d_activePanels;
    private OccEditorPanel d_occSect;
    private EditorPanel d_floorSect;
    private EditorPanel d_occCountSect;
    private EditorPanel d_occTargetCountSect;
    private EditorPanel d_roomInfoSect;
    private EditorPanel d_roomPropSect;
    private EditorPanel d_doorSect1;
    private EditorPanel d_doorSect2;
    private EditorPanel d_corrSect;
    private EditorPanel d_stairSect;
    private EditorPanel d_rampSect;
    private EditorPanel d_extraCorrInfoSect1;
    private EditorPanel d_extraCorrInfoSect2;
    private EditorPanel d_behaviorSect;
    private EditorPanel d_behaviorPropSect;
    private EditorPanel d_behaviorActSect;
    private EditorPanel d_gotoWaypointSect;
    private EditorPanel d_gotoElevatorsSect;
    private EditorPanel d_gotoRoomsSect;
    private EditorPanel d_gotoOccTargetsSect;
    private EditorPanel d_gotoOccSect1;
    private EditorPanel d_gotoOccSect2;
    private EditorPanel d_gotoCurrentAttractorSect;
    private EditorPanel d_gotoExitsSect;
    private EditorPanel d_abandonOccTargetsSect;
    private EditorPanel d_gotoQueueSect;
    private EditorPanel d_waitForAssistSect;
    private EditorPanel d_assistSect;
    private EditorPanel d_joinOccGroupSect;
    private EditorPanel d_changeTagsSect;
    private EditorPanel d_elevatorPropSect;
    private EditorPanel d_elevatorLevelSect;
    private EditorPanel d_elevatorExtraSect;
    private EditorPanel d_elevatorTypeSect;
    private EditorPanel d_waitSect;
    private EditorPanel d_waitUntilSect;
    private EditorPanel d_basicWaitSect;
    private EditorPanel d_attractorGenSect;
    private EditorPanel d_attractorBehaviorSect;
    private EditorPanel d_attractorWaitAtAttrSect;
    private EditorPanel d_attractorAwarenessSect;
    private EditorPanel d_attractorInfluenceSect;
    private EditorPanel d_occTargetsSect;
    private BoundsSect d_boundsSect;
    private RegionInfoSect d_regionInfoSect;
    private EditorPanel d_blockageSect;
    private EditorPanel d_blockageVisSect;
    private EditorPanel d_cameraControlSect;
    private EditorPanel d_cameraOrientSect;
    private EditorPanel d_cameraLimitsSect;
    private EditorPanel d_sceneGeomSect;
    private OccGroupPnl d_occGroupSect;
    private ChangeBehaviorSect d_changeBehaviorSect;
    private ChangeProfileSect d_changeProfileSect;
    private ChangeProfilePropSect d_changeProfilePropSect;
    private RevertProfilePropSect d_revertProfilePropSect;
    private CreateAttractorSect d_createAttractorSect;
    private DestroyAttractorSect d_destroyAttractorSect;
    private final NewCompGroupPnl d_newCompGroupPnl;
    private final FloorSortPnl d_floorSortPnl;
    private final EditorPanel d_generateModelFromBIM;
    private final EditorPanel d_generateModelFromBIMSel;
    private OccSourcePanel d_occSourcePanel;
    private QueueObjectPanel d_queuePanel;
    private final SetChooser<OccProfile> d_profileChooser;
    private static final guiLabel s_dmyLbl = new guiLabel("blah");

    public SelectionEditorPanel(MerlinData md, guiAction[] newBehaviorActionActions, guiAction[] newQueueElemActions) {
        super(new Object[0]);
        this.d_md = md;
        this.d_activePanels = Collections.EMPTY_LIST;
        this.d_md.getEvents().addObserver(this);
        this.d_newCompGroupPnl = new NewCompGroupPnl(md);
        this.d_floorSortPnl = new FloorSortPnl(md);
        this.d_generateModelFromBIM = new GenerateModelSect(true);
        this.d_generateModelFromBIMSel = new GenerateModelSect(false);
        this.d_profileChooser = new SetChooser<OccProfile>(md, Intl.intl("Accepted Profiles"), Intl.intl("none"), 0, md.profiles, OccProfile.class, Predicates.alwaysTrue());
        this.d_floorSect = new FloorSect();
        this.d_occCountSect = new OccCountSect(md);
        this.d_occTargetCountSect = new CountSect<OccTarget>(md, Intl.intl("Occ. Target Count:"), OccTarget.class);
        this.d_roomInfoSect = new RoomInfoSect();
        this.d_roomPropSect = new RoomPropSect();
        this.d_occSect = new OccEditorPanel(md);
        this.d_doorSect1 = new DoorSect1();
        this.d_doorSect2 = new DoorSect2();
        this.d_corrSect = new CorridorSect();
        this.d_extraCorrInfoSect1 = new CorridorExtraPnl1();
        this.d_extraCorrInfoSect2 = new CorridorExtraPnl2();
        this.d_stairSect = new StairSect();
        this.d_rampSect = new RampSect();
        this.d_boundsSect = new BoundsSect();
        this.d_regionInfoSect = new RegionInfoSect();
        this.d_blockageSect = new BlockageSect();
        this.d_blockageVisSect = new BlockageVisSect();
        this.d_cameraControlSect = new CameraControlSect();
        this.d_cameraOrientSect = new CameraOrientSect();
        this.d_cameraLimitsSect = new CameraLimitsSect();
        this.d_sceneGeomSect = new SceneGeomPnl();
        this.d_behaviorSect = new BehaviorSect();
        this.d_behaviorPropSect = new BehaviorPropSect();
        this.d_behaviorActSect = new BehaviorActionSect(newBehaviorActionActions);
        this.d_waitSect = new WaitSect();
        this.d_waitUntilSect = new WaitUntilSect();
        this.d_basicWaitSect = new BasicWaitSect();
        this.d_attractorAwarenessSect = new AttractorAwarenessSect(md);
        this.d_attractorInfluenceSect = new AttractorInfluenceSect(md);
        this.d_attractorGenSect = new AttractorGenSect(md);
        this.d_attractorBehaviorSect = new AttractorBehaviorSect(md);
        this.d_attractorWaitAtAttrSect = new AttractorWaitAtAttractorSect(md);
        this.d_occTargetsSect = new OccTargetsSect(md);
        this.d_gotoWaypointSect = new GotoWaypointSect();
        this.d_gotoElevatorsSect = new GotoElevatorsSect();
        this.d_gotoExitsSect = new GotoExitsSect();
        this.d_gotoRoomsSect = new GotoRoomsSect();
        this.d_gotoOccTargetsSect = new GotoOccTargetsSect();
        this.d_gotoOccSect1 = new GotoOccSect1();
        this.d_gotoOccSect2 = new GotoOccSect2();
        this.d_gotoCurrentAttractorSect = new GotoCurrentAttractorSect();
        this.d_abandonOccTargetsSect = new AbandonOccTargetsSect();
        this.d_gotoQueueSect = new GotoQueueSect();
        this.d_waitForAssistSect = new WaitForAssistanceSect();
        this.d_assistSect = new AssistSect();
        this.d_joinOccGroupSect = new JoinOccGroupSect();
        this.d_changeTagsSect = new ChangeTagsSect(md);
        this.d_elevatorPropSect = new ElevatorDataPnl();
        this.d_elevatorLevelSect = new ElevatorLevelPnl();
        this.d_elevatorExtraSect = new ElevatorExtraPnl();
        this.d_elevatorTypeSect = new ElevatorTypePnl();
        this.d_occSourcePanel = new OccSourcePanel(md);
        this.d_occGroupSect = new OccGroupPnl(md);
        this.d_queuePanel = new QueueObjectPanel(md, newQueueElemActions);
        this.d_changeBehaviorSect = new ChangeBehaviorSect(md);
        this.d_changeProfileSect = new ChangeProfileSect(md);
        this.d_changeProfilePropSect = new ChangeProfilePropSect(md);
        this.d_revertProfilePropSect = new RevertProfilePropSect();
        this.d_createAttractorSect = new CreateAttractorSect(md);
        this.d_destroyAttractorSect = new DestroyAttractorSect(md);
        this.updatePanels();
        this.updateLayout();
    }

    @Override
    public void commit() {
        for (EditorPanel panel : this.d_activePanels) {
            panel.commit();
        }
    }

    private List<EditorPanel> getActivePanels(Set<ICompElement> objs) {
        ArrayList<EditorPanel> activePanels = new ArrayList<EditorPanel>();
        MerlinSelectionModel sel = this.d_md.selection;
        if (objs.isEmpty()) {
            activePanels.add(this.d_floorSortPnl);
            activePanels.add(this.d_newCompGroupPnl);
            activePanels.add(this.d_generateModelFromBIM);
            return activePanels;
        }
        boolean hasSpecialNamePanel = false;
        if (sel.isExclusive(QueueObject.class, IQueueElement.class)) {
            activePanels.add(this.d_queuePanel.getQueueInfoPnl());
            hasSpecialNamePanel = true;
        }
        if (sel.isExclusive(Behavior.class, IBehaviorAction.class)) {
            this.addBehaviorPanels(sel, activePanels);
            return activePanels;
        }
        Set<Object> propTypes = Composite.getPropTypes(2, objs);
        Set<Object> unshared = Composite.getPropTypes(0, objs);
        PropBuilder propgb = new PropBuilder(activePanels);
        if (!hasSpecialNamePanel) {
            SelectionEditorPanel.addNameProp(propTypes, propgb, objs.stream().allMatch(obj -> EntryPointFactory.get(obj).tvEntryPoint.canRename(this.d_md, (ICompElement)obj)));
        }
        SelectionEditorPanel.addMovementGroupProp(propTypes, propgb, sel);
        SelectionEditorPanel.addVisibilityProp(propTypes, propgb);
        int colorCount = 0;
        if (SelectionEditorPanel.testMaterialProp(propTypes, unshared)) {
            ++colorCount;
        }
        if (SelectionEditorPanel.testColorProp(propTypes)) {
            ++colorCount;
        }
        if (SelectionEditorPanel.testOpacityProp(propTypes)) {
            ++colorCount;
        }
        propgb.prepareNewRowGroup(colorCount);
        SelectionEditorPanel.addMaterialProp(propTypes, unshared, propgb);
        SelectionEditorPanel.addColorProp(propTypes, propgb, sel);
        SelectionEditorPanel.addOpacityProp(propTypes, propgb);
        propgb.finalizePropPnl();
        if (objs.stream().anyMatch(ice -> ice instanceof IMerlinGeomSrc && EntryPointFactory.get(ice).getShowBounds(this.d_md, (ICompElement)ice))) {
            activePanels.add(this.d_boundsSect);
        }
        if (propTypes.contains(MeasurementRegionObj.MSR_AREA)) {
            activePanels.add(this.d_regionInfoSect);
        }
        if (propTypes.contains(Floor.WORKING_Z) && propTypes.contains(Floor.ZMIN_FILTER) && propTypes.contains(Floor.ZMAX_FILTER)) {
            activePanels.add(this.d_floorSect);
        }
        if (sel.isExclusive(EgressAgentComp.class) || propTypes.contains(OccSourceObj.PROP_FLOW_RATE)) {
            activePanels.add(this.d_occCountSect);
        }
        if (sel.isExclusive(OccTargetComp.class)) {
            activePanels.add(this.d_occTargetCountSect);
        }
        if (propTypes.contains(EgressAgent.PROFILE) && propTypes.contains(EgressAgent.BEHAVIOR)) {
            activePanels.addAll(this.d_occSect.getPanels());
        }
        if (sel.isExclusive(OccSourceObj.class)) {
            activePanels.addAll(this.d_occSourcePanel.getPanels());
        }
        if (propTypes.contains(EgressDoor.WIDTH)) {
            activePanels.add(this.d_doorSect1);
            activePanels.add(this.d_doorSect2);
        }
        boolean includeRoom = false;
        if (propTypes.contains(EgressStair.TREAD_RISE) && propTypes.contains(EgressStair.TREAD_RUN)) {
            activePanels.add(this.d_stairSect);
            includeRoom = true;
        }
        if (propTypes.contains(EgressCorridor.SLOPE) && !propTypes.contains(EgressStair.TREAD_RISE)) {
            activePanels.add(this.d_rampSect);
            includeRoom = true;
        }
        if (propTypes.contains(EgressCorridor.BOTTOM_DOOR) && propTypes.contains(EgressCorridor.TOP_DOOR) && propTypes.contains(EgressCorridor.LENGTH) && propTypes.contains(EgressCorridor.WIDTH)) {
            activePanels.remove(this.d_boundsSect);
            activePanels.add(this.d_corrSect);
            activePanels.add(this.d_extraCorrInfoSect1);
            activePanels.add(this.d_extraCorrInfoSect2);
            includeRoom = false;
        }
        if (propTypes.contains(EgressBlockage.DISPLAY_TYPE)) {
            activePanels.add(this.d_blockageVisSect);
            activePanels.add(this.d_blockageSect);
        }
        if (includeRoom || unshared.contains(IEgressOccupiable.AREA) && unshared.contains(IEgressOccupiable.OCC_COUNT)) {
            activePanels.add(this.d_roomInfoSect);
        }
        if (propTypes.contains(IEgressOccupiable.SPEED_MODIFIER) && !sel.isDeepEmpty(EgressRoom.class)) {
            activePanels.add(this.d_roomPropSect);
        }
        if (unshared.contains(Elevator.PROP_TYPE)) {
            activePanels.add(this.d_elevatorTypeSect);
        }
        if (unshared.contains(Elevator.PROP_OPEN_DELAY)) {
            activePanels.add(this.d_elevatorPropSect);
        }
        if (unshared.contains(Elevator.PROP_DISCHARGE_FLOOR)) {
            activePanels.add(this.d_elevatorLevelSect);
            activePanels.add(this.d_elevatorExtraSect);
        }
        if (MerlinApp.isFP() && propTypes.contains(Camera.PROP_SECURITY)) {
            activePanels.add(this.d_cameraControlSect);
            activePanels.add(this.d_cameraOrientSect);
            activePanels.add(this.d_cameraLimitsSect);
        }
        if (propTypes.contains(OccGroupObj.PROP_NAME) && !sel.contains(OccGroupTypeObj.class)) {
            activePanels.addAll(this.d_occGroupSect.getPanels());
        }
        if (propTypes.contains(ImportedGeom.PROP_OBJECT_TYPE) && propTypes.contains(ImportedGeom.PROP_IMPORTED_TYPE)) {
            activePanels.add(this.d_sceneGeomSect);
            activePanels.add(this.d_generateModelFromBIMSel);
        }
        if (sel.isExclusive(QueueObject.class, IQueueElement.class)) {
            if (sel.isExclusive(QueueService.class)) {
                activePanels.add(this.d_queuePanel.getQueueServiceEditPnl());
            }
            if (sel.isExclusive(QueuePath.class)) {
                activePanels.add(this.d_queuePanel.getQueuePathEditPnl());
            }
            if (sel.isExclusive(QueueObject.class)) {
                activePanels.add(this.d_queuePanel.getQueuePropPnl());
            }
            activePanels.add(this.d_queuePanel.getAddQueueElemPnl());
        }
        if (AttractorBehaviorSect.testProps(propTypes)) {
            activePanels.add(this.d_attractorBehaviorSect);
        }
        if (AttractorWaitAtAttractorSect.testProps(propTypes)) {
            activePanels.add(this.d_attractorWaitAtAttrSect);
        }
        if (AttractorGenSect.testProps(propTypes)) {
            activePanels.add(this.d_attractorGenSect);
        }
        if (AttractorAwarenessSect.testProps(propTypes)) {
            activePanels.add(this.d_attractorAwarenessSect);
        }
        if (AttractorInfluenceSect.testProps(propTypes)) {
            activePanels.add(this.d_attractorInfluenceSect);
        }
        if (OccTargetsSect.testProps(propTypes)) {
            activePanels.add(this.d_occTargetsSect);
        }
        propgb = new PropBuilder(activePanels);
        SelectionEditorPanel.addTagProps(propTypes, propgb);
        this.addComponentRestrictionsProfileFilter(this.d_md, sel, propgb, propTypes);
        propgb.finalizePropPnl();
        return activePanels;
    }

    private static GridBagHelper newHelper(EditorPanel pnl) {
        GridBagHelper propgb = new GridBagHelper(pnl);
        propgb.rowSpace = 1;
        return propgb;
    }

    private void addBehaviorPanels(MerlinSelectionModel sel, List<EditorPanel> activePanels) {
        activePanels.add(this.d_behaviorSect);
        if (sel.isExclusive(Behavior.class)) {
            activePanels.add(this.d_behaviorPropSect);
        } else if (sel.isExclusive(GotoWaypoint.class)) {
            activePanels.add(this.d_gotoWaypointSect);
        } else if (sel.isExclusive(GotoExits.class)) {
            activePanels.add(this.d_gotoExitsSect);
        } else if (sel.isExclusive(GotoElevators.class)) {
            activePanels.add(this.d_gotoElevatorsSect);
        } else if (sel.isExclusive(GotoRooms.class)) {
            activePanels.add(this.d_gotoRoomsSect);
        } else if (sel.isExclusive(GotoOccTarget.class)) {
            activePanels.add(this.d_gotoOccTargetsSect);
        } else if (sel.isExclusive(GotoOcc.class)) {
            activePanels.add(this.d_gotoOccSect1);
            activePanels.add(this.d_gotoOccSect2);
        } else if (sel.isExclusive(GotoCurrentAttractor.class)) {
            activePanels.add(this.d_gotoCurrentAttractorSect);
        } else if (sel.isExclusive(AbandonOccTargets.class)) {
            activePanels.add(this.d_abandonOccTargetsSect);
        } else if (sel.isExclusive(GotoQueue.class)) {
            activePanels.add(this.d_gotoQueueSect);
        } else if (sel.isExclusive(Wait.class)) {
            activePanels.add(this.d_waitSect);
        } else if (sel.isExclusive(WaitUntil.class)) {
            activePanels.add(this.d_waitUntilSect);
        } else if (sel.isExclusive(WaitForAssistance.class)) {
            activePanels.add(this.d_waitForAssistSect);
        } else if (sel.isExclusive(IWaitAction.class)) {
            activePanels.add(this.d_basicWaitSect);
        } else if (sel.isExclusive(AssistOccupants.class)) {
            activePanels.add(this.d_assistSect);
        } else if (sel.isExclusive(JoinOccGroup.class)) {
            activePanels.add(this.d_joinOccGroupSect);
        } else if (sel.isExclusive(ChangeTags.class)) {
            activePanels.add(this.d_changeTagsSect);
        } else if (sel.isExclusive(ChangeBehavior.class)) {
            activePanels.add(this.d_changeBehaviorSect);
        } else if (sel.isExclusive(ChangeProfile.class)) {
            activePanels.add(this.d_changeProfileSect);
        } else if (sel.isExclusive(ChangeProfileProp.class)) {
            activePanels.add(this.d_changeProfilePropSect);
        } else if (sel.isExclusive(RevertProfileProp.class)) {
            activePanels.add(this.d_revertProfilePropSect);
        } else if (sel.isExclusive(CreateAttractor.class)) {
            activePanels.add(this.d_createAttractorSect);
        } else if (sel.isExclusive(DestroyAttractor.class)) {
            activePanels.add(this.d_destroyAttractorSect);
        }
        IFilteredCollection<IBehaviorAction> terminalActions = sel.get(IBehaviorAction.class, ba -> ba.mustBeLast());
        if (terminalActions.isEmpty()) {
            activePanels.add(this.d_behaviorActSect);
        }
    }

    private static void addNameProp(Set<Object> propTypes, PropBuilder builder, boolean editable) {
        if (propTypes.contains(NamedMerlinObj.NAME)) {
            GridBagHelper propgb = builder.prepareNewRowGroup(1);
            guiTextField fldName = new guiTextField();
            Dimension d = fldName.getPreferredSize();
            fldName.setPreferredSize(new Dimension((int)(1.5 * (double)d.width), d.height));
            fldName.setToolTipText(Intl.intl("Name"));
            fldName.setEditable(editable);
            builder.addConnection(new NamePropConnection(fldName));
            propgb.addRow(fldName, 0, 1.0);
        }
    }

    private static void addMovementGroupProp(Set<Object> propTypes, PropBuilder builder, MerlinSelectionModel sel) {
        if (!propTypes.contains(EgressAgent.MOVEMENT_GROUP) || sel.isExclusive(OccGroupObj.class)) {
            return;
        }
        GridBagHelper propgb = builder.prepareNewRowGroup(1);
        HTMLBtn grpBtn = new HTMLBtn("");
        grpBtn.setToolTipText(Intl.intl("Movement Group"));
        builder.addConnection(new SelectNamedPropConnection(EgressAgent.MOVEMENT_GROUP, grpBtn));
        propgb.addRow(grpBtn, 0, 1.0);
    }

    private static void addVisibilityProp(Set<Object> propTypes, PropBuilder builder) {
        if (propTypes.contains(MerlinData.VISIBILITY)) {
            GridBagHelper propgb = builder.prepareNewRowGroup(1);
            guiMultiStateCheckBox ckVisible = new guiMultiStateCheckBox(Intl.intl("Visible"));
            builder.addConnection(new VisPropConnection(ckVisible));
            propgb.addRow(ckVisible, 0);
        }
    }

    private static boolean testMaterialProp(Set<Object> propTypes, Set<Object> propTypesUnion) {
        return propTypes.contains(MerlinData.MATERIAL) || SelectionEditorPanel.testColorProp(propTypes) && propTypesUnion.contains(MerlinData.MATERIAL);
    }

    private static void addMaterialProp(Set<Object> propTypes, Set<Object> propTypesUnion, PropBuilder builder) {
        if (SelectionEditorPanel.testMaterialProp(propTypes, propTypesUnion)) {
            MaterialBtn btn = new MaterialBtn(true);
            GridBagHelper propgb = builder.prepareNewRowGroup(1);
            builder.addConnection(new MaterialConn(btn));
            propgb.addRow(Intl.intl("Material:"), btn, 1.0, 0);
        }
    }

    private static boolean testColorProp(Set<Object> propTypes) {
        return propTypes.contains(MerlinData.COLOR);
    }

    private static void addColorProp(Set<Object> propTypes, PropBuilder builder, MerlinSelectionModel sel) {
        if (SelectionEditorPanel.testColorProp(propTypes)) {
            JComponent lblComp;
            GridBagHelper propgb = builder.prepareNewRowGroup(1);
            ColorButton cb = SelectionEditorPanel.newColorButton();
            builder.addConnection(new ColorConn(cb));
            if (sel.isDeepEmpty(ImportedGeom.class)) {
                guiMultiStateCheckBox colorCB = new guiMultiStateCheckBox(Intl.intl("Color:"));
                LinkStatus.link((AbstractButton)colorCB, cb);
                builder.addConnection(new BoolPropConnection(new ColorDefProp(), colorCB));
                lblComp = colorCB;
            } else {
                lblComp = new guiLabel(Intl.intl("Color:"));
            }
            propgb.addRow(lblComp, cb, 1.0, 0);
        }
    }

    private static boolean testOpacityProp(Set<Object> propTypes) {
        return propTypes.contains(MerlinData.OPACITY);
    }

    private static void addOpacityProp(Set<Object> propTypes, PropBuilder builder) {
        if (SelectionEditorPanel.testOpacityProp(propTypes)) {
            MerlinUDF opacityFld = new MerlinUDF(NonSI.PERCENT);
            GridBagHelper propgb = builder.prepareNewRowGroup(1);
            builder.addConnection(new OpacityConn(opacityFld));
            propgb.addRow(Intl.intl("Opacity:"), opacityFld, 1.0);
        }
    }

    private static ColorButton newColorButton() {
        ColorButton cb = new ColorButton(1);
        cb.setText(Intl.intl("<multiple>"));
        Insets margin = cb.getMargin();
        cb.setMargin(new Insets(margin.top, 3, margin.bottom, 3));
        return cb;
    }

    public void updatePanels() {
        MerlinSelectionModel sel = this.d_md.selection;
        for (EditorPanel panel : this.d_activePanels) {
            panel.release();
        }
        Set<ICompElement> objs = sel.getSelected(ICompElement.class);
        this.d_activePanels = this.getActivePanels(objs);
        for (EditorPanel pp : this.d_activePanels) {
            pp.bind(objs);
        }
    }

    private void updateLayout() {
        EventQueue.invokeLater(() -> {
            this.removeAll();
            for (EditorPanel panel : this.d_activePanels) {
                this.addSeparator();
                this.addSection(panel);
            }
            SwingUtilities.updateComponentTreeUI(this);
        });
    }

    @Override
    public void update(Events events) {
        for (EventChannel channel : events.getChannels()) {
            if (!channel.containsChange(MerlinData.SELECTION_CHANGED) && !channel.containsChange(MerlinData.CHILD_ADDED) && !channel.containsChange(MerlinData.CHILD_REMOVED) && !channel.getChangedObjs(MerlinData.SUPPORTED_PROPS_CHANGED).stream().anyMatch(o -> this.d_md.selection.isSelected(o))) continue;
            this.updatePanels();
            this.updateLayout();
            break;
        }
        for (EditorPanel panel : this.d_activePanels) {
            panel.update(events);
        }
    }

    private static int countOccupants(MerlinData md, OccSourceObj source) {
        Function1dProp fprop = OccSourceObj.PROP_FLOW_RATE;
        IFunction1d fr = source.get(fprop);
        return fr.getMaxNumOccs(source.getSeed(), md.simParams.runTimeMax);
    }

    private static void addTagProps(Set<Object> props, PropBuilder builder) {
        if (!props.contains(IEgressComp.CUSTOM_OCC_TAGS)) {
            return;
        }
        TagsField tagsEd = new TagsField();
        tagsEd.setNullAllowed(true);
        tagsEd.setColumns(10);
        builder.addConnection(new ValueFieldPropConn<Set>(new CompElementActions.DefProp(IEgressComp.CUSTOM_OCC_TAGS), tagsEd, Set.class));
        GridBagHelper gb = builder.prepareNewRowGroup(1);
        gb.addRow(guiUtil.lbl(Intl.intl("Occupant Tags:"), "<html>" + Intl.intl("Tags that are applied to occupants when they use the component.<br>For doors, the tags are applied when the occupant crosses the door. For <br>other components, the tags are applied when the occupant enters the space<br>and removed when the occupant exits the space.")), tagsEd);
    }

    private static void addWaitActionMode(EditorPanel pnl, GridBagHelper gb) {
        guiComboBox<WaitMode> modeCombo = guiUtil.newCombo(m -> m == null ? new Pair<String, String>(Intl.intl("<mixed>"), null) : guiUtil.encodeToHtmlLabels(m.name, m.desc), WaitMode.values());
        pnl.addConnection(new ComboPropConn<WaitMode>(new CompElementActions.DefProp(IWaitAction.MODE), modeCombo));
        gb.addRow(guiUtil.lbl(Intl.intl("Wait Mode:"), Intl.intl("Defines how the occupant will wait during this action.")), modeCombo, 0);
    }

    private static String format(IEgressFlowrate value, guiUnitDoubleField flowFld) {
        if (value == null) {
            return "";
        }
        if (value instanceof IEgressFlowrate.FromDensity) {
            return Intl.intl("<from density>");
        }
        IEgressFlowrate.Limited limited = (IEgressFlowrate.Limited)value;
        if (Double.isInfinite(limited.maxVal.getValueNoUnit())) {
            return Intl.intl("<unlimited>");
        }
        flowFld.setValue(limited.maxVal);
        return flowFld.getText();
    }

    private static UnitDouble getDoorWidth(ICompElement obj) {
        Object width = obj.getProperty(EgressDoor.WIDTH);
        if (width instanceof Double) {
            return new UnitDouble((Double)width, SI.METER);
        }
        if (width instanceof UnitDouble) {
            return (UnitDouble)width;
        }
        return new UnitDouble(0.0, SI.METER);
    }

    private static void addFlowrate(EditorPanel panel, GridBagHelper gb) {
        final MerlinUDF tempFld = new MerlinUDF(13);
        final UnitDouble UD_UNLIMITED = SIUS.newud(Double.POSITIVE_INFINITY, 13);
        final UnitDouble UD_FROM_DENSITY = SIUS.newud(0.0, 13);
        guiComboBox<IEgressFlowrate> flowrateCB = new guiComboBox<IEgressFlowrate>(new IEgressFlowrate[]{IEgressFlowrate.UNLIMITED}){
            private static final long serialVersionUID = -1471184688536134285L;

            @Override
            public boolean validateData(boolean showWarn, boolean allowModify) {
                Validateable v;
                Component c;
                if (!super.validateData(showWarn, allowModify)) {
                    return false;
                }
                if (!this.isEnabled()) {
                    return true;
                }
                return !this.isEditable() || !((c = this.getEditor().getEditorComponent()) instanceof Validateable) || (v = (Validateable)((Object)c)).validateData(showWarn, allowModify);
            }
        };
        flowrateCB.setRenderer(new DefaultListCellRenderer(){
            private static final long serialVersionUID = 1684955252114518199L;

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                this.setText(SelectionEditorPanel.format((IEgressFlowrate)value, tempFld));
                return this;
            }
        });
        flowrateCB.setEditable(true);
        flowrateCB.setEditor(new BasicComboBoxEditor(){

            @Override
            protected JTextField createEditorComponent() {
                MerlinUDF flowFld = new MerlinUDF(13);
                flowFld.setBorder(null);
                flowFld.aliasValue(null, "");
                flowFld.aliasValue(UD_UNLIMITED, SelectionEditorPanel.format(IEgressFlowrate.UNLIMITED, tempFld));
                flowFld.aliasValue(UD_FROM_DENSITY, SelectionEditorPanel.format(IEgressFlowrate.FROM_DENSITY, tempFld));
                return flowFld;
            }

            @Override
            public Object getItem() {
                guiUnitDoubleField flowFld = this.getField();
                if (!this.getField().validateData(true, true)) {
                    return null;
                }
                UnitDouble val = (UnitDouble)flowFld.getValue();
                if (val == null) {
                    return null;
                }
                if (val == UD_UNLIMITED) {
                    return IEgressFlowrate.UNLIMITED;
                }
                if (val == UD_FROM_DENSITY) {
                    return IEgressFlowrate.FROM_DENSITY;
                }
                return new IEgressFlowrate.Limited(val);
            }

            @Override
            public void setItem(Object anObject) {
                guiUnitDoubleField flowFld = this.getField();
                UnitDouble val = anObject == null ? null : (anObject instanceof IEgressFlowrate.FromDensity ? UD_FROM_DENSITY : ((IEgressFlowrate.Limited)anObject).maxVal);
                flowFld.setValue(val);
            }

            private guiUnitDoubleField getField() {
                return (guiUnitDoubleField)this.getEditorComponent();
            }
        });
        final ComboPropConn<IEgressFlowrate> comboProp = new ComboPropConn<IEgressFlowrate>(new FlowrateProp(), flowrateCB);
        panel.addConnection(comboProp);
        guiMultiStateCheckBox overrideParentCB = new guiMultiStateCheckBox(Intl.intl("Flow Rate:"));
        String overrideTT = "<html>" + Intl.intl("If checked, sets a custom flow rate limit for selected doors.<br>If unchecked, uses the default flow rate limit set in the <b>Simulation Parameters</b>.") + "</html>";
        overrideParentCB.setToolTipText(overrideTT);
        panel.addConnection(new BoolPropConnection(new FlowrateOverrideProp(), overrideParentCB){

            @Override
            public void apply(CompElementActions.IObjectProp<ICompElement, Boolean> prop, Collection<? extends ICompElement> objs, Boolean val) {
                super.apply(prop, objs, val);
                comboProp.initFromProp();
            }
        });
        LinkStatus.link((AbstractButton)overrideParentCB, flowrateCB);
        gb.addRow(overrideParentCB, flowrateCB, 0, 1.0);
    }

    private static void addTagCheckBox(EditorPanel panel, GridBagHelper gb, IPropertySet.Prop<Set<String>> tagProp, final String tag) {
        guiMultiStateCheckBox refugeCB = new guiMultiStateCheckBox(Intl.intl("Refuge Area"));
        refugeCB.setToolTipText(Intl.intl("Specifies whether the component is considered a refuge area."));
        CompElementActions.DefProp<ICompElement, Boolean> prop = new CompElementActions.DefProp<ICompElement, Boolean>(tagProp){

            @Override
            protected Object get(MerlinData md, Object prop, ICompElement obj) {
                Object val = obj.getProperty(prop);
                if (val instanceof Set) {
                    return ((Set)val).contains(tag);
                }
                return val;
            }

            @Override
            public void set(MerlinData md, Collection<? extends ICompElement> objs, Boolean newVal) {
                if (newVal != null && !newVal.booleanValue()) {
                    Collection<IEgressOccupiable> rooms = MerlinUtil.flatten(objs, IEgressOccupiable.class);
                    Set<Object> roomsSet = rooms instanceof Set ? (Set<Object>)rooms : new IdentityHashSet<IEgressOccupiable>(rooms);
                    LinkedIdentityHashSet gotoRooms = new LinkedIdentityHashSet();
                    Predicate<GotoRooms> roomTest = gr -> gr.getFilter().equals(RefugeFilter.INSTANCE);
                    Dependencies.getObjReferences(md.behaviors.flatten(GotoRooms.class, roomTest), IEgressOccupiable.class, Filters.accept(roomsSet, ICompElement.class), (obj, target) -> {
                        if (obj instanceof GotoRooms && roomTest.test((GotoRooms)obj)) {
                            gotoRooms.add((GotoRooms)obj);
                        }
                    });
                    if (!gotoRooms.isEmpty()) {
                        Undo.insertUndoEntry_propRestore(md, gotoRooms, GotoRooms.PROP_ROOMS);
                        for (GotoRooms gr2 : gotoRooms) {
                            LinkedIdentityHashSet<IEgressOccupiable> grrooms = new LinkedIdentityHashSet<IEgressOccupiable>((Collection<IEgressOccupiable>)gr2.getRooms());
                            grrooms.removeAll(roomsSet);
                            gr2.setRooms(grrooms);
                        }
                    }
                }
                super.set(md, objs, newVal);
            }

            @Override
            protected void set(MerlinData md, Object prop, ICompElement obj, Boolean newVal) {
                Object val = obj.getProperty(prop);
                if (newVal != null && val instanceof Set) {
                    HashSet<String> tags = (HashSet<String>)val;
                    if (newVal.booleanValue() && !tags.contains(tag)) {
                        tags = new HashSet<String>(tags);
                        tags.add(tag);
                    } else if (!newVal.booleanValue() && tags.contains(tag)) {
                        tags = new HashSet(tags);
                        tags.remove(tag);
                    }
                    obj.setProperty(prop, tags);
                }
            }
        };
        panel.addConnection(new BoolPropConnection((CompElementActions.IObjectProp<ICompElement, Boolean>)prop, refugeCB));
        gb.addRow(refugeCB, 0);
    }

    private static void addSpeedModifier(EditorPanel panel, GridBagHelper gb) {
        final CardLayout cardLayout = new CardLayout();
        final guiPanel cardPnl = new guiPanel(cardLayout);
        for (SpeedModifier.Type type2 : SpeedModifier.Type.values()) {
            ValueField<UnitDouble> fld = MerlinValueFields.udFld(type2.valueUnitType);
            for (SpeedModifier.ValueAlias alias : type2.valueAliases) {
                fld.alias(alias.value, alias.alias);
            }
            UDVarEditor velEditor = new UDVarEditor(fld);
            for (SpeedModifier.ValueAlias alias : type2.valueAliases) {
                velEditor.addAdditionalMessage(alias.description);
            }
            VariantButton<UnitDouble> btn = new VariantButton<UnitDouble>(type2.name, velEditor);
            panel.addConnection(new VariantProp<UnitDouble>(new SpeedModifierValProp(type2), btn));
            cardPnl.add(btn, type2.name());
        }
        guiComboBox<SpeedModifier.Type> typesCB = guiUtil.newCombo(type -> type == null ? new Pair<String, Object>("", null) : new Pair<String, String>(type.name, type.shortDesc), SpeedModifier.Type.values());
        ComboPropConn<SpeedModifier.Type> typeConn = new ComboPropConn<SpeedModifier.Type>((CompElementActions.IObjectProp)new SpeedModifierTypeProp(), typesCB){

            @Override
            public void initFromProp(Object prop, Collection<? extends ICompElement> objs, guiComboBox<SpeedModifier.Type> comp) {
                super.initFromProp(prop, objs, comp);
                EnumSet<SpeedModifier.Type> disallowedTypes = EnumSet.noneOf(SpeedModifier.Type.class);
                for (ICompElement obj : MerlinUtil.flatten(objs, ICompElement.class)) {
                    Optional<Predicate<SpeedModifier.Type>> tfilter = obj.getProp(SpeedModifier.PROP_TYPE_FILTER);
                    tfilter.ifPresent(filter -> {
                        for (SpeedModifier.Type type : SpeedModifier.Type.values()) {
                            if (disallowedTypes.contains((Object)type) || filter.test(type)) continue;
                            disallowedTypes.add(type);
                        }
                    });
                    if (disallowedTypes.size() != SpeedModifier.Type.values().length) continue;
                    break;
                }
                SpeedModifier.Type newSel = comp.getSelectedItem();
                IListenerStripper prevListeners = guiUtil.stripListeners(comp);
                comp.removeAllItems();
                for (SpeedModifier.Type type : SpeedModifier.Type.values()) {
                    if (disallowedTypes.contains((Object)type)) continue;
                    comp.addItem((SpeedModifier.Type)type);
                }
                if (!disallowedTypes.contains((Object)newSel)) {
                    comp.setSelectedItem((Object)newSel);
                } else {
                    newSel = null;
                }
                comp.setModified(false);
                prevListeners.restore();
                if (newSel != null) {
                    cardPnl.setEnabled(true);
                    cardLayout.show(cardPnl, newSel.name());
                } else {
                    cardPnl.setEnabled(false);
                }
            }
        };
        panel.addConnection(typeConn);
        gb.addRow(typesCB, cardPnl);
    }

    private static void addCapacityEditor(EditorPanel panel, GridBagHelper gb) {
        CapacityEditor editor = new CapacityEditor();
        CompElementActions.DefProp<ICompElement, IFunction1d> prop = new CompElementActions.DefProp<ICompElement, IFunction1d>(AEgressComp.PROP_CAPACITY);
        final ValEditorConn connection = new ValEditorConn(prop, editor);
        panel.addConnection(connection);
        guiMultiStateCheckBox enableCapacityCb = new guiMultiStateCheckBox(Intl.intl("Capacity:"));
        String enableCapacityTT = "<html>" + Intl.intl("If checked, sets a custom capacity limit for selected components.<br>If unchecked, no capacity limit is used for selected components.") + "</html>";
        enableCapacityCb.setToolTipText(enableCapacityTT);
        panel.addConnection(new BoolPropConnection(new CompElementActions.DefProp(AEgressComp.PROP_CAPACITY_ENABLED), enableCapacityCb){

            @Override
            public void apply(CompElementActions.IObjectProp<ICompElement, Boolean> prop, Collection<? extends ICompElement> objs, Boolean val) {
                super.apply(prop, objs, val);
                connection.initFromProp();
            }
        });
        LinkStatus.link((AbstractButton)enableCapacityCb, editor);
        gb.addRow(enableCapacityCb, editor, 0, 1.0);
    }

    private static void addCorridorDoorState(EditorPanel pnl, GridBagHelper gb) {
        VariantButton stateBtn = new VariantButton(Intl.intl("Door State"), new DiscreteVarEditor(true, Intl.intl("Open"), false, Intl.intl("Closed")));
        pnl.addConnection(new VariantProp(new CompElementActions.DefProp(IEgressConnector.STATE), stateBtn));
        gb.addRow(Intl.intl("State:"), stateBtn, 1.0, 0);
    }

    private static void addConnectorState(EditorPanel pnl, GridBagHelper gb) {
        VariantButton<EgressDoorDir> stateBtn = new VariantButton<EgressDoorDir>(Intl.intl("Door State"), new DiscreteVarEditor<EgressDoorDir>(EgressDoorDir.getMap(Predicates.alwaysTrue())));
        pnl.addConnection(new VariantProp<EgressDoorDir>(new CompElementActions.DefProp(IEgressConnector.STATE), stateBtn));
        gb.addRow(Intl.intl("State:"), stateBtn, 1.0, 0);
    }

    private static <ObjT extends ICompElement, PropT> CompElementActions.DefProp<ObjT, PropT> newRestoreProp(Object prop) {
        return new CompElementActions.DefProp<ObjT, PropT>(prop){

            @Override
            protected void saveState(MerlinData md, Object prop, Collection<? extends ObjT> objs, PropT newVal) {
                List<ICompElement> modObjs = CompElementActions.flattenToLocallyDefined(prop, objs);
                Undo.insertUndoEntry_restore(md, theUtil.filter(modObjs, IRestorable.class));
            }
        };
    }

    private static void adjustHeight(JComponent comp) {
        comp.setPreferredSize(new Dimension(comp.getPreferredSize().width, SelectionEditorPanel.s_dmyLbl.getPreferredSize().height - 2));
    }

    private void addComponentRestrictionsProfileFilter(MerlinData md, MerlinSelectionModel sel, PropBuilder builder, Set<Object> props) {
        if (!OccProfile.CompRestrictions.allAcceptableTypes(sel)) {
            return;
        }
        builder.addConnection(new ProfileFilterConn(new CompElementActions.DefProp(OccProfile.PROP_RESTRICTED_COMPONENTS), this.d_profileChooser, md));
        GridBagHelper gb = builder.prepareNewRowGroup(1);
        gb.add(Intl.intl("Accepted Profiles:"), this.d_profileChooser);
    }

    private static Set<Elevator> getElevators(Collection<? extends ICompElement> objs) {
        LinkedIdentityHashSet<Elevator> elevators = new LinkedIdentityHashSet<Elevator>();
        for (ICompElement iCompElement : objs) {
            if (iCompElement instanceof Elevator) {
                elevators.add((Elevator)iCompElement);
                continue;
            }
            if (!(iCompElement instanceof Composite)) continue;
            elevators.addAll(((Composite)iCompElement).getDeepMembers(Elevator.class));
        }
        return elevators;
    }

    public static <ObjT extends ICompElement, PropT> void setPropRecursive(String actionName, CompElementActions.IObjectProp<ObjT, PropT> prop, Collection<? extends ObjT> objs, PropT newVal) {
        Undo.begin(actionName);
        MerlinData md = MerlinApp.getApp().getData();
        prop.set(md, objs, newVal);
        Undo.end(MerlinApp.getApp().getData());
    }

    public static class EditorPanel
    extends guiPanel
    implements IPropConnection {
        private static final long serialVersionUID = 475979557780107511L;
        private List<IPropConnection> d_conns = new LinkedList<IPropConnection>();
        private Collection<ICompElement> d_objs = Collections.EMPTY_LIST;

        @Override
        public void setVisible(boolean visible) {
            super.setVisible(visible);
            Container parent = this.getParent();
            if (parent instanceof APropEditPanel) {
                ((APropEditPanel)parent).setPriorSeparatorVisible(this, visible);
            }
        }

        @Override
        public void update(Events events) {
            for (IPropConnection conn : this.d_conns) {
                conn.update(events);
            }
        }

        @Override
        public void commit() {
            for (IPropConnection conn : this.d_conns) {
                conn.commit();
            }
        }

        protected void addConnection(IPropConnection conn) {
            this.d_conns.add(conn);
        }

        @Override
        public void bind(Collection<ICompElement> objs) {
            this.d_objs = objs;
            for (IPropConnection conn : this.d_conns) {
                conn.bind(objs);
            }
        }

        @Override
        public void release() {
            for (IPropConnection conn : this.d_conns) {
                conn.release();
            }
            this.d_objs = Collections.EMPTY_LIST;
        }

        public Collection<ICompElement> getObjects() {
            return this.d_objs;
        }
    }

    private static class VisPropConnection
    extends BoolPropConnection {
        public VisPropConnection(guiMultiStateCheckBox control) {
            super((CompElementActions.IObjectProp<ICompElement, Boolean>)new CompElementActions.DefProp<ICompElement, Boolean>(MerlinData.VISIBILITY){

                @Override
                public void set(MerlinData md, Collection<? extends ICompElement> objs, Boolean newVal) {
                    Collection<Object> toShow = Collections.EMPTY_LIST;
                    Collection<Object> toHide = Collections.EMPTY_LIST;
                    if (newVal.booleanValue()) {
                        toShow = objs;
                    } else {
                        toHide = objs;
                    }
                    Visibility.setVisibility(MerlinApp.getApp().getData(), toShow, toHide, true);
                }
            }, control);
        }
    }

    public static class BoolPropConnection
    extends ASinglePropConnection<guiMultiStateCheckBox> {
        public BoolPropConnection(CompElementActions.IObjectProp<ICompElement, Boolean> prop, guiMultiStateCheckBox control) {
            super(prop, control);
            control.addItemListener(this);
        }

        @Override
        public void setProp(Object prop, Collection<? extends ICompElement> objs, guiMultiStateCheckBox comp) {
            if (comp.getState() != 2) {
                Boolean newval = comp.isSelected() ? Boolean.TRUE : Boolean.FALSE;
                this.apply((CompElementActions.IObjectProp)prop, objs, newval);
            }
        }

        public void apply(CompElementActions.IObjectProp<ICompElement, Boolean> prop, Collection<? extends ICompElement> objs, Boolean val) {
            SelectionEditorPanel.setPropRecursive(Intl.intl("Set Property"), prop, objs, val);
        }

        @Override
        public void initFromProp(Object prop, Collection<? extends ICompElement> objs, guiMultiStateCheckBox comp) {
            Object val = ((CompElementActions.IObjectProp)prop).get(MerlinApp.getApp().getData(), objs);
            if (val instanceof Boolean) {
                comp.setMode(0);
                Boolean b = (Boolean)val;
                if (b.booleanValue()) {
                    comp.setSelected(true);
                } else {
                    comp.setSelected(false);
                }
            } else {
                comp.setMode(1);
                comp.setState(2);
                ItemEvent evt = new ItemEvent(comp.getModel(), 2000, comp.getModel(), 2);
                for (ItemListener il : comp.getItemListeners()) {
                    il.itemStateChanged(evt);
                }
            }
            comp.setModified(false);
        }
    }

    public static class DistributionConn<T>
    extends ASinglePropConnection<AValEditor<IUrn<T>>> {
        private final String setPropMsg;

        public DistributionConn(Object prop, AValEditor<IUrn<T>> comp, String setPropMsg) {
            super(prop, comp);
            this.setPropMsg = setPropMsg;
            comp.addValueListener(e -> this.onControlChanged());
        }

        @Override
        public void setProp(Object prop, Collection<? extends ICompElement> objs, AValEditor<IUrn<T>> comp) {
            IUrn<T> dist = comp.getValue();
            SelectionEditorPanel.setPropRecursive(this.setPropMsg, (CompElementActions.IObjectProp)prop, objs, dist);
        }

        @Override
        public void initFromProp(Object prop, Collection<? extends ICompElement> objs, AValEditor<IUrn<T>> comp) {
            Object val = ((CompElementActions.IObjectProp)prop).get(MerlinApp.getApp().getData(), objs);
            if (val instanceof IUrn) {
                comp.setValue((IUrn)val);
            } else {
                comp.setValue(null);
            }
            comp.setModified(false);
        }
    }

    public static class NamePropConnection
    extends TextPropConnection {
        public NamePropConnection(guiTextField control) {
            super(NamedMerlinObj.NAME, control);
        }

        protected void setProp(MerlinData md, Object prop, Collection<ICompElement> objs, String newText) {
            RenameAction.rename(md, objs, newText);
        }
    }

    public static class StringPropConnection
    extends ASinglePropConnection<guiTextArea> {
        public StringPropConnection(Object prop, guiTextArea control) {
            super(prop, control);
            control.addFocusListener(this);
            control.addKeyListener(this);
        }

        @Override
        public void initFromProp(Object prop, Collection<? extends ICompElement> objs, guiTextArea comp) {
            Object val = Composite.getProperty(prop, objs);
            if (val instanceof String) {
                String s = (String)val;
                comp.setValue(s);
                comp.setCaretPosition(0);
            } else {
                comp.setText("");
            }
            comp.setModified(false);
        }

        @Override
        public void setProp(Object prop, Collection<? extends ICompElement> objs, guiTextArea comp) {
            if (!comp.getText().isEmpty() && comp.isModified() && comp.validateData(false, true)) {
                MerlinData md = MerlinApp.getApp().getData();
                assert (md != null);
                this.setProp(prop, objs, comp.getValue());
                comp.setModified(false);
            }
            comp.selectAll();
        }

        @Override
        public void setProp(Object prop, Collection<? extends ICompElement> objs, Object newText) {
            MerlinData md = MerlinApp.getApp().getData();
            Undo.begin(Intl.intl("Set Property"));
            Undo.insertUndoEntry_propRestore(md, objs, prop);
            Composite.setProperty(prop, newText, objs);
            Undo.end(md);
        }
    }

    public static class TextPropConnection
    extends ASinglePropConnection<guiTextField> {
        public TextPropConnection(Object prop, guiTextField control) {
            super(prop, control);
            control.addFocusListener(this);
            control.addKeyListener(this);
        }

        @Override
        public void initFromProp(Object prop, Collection<? extends ICompElement> objs, guiTextField comp) {
            Object val = Composite.getProperty(prop, objs);
            if (val instanceof String) {
                String s = (String)val;
                comp.setValue(s);
                comp.setCaretPosition(0);
            } else {
                comp.setText("");
            }
            comp.setModified(false);
        }

        @Override
        public void setProp(Object prop, Collection<? extends ICompElement> objs, guiTextField comp) {
            if (!comp.getText().isEmpty() && comp.isModified() && comp.validateData(false, true)) {
                MerlinData md = MerlinApp.getApp().getData();
                assert (md != null);
                this.setProp(prop, objs, comp.getValue());
                comp.setModified(false);
            }
            comp.selectAll();
        }

        @Override
        public void setProp(Object prop, Collection<? extends ICompElement> objs, Object newText) {
            MerlinData md = MerlinApp.getApp().getData();
            Undo.begin(Intl.intl("Set Property"));
            Undo.insertUndoEntry_propRestore(md, objs, prop);
            Composite.setProperty(prop, newText, objs);
            Undo.end(md);
        }
    }

    public static class SelectNamedPropConnection
    extends ASinglePropConnection<HTMLBtn> {
        public SelectNamedPropConnection(Object prop, HTMLBtn control) {
            super(prop, control);
            control.addFocusListener(this);
            control.addKeyListener(this);
        }

        @Override
        public void setProp(Object prop, Collection<? extends ICompElement> objs, HTMLBtn comp) {
        }

        @Override
        public void initFromProp(Object prop, Collection<? extends ICompElement> objs, HTMLBtn comp) {
            Object val = Composite.getProperty(prop, objs);
            comp.setText("");
            comp.setVisible(false);
            if (val instanceof INamed) {
                INamed named = (INamed)val;
                comp.setText(named.getName());
                comp.setVisible(true);
                comp.addActionListener(new SelectNamedAction(named));
            }
        }

        private static class SelectNamedAction
        extends AMerlinOp
        implements ActionListener {
            private static INamed d_named;

            public SelectNamedAction(INamed named) {
                d_named = named;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                UIHook.run(UIHook.getComponent(e), "SelectNamedAction", this, 0);
            }

            @Override
            public void run(MerlinApp app, MerlinData md) {
                md.beginWrite();
                try {
                    md.selection.set(d_named);
                }
                finally {
                    md.endWrite();
                }
            }
        }
    }

    public static class ValueFieldPropConn<T>
    extends ASinglePropConnection<guiFormattedFld<T>> {
        private final Class<T> d_type;

        public ValueFieldPropConn(CompElementActions.IObjectProp<ICompElement, T> prop, guiFormattedFld<T> control, Class<T> type) {
            super(prop, control, false);
            this.d_type = type;
            control.setNullAllowed(true);
            control.addValueChangeListener(e -> this.onControlChanged());
        }

        @Override
        public void initFromProp(Object prop, Collection<? extends ICompElement> objs, guiFormattedFld<T> comp) {
            Object val = ((CompElementActions.IObjectProp)prop).get(MerlinApp.getApp().getData(), objs);
            this.initFromVal(val, comp);
        }

        public void initFromVal(Object val, guiFormattedFld<T> comp) {
            if (this.d_type.isInstance(val)) {
                comp.setValue(this.d_type.cast(val));
            } else {
                comp.setValue(null);
            }
            comp.setModified(false);
        }

        @Override
        public void setProp(Object prop, Collection<? extends ICompElement> objs, guiFormattedFld<T> comp) {
            if (comp.validateData(false, true)) {
                if (comp.getValue() != null) {
                    this.apply((CompElementActions.IObjectProp)prop, objs, comp.getValue());
                    this.initFromProp(prop, objs, comp);
                }
            } else {
                comp.setValue(comp.getValue());
            }
            comp.selectAll();
        }

        protected void apply(CompElementActions.IObjectProp<ICompElement, T> prop, Collection<? extends ICompElement> objs, T val) {
            SelectionEditorPanel.setPropRecursive(Intl.intl("Set Property"), prop, objs, val);
        }
    }

    public static class NumberPropConn<NT>
    extends ASinglePropConnection<guiValueField<NT>> {
        private final Class<NT> d_type;

        public NumberPropConn(CompElementActions.IObjectProp<ICompElement, NT> prop, guiValueField<NT> control, Class<NT> type) {
            super(prop, control);
            this.d_type = type;
            control.setEmptyAllowed(true);
            control.addFocusListener(this);
            control.addKeyListener(this);
        }

        @Override
        public void initFromProp(Object prop, Collection<? extends ICompElement> objs, guiValueField<NT> comp) {
            Object val = ((CompElementActions.IObjectProp)prop).get(MerlinApp.getApp().getData(), objs);
            this.initFromVal(val, comp);
        }

        public void initFromVal(Object val, guiValueField<NT> comp) {
            if (this.d_type.isInstance(val)) {
                comp.setValue(this.d_type.cast(val));
            } else {
                comp.setValue(null);
            }
            comp.setModified(false);
        }

        @Override
        public void setProp(Object prop, Collection<? extends ICompElement> objs, guiValueField<NT> comp) {
            if (comp.validateData(false, true)) {
                if (comp.getValue() != null) {
                    this.apply((CompElementActions.IObjectProp)prop, objs, comp.getValue());
                    this.initFromProp(prop, objs, comp);
                }
            } else {
                comp.setValue(comp.getValue());
            }
            comp.selectAll();
        }

        protected void apply(CompElementActions.IObjectProp<ICompElement, NT> prop, Collection<? extends ICompElement> objs, NT val) {
            SelectionEditorPanel.setPropRecursive(Intl.intl("Set Property"), prop, objs, val);
        }
    }

    public static class IntPropConn
    extends NumberPropConn<Integer> {
        public IntPropConn(CompElementActions.IObjectProp<ICompElement, Integer> prop, guiIntField control) {
            super(prop, control, Integer.class);
        }
    }

    public static class DoublePropConn
    extends NumberPropConn<Double> {
        public DoublePropConn(CompElementActions.IObjectProp<ICompElement, Double> prop, guiDoubleField control) {
            super(prop, control, Double.class);
        }
    }

    public static class UDPropConnection
    extends NumberPropConn<UnitDouble> {
        public UDPropConnection(CompElementActions.IObjectProp<ICompElement, UnitDouble> prop, guiUnitDoubleField control) {
            super(prop, control, UnitDouble.class);
        }
    }

    private static class DToUDProp<ObjT>
    implements CompElementActions.IObjectProp<ObjT, UnitDouble> {
        private final Unit d_storageUnit;
        private final CompElementActions.IObjectProp<ObjT, Double> d_dProp;

        public DToUDProp(Unit storageUnit, CompElementActions.IObjectProp<ObjT, Double> dProp) {
            this.d_storageUnit = storageUnit;
            this.d_dProp = dProp;
        }

        @Override
        public Object get(MerlinData md, Collection<? extends ObjT> objs) {
            Object v = this.d_dProp.get(md, objs);
            return v instanceof Double ? new UnitDouble((Double)v, this.d_storageUnit) : v;
        }

        @Override
        public void set(MerlinData md, Collection<? extends ObjT> objs, UnitDouble newVal) {
            this.d_dProp.set(md, objs, newVal.getValue(this.d_storageUnit));
        }
    }

    private static class MaterialProp
    extends CompElementActions.DefProp<ICompElement, IMaterial> {
        public MaterialProp() {
            super(MerlinData.MATERIAL);
        }

        @Override
        public Object get(MerlinData md, Collection<? extends ICompElement> objs) {
            return super.get(md, CompElementActions.flattenToLocallyDefined(this.getProp(), objs));
        }

        private IMaterial[] getMats(MerlinData md, Object prop, ICompElement obj) {
            IMaterial[] mats = (IMaterial[])obj.getProperty(prop);
            if (mats.length > 1 && MerlinUtil.isUniform(mats)) {
                mats = new IMaterial[]{mats[0]};
            }
            return mats;
        }

        @Override
        protected Object get(MerlinData md, Object prop, ICompElement obj) {
            IMaterial[] mats = this.getMats(md, prop, obj);
            if (mats.length == 0) {
                return null;
            }
            if (mats.length == 1) {
                return mats[0];
            }
            return ICompElement.NON_UNIFORM;
        }

        @Override
        public void set(MerlinData md, Collection<? extends ICompElement> objs, IMaterial newVal) {
            super.set(md, CompElementActions.flattenToLocallyDefined(this.getProp(), objs), newVal);
        }

        @Override
        protected void set(MerlinData md, Object prop, ICompElement obj, IMaterial newVal) {
            IMaterial[] oldMats = this.getMats(md, prop, obj);
            if (oldMats.length == 1 && oldMats[0] == newVal) {
                return;
            }
            if (obj.getPropTypes(1).contains(ImportedGeom.PROP_GEOM)) {
                IGeomNode newGeom = (IGeomNode)obj.getProperty(ImportedGeom.PROP_GEOM);
                newGeom = GeomUtil.finalizeTexCoords(newGeom, MaterialProp.needsTexCoords(newVal));
                obj.setProperty(ImportedGeom.PROP_GEOM, newGeom);
            }
            obj.setProperty(prop, new IMaterial[]{newVal});
        }

        private static boolean needsTexCoords(IMaterial mat) {
            if (mat == null) {
                return false;
            }
            return mat.getAttributes().hasTexture();
        }

        @Override
        protected void saveState(MerlinData md, Object prop, Collection<? extends ICompElement> objs, IMaterial newVal) {
            Undo.insertUndoEntry_propRestore(md, objs, MerlinData.MATERIAL);
            if (Composite.getPropTypes(0, objs).contains(ImportedGeom.PROP_GEOM)) {
                Undo.insertUndoEntry_propRestore(md, objs, ImportedGeom.PROP_GEOM);
            }
        }
    }

    public static abstract class AMultiPropConnection<T extends JComponent>
    extends APropConnection<T> {
        private Collection<Object> d_props;

        public AMultiPropConnection(Collection<Object> props, T control) {
            this(props, control, true);
        }

        public AMultiPropConnection(Collection<Object> props, T control, boolean commitOnEnter) {
            super(control, commitOnEnter);
            this.d_props = props;
        }

        @Override
        public void commit() {
            if (!this.d_lock.tryAcquire()) {
                return;
            }
            try {
                if (this.isDataEmpty() || !this.isModified(this.d_control)) {
                    return;
                }
                MerlinData md = MerlinApp.getApp().getData();
                md.pauseUpdates();
                this.setProps(this.d_props, this.d_data, this.d_control);
                md.resumeUpdates();
                this.setModified(this.d_control, false);
            }
            finally {
                this.d_lock.release();
            }
        }

        @Override
        protected void initFromProp() {
            for (Object prop : this.d_props) {
                this.initFromProp(prop, this.d_data, this.d_control);
            }
        }

        public abstract void setProps(Collection<Object> var1, Collection<? extends ICompElement> var2, T var3);

        public abstract void initFromProp(Object var1, Collection<? extends ICompElement> var2, T var3);
    }

    public static abstract class ASinglePropConnection<T extends JComponent>
    extends APropConnection<T> {
        private Object d_prop;

        public ASinglePropConnection(Object prop, T control) {
            this(prop, control, true);
        }

        public ASinglePropConnection(Object prop, T control, boolean commitOnEnter) {
            super(control, commitOnEnter);
            this.d_prop = prop;
        }

        @Override
        public void commit() {
            if (!this.d_lock.tryAcquire()) {
                return;
            }
            try {
                if (this.isDataEmpty() || !this.isModified(this.d_control)) {
                    return;
                }
                MerlinData md = MerlinApp.getApp().getData();
                md.pauseUpdates();
                this.setProp(this.d_prop, this.d_data, this.d_control);
                md.resumeUpdates();
                this.setModified(this.d_control, false);
            }
            finally {
                this.d_lock.release();
            }
        }

        @Override
        protected void initFromProp() {
            this.initFromProp(this.d_prop, this.d_data, this.d_control);
        }

        public abstract void setProp(Object var1, Collection<? extends ICompElement> var2, T var3);

        public abstract void initFromProp(Object var1, Collection<? extends ICompElement> var2, T var3);
    }

    public static abstract class APropConnection<T extends JComponent>
    extends APropEditorListener
    implements IPropConnection {
        protected T d_control;
        protected Collection<ICompElement> d_data;
        private Action d_listenerAction;
        protected Semaphore d_lock;
        protected boolean d_live;

        protected APropConnection(T control) {
            this(control, true);
        }

        protected APropConnection(T control, boolean commitOnEnter) {
            this.d_control = control;
            this.d_live = true;
            this.d_lock = new Semaphore(1);
            this.d_listenerAction = new AbstractAction(){
                private static final long serialVersionUID = 3563125676559170424L;

                @Override
                public void actionPerformed(ActionEvent evt) {
                    this.onControlChanged();
                }
            };
            if (commitOnEnter) {
                KeyStroke enter = KeyStroke.getKeyStroke(10, 0);
                ((JComponent)this.d_control).getInputMap().put(enter, "enter");
                ((JComponent)this.d_control).getActionMap().put("enter", this.d_listenerAction);
            }
        }

        public T getControl() {
            return this.d_control;
        }

        public void setUpdateLock(Semaphore lock) {
            this.d_lock = lock;
        }

        public Semaphore getUpdateLock() {
            return this.d_lock;
        }

        protected boolean isLocked() {
            return this.d_lock.availablePermits() == 0;
        }

        public Collection<ICompElement> getObjs() {
            return this.d_data;
        }

        protected boolean isDataEmpty() {
            return this.d_data == null || this.d_data.isEmpty();
        }

        protected boolean isModified(T comp) {
            return !(this.d_control instanceof Modifiable) || ((Modifiable)this.d_control).isModified();
        }

        protected void setModified(T comp, boolean modified) {
            if (comp instanceof Modifiable) {
                ((Modifiable)comp).setModified(modified);
            }
        }

        @Override
        public void update(Events events) {
            if (!this.d_lock.tryAcquire()) {
                return;
            }
            try {
                if (this.isDataEmpty()) {
                    return;
                }
                this.initFromProp();
            }
            finally {
                this.d_lock.release();
            }
        }

        @Override
        public void keyPressed(KeyEvent evt) {
        }

        public void setLive(boolean live) {
            this.d_live = live;
        }

        public boolean isLive() {
            return this.d_live;
        }

        @Override
        public void onControlChanged() {
            if (this.d_live) {
                this.commit();
            }
        }

        @Override
        public void release() {
            this.d_data = Collections.EMPTY_LIST;
        }

        @Override
        public void bind(Collection<ICompElement> objs) {
            this.d_data = objs;
            Runnable r = () -> {
                if (!this.d_lock.tryAcquire()) {
                    return;
                }
                try {
                    if (this.isDataEmpty()) {
                        return;
                    }
                    this.initFromProp();
                }
                finally {
                    this.d_lock.release();
                }
            };
            SwingUtilities.invokeLater(r);
        }

        protected abstract void initFromProp();
    }

    public static abstract class APropEditorListener
    implements ItemListener,
    FocusListener,
    KeyListener,
    ActionListener,
    IEventObserver {
        public abstract void onControlChanged();

        @Override
        public void itemStateChanged(ItemEvent e) {
            this.onControlChanged();
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (!e.isTemporary()) {
                this.onControlChanged();
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            this.onControlChanged();
        }
    }

    public static interface IPropConnection
    extends IEventObserver {
        public void bind(Collection<ICompElement> var1);

        public void release();

        public void commit();
    }

    private static class OccGroupPnl
    extends EditorPanel {
        private static final long serialVersionUID = 1328596925645869644L;
        private EditorPanel panel1;
        private EditorPanel panel2;

        public OccGroupPnl(MerlinData md) {
            String followLeaderLbl = Intl.intl("Follow Leader:");
            guiMultiStateCheckBox cbFollowLeader = new guiMultiStateCheckBox(followLeaderLbl);
            cbFollowLeader.setToolTipText(Intl.intl("Whether the group should follow a leader."));
            guiMultiStateCheckBox cbRespectSocialDist = new guiMultiStateCheckBox((String)OccGroupsPanel.SOCIAL_DIST_IN_GROUP_LBL.v1);
            cbRespectSocialDist.setToolTipText((String)OccGroupsPanel.SOCIAL_DIST_IN_GROUP_LBL.v2);
            MerlinComboBox leaderCb = new MerlinComboBox(md, EgressAgent.class, (IMerlinObj[])new EgressAgent[0]);
            LinkStatus.link2((AbstractButton)cbFollowLeader, leaderCb);
            MerlinUDF maxDistanceFld = new MerlinUDF(0, DoubleVR.above(0.0, true));
            MerlinUDF slowdownTimeFld = new MerlinUDF((Unit)SI.SECOND, UnitDoubleVR.above(0.0, SI.SECOND, true));
            guiLabel lMaxDist = new guiLabel((String)OccGroupsPanel.MAX_DIST_LBL.v1);
            lMaxDist.setToolTipText((String)OccGroupsPanel.MAX_DIST_LBL.v2);
            ColorButton colorBtn = SelectionEditorPanel.newColorButton();
            int height = (int)colorBtn.getPreferredSize().getHeight();
            colorBtn.setPreferredSize(new Dimension(70, height));
            this.panel1 = new EditorPanel();
            this.panel2 = new EditorPanel();
            GridBagHelper gb = new GridBagHelper(this.panel1);
            gb.rowSpace = 2;
            gb.addRow(lMaxDist, maxDistanceFld, 1.0, GridBagHelper.REMAINING);
            guiLabel lSlowDown = new guiLabel(Intl.intl("Slowdown Time:"));
            lSlowDown.setToolTipText(Intl.intl("Time interval during which the group will keep slowing down after it is disconnected."));
            gb.addRow(lSlowDown, slowdownTimeFld, 1.0, GridBagHelper.REMAINING);
            gb.addRow(cbFollowLeader, leaderCb, 1.0, GridBagHelper.REMAINING);
            gb = new GridBagHelper(this.panel2);
            gb.rowSpace = 2;
            gb.addRow(cbRespectSocialDist, 1.0, GridBagHelper.REMAINING);
            gb.addRow(Intl.intl("Movement Group Color:"), colorBtn);
            gb.finalizeRows();
            CompElementActions.DefProp<ICompElement, EgressAgent> leaderProp = new CompElementActions.DefProp<ICompElement, EgressAgent>(OccGroupObj.PROP_GROUP_LEADER);
            this.panel1.addConnection(new FollowGroupLeaderPropConn(new CompElementActions.DefProp<ICompElement, Boolean>(OccGroupObj.PROP_REQUIRES_GROUP_LEADER), leaderProp, cbFollowLeader, md));
            this.panel1.addConnection(new GroupLeaderPropConn<EgressAgent>(leaderProp, leaderCb));
            this.panel1.addConnection(new UDPropConnection(new CompElementActions.DefProp<ICompElement, UnitDouble>(OccGroupObj.PROP_MAX_DISTANCE), maxDistanceFld));
            this.panel1.addConnection(new UDPropConnection(new CompElementActions.DefProp<ICompElement, UnitDouble>(OccGroupObj.PROP_SLOWDOWN_TIME), slowdownTimeFld));
            this.panel2.addConnection(new BoolPropConnection(new CompElementActions.DefProp<ICompElement, Boolean>(OccGroupObj.PROP_SOCIAL_DIST_IN_GROUP), cbRespectSocialDist));
            this.panel2.addConnection(new ColorConn(colorBtn, OccGroupObj.PROP_COLOR));
        }

        public List<EditorPanel> getPanels() {
            return Arrays.asList(this.panel1, this.panel2);
        }
    }

    private static class FloorSortPnl
    extends EditorPanel {
        private static final long serialVersionUID = -1767295841240590359L;
        private final guiMultiStateCheckBox d_autoCreateFloorsCB = new guiMultiStateCheckBox(Intl.intl("Automatically create floors"));
        private final guiUnitDoubleField d_autoFloorDistFld;
        private final guiMultiStateCheckBox d_autoSortCompsCB;

        public FloorSortPnl(MerlinData md) {
            guiUtil.setLongTooltip(this.d_autoCreateFloorsCB, Intl.intl("Automatically create new floors when adding/modifying egress\ncomponents if they are outside the <b>Floor height</b> of the previous floor."));
            guiLabel distLbl = new guiLabel(Intl.intl("Floor height:"));
            distLbl.setToolTipText(Intl.intl("The minimum distance between floors to automatically create a new floor."));
            this.d_autoFloorDistFld = new MerlinUDF(0, DoubleVR.above(0.0, false));
            this.d_autoSortCompsCB = new guiMultiStateCheckBox(Intl.intl("Auto sort egress components"));
            guiUtil.setLongTooltip(this.d_autoSortCompsCB, Intl.intl("Automatically sort new and modified egress components (rooms, doors, etc.)\ninto appropriate floors."));
            this.d_autoFloorDistFld.setPreferredSize(new Dimension(this.d_autoFloorDistFld.getPreferredSize().width, this.d_autoCreateFloorsCB.getPreferredSize().height - 2));
            LinkStatus.link2((AbstractButton)this.d_autoCreateFloorsCB, distLbl, this.d_autoFloorDistFld);
            LinkStatus.link2((AbstractButton)this.d_autoSortCompsCB, this.d_autoCreateFloorsCB, distLbl, this.d_autoFloorDistFld);
            this.addConnection(new BoolConn(FloorSort.AUTO_SELECT_FLOOR, this.d_autoSortCompsCB));
            this.addConnection(new UDConn(FloorSort.MIN_AUTO_FLOOR_DIST, this.d_autoFloorDistFld));
            this.addConnection(new BoolConn(FloorSort.AUTO_CREATE_FLOOR, this.d_autoCreateFloorsCB));
            guiLabel title = new guiLabel(Intl.intl("Floor Creation/Sorting"));
            title.setFont(title.getFont().deriveFont(1));
            GridBagHelper gb = new GridBagHelper(this);
            gb.rowSpace = 1;
            gb.addRow(title, 2);
            gb.indent();
            gb.addRow(this.d_autoSortCompsCB, GridBagHelper.REMAINING);
            gb.addRow(this.d_autoCreateFloorsCB, GridBagHelper.REMAINING);
            gb.indent();
            gb.addRow(distLbl, this.d_autoFloorDistFld);
            gb.finalizeRows();
        }

        @Override
        public void update(Events events) {
            if (!events.isAffected(FloorSort.class)) {
                return;
            }
            super.update(events);
        }

        private class BoolConn
        extends BoolPropConnection {
            public BoolConn(FloorSort.Prop<Boolean> prop, guiMultiStateCheckBox cb) {
                super(new FloorProp<Boolean>(prop), cb);
            }

            @Override
            protected boolean isDataEmpty() {
                return false;
            }
        }

        private class UDConn
        extends UDPropConnection {
            public UDConn(FloorSort.Prop<UnitDouble> prop, guiUnitDoubleField fld) {
                super(new FloorProp<UnitDouble>(prop), fld);
            }

            @Override
            protected boolean isDataEmpty() {
                return false;
            }
        }

        private static class FloorProp<ValT>
        implements CompElementActions.IObjectProp<ICompElement, ValT> {
            private final FloorSort.Prop<ValT> d_floorProp;

            public FloorProp(FloorSort.Prop<ValT> floorProp) {
                this.d_floorProp = floorProp;
            }

            @Override
            public Object get(MerlinData md, Collection<? extends ICompElement> objs) {
                return md.floorSortOptions.get(this.d_floorProp);
            }

            @Override
            public void set(MerlinData md, Collection<? extends ICompElement> objs, ValT newVal) {
                Undo.begin(Intl.intl("Set Property"));
                Undo.insertUndoEntry_restore(md, md.floorSortOptions);
                md.floorSortOptions.set(this.d_floorProp, newVal);
                Undo.end(md);
            }
        }
    }

    public static class GroupLeaderPropConn<T extends ICompElement>
    extends ComboPropConn<T> {
        public GroupLeaderPropConn(CompElementActions.IObjectProp<ICompElement, T> prop, guiComboBox<T> control) {
            super(Intl.intl("Set Movement Group Leader"), prop, control);
        }

        @Override
        public void initFromProp(Object prop, Collection<? extends ICompElement> objs, guiComboBox<T> comp) {
            ICompElement obj;
            comp.setItems(new ICompElement[0]);
            if (objs.size() == 1 && (obj = objs.iterator().next()) instanceof OccGroupObj) {
                Collection<Proxy> proxies = ((OccGroupObj)obj).flatten(Proxy.class);
                for (Proxy p : proxies) {
                    comp.add((ICompElement)p.getObj());
                }
                super.initFromProp(prop, objs, comp);
            }
        }
    }

    public static class FollowGroupLeaderPropConn
    extends BoolPropConnection {
        private CompElementActions.IObjectProp<ICompElement, EgressAgent> leaderProp;
        private MerlinData md;

        public FollowGroupLeaderPropConn(CompElementActions.IObjectProp<ICompElement, Boolean> prop, CompElementActions.IObjectProp<ICompElement, EgressAgent> leaderProp, guiMultiStateCheckBox control, MerlinData md) {
            super(prop, control);
            this.leaderProp = leaderProp;
            this.md = md;
        }

        @Override
        public void setProp(Object prop, Collection<? extends ICompElement> objs, guiMultiStateCheckBox comp) {
            if (comp.getState() != 2) {
                Boolean newval;
                Boolean bl = newval = comp.isSelected() ? Boolean.TRUE : Boolean.FALSE;
                if (!newval.booleanValue()) {
                    Undo.begin(Intl.intl("Set Follow Movement Group Leader"));
                    SelectionEditorPanel.setPropRecursive(Intl.intl("Set Movement Group Leader"), this.leaderProp, objs, null);
                    super.setProp(prop, objs, comp);
                    Undo.end(this.md);
                } else {
                    super.setProp(prop, objs, comp);
                }
            }
        }
    }

    public static class ComboPropConn<T>
    extends ASinglePropConnection<guiComboBox<T>> {
        private final String d_actionName;

        public ComboPropConn(CompElementActions.IObjectProp<ICompElement, T> prop, guiComboBox<T> control) {
            this(Intl.intl("Set Property"), prop, control);
        }

        public ComboPropConn(String actionName, CompElementActions.IObjectProp<ICompElement, T> prop, guiComboBox<T> control) {
            super(prop, control);
            this.d_actionName = actionName;
            control.addItemListener(this);
            if (control instanceof MerlinComboBox) {
                this.setUpdateLock(((MerlinComboBox)control).getUpdateLock());
            }
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                if (this.isLocked()) {
                    return;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        this.onControlChanged();
                    }
                });
            }
        }

        @Override
        public void initFromProp(Object prop, Collection<? extends ICompElement> objs, guiComboBox<T> comp) {
            IListenerStripper ls = guiUtil.stripListeners(comp);
            Object val = ((CompElementActions.IObjectProp)prop).get(MerlinApp.getApp().getData(), objs);
            if (val == ICompElement.NON_UNIFORM || val == ICompElement.NOT_SUPPORTED) {
                comp.setSelectedItem(null);
            } else {
                comp.setSelectedItem(val);
            }
            comp.setModified(false);
            ls.restore();
        }

        @Override
        public void setProp(Object prop, Collection<? extends ICompElement> objs, guiComboBox<T> comp) {
            if (!comp.isEditable() && comp.getSelectedIndex() < 0) {
                return;
            }
            SelectionEditorPanel.setPropRecursive(this.d_actionName, (CompElementActions.IObjectProp)prop, objs, comp.getSelectedItem());
            this.initFromProp(prop, objs, comp);
        }
    }

    private static class OnewayProp
    extends CompElementActions.DefProp<ICompElement, EgressDoorDir> {
        public OnewayProp() {
            super(IEgressConnector.TRAVEL_DIR);
        }

        @Override
        public void set(MerlinData md, Collection<? extends ICompElement> objs, EgressDoorDir dir) {
            super.set(md, objs, dir);
            if (dir == EgressDoorDir.ALL) {
                Collection<EgressCorridor> corridors = MerlinUtil.flatten(objs, EgressCorridor.class);
                ArrayList<EgressCorridor> escalators = new ArrayList<EgressCorridor>();
                for (EgressCorridor corridor : corridors) {
                    SpeedModifier mod = corridor.getSpeedModifier();
                    if (!mod.isMovingWalkway()) continue;
                    escalators.add(corridor);
                }
                if (!escalators.isEmpty()) {
                    SpeedModifier newMod = SpeedModifier.DEFAULT;
                    Undo.insertUndoEntry_propRestore(md, escalators, IEgressOccupiable.SPEED_MODIFIER);
                    Composite.setProperty(IEgressOccupiable.SPEED_MODIFIER, newMod, escalators);
                }
            }
        }
    }

    private static class OnewayComboBox
    extends guiComboBox<EgressDoorDir> {
        private static final long serialVersionUID = 7458733946367811681L;

        public OnewayComboBox() {
            super(EgressDoorDir.ALL, EgressDoorDir.EAST, EgressDoorDir.WEST, EgressDoorDir.NORTH, EgressDoorDir.SOUTH);
            this.setRenderer(new DefaultListCellRenderer(){
                private static final long serialVersionUID = -3213510783145668673L;

                @Override
                public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    Component c = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                    String name = "";
                    if (value != null) {
                        switch ((EgressDoorDir)((Object)value)) {
                            case EAST: {
                                name = Intl.intl("+X");
                                break;
                            }
                            case WEST: {
                                name = Intl.intl("-X");
                                break;
                            }
                            case NORTH: {
                                name = Intl.intl("+Y");
                                break;
                            }
                            case SOUTH: {
                                name = Intl.intl("-Y");
                                break;
                            }
                            default: {
                                name = Intl.intl("<disabled>");
                            }
                        }
                    }
                    this.setText(name);
                    return c;
                }
            });
        }
    }

    private static class ElevatorPriorityConn
    extends ASinglePropConnection<PriorityChooser<Floor>> {
        public ElevatorPriorityConn(Object prop, PriorityChooser<Floor> chooser) {
            super(prop, chooser);
            ((PriorityChooser)this.getControl()).getComm().addObserver(new Observer(){

                @Override
                public void update(Observable o, Object arg) {
                    this.onControlChanged();
                }
            });
        }

        @Override
        public void initFromProp(Object prop, Collection<? extends ICompElement> objs, PriorityChooser<Floor> comp) {
            Object availFloorsObj = Composite.getProperty(Elevator.PROP_SERVABLE_FLOORS, this.getObjs());
            final Set availFloors = availFloorsObj instanceof Set ? (Set)availFloorsObj : Collections.EMPTY_SET;
            comp.setFilter(new Predicate<Floor>(){

                @Override
                public boolean test(Floor o) {
                    return availFloors.contains(o);
                }
            });
            Object priority = Composite.getProperty(prop, objs);
            Object type = Composite.getProperty(Elevator.PROP_TYPE, objs);
            if (type.equals(ICompElement.NON_UNIFORM)) {
                comp.setPriority(null);
            } else {
                comp.setPriority(priority instanceof List ? (List)priority : null);
            }
            comp.setModified(false);
        }

        @Override
        public void setProp(Object prop, Collection<? extends ICompElement> objs, PriorityChooser<Floor> comp) {
            List floorPriority = comp.getPriority();
            if (floorPriority == null) {
                return;
            }
            int defaultIndex = 0;
            for (int m = 0; m < floorPriority.size() - 1; ++m) {
                Floor f1 = floorPriority.get(m);
                Floor f2 = (Floor)floorPriority.get(m + 1);
                if (f1.getWorkingZ().compareTo(f2.getWorkingZ()) >= 0) continue;
                defaultIndex = m + 1;
            }
            if (defaultIndex == 0) {
                floorPriority = Collections.EMPTY_LIST;
            } else if (defaultIndex < floorPriority.size() - 1) {
                floorPriority = floorPriority.subList(0, defaultIndex);
            }
            this.setProp(prop, objs, floorPriority);
            this.initFromProp(prop, objs, comp);
        }

        @Override
        public void setProp(Object prop, Collection<? extends ICompElement> objs, Object val) {
            List floorPriority = (List)val;
            MerlinData md = MerlinApp.getApp().getData();
            Undo.begin(Intl.intl("Edit Floor Priority"));
            Undo.insertUndoEntry_propRestore(md, objs, prop);
            Composite.setProperty(prop, floorPriority, objs);
            Undo.end(md);
        }
    }

    private static class ElevatorPriorityTypeConn
    extends ASinglePropConnection<PriorityChooser<Floor>> {
        public ElevatorPriorityTypeConn(Object prop, PriorityChooser<Floor> control) {
            super(prop, control);
        }

        @Override
        public void setProp(Object prop, Collection<? extends ICompElement> objs, PriorityChooser<Floor> comp) {
            Object type = Composite.getProperty(Elevator.PROP_TYPE, this.getObjs());
            comp.setApplicable(type.equals((Object)ElevatorType.EVAC));
        }

        @Override
        public void initFromProp(Object prop, Collection<? extends ICompElement> objs, PriorityChooser<Floor> comp) {
            Object type = Composite.getProperty(Elevator.PROP_TYPE, this.getObjs());
            comp.setApplicable(type.equals((Object)ElevatorType.EVAC));
        }
    }

    private static class ElevatorFloorConn
    extends ComboPropConn<Floor> {
        private final boolean isDischargeConn;
        private Component[] sameWidthComps;

        public ElevatorFloorConn(CompElementActions.IObjectProp<ICompElement, Floor> prop, guiComboBox<Floor> control, boolean isDischargeConn, Component ... sameWidthComps) {
            super(prop, control);
            this.isDischargeConn = isDischargeConn;
            this.sameWidthComps = sameWidthComps;
        }

        @Override
        public void initFromProp(Object prop, Collection<? extends ICompElement> objs, guiComboBox<Floor> comp) {
            IdentityHashSet<Floor> allServableFloors = null;
            for (Elevator elevator : SelectionEditorPanel.getElevators(objs)) {
                Collection<Floor> serveFloors = elevator.getServableFloors();
                if (allServableFloors == null) {
                    allServableFloors = new IdentityHashSet<Floor>(serveFloors);
                    continue;
                }
                allServableFloors.retainAll(serveFloors);
            }
            final IdentityHashSet<Floor> availFloors = allServableFloors;
            IListenerStripper ls = guiUtil.stripListeners(comp);
            ((MerlinComboBox)comp).setFilter(new Predicate<Floor>(){

                @Override
                public boolean test(Floor o) {
                    return availFloors.contains(o);
                }
            });
            ls.restore();
            int cbWdith = comp.getPreferredSize().width;
            for (Component c : this.sameWidthComps) {
                Dimension d = c.getPreferredSize();
                c.setPreferredSize(new Dimension(cbWdith, d.height));
            }
            super.initFromProp(prop, objs, comp);
        }

        @Override
        public void setProp(Object prop, Collection<? extends ICompElement> objs, guiComboBox<Floor> comp) {
            if (comp.getSelectedIndex() < 0) {
                return;
            }
            if (!this.isDischargeConn) {
                super.setProp(prop, objs, comp);
                return;
            }
            MerlinData md = MerlinApp.getApp().getData();
            List newTimingModelObjs = CompElementActions.flattenToLocallyDefined(Elevator.PROP_TIMING_MODEL, objs).stream().filter(c -> c.getProperty(Elevator.PROP_TIMING_MODEL) instanceof IElevatorTimingModel.DistModel).collect(Collectors.toList());
            IElevatorTimingModel newTimingModel = null;
            if (!newTimingModelObjs.isEmpty()) {
                try {
                    int option = JOptionPane.showConfirmDialog(MerlinApp.getApp().getActiveFrame(), "<html>" + String.format(Intl.intl("%d selected elevators use a legacy timing model that might report incorrect<br>floor pickup/discharge times if the discharge floor is changed. Would you like<br>to update the timing models to work with any discharge floor?"), newTimingModelObjs.size()), Intl.intl("Update Floor Timing Model?"), 1);
                    if (option == 0) {
                        guiDialog timingDlg = new guiDialog((Window)MerlinApp.getApp().getActiveFrame(), Intl.intl("Elevator Timing"), 9);
                        NewElevatorDlg.TimingPnl timingPnl = new NewElevatorDlg.TimingPnl();
                        timingDlg.getDialogPane().add(timingPnl);
                        timingPnl.load(CreateElevator.getLastTimingModel());
                        if (timingDlg.doModal() != 1) {
                            throw new CancellationException();
                        }
                        newTimingModel = timingPnl.save();
                    } else if (option != 1) {
                        throw new CancellationException();
                    }
                }
                catch (CancellationException e) {
                    this.initFromProp(prop, objs, comp);
                    return;
                }
            }
            Undo.begin(Intl.intl("Set Discharge Floor"));
            ((CompElementActions.IObjectProp)prop).set(md, objs, comp.getSelectedItem());
            if (newTimingModel != null) {
                new CompElementActions.DefProp(Elevator.PROP_TIMING_MODEL).set(md, newTimingModelObjs, newTimingModel);
            }
            this.initFromProp(prop, objs, comp);
            Undo.end(md);
        }
    }

    private static class ProfileFilterConn
    extends ASinglePropConnection<SetChooser<OccProfile>> {
        private MerlinData md;

        public ProfileFilterConn(Object prop, SetChooser<OccProfile> control, MerlinData md) {
            super(prop, control);
            this.md = md;
            control.addObserver((o, arg) -> this.commit());
        }

        @Override
        public void setProp(Object prop, Collection<? extends ICompElement> objs, SetChooser<OccProfile> comp) {
            OccProfile.CompRestrictions restrictedComps;
            Set<OccProfile> selectedProfiles = comp.getObjs();
            Set<OccProfile> unSelectedProfiles = comp.getUnselectedObjs();
            Undo.begin(Intl.intl("Edit Restricted Profiles"));
            Undo.insertUndoEntry_propRestore(this.md, this.md.profiles.flatten(OccProfile.class), OccProfile.PROP_RESTRICTED_COMPONENTS);
            for (OccProfile prof : selectedProfiles) {
                restrictedComps = prof.getProperty(OccProfile.PROP_RESTRICTED_COMPONENTS).clone();
                for (ICompElement iCompElement : objs) {
                    if (!OccProfile.CompRestrictions.isAcceptableType(iCompElement.getClass())) continue;
                    restrictedComps.accept(iCompElement);
                }
                prof.setProperty(OccProfile.PROP_RESTRICTED_COMPONENTS, restrictedComps);
            }
            for (OccProfile prof : unSelectedProfiles) {
                restrictedComps = prof.getProperty(OccProfile.PROP_RESTRICTED_COMPONENTS).clone();
                for (ICompElement iCompElement : objs) {
                    if (!OccProfile.CompRestrictions.isAcceptableType(iCompElement.getClass())) continue;
                    restrictedComps.reject(iCompElement);
                }
                prof.setProperty(OccProfile.PROP_RESTRICTED_COMPONENTS, restrictedComps);
            }
            Undo.end(this.md);
        }

        @Override
        public void initFromProp(Object prop, Collection<? extends ICompElement> objs, SetChooser<OccProfile> comp) {
            LinkedHashSet<OccProfile> selectedProfs = new LinkedHashSet<OccProfile>();
            boolean firstObj = true;
            for (ICompElement iCompElement : objs) {
                for (OccProfile prof : MerlinApp.getApp().getData().profiles.flatten(OccProfile.class)) {
                    OccProfile.CompRestrictions restrictedComps = prof.getProperty(OccProfile.PROP_RESTRICTED_COMPONENTS);
                    if (firstObj && restrictedComps.isAccepted(iCompElement)) {
                        selectedProfs.add(prof);
                    }
                    if (firstObj || (!restrictedComps.isAccepted(iCompElement) || selectedProfs.contains(prof)) && (restrictedComps.isAccepted(iCompElement) || !selectedProfs.contains(prof))) continue;
                    comp.setObjs(null);
                    return;
                }
                firstObj = false;
            }
            comp.setObjs(selectedProfs);
        }
    }

    private static class SceneGeomPnl
    extends EditorPanel {
        private static final long serialVersionUID = 7501610581410197415L;

        public SceneGeomPnl() {
            guiTextField objType = new guiTextField();
            this.addConnection(new TextPropConnection((Object)ImportedGeom.PROP_OBJECT_TYPE, objType));
            objType.setEnabled(false);
            guiComboBox<ImportType> importTypes = guiUtil.newCombo(type -> {
                if (type == null) {
                    return new Pair<String, Object>("", null);
                }
                return new Pair<String, String>(type.name, type.desc);
            }, Stream.of(ImportType.values()).sorted((t1, t2) -> {
                if (t1 == t2) {
                    return 0;
                }
                if (t1 == ImportType.IGNORED) {
                    return -1;
                }
                if (t2 == ImportType.IGNORED) {
                    return 1;
                }
                return t1.name.compareToIgnoreCase(t2.name);
            }).collect(Collectors.toList()));
            this.addConnection(new ComboPropConn<ImportType>(new CompElementActions.DefProp(ImportedGeom.PROP_IMPORTED_TYPE), importTypes));
            VariantButton resultsVisBtn = new VariantButton(Intl.intl("Results Visibility"), new DiscreteVarEditor(true, Intl.intl("Visible"), false, Intl.intl("Hidden")));
            this.addConnection(new VariantProp(new CompElementActions.DefProp(ImportedGeom.PROP_RESULTS_VISIBILITY), resultsVisBtn));
            GridBagHelper gb = new GridBagHelper(this);
            gb.rowSpace = 3;
            guiLabel typelbl = new guiLabel(Intl.intl("Object Type:"));
            typelbl.setToolTipText(Intl.intl("The object type as specified in the imported file."));
            guiLabel itypelbl = new guiLabel(Intl.intl("Import Type:"));
            itypelbl.setToolTipText("<html>" + Intl.intl("The object type used when generating model elements.<br>This is determined automatically if imported from an IFC file."));
            gb.addRow(typelbl, objType, 1.0, 0);
            gb.addRow(itypelbl, importTypes, 1.0, 0);
            gb.addRow(guiUtil.lbl(Intl.intl("Results Visibility:"), Intl.intl("Controls the visibility of the geometry over time when viewed in Results.")), resultsVisBtn, 1.0, 0);
        }
    }

    private static class ElevatorExtraPnl
    extends ElevatorPnl {
        private static final long serialVersionUID = 6230900399034401889L;

        public ElevatorExtraPnl() {
            BasicFloorComboBox initFloorCB = new BasicFloorComboBox(MerlinApp.getApp().getData());
            MerlinUDF callDistFld = new MerlinUDF(0, DoubleVR.above(0.0, true));
            callDistFld.setToolTipText(Intl.intl("The distance away from the elevator door at which an occupant can call the elevator."));
            this.addConnection(new ElevatorFloorConn(new CompElementActions.DefProp<ICompElement, Floor>(Elevator.PROP_INIT_FLOOR), initFloorCB, false, callDistFld));
            this.addConnection(new UDPropConnection(new CompElementActions.DefProp<ICompElement, UnitDouble>(Elevator.PROP_CALL_DISTANCE), callDistFld));
            guiMultiStateCheckBox doubleDeckCb = new guiMultiStateCheckBox(Intl.intl("Double-Deck"), false);
            doubleDeckCb.setToolTipText(String.format("<html>" + Intl.intl("If checked, the elevator will use two decks to transport occupants.<br>Additionally to the discharge level, the level on top of the discharge level will also be used for discharge.") + "</html>", new Object[0]));
            this.addConnection(new BoolPropConnection(new CompElementActions.DefProp<ICompElement, Boolean>(Elevator.PROP_DOUBLE_DECK), doubleDeckCb));
            GridBagHelper gb = new GridBagHelper(this);
            gb.rowSpace = 1;
            gb.addRow(Intl.intl("Initial Floor:"), initFloorCB);
            gb.addRow(Intl.intl("Call Distance:"), callDistFld);
            gb.addRow(doubleDeckCb);
        }
    }

    private static class ElevatorTypePnl
    extends ElevatorPnl {
        private static final long serialVersionUID = -5390926138045470372L;
        private ElevatorType d_type;
        private Set<Elevator> d_objs;

        public ElevatorTypePnl() {
            MerlinData md = MerlinApp.getApp().getData();
            guiComboBox<ElevatorType> typeChooser = new guiComboBox<ElevatorType>(ElevatorType.values());
            GridBagHelper gb = new GridBagHelper(this);
            gb.rowSpace = 1;
            gb.addRow(Intl.intl("Type:"), typeChooser);
            this.addConnection(new ComboPropConn<ElevatorType>(new CompElementActions.DefProp(Elevator.PROP_TYPE), typeChooser));
        }

        @Override
        public void bind(Collection<ICompElement> objs) {
            this.d_objs = SelectionEditorPanel.getElevators(objs);
            super.bind(objs);
        }

        @Override
        public void release() {
            this.d_objs = Collections.EMPTY_SET;
            super.release();
        }
    }

    private static class ElevatorLevelPnl
    extends ElevatorPnl {
        private static final long serialVersionUID = -5390926138045470372L;
        private Set<Elevator> d_objs;
        private PriorityChooser<Floor> priorityChooser;

        public ElevatorLevelPnl() {
            BasicFloorComboBox dischargeCB = new BasicFloorComboBox(MerlinApp.getApp().getData());
            this.addConnection(new ElevatorFloorConn(new CompElementActions.DefProp<ICompElement, Floor>(Elevator.PROP_DISCHARGE_FLOOR), dischargeCB, true, new Component[0]));
            HTMLBtn levelBtn = new HTMLBtn(Intl.intl("Edit"));
            levelBtn.addActionListener(new LevelActionListener());
            MerlinData md = MerlinApp.getApp().getData();
            this.priorityChooser = new PriorityChooser<Floor>(md, Intl.intl("Floor Priority"), Intl.intl("top-down"), Intl.intl("none"), md.floors, Floor.class, null);
            this.priorityChooser.setSorter(new Comparator<Floor>(){

                @Override
                public int compare(Floor o1, Floor o2) {
                    return o2.getWorkingZ().compareTo(o1.getWorkingZ());
                }
            });
            this.addConnection(new ElevatorPriorityConn(Elevator.PROP_FLOOR_PRIORITY, this.priorityChooser));
            this.addConnection(new ElevatorPriorityTypeConn((Object)new CompElementActions.DefProp(Elevator.PROP_TYPE), this.priorityChooser));
            GridBagHelper gb = new GridBagHelper(this);
            gb.rowSpace = 1;
            gb.addRow(Intl.intl("Discharge Floor:"), dischargeCB);
            gb.addRow(Intl.intl("Floor Priority:"), this.priorityChooser);
            gb.addRow(Intl.intl("Level Data:"), levelBtn);
        }

        @Override
        public void bind(Collection<ICompElement> objs) {
            this.d_objs = SelectionEditorPanel.getElevators(objs);
            boolean includePriority = SelectionEditorPanel.getElevators(this.d_objs).stream().noneMatch(e -> e.getType().equals((Object)ElevatorType.SCAN));
            this.priorityChooser.setApplicable(includePriority);
            super.bind(objs);
        }

        @Override
        public void release() {
            this.d_objs = Collections.EMPTY_SET;
            super.release();
        }

        private class LevelActionListener
        implements ActionListener {
            private LevelActionListener() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                MerlinData md = MerlinApp.getApp().getData();
                IdentityHashMap<Floor, Elevator.LevelData> levelData = new IdentityHashMap<Floor, Elevator.LevelData>();
                IdentityHashMap<Floor, Double> levelDistsMap = new IdentityHashMap<Floor, Double>();
                CompElementActions.DefProp timingProp = new CompElementActions.DefProp(Elevator.PROP_TIMING_MODEL);
                Object timingModel = timingProp.get(md, ElevatorLevelPnl.this.d_objs);
                for (Elevator elevator : ElevatorLevelPnl.this.d_objs) {
                    ElevatorRoom discharge = elevator.getDischargeRoom();
                    Map<Floor, ElevatorRoom> levelMap = elevator.getFloorLevelMap();
                    for (Map.Entry<Floor, ElevatorRoom> entry : levelMap.entrySet()) {
                        Floor floor = entry.getKey();
                        double dist = elevator.getDist(discharge, entry.getValue());
                        levelDistsMap.merge(floor, dist, (d1, d2) -> {
                            if (d1 == null || d2 == null) {
                                return null;
                            }
                            return theMath.round((double)d1, 5) == theMath.round((double)d2, 5) ? d1 : null;
                        });
                    }
                    Map<Floor, Elevator.LevelData> eLevelData = elevator.getFloorLevelData();
                    for (Map.Entry<Floor, Elevator.LevelData> entry : eLevelData.entrySet()) {
                        Floor floor = entry.getKey();
                        Elevator.LevelData ld = entry.getValue();
                        if (!levelData.containsKey(floor)) {
                            levelData.put(floor, ld);
                            continue;
                        }
                        Elevator.LevelData existing = (Elevator.LevelData)levelData.get(floor);
                        if (Objects.equals(existing, ld)) continue;
                        levelData.put(floor, null);
                    }
                }
                ElevatorLevelDlg dlg = new ElevatorLevelDlg((Window)MerlinApp.getApp().getActiveFrame(), levelData, levelDistsMap, timingModel instanceof IElevatorTimingModel ? (IElevatorTimingModel)timingModel : null);
                if (dlg.doModal() != 1) {
                    return;
                }
                Map<Floor, Elevator.LevelData> newLevelData = dlg.getLevelData();
                IElevatorTimingModel newTimingModel = dlg.getTimingModel();
                if (!newLevelData.isEmpty() || newTimingModel != null) {
                    MerlinOpImpl op = new MerlinOpImpl((app, mdd) -> {
                        try (MerlinData.WriteLock lock = mdd.lockWrite();){
                            Undo.begin(Intl.intl("Edit Elevator Levels"));
                            if (!newLevelData.isEmpty()) {
                                Undo.insertUndoEntry_propRestore(md, ElevatorLevelPnl.this.d_objs, Elevator.PROP_LEVEL_DATA);
                                for (Elevator elevator : ElevatorLevelPnl.this.d_objs) {
                                    elevator.setLevelData(newLevelData);
                                }
                            }
                            if (newTimingModel != null) {
                                timingProp.set(md, ElevatorLevelPnl.this.d_objs, newTimingModel);
                            }
                            Undo.end(md);
                        }
                    });
                    UIHook.run(MerlinApp.getApp().getActiveFrame(), "SelectionEditorPanel.LevelActionListener.actionPerformed", op, 0);
                }
            }
        }
    }

    private static class ElevatorDataPnl
    extends ElevatorPnl {
        private static final long serialVersionUID = 8065547898578052044L;

        public ElevatorDataPnl() {
            MerlinUDF sepFld = new MerlinUDF(9);
            sepFld.setToolTipText(Intl.intl("The approximate number of people in a full load."));
            this.addConnection(new UDPropConnection(new CompElementActions.DefProp<ICompElement, UnitDouble>(Elevator.PROP_NOMINAL_LOAD), sepFld));
            MerlinUDF openDelayFld = new MerlinUDF(1);
            openDelayFld.setToolTipText(Intl.intl("The minimum time an elevator door stays open on a pickup floor."));
            this.addConnection(new UDPropConnection(new CompElementActions.DefProp<ICompElement, UnitDouble>(Elevator.PROP_OPEN_DELAY), openDelayFld));
            MerlinUDF closeDelayFld = new MerlinUDF(1);
            closeDelayFld.setToolTipText(Intl.intl("The door closing delay after the last occupant goes through on a pickup floor."));
            this.addConnection(new UDPropConnection(new CompElementActions.DefProp<ICompElement, UnitDouble>(Elevator.PROP_CLOSE_DELAY), closeDelayFld));
            GridBagHelper gb = new GridBagHelper(this);
            gb.rowSpace = 1;
            gb.addRow(Intl.intl("Nominal Load:"), sepFld);
            gb.addRow(Intl.intl("Open Delay:"), openDelayFld);
            gb.addRow(Intl.intl("Close Delay:"), closeDelayFld);
        }
    }

    private static class ElevatorPnl
    extends EditorPanel {
        private static final long serialVersionUID = 2178416092442683841L;

        private ElevatorPnl() {
        }

        @Override
        public void bind(Collection<ICompElement> objs) {
            super.bind(SelectionEditorPanel.getElevators(objs));
        }
    }

    private static class EgressNodeComboModel
    extends NodeComboModel<GeomComposite> {
        private static final long serialVersionUID = -5915100069213541260L;
        private static final String NEW_GROUP_ITEM = Intl.intl("<Add New...>");
        private final MerlinData d_data;
        private final ListDataListener d_listener;

        public EgressNodeComboModel(MerlinData md) {
            super(md, GeomComposite.class, new RootFinder());
            this.d_data = md;
            this.d_listener = new ListDataListener(){

                @Override
                public void contentsChanged(final ListDataEvent e) {
                    AMerlinOp op = new AMerlinOp(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run(MerlinApp app, MerlinData md) {
                            md.beginWrite();
                            try {
                                Undo.begin(Intl.intl("Change Working Group"));
                                NodeComboModel model = (NodeComboModel)e.getSource();
                                SetWorkingGroup.setWorkingGroup(md, md.activeFloor(), (GeomComposite)model.getSelectedNode());
                                Undo.end(md);
                            }
                            finally {
                                md.endWrite();
                            }
                        }
                    };
                    UIHook.run(UIHook.getComponent(e), "SelectionEditorPane.EgressNodeComboModel.ListDataListener.contentsChanged", op, 20);
                }

                @Override
                public void intervalAdded(ListDataEvent e) {
                }

                @Override
                public void intervalRemoved(ListDataEvent e) {
                }
            };
            md.getEvents().addObserver(this);
        }

        @Override
        protected Collection<?> getObjects() {
            Collection<?> superObjs = super.getObjects();
            ArrayList<Object> objs = new ArrayList<Object>(superObjs.size() + 2);
            objs.add(NEW_GROUP_ITEM);
            objs.add(new JSeparator(0));
            objs.addAll(superObjs);
            return objs;
        }

        @Override
        public void setSelectedItem(Object anObject) {
            if (anObject == NEW_GROUP_ITEM) {
                AMerlinOp op = new AMerlinOp(){

                    @Override
                    public void run(MerlinApp app, MerlinData md) {
                        Floor activeFloor = md.floors.getActive();
                        NewGroup.addNewGroup(MerlinApp.getApp(), md, Arrays.asList(activeFloor), activeFloor);
                    }
                };
                UIHook.run(null, "SelectionEditorPanel.EgressNodeComboModel.setSelectedItem", op, 20);
            } else {
                super.setSelectedItem(anObject);
            }
        }

        @Override
        public void update(Events events) {
            this.removeListDataListener(this.d_listener);
            super.update(events);
            boolean update = false;
            for (EventChannel<FloorComposite> eventChannel : events.getAffectedChannels(FloorComposite.class, new Class[0])) {
                if (!eventChannel.hasChangedObjs(FloorComposite.ACTIVE_FLOOR_CHANGED)) continue;
                update = true;
                break;
            }
            for (EventChannel<Composite> eventChannel : events.getAffectedChannels(Floor.class, new Class[0])) {
                if (!eventChannel.hasChangedObjs(Floor.WORKING_GROUP_CHANGED)) continue;
                update = true;
                break;
            }
            if (update) {
                this.setSelectedNode(this.d_data.activeFloor().getWorkingGeomGroup());
            }
            this.addListDataListener(this.d_listener);
        }

        private static class RootFinder
        implements NodeComboModel.RootFinder<GeomComposite> {
            private RootFinder() {
            }

            @Override
            public Collection<? extends GeomComposite<?>> getRoots(MerlinData md) {
                return Arrays.asList(md.activeFloor());
            }

            @Override
            public boolean includeRoot() {
                return true;
            }

            @Override
            public Predicate<? super GeomComposite> getFilter(MerlinData md) {
                return Predicates.alwaysTrue();
            }
        }
    }

    private static class NewCompGroupPnl
    extends EditorPanel {
        private static final long serialVersionUID = 5997508668479008215L;
        private final MerlinData d_md;
        private final NodeComboBox<?> d_nodeCB;
        private final guiLabel d_nodeLbl;

        public NewCompGroupPnl(MerlinData md) {
            this.d_md = md;
            EgressNodeComboModel nodeModel = new EgressNodeComboModel(md);
            this.d_nodeCB = new NodeComboBox<GeomComposite>(nodeModel);
            Dimension prefSize = this.d_nodeCB.getPreferredSize();
            if (prefSize.width < 300) {
                prefSize.width = 120;
                this.d_nodeCB.setPreferredSize(prefSize);
            }
            SelectionEditorPanel.adjustHeight(this.d_nodeCB);
            this.d_nodeLbl = new guiLabel(Intl.intl("Group:"));
            guiLabel title = new guiLabel(Intl.intl("New Egress Components"));
            title.setFont(title.getFont().deriveFont(1));
            GridBagHelper gb = new GridBagHelper(this, false);
            gb.rowSpace = 1;
            gb.addRow(title, GridBagHelper.REMAINING);
            gb.addIdentRow(this.d_nodeLbl, this.d_nodeCB);
            gb.finalizeRows();
        }

        private void updateEnabledStatus() {
            boolean nodeEnabled = this.d_md.floorSortOptions.get(FloorSort.AUTO_SELECT_FLOOR) == false;
            this.d_nodeLbl.setEnabled(nodeEnabled);
            this.d_nodeCB.setEnabled(nodeEnabled);
        }

        @Override
        public void bind(Collection<ICompElement> arg0) {
            super.bind(arg0);
            this.updateEnabledStatus();
        }

        @Override
        public void update(Events events) {
            if (events.isAffected(FloorSort.class)) {
                this.updateEnabledStatus();
            }
        }
    }

    public static class VariantProp<ValType>
    extends ASinglePropConnection<HTMLBtn> {
        private final VariantButton<ValType> d_varEditor;
        private boolean d_modified;

        public VariantProp(CompElementActions.IObjectProp<ICompElement, IVariant<ValType>> prop, VariantButton<ValType> varEditor) {
            super(prop, varEditor);
            this.d_varEditor = varEditor;
            this.d_modified = false;
            varEditor.addPropertyChangeListener("value", e -> {
                this.d_modified = true;
                this.onControlChanged();
                this.initFromProp();
            });
        }

        @Override
        protected boolean isModified(HTMLBtn comp) {
            return this.d_modified;
        }

        @Override
        protected void setModified(HTMLBtn comp, boolean modified) {
            this.d_modified = modified;
        }

        @Override
        public void setProp(Object prop, Collection<? extends ICompElement> objs, HTMLBtn comp) {
            SelectionEditorPanel.setPropRecursive(String.format(Intl.intl("Edit %s"), this.d_varEditor.getPropDescription()), (CompElementActions.IObjectProp)prop, objs, this.d_varEditor.getValue());
        }

        @Override
        public void initFromProp(Object prop, Collection<? extends ICompElement> objs, HTMLBtn comp) {
            Object value = ((CompElementActions.IObjectProp)prop).get(MerlinApp.getApp().getData(), objs);
            IVariant d_currVal = value instanceof IVariant ? (IVariant)value : (IVariant)null;
            this.d_varEditor.setValue(d_currVal);
            this.setModified(comp, false);
        }
    }

    private static class BlockageVisSect
    extends EditorPanel {
        private static final long serialVersionUID = -1690783360723324239L;
        private final Runnable d_updateControls;

        public BlockageVisSect() {
            guiComboBox<EgressBlockage.DisplayType> displayType = guiUtil.newCombo(type -> type == null ? new Pair<String, String>(Intl.intl("<mixed>"), "") : new Pair<String, String>(type.name, type.desc), EgressBlockage.DisplayType.values());
            CompElementActions.DefProp dtProp = SelectionEditorPanel.newRestoreProp(EgressBlockage.DISPLAY_TYPE);
            this.addConnection(new ComboPropConn<EgressBlockage.DisplayType>(dtProp, displayType));
            guiLabel importLbl = new guiLabel(Intl.intl("Imported geometry:"));
            JButton pickImportBtn = new JButton(Intl.intl("Pick"));
            pickImportBtn.setToolTipText(Intl.intl("Picks the imported geometry from the scene."));
            pickImportBtn.addActionListener(e -> this.pickImportGeom());
            guiMultiStateCheckBox linkSearchGeom = new guiMultiStateCheckBox(Intl.intl("Link shape to CAD geometry"));
            linkSearchGeom.setToolTipText("<html>" + Intl.intl("If checked, the shape of the obstacle is defined by the CAD geometry.<br>If unchecked, the shape of the obstacle must be defined explicitly."));
            this.addConnection(new BoolPropConnection(SelectionEditorPanel.newRestoreProp(EgressBlockage.LINK_CAD_GEOM_TO_SEARCH), linkSearchGeom));
            GridBagHelper gb = new GridBagHelper(this);
            gb.rowSpace = 1;
            gb.addRow(guiUtil.lbl(Intl.intl("Results display:"), Intl.intl("Controls the appearance of the obstacle in Results.")), displayType);
            gb.addRow(importLbl, pickImportBtn, 1.0);
            gb.addRow(linkSearchGeom, 0);
            gb.addRow(new Object[0]);
            this.d_updateControls = () -> {
                Object val = dtProp.get(MerlinApp.getApp().getData(), this.getObjects());
                boolean imported = val instanceof EgressBlockage.DisplayType && val == EgressBlockage.DisplayType.CAD_GEOM;
                linkSearchGeom.setVisible(imported);
                importLbl.setVisible(imported);
                pickImportBtn.setVisible(imported);
            };
        }

        @Override
        public void update(Events events) {
            super.update(events);
            this.d_updateControls.run();
        }

        public void pickImportGeom() {
            final ModelView mv = MerlinApp.getApp().getModelView();
            if (mv == null) {
                return;
            }
            final ArrayList<ICompElement> selObjs = new ArrayList<ICompElement>(this.getObjects());
            final ArrayList<EgressBlockage> blockages = new ArrayList<EgressBlockage>(theUtil.filter(this.getObjects(), EgressBlockage.class));
            mv.startChoosingPoints(new IPointPickListener(){

                @Override
                public Pair<SnapMode, IIsectFilter> getSnapInfo(CursorTool tool) {
                    return new Pair<SnapMode, IIsectFilter>(SnapMode.FILTERED_ONE_PASS, new DefaultFilter(ImportedGeom.class));
                }

                @Override
                public void pointPicked(IMerlinGeomSrc source, UnitPoint3D p) {
                    if (!(source instanceof ImportedGeom)) {
                        return;
                    }
                    ImportedGeom ig = (ImportedGeom)source;
                    SimpleOp op = new SimpleOp((app, md) -> {
                        try {
                            ArrayList<Pair<EgressBlockage, DisplayGeom>> newBlkgGeoms = new ArrayList<Pair<EgressBlockage, DisplayGeom>>();
                            Runnable deleteSource = () -> {};
                            md.beginRead();
                            try {
                                boolean delSource;
                                int deleteOption;
                                boolean bl;
                                boolean moveToObjs = false;
                                boolean bl2 = false;
                                Predicate<EgressBlockage> testHasCadGeom = o -> o.getDisplayType() == EgressBlockage.DisplayType.CAD_GEOM && !o.getProp(EgressBlockage.CAD_GEOM).get().node.isGeomEmpty(false);
                                IntPredicate testYesNoResult = option -> option == 0 || option == 1;
                                if (blockages.stream().anyMatch(testHasCadGeom)) {
                                    int option2 = md.ui(() -> JOptionPane.showConfirmDialog(app.getActiveFrame(), Intl.intl("Do you want to overwrite the existing imported geometry in the selected obstacles?"), Intl.intl("Overwrite Existing Imported Geometry?"), 1, 3));
                                    if (!testYesNoResult.test(option2)) {
                                        return;
                                    }
                                    boolean bl3 = bl = option2 == 0;
                                    if (!bl && theUtil.filter(blockages, testHasCadGeom).isExclusive()) {
                                        return;
                                    }
                                }
                                Function<EgressBlockage, AABox> getUsefulSearchBounds = blkg -> {
                                    AABox bounds = blkg.getSearchGeom().getBoundingBox(new AABox());
                                    if (bounds.isValid()) {
                                        return bounds;
                                    }
                                    if (blkg.getSetSearchGeom() != blkg.getSearchGeom()) {
                                        bounds = blkg.getSetSearchGeom().getBoundingBox(new AABox());
                                    }
                                    return bounds;
                                };
                                Predicate<EgressBlockage> testHasValidSearchGeom = o -> ((AABox)getUsefulSearchBounds.apply((EgressBlockage)o)).isValid();
                                if (blockages.stream().anyMatch(testHasValidSearchGeom)) {
                                    int option3 = md.ui(() -> JOptionPane.showConfirmDialog(app.getActiveFrame(), Intl.intl("Would you like to move the imported geometry to the selected obstacle's location?"), Intl.intl("Move Imported Geometry?"), 1, 3));
                                    if (!testYesNoResult.test(option3)) {
                                        return;
                                    }
                                    boolean bl4 = moveToObjs = option3 == 0;
                                }
                                if (!testYesNoResult.test(deleteOption = md.ui(() -> JOptionPane.showConfirmDialog(app.getActiveFrame(), String.format(Intl.intl("Do you want to delete the source object, \"%s\"?"), ig.getName()), Intl.intl("Delete Imported Object?"), 1, 3)).intValue())) {
                                    return;
                                }
                                boolean bl5 = delSource = deleteOption == 0;
                                if (delSource) {
                                    Pair<Delete.DelStatus, Runnable> delResult = Delete.startUiDelete(app, md, Collections.singleton(ig), false);
                                    if (delResult.v1 == Delete.DelStatus.CANCELLED) {
                                        return;
                                    }
                                    deleteSource = (Runnable)delResult.v2;
                                }
                                AABox igBounds = moveToObjs ? ig.getBounds() : new AABox();
                                Point3d igCenter = new Point3d(igBounds.getCenter());
                                igCenter.z = igBounds.getMinZ();
                                for (EgressBlockage blkg2 : blockages) {
                                    if (!bl && testHasCadGeom.test(blkg2)) continue;
                                    if (moveToObjs && testHasValidSearchGeom.test(blkg2)) {
                                        Supplier<Point3d> getMoveDest = () -> {
                                            if (blkg2.getDisplayType() == EgressBlockage.DisplayType.CAD_GEOM && blkg2.getProp(EgressBlockage.LINK_CAD_GEOM_TO_SEARCH).get().booleanValue()) {
                                                DisplayGeom dg = blkg2.getProp(EgressBlockage.CAD_GEOM).get();
                                                AABox bounds = dg.node.getBoundingBox(new AABox());
                                                if (bounds.isValid()) {
                                                    Point3d center = bounds.getCenter();
                                                    center.z = bounds.getMinZ();
                                                    return center;
                                                }
                                            }
                                            return ((AABox)getUsefulSearchBounds.apply(blkg2)).getCenter();
                                        };
                                        Point3d moveDest = getMoveDest.get();
                                        ITransform xform = TransformUtil.translate(Util3D.vector(igCenter, moveDest));
                                        IGeomNode blkgCad = ig.getGeom().quickTransform(xform.getInfo());
                                        newBlkgGeoms.add(new Pair<EgressBlockage, DisplayGeom>(blkg2, new DisplayGeom(blkgCad, ig.getDisplayProps())));
                                        continue;
                                    }
                                    newBlkgGeoms.add(new Pair<EgressBlockage, DisplayGeom>(blkg2, ig.getDisplayGeom()));
                                }
                            }
                            finally {
                                md.endRead();
                            }
                            md.beginWrite();
                            try {
                                Undo.begin(Intl.intl("Set obstacle imported geometry"));
                                Undo.insertUndoEntry_restore(md, newBlkgGeoms.stream().map(e -> (EgressBlockage)e.v1).collect(Collectors.toList()));
                                for (Pair pair : newBlkgGeoms) {
                                    ((EgressBlockage)pair.v1).setProp(EgressBlockage.CAD_GEOM, (DisplayGeom)pair.v2);
                                }
                                deleteSource.run();
                                Undo.end(md);
                                return;
                            }
                            finally {
                                md.endWrite();
                            }
                        }
                        finally {
                            md.uiLater(() -> {
                                mv.stopChoosingPoints();
                                this.stopPicking();
                            });
                        }
                    });
                    UIHook.run(MerlinApp.getApp().getActiveFrame(), "Set obstacle imported geometry", op, 4);
                }

                @Override
                public void stopPicking() {
                    SimpleOp selOp = new SimpleOp((app, md) -> {
                        md.beginWrite();
                        try {
                            md.selection.set(selObjs);
                        }
                        finally {
                            md.endWrite();
                        }
                    });
                    UIHook.run(MerlinApp.getApp().getActiveFrame(), "Select objects", selOp, 0);
                }
            });
        }
    }

    private static class BlockageSect
    extends EditorPanel {
        private static final long serialVersionUID = -5590512196812592313L;

        public BlockageSect() {
            guiPanel p = new guiPanel(new GridBagLayout());
            GridBagHelper gb = new GridBagHelper(p);
            gb.rowSpace = 1;
            SelectionEditorPanel.addSpeedModifier(this, gb);
            this.setLayout(new BorderLayout());
            this.add((Component)p, "Center");
        }
    }

    public static class ValEditorConn<T, CompT extends JComponent>
    extends ASinglePropConnection<JComponent>
    implements Observer {
        private final IValEditor<T> d_editor;

        public ValEditorConn(CompElementActions.IObjectProp<ICompElement, IFunction1d> prop, IValEditor<T> editor) {
            this(prop, editor, true);
        }

        public ValEditorConn(CompElementActions.IObjectProp<ICompElement, IFunction1d> prop, IValEditor<T> editor, boolean overrideEnter) {
            super(prop, editor.getComponent(), overrideEnter);
            this.d_editor = editor;
            this.d_editor.addValueListener(e -> this.onControlChanged());
            MerlinApp.getApp().getData().getEvents().addObserver(this);
        }

        @Override
        public void update(Observable o, Object arg) {
            this.onControlChanged();
        }

        @Override
        public void initFromProp(Object prop, Collection<? extends ICompElement> objs, JComponent comp) {
            Object obj = ((CompElementActions.IObjectProp)prop).get(MerlinApp.getApp().getData(), objs);
            Class<T> type = this.d_editor.getType();
            this.d_editor.setValue(type.isInstance(obj) ? (Object)type.cast(obj) : null);
            if (comp instanceof Modifiable) {
                ((Modifiable)((Object)comp)).setModified(false);
            }
        }

        @Override
        public void setProp(Object prop, Collection<? extends ICompElement> objs, Object val) {
            if (val != null) {
                SelectionEditorPanel.setPropRecursive(Intl.intl("Edit Property"), (CompElementActions.IObjectProp)prop, objs, val);
            }
        }

        @Override
        public void setProp(Object prop, Collection<? extends ICompElement> objs, JComponent comp) {
            this.setProp(prop, objs, (Object)this.d_editor.getValue());
        }
    }

    public static class CapacityEditor
    extends HTMLBtn
    implements Modifiable,
    IValEditor<IOccCount>,
    UnitUpdatableComponent {
        private static final long serialVersionUID = -8981797637304025722L;
        private IOccCount d_count;
        private boolean d_modified = false;
        private guiPanel d_pnl;

        public CapacityEditor() {
            super("");
            UnitUpdator.addComp(this);
            this.addActionListener(e -> {
                IOccCount newCount;
                guiDialog dlg = new guiDialog(SwingUtilities.getWindowAncestor(this), Intl.intl("Capacity"), 9);
                MerlinApp app = MerlinApp.getApp();
                MerlinData md = app.getData();
                OccupancyPanel occupancyPnl = new OccupancyPanel(app, md);
                occupancyPnl.set(this.d_count, md);
                this.d_pnl = occupancyPnl.getCountPanel();
                dlg.getDialogPane().add(this.d_pnl);
                if (dlg.doModal() == 1 && !Objects.equals(newCount = occupancyPnl.getCount(), this.d_count)) {
                    IOccCount oldVal = this.d_count;
                    this.setValue(newCount);
                    this.setModified(true);
                    this.firePropertyChange("value", oldVal, newCount);
                }
            });
            this.update();
        }

        @Override
        public void add(GridBagHelper gb) {
            gb.add(this, 1.0);
        }

        @Override
        public JComponent getComponent() {
            return this;
        }

        @Override
        public Class<IOccCount> getType() {
            return IOccCount.class;
        }

        @Override
        public boolean isModified() {
            return this.d_modified;
        }

        @Override
        public void setModified(boolean modified) {
            this.d_modified = modified;
        }

        @Override
        public void setValue(IOccCount count) {
            if (Objects.equals(count, this.d_count)) {
                return;
            }
            this.d_count = count;
            this.update();
            this.setModified(false);
        }

        @Override
        public IOccCount getValue() {
            return this.d_count;
        }

        public void update() {
            this.setText(this.d_count != null ? CapacityEditor.format(this.d_count) : Intl.intl("&lt;mixed&gt;"));
        }

        public static String format(IOccCount count) {
            if (count instanceof ConstOccCount) {
                return String.format(Intl.intl("%d pers"), ((ConstOccCount)count).count);
            }
            if (count instanceof IOccArea) {
                return OccAreaListCellRenderer.getOccAreaString((IOccArea)count, MerlinApp.getApp().getUnitSystem());
            }
            return count.toString();
        }

        @Override
        public void update(Unit newUnit) {
            this.update();
        }

        @Override
        public Unit getDisplayUnit() {
            return SI.METER;
        }
    }

    private static class RoomInfoSect
    extends EditorPanel {
        private static final long serialVersionUID = -7471856652914712994L;
        private guiUnitDoubleField d_fldArea;
        private guiIntField d_fldOccs;
        private guiUnitDoubleField d_fldDens;
        private volatile Thread d_lastUpdaterThread = null;
        private guiLabel d_labArea = new guiLabel(Intl.intl("Area:"));
        private guiLabel d_labOccs;
        private guiLabel d_labDens;

        public RoomInfoSect() {
            this.d_fldArea = new MerlinUDF(4);
            this.d_fldArea.setEditable(false);
            this.d_labOccs = new guiLabel(Intl.intl("Pers:"));
            this.d_fldOccs = new guiIntField(0);
            this.d_fldOccs.setEditable(false);
            this.d_labDens = new guiLabel(Intl.intl("Density:"));
            this.d_fldDens = new MerlinUDF(3);
            this.d_fldDens.setEditable(false);
            Dimension preferredSize = this.d_fldArea.getPreferredSize();
            preferredSize.width = (int)((double)preferredSize.width * 1.15);
            this.d_fldArea.setPreferredSize(preferredSize);
            this.d_fldOccs.setPreferredSize(preferredSize);
            this.d_fldDens.setPreferredSize(preferredSize);
            guiPanel p = new guiPanel(new GridBagLayout());
            GridBagUtil.add(p, this.d_labArea, 0, 0, 1, 1, 0, 6, 0, 0, 0, 0.0, 0.0, 17);
            GridBagUtil.add(p, this.d_fldArea, 1, 0, 1, 1, 0, 12, 0, 0, 0, 0.0, 0.0, 17);
            GridBagUtil.add(p, this.d_labOccs, 0, 1, 1, 1, 3, 6, 0, 0, 0, 0.0, 0.0, 17);
            GridBagUtil.add(p, this.d_fldOccs, 1, 1, 1, 1, 3, 12, 0, 0, 0, 0.0, 0.0, 17);
            GridBagUtil.add(p, this.d_labDens, 0, 2, 1, 1, 3, 6, 0, 0, 0, 0.0, 0.0, 17);
            GridBagUtil.add(p, this.d_fldDens, 1, 2, 1, 1, 3, 12, 0, 0, 0, 0.0, 0.0, 17);
            this.setLayout(new BorderLayout());
            this.add((Component)p, "Center");
            this.addConnection(new Updater());
        }

        public void addToLayout(GridBagHelper gb) {
            gb.pushSpacing(gb.colSpace, 3);
            gb.addRow(this.d_labArea, this.d_fldArea, 1.0, 0);
            gb.addRow(this.d_labOccs, this.d_fldOccs, 1.0, 0);
            gb.addRow(this.d_labDens, this.d_fldDens, 1.0, 0);
            gb.popSpacing();
        }

        private UnitDouble accumulateUD(Object prop, Collection<ICompElement> objs, Unit defUnit) {
            UnitDouble udSum = null;
            Collection<ICompElement> dColl = MerlinUtil.flattenComposites(objs);
            for (ICompElement leaf : dColl) {
                if (this.d_lastUpdaterThread != Thread.currentThread()) {
                    return null;
                }
                Object property = leaf.getProperty(prop);
                if (property == null || property == ICompElement.NOT_SUPPORTED) continue;
                UnitDouble ud = (UnitDouble)property;
                if (udSum == null) {
                    udSum = ud;
                    continue;
                }
                udSum = udSum.add(ud);
            }
            if (udSum == null) {
                udSum = new UnitDouble(0.0, defUnit);
            }
            return udSum;
        }

        private int accumulateInt(Object prop, Collection<ICompElement> objs) {
            int sum = 0;
            Collection<ICompElement> dColl = MerlinUtil.flattenComposites(objs);
            for (ICompElement leaf : dColl) {
                Integer i;
                if (this.d_lastUpdaterThread != Thread.currentThread()) {
                    return 0;
                }
                Object property = leaf.getProperty(prop);
                if (property == null || property == ICompElement.NOT_SUPPORTED || (i = (Integer)property) == null) continue;
                sum += i.intValue();
            }
            return sum;
        }

        private class Updater
        implements IPropConnection {
            private Collection<ICompElement> d_objs;

            private Updater() {
            }

            @Override
            public void bind(Collection<ICompElement> objs) {
                this.d_objs = objs;
                this.update(null);
            }

            @Override
            public void commit() {
            }

            @Override
            public void release() {
                this.d_objs = Collections.EMPTY_LIST;
                RoomInfoSect.this.d_lastUpdaterThread = null;
            }

            @Override
            public void update(Events events) {
                RoomInfoSect.this.d_lastUpdaterThread = new Thread(new PropUpdater(this.d_objs));
                RoomInfoSect.this.d_lastUpdaterThread.start();
            }
        }

        private class PropUpdater
        implements Runnable {
            private final Collection<ICompElement> d_elements;

            public PropUpdater(Collection<ICompElement> elements) {
                this.d_elements = elements;
            }

            @Override
            public void run() {
                UnitSystem us = MerlinApp.getApp().getUnitSystem();
                Unit areaUnit = us.getUnit(4);
                final UnitDouble area = RoomInfoSect.this.accumulateUD(IEgressOccupiable.AREA, this.d_elements, areaUnit);
                final int occs = RoomInfoSect.this.accumulateInt(IEgressOccupiable.OCC_COUNT, this.d_elements);
                if (RoomInfoSect.this.d_lastUpdaterThread != Thread.currentThread()) {
                    return;
                }
                double a = area.getValue(areaUnit);
                final UnitDouble dens = new UnitDouble((double)occs / a, us.getUnit(3));
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        RoomInfoSect.this.d_fldArea.setValue(area);
                        RoomInfoSect.this.d_fldOccs.setValue(occs);
                        RoomInfoSect.this.d_fldDens.setValue(dens);
                    }
                });
            }
        }
    }

    private static class RoomPropSect
    extends EditorPanel {
        private static final long serialVersionUID = -7690179246229293050L;

        public RoomPropSect() {
            GridBagHelper gb = new GridBagHelper(this);
            gb.rowSpace = 1;
            SelectionEditorPanel.addTagCheckBox(this, gb, IEgressComp.OCC_TAGS, PredefTags.SAFE.name);
            SelectionEditorPanel.addSpeedModifier(this, gb);
            SelectionEditorPanel.addCapacityEditor(this, gb);
        }
    }

    private static class MsrRegionAreaProp
    implements CompElementActions.IObjectProp<ICompElement, UnitDouble> {
        private MsrRegionAreaProp() {
        }

        @Override
        public void set(MerlinData md, Collection<? extends ICompElement> objs, UnitDouble newVal) {
        }

        @Override
        public Object get(MerlinData md, Collection<? extends ICompElement> objs) {
            Collection<MeasurementRegionObj> regions = MerlinUtil.flatten(objs, MeasurementRegionObj.class);
            if (regions.isEmpty()) {
                return ICompElement.NOT_SUPPORTED;
            }
            UnitDouble totArea = new UnitDouble(0.0, Geometry.AREA_UNIT);
            for (MeasurementRegionObj obj : regions) {
                totArea = totArea.add(obj.getXYArea());
            }
            return totArea;
        }
    }

    private static class RegionInfoSect
    extends EditorPanel {
        private static final long serialVersionUID = 1L;
        private MerlinUDF d_regionArea = new MerlinUDF(4);

        public RegionInfoSect() {
            this.d_regionArea.setEditable(false);
            this.addConnection(new UDPropConnection(new MsrRegionAreaProp(), this.d_regionArea));
            guiPanel p = new guiPanel(new GridBagLayout());
            GridBagUtil.add(p, new guiLabel(Intl.intl("Area:")), 0, 0, 1, 1, 0, 6, 0, 0, 0, 0.0, 0.0, 17);
            GridBagUtil.add(p, this.d_regionArea, 1, 0, 1, 1, 0, 12, 0, 0, 0, 0.0, 0.0, 17);
            this.setLayout(new BorderLayout());
            this.add((Component)p, "Center");
        }
    }

    private static class BoundsSect
    extends EditorPanel {
        private static final long serialVersionUID = -6736958249381526284L;
        private guiTextField d_xBoundsFld;
        private guiTextField d_yBoundsFld;
        private guiTextField d_zBoundsFld;
        private volatile Thread d_lastUpdaterThread = null;

        public BoundsSect() {
            this.setPreferredSize(new Dimension(150, 70));
            this.d_xBoundsFld = new guiTextField();
            this.d_yBoundsFld = new guiTextField();
            this.d_zBoundsFld = new guiTextField();
            this.d_xBoundsFld.setEditable(false);
            this.d_yBoundsFld.setEditable(false);
            this.d_zBoundsFld.setEditable(false);
            Dimension preferredSize = this.d_xBoundsFld.getPreferredSize();
            preferredSize.width = (int)((double)preferredSize.width * 1.3);
            this.d_xBoundsFld.setPreferredSize(preferredSize);
            this.d_yBoundsFld.setPreferredSize(preferredSize);
            this.d_zBoundsFld.setPreferredSize(preferredSize);
            GridBagHelper gb = new GridBagHelper(this);
            gb.rowSpace = 3;
            gb.addRow(Intl.intl("X Bounds:"), this.d_xBoundsFld, 1.0, 0);
            gb.addRow(Intl.intl("Y Bounds:"), this.d_yBoundsFld, 1.0, 0);
            gb.addRow(Intl.intl("Z Bounds:"), this.d_zBoundsFld, 1.0, 0);
            this.addConnection(new Updater());
        }

        public void addToLayout(GridBagHelper gb) {
            gb.pushSpacing(gb.colSpace, 3);
            gb.addRow(Intl.intl("X Bounds:"), this.d_xBoundsFld, 1.0, 0);
            gb.addRow(Intl.intl("Y Bounds:"), this.d_yBoundsFld, 1.0, 0);
            gb.addRow(Intl.intl("Z Bounds:"), this.d_zBoundsFld, 1.0, 0);
            gb.popSpacing();
        }

        private void updateMinMax(Set<ICompElement> objs) {
            AABox bb = new AABox();
            if (objs != null) {
                for (ICompElement ice : objs) {
                    if (!(ice instanceof IMerlinGeomSrc)) continue;
                    AABox box = ((IMerlinGeomSrc)((Object)ice)).getBounds();
                    bb.add(box);
                }
            }
            Unit u = Geometry.LENGTH_UNIT;
            Point3d boundsMin = bb.getMin();
            Point3d boundsMax = bb.getMax();
            UnitSystem us = MerlinApp.getApp().getUnitSystem();
            Unit length = us.getLength();
            BiFunction<Double, Double, String> formatBounds = (min, max) -> {
                if (min > max) {
                    return Intl.intl("<unknown>");
                }
                if (max - min >= Double.MAX_VALUE) {
                    return Intl.intl("<infinite>");
                }
                return String.format("%1.2f %s, %1.2f %s", UnitDouble.convert(min, u, length), length, UnitDouble.convert(max, u, length), length);
            };
            TriConsumer<guiTextField, Double, Double> updateFld = (fld, min, max) -> {
                String boundsStr = (String)formatBounds.apply((Double)min, (Double)max);
                fld.setText(boundsStr);
                fld.setToolTipText(boundsStr);
                fld.setCaretPosition(0);
            };
            updateFld.accept(this.d_xBoundsFld, boundsMin.x, boundsMax.x);
            updateFld.accept(this.d_yBoundsFld, boundsMin.y, boundsMax.y);
            updateFld.accept(this.d_zBoundsFld, boundsMin.z, boundsMax.z);
            this.setVisible(bb.isValid());
        }

        private class PropUpdater
        implements Runnable {
            @Override
            public void run() {
                if (BoundsSect.this.d_lastUpdaterThread != Thread.currentThread()) {
                    return;
                }
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MerlinSelectionModel sel = MerlinApp.getApp().getData().selection;
                        Set<ICompElement> objs = sel.getSelected(ICompElement.class);
                        BoundsSect.this.updateMinMax(objs);
                    }
                });
            }
        }

        private class Updater
        implements IPropConnection {
            private Updater() {
            }

            @Override
            public void bind(Collection<ICompElement> objs) {
                this.update(null);
            }

            @Override
            public void commit() {
            }

            @Override
            public void release() {
                BoundsSect.this.d_lastUpdaterThread = null;
            }

            @Override
            public void update(Events events) {
                BoundsSect.this.d_lastUpdaterThread = new Thread(new PropUpdater());
                BoundsSect.this.d_lastUpdaterThread.start();
            }
        }
    }

    private static class StairSect
    extends EditorPanel {
        private static final long serialVersionUID = -5785590882396541290L;

        public StairSect() {
            MerlinUDF fldRiser = new MerlinUDF(6);
            UDPropConnection connRiser = new UDPropConnection(new CompElementActions.DefProp<ICompElement, UnitDouble>(EgressStair.TREAD_RISE), fldRiser);
            this.addConnection(connRiser);
            MerlinUDF fldTread = new MerlinUDF(6);
            UDPropConnection connTread = new UDPropConnection(new CompElementActions.DefProp<ICompElement, UnitDouble>(EgressStair.TREAD_RUN), fldTread);
            this.addConnection(connTread);
            MerlinUDF fldLen = new MerlinUDF(0);
            fldLen.setEditable(false);
            this.addConnection(new UDPropConnection(new CompElementActions.DefProp<ICompElement, UnitDouble>(EgressCorridor.LENGTH), fldLen));
            GridBagHelper gb = new GridBagHelper(this);
            gb.rowSpace = 1;
            gb.addRow(Intl.intl("Riser:"), fldRiser);
            gb.addRow(Intl.intl("Tread:"), fldTread);
            gb.addRow(Intl.intl("Length:"), fldLen);
        }
    }

    private static class RampSect
    extends EditorPanel {
        private static final long serialVersionUID = 8041411753500460637L;

        public RampSect() {
            guiDoubleField fldSlope = new guiDoubleField();
            fldSlope.setEditable(false);
            this.addConnection(new DoublePropConn(new CompElementActions.DefProp<ICompElement, Double>(EgressCorridor.SLOPE), fldSlope));
            MerlinUDF fldSlopeAngle = new MerlinUDF(7);
            fldSlopeAngle.setEditable(false);
            this.addConnection(new SlopeAngleConn(fldSlopeAngle));
            MerlinUDF fldLen = new MerlinUDF(0);
            fldLen.setEditable(false);
            this.addConnection(new UDPropConnection(new CompElementActions.DefProp<ICompElement, UnitDouble>(EgressCorridor.LENGTH), fldLen));
            GridBagHelper gb = new GridBagHelper(this);
            gb.rowSpace = 1;
            gb.addRow(Intl.intl("Incline Angle:"), fldSlopeAngle);
            gb.addRow(Intl.intl("Incline (rise/run):"), fldSlope);
            gb.addRow(Intl.intl("Length:"), fldLen);
        }

        public static UnitDouble getSlopeAngle(double slope) {
            if (Double.isNaN(slope)) {
                return new UnitDouble(slope, SI.RADIAN);
            }
            double slopeAngle = Math.atan(slope);
            return new UnitDouble(slopeAngle, SI.RADIAN);
        }

        private static class SlopeAngleConn
        extends UDPropConnection {
            public SlopeAngleConn(guiUnitDoubleField field) {
                super(new CompElementActions.DefProp<ICompElement, UnitDouble>(EgressCorridor.SLOPE), field);
            }

            @Override
            public void initFromVal(Object val, guiValueField<UnitDouble> comp) {
                if (val instanceof Double) {
                    val = RampSect.getSlopeAngle((Double)val);
                }
                super.initFromVal(val, comp);
            }
        }
    }

    private static class SpeedModifierValProp
    extends CompElementActions.DefProp<ICompElement, IVariant<UnitDouble>> {
        private final SpeedModifier.Type d_type;

        public SpeedModifierValProp(SpeedModifier.Type type) {
            super(IEgressOccupiable.SPEED_MODIFIER);
            this.d_type = type;
        }

        @Override
        protected Object get(MerlinData md, Object prop, ICompElement obj) {
            Object val = obj.getProperty(prop);
            if (val instanceof SpeedModifier) {
                SpeedModifier sm = (SpeedModifier)val;
                return sm.type == this.d_type ? sm.value : null;
            }
            return null;
        }

        @Override
        protected void set(MerlinData md, Object prop, ICompElement obj, IVariant<UnitDouble> newVal) {
            SpeedModifier newModifier = new SpeedModifier(this.d_type, newVal);
            obj.setProperty(prop, newModifier);
        }
    }

    private static class SpeedModifierTypeProp
    extends CompElementActions.DefProp<ICompElement, SpeedModifier.Type> {
        public SpeedModifierTypeProp() {
            super(IEgressOccupiable.SPEED_MODIFIER);
        }

        @Override
        protected Object get(MerlinData md, Object prop, ICompElement obj) {
            Object val = obj.getProperty(prop);
            if (val instanceof SpeedModifier) {
                SpeedModifier mod = (SpeedModifier)val;
                return mod.type;
            }
            return null;
        }

        @Override
        protected void set(MerlinData md, Object prop, ICompElement obj, SpeedModifier.Type newVal) {
            SpeedModifier newModifier = this.getNewSpeedModifier(md, prop, obj, newVal);
            obj.setProperty(prop, newModifier);
        }

        private SpeedModifier getNewSpeedModifier(MerlinData md, Object prop, ICompElement obj, SpeedModifier.Type newVal) {
            SpeedModifier currModifier = (SpeedModifier)obj.getProperty(prop);
            if (currModifier.type == newVal) {
                return currModifier;
            }
            return new SpeedModifier(newVal, SpeedModifier.newValForType(newVal));
        }
    }

    private static class FlowrateProp
    extends CompElementActions.DefProp<ICompElement, IEgressFlowrate> {
        public FlowrateProp() {
            super(IEgressConnector.FLOWRATE);
        }

        @Override
        protected Object get(MerlinData md, Object prop, ICompElement obj) {
            Object val = obj.getProperty(prop);
            if (val != null && !(val instanceof IEgressFlowrate)) {
                return val;
            }
            IEgressFlowrate flowrate = (IEgressFlowrate)val;
            if (flowrate == null) {
                assert (md != null);
                SimParams sp = md.simParams;
                return DoorUtil.getFlowrate(sp, SelectionEditorPanel.getDoorWidth(obj));
            }
            return flowrate;
        }
    }

    private static class FlowrateOverrideProp
    extends CompElementActions.DefProp<ICompElement, Boolean> {
        public FlowrateOverrideProp() {
            super(IEgressConnector.FLOWRATE);
        }

        @Override
        protected Object get(MerlinData md, Object prop, ICompElement obj) {
            Object val = obj.getProperty(prop);
            if (val == null) {
                return false;
            }
            if (val instanceof IEgressFlowrate) {
                return true;
            }
            return val;
        }

        @Override
        protected void set(MerlinData md, Object prop, ICompElement obj, Boolean newVal) {
            IEgressFlowrate newFlowrate = this.getNewFlowrate(md, prop, obj, newVal);
            obj.setProperty(prop, newFlowrate);
        }

        private IEgressFlowrate getNewFlowrate(MerlinData md, Object prop, ICompElement obj, Boolean newVal) {
            if (!newVal.booleanValue()) {
                return null;
            }
            IEgressFlowrate currFlowrate = (IEgressFlowrate)obj.getProperty(prop);
            if (currFlowrate != null) {
                return currFlowrate;
            }
            UnitDouble doorWidth = SelectionEditorPanel.getDoorWidth(obj);
            IEgressFlowrate flowrate = DoorUtil.getFlowrate(md.simParams, doorWidth);
            if (flowrate instanceof IEgressFlowrate.FromDensity) {
                UnitDouble sflowrate = SIUS.newud(1.32, 12);
                return new IEgressFlowrate.Limited(DoorUtil.getFlowrate(sflowrate, md.simParams.doorBoundaryLayer, doorWidth));
            }
            return flowrate;
        }
    }

    private static class DestroyAttractorSect
    extends EditorPanel {
        private static final long serialVersionUID = 1L;

        public DestroyAttractorSect(MerlinData md) {
            guiLabel attractorsLbl = guiUtil.lbl(Intl.intl("Triggers:"), Intl.intl("<html>The set of triggers to destroy.<br>Only triggers previously created by this occupant will be destroyed."));
            SetChooser<Attractor> attractorChooser = new SetChooser<Attractor>(md, Intl.intl("Triggers"), "", 0, md.attractorTemplates, Attractor.class, Attractor::isTemplate);
            this.addConnection(new SetPropConnection<Attractor>(DestroyAttractor.PROP_ATTRACTORS, attractorChooser));
            GridBagHelper gb = new GridBagHelper(this);
            gb.addRow(attractorsLbl, attractorChooser);
        }
    }

    private static class CreateAttractorSect
    extends EditorPanel {
        private static final long serialVersionUID = 1L;

        public CreateAttractorSect(MerlinData md) {
            guiLabel attractorsLbl = guiUtil.lbl(Intl.intl("Triggers:"), Intl.intl("The set of triggers to create."));
            SetChooser<Attractor> attractorChooser = new SetChooser<Attractor>(md, Intl.intl("Triggers"), "", 0, md.attractorTemplates, Attractor.class, Attractor::isTemplate);
            this.addConnection(new SetPropConnection<Attractor>(CreateAttractor.PROP_ATTRACTORS, attractorChooser));
            guiLabel locationLbl = guiUtil.lbl(Intl.intl("Location:"), Intl.intl("The location where triggers will be placed."));
            guiComboBox<CreateAttractor.LocationMode> locationCombo = guiUtil.newCombo(location -> location == null ? new Pair<String, Object>(Intl.intl("<mixed>"), null) : new Pair<String, String>(location.name, location.desc), CreateAttractor.LocationMode.values());
            this.addConnection(new ComboPropConn<CreateAttractor.LocationMode>(new CompElementActions.DefProp(CreateAttractor.PROP_LOCATION), locationCombo){
                private final CompElementActions.IObjectProp<ICompElement, Point3d> d_fixedLocationProp;
                {
                    super(prop, control);
                    this.d_fixedLocationProp = new CompElementActions.DefProp<ICompElement, Point3d>(CreateAttractor.PROP_FIXED_LOCATION);
                }

                @Override
                public void setProp(Object prop, Collection<? extends ICompElement> objs, guiComboBox<CreateAttractor.LocationMode> comp) {
                    if (!comp.isEditable() && comp.getSelectedIndex() < 0) {
                        return;
                    }
                    CompElementActions.IObjectProp locationModeProp = (CompElementActions.IObjectProp)prop;
                    Undo.begin(Intl.intl("Set Property"));
                    MerlinData md = MerlinApp.getApp().getData();
                    if (comp.getSelectedItem() == CreateAttractor.LocationMode.FIXED_LOCATION) {
                        List<ICompElement> modObjs = CompElementActions.flattenToLocallyDefined(CreateAttractor.PROP_FIXED_LOCATION, objs);
                        Undo.insertUndoEntry_propRestore(md, modObjs, this.d_fixedLocationProp);
                        for (ICompElement obj : modObjs) {
                            if (obj.getProperty(CreateAttractor.PROP_FIXED_LOCATION) != null) continue;
                            obj.setProperty(CreateAttractor.PROP_FIXED_LOCATION, new Point3d());
                        }
                    } else {
                        this.d_fixedLocationProp.set(md, objs, null);
                    }
                    locationModeProp.set(md, objs, comp.getSelectedItem());
                    Undo.end(MerlinApp.getApp().getData());
                    this.initFromProp(prop, objs, comp);
                }
            });
            GridBagHelper gb = new GridBagHelper(this);
            gb.addRow(attractorsLbl, attractorChooser);
            gb.addRow(locationLbl, locationCombo);
        }
    }

    private static class RevertProfilePropSect
    extends EditorPanel {
        private static final long serialVersionUID = 1L;

        public RevertProfilePropSect() {
            guiComboBox<Object> combo = NewRevertProfilePropPnl.createPropCombo(true);
            GridBagHelper gb = new GridBagHelper(this);
            gb.rowSpace = 1;
            gb.addRow(Intl.intl("Property:"), combo, 1.0);
            this.addConnection(new ComboPropConn<Object>(new CompElementActions.DefProp(RevertProfileProp.PROFILE_PROP), combo));
        }
    }

    private static class ChangeProfilePropSect
    extends EditorPanel {
        private static final long serialVersionUID = 1L;

        public ChangeProfilePropSect(final MerlinData md) {
            guiComboBox<Object> combo = NewChangeProfilePropPnl.createPropCombo(true);
            final IValEditor[] valEditor = new IValEditor[]{null};
            final Runnable updateComps = () -> {
                this.removeAll();
                GridBagHelper gb = new GridBagHelper(this);
                gb.rowSpace = 1;
                gb.addRow(Intl.intl("Property:"), combo, 0, 1.0);
                gb.add(Intl.intl("Value:"));
                if (valEditor[0] == null) {
                    gb.add(Intl.intl("<mixed property types>"), 0, 1.0);
                } else {
                    valEditor[0].add(gb);
                }
                gb.nextRow();
                this.validate();
            };
            CompElementActions.IObjectProp<ICompElement, Object> propProp = new CompElementActions.IObjectProp<ICompElement, Object>(){

                @Override
                public void set(MerlinData md, Collection<? extends ICompElement> objs, Object newVal) {
                    assert (newVal instanceof IPropertySet.Prop);
                    IPropertySet.Prop newProp = (IPropertySet.Prop)newVal;
                    List<ICompElement> fobjs = CompElementActions.flattenToLocallyDefined(ChangeProfileProp.PROFILE_PROP, objs);
                    List<ICompElement> fobjsChanged = fobjs.stream().filter(o -> !Objects.equals(o.getProperty(ChangeProfileProp.PROFILE_PROP), newProp)).collect(Collectors.toList());
                    if (fobjsChanged.isEmpty()) {
                        return;
                    }
                    Undo.insertUndoEntry_propRestore(md, fobjsChanged, ChangeProfileProp.PROFILE_PROP);
                    Undo.insertUndoEntry_propRestore(md, fobjsChanged, ChangeProfileProp.VALUE);
                    fobjsChanged.forEach(o -> {
                        o.setProp(ChangeProfileProp.PROFILE_PROP, newProp);
                        o.setProp(ChangeProfileProp.VALUE, newProp.defVal);
                    });
                }

                @Override
                public Object get(MerlinData md, Collection<? extends ICompElement> objs) {
                    return Composite.getProperty(ChangeProfileProp.PROFILE_PROP, objs);
                }
            };
            this.addConnection(new ComboPropConn<Object>(propProp, combo));
            ASinglePropConnection<guiPanel> valueConn = new ASinglePropConnection<guiPanel>(new CompElementActions.DefProp(ChangeProfileProp.VALUE), (guiPanel)this){

                @Override
                public void update(Events events) {
                    EventQueue.invokeLater(() -> super.update(events));
                }

                @Override
                public void setProp(Object prop, Collection<? extends ICompElement> objs, guiPanel comp) {
                    assert (valEditor[0] != null);
                    if (valEditor[0] == null) {
                        return;
                    }
                    Object val = valEditor[0].getValue();
                    if (val == null) {
                        return;
                    }
                    SelectionEditorPanel.setPropRecursive(Intl.intl("Set Value"), new CompElementActions.DefProp(ChangeProfileProp.VALUE), objs, val);
                    this.setModified(false);
                }

                @Override
                public void initFromProp(Object prop, Collection<? extends ICompElement> objs, guiPanel comp) {
                    Object profileProp = Composite.getProperty(ChangeProfileProp.PROFILE_PROP, objs);
                    if (!(profileProp instanceof INamedProp)) {
                        valEditor[0] = null;
                        updateComps.run();
                        return;
                    }
                    INamedProp nprop = (INamedProp)profileProp;
                    valEditor[0] = nprop.newValueEditor(md, false).get();
                    Object propVal = Composite.getProperty(ChangeProfileProp.VALUE, objs);
                    if (propVal == Composite.NOT_SUPPORTED || propVal == Composite.NON_UNIFORM) {
                        propVal = null;
                    }
                    updateComps.run();
                    valEditor[0].setValue(propVal);
                    this.setModified(false);
                    valEditor[0].addValueListener(e -> {
                        this.setModified(true);
                        this.commit();
                    });
                }
            };
            this.addConnection(valueConn);
        }
    }

    private static class ChangeProfileSect
    extends EditorPanel {
        private static final long serialVersionUID = 2981898247839210467L;

        public ChangeProfileSect(MerlinData md) {
            DistributionEditor<OccProfile> profileDistEd = new DistributionEditor<OccProfile>(md, Intl.intl("Profiles"), md.profiles, OccProfile.class, null);
            profileDistEd.setExtraObjs(data -> Collections.singleton(data.profiles.NO_CHANGE));
            this.addConnection(new DistributionConn(new CompElementActions.DefProp(ChangeProfile.PROP_PROFILE_DIST), profileDistEd, Intl.intl("Set Profile Distribution")));
            GridBagHelper gb = new GridBagHelper(this);
            gb.addRow(Intl.intl("Target Profiles:"), profileDistEd);
        }
    }

    private static class ChangeBehaviorSect
    extends EditorPanel {
        private static final long serialVersionUID = 6525339523451997905L;

        public ChangeBehaviorSect(MerlinData md) {
            DistributionEditor<Behavior> behaviorDistEd = new DistributionEditor<Behavior>(md, Intl.intl("Behaviors"), md.behaviors, Behavior.class, null);
            behaviorDistEd.setExtraObjs(data -> Collections.singleton(data.behaviors.NO_CHANGE));
            this.addConnection(new DistributionConn(new CompElementActions.DefProp(ChangeBehavior.PROP_BEHAVIOR_DIST), behaviorDistEd, Intl.intl("Set Behavior Distribution")));
            GridBagHelper gb = new GridBagHelper(this);
            gb.addRow(Intl.intl("Target Behaviors:"), behaviorDistEd);
        }
    }

    private static class AttractorWaitAtAttractorSect
    extends EditorPanel {
        private static final long serialVersionUID = 1L;
        private final MerlinData d_md;

        public AttractorWaitAtAttractorSect(MerlinData md) {
            this.d_md = md;
            CompactDistributedValPnl waitTimePnl = new CompactDistributedValPnl(Intl.intl("Wait Time"), 1);
            this.addConnection(new CurveConn<IDistributedVal<UnitDouble>>(Attractor.WAIT_TIME, waitTimePnl));
            guiLabel waitTimeLbl = guiUtil.lbl(Intl.intl("Wait Time:"), Intl.intl("The amount of time to wait at the trigger."));
            MerlinUDF radiusFld = new MerlinUDF(0, DoubleVR.above(0.0, false));
            this.addConnection(new UDPropConnection(new CompElementActions.DefProp<ICompElement, UnitDouble>(Attractor.WAIT_RADIUS), radiusFld));
            guiLabel radiusLbl = guiUtil.lbl(Intl.intl("Wait Area Radius:"), Intl.intl("Defines the radius of the wait area for the trigger."));
            GridBagHelper gb = new GridBagHelper(this);
            gb.rowSpace = 1;
            gb.addRow(radiusLbl, radiusFld, 1.0);
            gb.addRow(waitTimeLbl, waitTimePnl, 1.0);
        }

        public static boolean testProps(Set<Object> props) {
            return props.contains(Attractor.WAIT_TIME) && props.contains(Attractor.WAIT_RADIUS);
        }

        private void updateState(Collection<ICompElement> objs) {
            Object val = new CompElementActions.DefProp(Attractor.BEHAVIOR).get(this.d_md, objs);
            this.setVisible(val == Attractor.WAIT_AT_ATTRACTOR_BEHAVIOR);
        }

        @Override
        public void bind(Collection<ICompElement> objs) {
            super.bind(objs);
            this.updateState(objs);
        }

        @Override
        public void update(Events events) {
            super.update(events);
            this.updateState(this.getObjects());
        }
    }

    private static class AttractorBehaviorSect
    extends EditorPanel {
        private static final long serialVersionUID = 1L;

        public AttractorBehaviorSect(MerlinData md) {
            AttractorBehaviorChooser behaviorChooser = new AttractorBehaviorChooser(md);
            this.addConnection(new ComboPropConn<Behavior>(new CompElementActions.DefProp(Attractor.BEHAVIOR), behaviorChooser));
            guiIntField rankFld = new guiIntField();
            this.addConnection(new IntPropConn(new CompElementActions.DefProp<ICompElement, Integer>(Attractor.RANK), rankFld));
            guiMultiStateCheckBox requiresCompletion = new guiMultiStateCheckBox(Intl.intl("Resume if interrupted"));
            requiresCompletion.setToolTipText("<html>" + Intl.intl("If the selected trigger is interrupted by another higher rank trigger with a <br><i>Resume Prior Behavior</i> action, this flag determines what happens when the <br>selected trigger's behavior is resumed: <br>If <b>checked</b>, the selected trigger's behavior resumes and is completed normally.<br>If <b>unchecked</b>, the remainder of the selected trigger's behavior is skipped, <br>replaced immediately with a <i>Resume Prior Behavior</i> action."));
            this.addConnection(new BoolPropConnection(new CompElementActions.DefProp<ICompElement, Boolean>(Attractor.REQUIRES_COMPLETION), requiresCompletion));
            GridBagHelper gb = new GridBagHelper(this);
            gb.rowSpace = 1;
            gb.addRow(guiUtil.lbl(Intl.intl("Rank:"), "<html>" + Intl.intl("Used to compare with other triggers if an occupant has multiple choices available<br>or has already started a trigger. Triggers with higher ranks are given priority<br>over those with lower and can interrupt a lower-rank trigger's behavior.")), rankFld, 1.0);
            gb.addRow(thunderheadeng.gui.guiUtil.lbl(Intl.intl("Behavior:"), Intl.intl("The behavior used by the occupant when influenced by this trigger.")), behaviorChooser, 1.0);
            gb.addRow(requiresCompletion, 0);
        }

        public static boolean testProps(Set<Object> props) {
            return props.contains(Attractor.BEHAVIOR) && props.contains(Attractor.REQUIRES_COMPLETION) && props.contains(Attractor.RANK);
        }
    }

    private static class AttractorInfluenceSect
    extends EditorPanel {
        private static final long serialVersionUID = 1L;

        public AttractorInfluenceSect(MerlinData md) {
            guiComboBox<Attractor.InfluenceFrom> influenceFromCB = guiUtil.newCombo(influenceFrom -> influenceFrom == null ? new Pair<String, Object>(Intl.intl("<mixed>"), null) : new Pair<String, String>(guiUtil.encodeToHtmlLabel(influenceFrom.name), guiUtil.encodeToHtmlLabel(influenceFrom.desc)), Attractor.InfluenceFrom.values());
            this.addConnection(new ComboPropConn<Attractor.InfluenceFrom>(new CompElementActions.DefProp(Attractor.ATTR_INFLUENCE_FROM), influenceFromCB));
            VariantButton<UnitDouble> influence = new VariantButton<UnitDouble>(Intl.intl("Influence"), new UDVarEditor(ValueFields.udFld(100.0, DoubleVR.above(0.0, true), NonSI.PERCENT, UnitSystem.getType(10, true))));
            this.addConnection(new VariantProp<UnitDouble>(new CompElementActions.DefProp(Attractor.ATTR_INFLUENCE), influence));
            guiMultiStateCheckBox ignoreSusc = new guiMultiStateCheckBox(Attractor.IGNORE_OCC_SUSC.name);
            ignoreSusc.setToolTipText(guiUtil.encodeToHtmlLabel(Attractor.IGNORE_OCC_SUSC.desc));
            this.addConnection(new BoolPropConnection(new CompElementActions.DefProp<ICompElement, Boolean>(Attractor.IGNORE_OCC_SUSC), ignoreSusc));
            GridBagHelper gb = new GridBagHelper(this);
            gb.rowSpace = 1;
            gb.addRow(guiUtil.lbl(Intl.intl("Influence:"), "<html>" + Intl.intl("The influence of this trigger. This is multiplied by an<br>occupant's susceptibility to triggers to create a probability<br>that this trigger will influence the occupant.")), influence, 1.0);
            gb.addRow(guiUtil.lbl(Intl.intl("Influence Timeline:"), Intl.intl("The timeline on which the trigger's influence times are based.")), influenceFromCB);
            gb.addRow(ignoreSusc, 0);
        }

        public static boolean testProps(Set<Object> props) {
            return props.contains(Attractor.ATTR_INFLUENCE) && props.contains(Attractor.ATTR_INFLUENCE_FROM) && props.contains(Attractor.IGNORE_OCC_SUSC);
        }
    }

    private static class AttractorAwarenessSect
    extends EditorPanel {
        private static final long serialVersionUID = 1L;

        public AttractorAwarenessSect(MerlinData md) {
            guiComboBox<Attractor.Awareness> awarenessCB = guiUtil.newCombo(awareness -> awareness == null ? new Pair<String, Object>(Intl.intl("<mixed>"), null) : new Pair<String, String>(guiUtil.encodeToHtmlLabel(awareness.name), guiUtil.encodeToHtmlLabel(awareness.desc)), Attractor.Awareness.values());
            this.addConnection(new ComboPropConn<Attractor.Awareness>(new CompElementActions.DefProp(Attractor.AWARENESS), awarenessCB));
            final guiLabel radiusLbl = guiUtil.lbl(Intl.intl("Awareness Radius"), Intl.intl("The maximum distance at which an occupant would be aware of this trigger."));
            final MerlinUDF radiusFld = new MerlinUDF(0, UnitDoubleVR.above(0.0, SI.METER, false));
            this.addConnection(new UDPropConnection(new CompElementActions.DefProp<ICompElement, UnitDouble>(Attractor.INFLUENCE_RADIUS), radiusFld));
            final guiLabel roomsLbl = guiUtil.lbl(Intl.intl("Rooms:"), Intl.intl("The rooms in which an occupant is aware of the trigger."));
            final RoomChooser roomsChooser = new RoomChooser(md);
            this.addConnection(new SetPropConnection<IEgressOccupiable>(Attractor.ROOMS, roomsChooser));
            this.addConnection(new ASinglePropConnection<guiComboBox<Attractor.Awareness>>(new CompElementActions.DefProp(Attractor.AWARENESS), awarenessCB){

                @Override
                public void setProp(Object prop, Collection<? extends ICompElement> objs, guiComboBox<Attractor.Awareness> comp) {
                }

                @Override
                public void initFromProp(Object prop, Collection<? extends ICompElement> objs, guiComboBox<Attractor.Awareness> comp) {
                    Object val = ((CompElementActions.IObjectProp)prop).get(MerlinApp.getApp().getData(), objs);
                    boolean radVisible = val instanceof Attractor.Awareness && val == Attractor.Awareness.LINE_OF_SIGHT;
                    radiusLbl.setVisible(radVisible);
                    radiusFld.setVisible(radVisible);
                    boolean roomVisible = val instanceof Attractor.Awareness && val == Attractor.Awareness.ROOMS;
                    roomsLbl.setVisible(roomVisible);
                    roomsChooser.setVisible(roomVisible);
                }
            });
            GridBagHelper gb = new GridBagHelper(this);
            gb.rowSpace = 1;
            gb.addRow(guiUtil.lbl(Intl.intl("Awareness:"), Intl.intl("Defines how an occupant becomes aware of the trigger.")), awarenessCB, 1.0);
            gb.addRow(radiusLbl, radiusFld, 1.0);
            gb.addRow(roomsLbl, roomsChooser, 1.0);
        }

        public static boolean testProps(Set<Object> props) {
            return props.contains(Attractor.INFLUENCE_RADIUS) && props.contains(Attractor.AWARENESS) && props.contains(Attractor.ROOMS);
        }
    }

    private static class AttractorGenSect
    extends EditorPanel {
        private static final long serialVersionUID = 1L;

        public AttractorGenSect(MerlinData md) {
            IValEditor allowedOccTagsEd = Attractor.OCC_TAG_FILTER.newValueEditor(md, false).get();
            this.addConnection(new ValEditorConn(new CompElementActions.DefProp<ICompElement, IFunction1d>(Attractor.OCC_TAG_FILTER), allowedOccTagsEd));
            IValEditor<IAttractorTime> usageTime = IAttractorTime.newEditor(md, true);
            this.addConnection(new ValEditorConn(new CompElementActions.DefProp<ICompElement, IFunction1d>(Attractor.OCC_REACT_TIME), usageTime));
            guiMultiStateCheckBox rememberOutsideCb = new guiMultiStateCheckBox(Intl.intl("Remain aware"), false);
            rememberOutsideCb.setToolTipText("<html>" + Intl.intl("Allows the occupant to consider the trigger if they become aware of it and then leave<br>the awareness region before the <b>Decision Time</b>.<br>If <b>checked</b>, the occupant will consider the trigger when it's time, even if they're no longer in the awareness region.<br>If <b>unchecked</b>, the occupant ignores the trigger if they are no longer in the awareness region."));
            this.addConnection(new BoolPropConnection(new CompElementActions.DefProp<ICompElement, Boolean>(Attractor.REMEMBER_OUTSIDE_AWARENESS), rememberOutsideCb));
            GridBagHelper gb = new GridBagHelper(this);
            gb.rowSpace = 1;
            gb.add(guiUtil.lbl(Attractor.OCC_TAG_FILTER.name, Attractor.OCC_TAG_FILTER.desc));
            allowedOccTagsEd.add(gb);
            gb.nextRow();
            gb.add(guiUtil.lbl(Intl.intl("Decision Time:"), Intl.intl("Specifies the time at which an occupant considers the trigger after becoming aware of it.")));
            usageTime.add(gb);
            gb.nextRow();
            gb.addRow(rememberOutsideCb, 0);
        }

        public static boolean testProps(Set<Object> props) {
            return props.contains(Attractor.OCC_REACT_TIME) && props.contains(Attractor.REMEMBER_OUTSIDE_AWARENESS);
        }
    }

    private static class OccTargetsSect
    extends EditorPanel {
        private static final long serialVersionUID = 1L;

        public OccTargetsSect(MerlinData md) {
            guiLabel orientLbl = guiUtil.lbl(Intl.intl("Orientation:"), "<html>" + Intl.intl("The orientation of the occupant when they occupy this target.<br>This is an angle relative to the +X axis."));
            MerlinUDF orientFld = new MerlinUDF(7, UnitDoubleVR.between(-360.0, 360.0, NonSI.DEGREE_ANGLE, true, true));
            this.addConnection(new UDPropConnection(new CompElementActions.DefProp<ICompElement, UnitDouble>(OccTarget.ORIENT), orientFld));
            guiLabel priorityLbl = guiUtil.lbl(Intl.intl("Priority:"), "<html>" + Intl.intl("Defines a priority that can optionally be used by occupants to prioritize some<br>targets over others."));
            guiDoubleField priorityFld = new guiDoubleField(0.0);
            this.addConnection(new DoublePropConn(new CompElementActions.DefProp<ICompElement, Double>(OccTarget.PRIORITY), priorityFld));
            GridBagHelper gb = new GridBagHelper(this);
            gb.rowSpace = 1;
            gb.addRow(orientLbl, orientFld, 1.0);
            gb.addRow(priorityLbl, priorityFld, 1.0);
        }

        public static boolean testProps(Set<Object> props) {
            return props.contains(OccTarget.RADIUS) && props.contains(OccTarget.ORIENT) && props.contains(OccTarget.PRIORITY);
        }
    }

    private static class ChangeTagsSect
    extends EditorPanel {
        private static final long serialVersionUID = 1L;

        public ChangeTagsSect(MerlinData md) {
            guiComboBox<ChangeTags.Operation> opCombo = guiUtil.newCombo(op -> op == null ? new Pair<String, String>(Intl.intl("<mixed>"), null) : guiUtil.encodeToHtmlLabel(op.name, op.description), ChangeTags.Operation.values());
            this.addConnection(new ComboPropConn<ChangeTags.Operation>(new CompElementActions.DefProp(ChangeTags.OPERATION), opCombo));
            TagsField tagsEd = new TagsField();
            tagsEd.setEmptyAllowed(false);
            tagsEd.setNullAllowed(true);
            this.addConnection(new ValueFieldPropConn<Set>(new CompElementActions.DefProp(ChangeTags.TAGS), tagsEd, Set.class));
            final Runnable updateTagsFld = () -> {
                boolean emptyAllowed = CompElementActions.flattenToLocallyDefined(ChangeTags.OPERATION, this.getObjects()).stream().map(c -> c.getProperty(ChangeTags.OPERATION)).filter(o -> o instanceof ChangeTags.Operation).map(o -> (ChangeTags.Operation)((Object)((Object)((Object)o)))).allMatch(op -> op.tagsCanBeEmpty);
                tagsEd.setEmptyAllowed(emptyAllowed);
            };
            updateTagsFld.run();
            this.addConnection(new IPropConnection(){

                @Override
                public void bind(Collection<ICompElement> objs) {
                    updateTagsFld.run();
                }

                @Override
                public void update(Events events) {
                    updateTagsFld.run();
                }

                @Override
                public void release() {
                }

                @Override
                public void commit() {
                }
            });
            GridBagHelper gb = new GridBagHelper(this);
            gb.rowSpace = 1;
            gb.addRow(guiUtil.lbl(Intl.intl("Operation:"), Intl.intl("Specifies how the tags should be applied to the occupant.")), opCombo, 1.0);
            gb.addRow(guiUtil.lbl(Intl.intl("Tags:"), Intl.intl("The tags for the operation.")), tagsEd, 1.0);
        }
    }

    private static class JoinOccGroupSect
    extends EditorPanel {
        private static final long serialVersionUID = 7643305048030384490L;

        public JoinOccGroupSect() {
            MerlinComboBox groupChooser = new MerlinComboBox(MerlinApp.getApp().getData(), OccGroupObj.class, (IMerlinObj[])new OccGroupObj[0]);
            this.addConnection(new ComboPropConn(new CompElementActions.DefProp(JoinOccGroup.PROP_GROUP), groupChooser));
            GridBagHelper gb = new GridBagHelper(this);
            guiLabel lbl = new guiLabel(Intl.intl("Group:"));
            lbl.setToolTipText(Intl.intl("The group that the occupant will join."));
            gb.addRow(lbl, groupChooser, 1.0, 0);
        }
    }

    private static class AssistSect
    extends EditorPanel {
        private static final long serialVersionUID = -1495855788866897224L;

        public AssistSect() {
            MerlinComboBox teamChooser = new MerlinComboBox(MerlinApp.getApp().getData(), AssistedEvacTeam.class, (IMerlinObj[])new AssistedEvacTeam[0]);
            this.addConnection(new ComboPropConn(new CompElementActions.DefProp(AssistOccupants.TEAM), teamChooser));
            GridBagHelper gb = new GridBagHelper(this);
            guiLabel lbl = new guiLabel(Intl.intl("Team:"));
            lbl.setToolTipText(Intl.intl("The team on which the occupant will assist."));
            gb.addRow(lbl, teamChooser, 1.0, 0);
        }
    }

    private static class WaitForAssistanceSect
    extends EditorPanel {
        private static final long serialVersionUID = -8230874143773137125L;

        public WaitForAssistanceSect() {
            AETeamsChooser chooser = new AETeamsChooser(MerlinApp.getApp().getData());
            this.addConnection(new SetPropConnection<AssistedEvacTeam>(WaitForAssistance.TEAMS, chooser));
            GridBagHelper gb = new GridBagHelper(this);
            SelectionEditorPanel.addWaitActionMode(this, gb);
            guiLabel lbl = new guiLabel(Intl.intl("Assisting Teams:"));
            lbl.setToolTipText(Intl.intl("The teams that will assist the occupant."));
            gb.addRow(lbl, chooser, 1.0, 0);
        }
    }

    private static class BasicWaitSect
    extends EditorPanel {
        private static final long serialVersionUID = 1L;

        public BasicWaitSect() {
            GridBagHelper gb = new GridBagHelper(this);
            SelectionEditorPanel.addWaitActionMode(this, gb);
        }
    }

    private static class WaitUntilSect
    extends EditorPanel {
        private static final long serialVersionUID = -9111400939967609919L;

        public WaitUntilSect() {
            WaitUntilSrcPnl waitPnl = new WaitUntilSrcPnl(Intl.intl("Wait Until Time:"));
            this.addConnection(new WaitConn<IWaitUntilSrc>(WaitUntil.TIME_SOURCE, waitPnl));
            GridBagHelper gb = new GridBagHelper(this);
            SelectionEditorPanel.addWaitActionMode(this, gb);
            gb.addRow(Intl.intl("Wait Until Time:"), waitPnl);
        }
    }

    private static class WaitSect
    extends EditorPanel {
        private static final long serialVersionUID = 905883487856915979L;

        public WaitSect() {
            CompactDistributedValPnl delayPnl = new CompactDistributedValPnl(Intl.intl("Wait Time:"), 1);
            this.addConnection(new CurveConn<IDistributedVal<UnitDouble>>(Wait.TIME, delayPnl));
            GridBagHelper gb = new GridBagHelper(this);
            SelectionEditorPanel.addWaitActionMode(this, gb);
            gb.addRow(Intl.intl("Wait Time:"), delayPnl, 1.0, 0);
        }
    }

    private static class GotoExitsSect
    extends EditorPanel {
        private static final long serialVersionUID = -3751225364472811879L;

        public GotoExitsSect() {
            ExitChooser chooser = new ExitChooser(MerlinApp.getApp().getData());
            this.addConnection(new SetPropConnection<EgressDoor>(GotoExits.PROP_EXITS, chooser));
            GridBagHelper gb = new GridBagHelper(this);
            gb.addRow(Intl.intl("Exits:"), chooser);
        }
    }

    private static class AbandonOccTargetsSect
    extends EditorPanel {
        private static final long serialVersionUID = 1L;

        public AbandonOccTargetsSect() {
            guiComboBox<AbandonOccTargets.Which> whichCB = guiUtil.newCombo(which -> guiUtil.encodeToHtmlLabels(which.shortDesc, which.longDesc), AbandonOccTargets.Which.values());
            this.addConnection(new ComboPropConn<AbandonOccTargets.Which>(new CompElementActions.DefProp(AbandonOccTargets.WHICH), whichCB));
            GridBagHelper gb = new GridBagHelper(this);
            gb.addRow(guiUtil.lbl(Intl.intl("Locations:"), Intl.intl("Defines which location(s) will be abandoned.")), whichCB);
        }
    }

    private static class GotoCurrentAttractorSect
    extends EditorPanel {
        private static final long serialVersionUID = 1L;

        public GotoCurrentAttractorSect() {
            guiComboBox<GotoCurrentAttractor.Tracking> trackingCombo = guiUtil.newEnumCombo(GotoCurrentAttractor.Tracking.class);
            ValueField<UnitDouble> arrivalRadiusFld = MerlinValueFields.udFld(0.0, DoubleVR.above(0.0, true), (Unit)SI.METER, 0);
            guiComboBox<GotoCurrentAttractor.TargetUnreachable> unreachableCombo = guiUtil.newEnumCombo(GotoCurrentAttractor.TargetUnreachable.class);
            Function<INamedProp, guiLabel> lbl = prop -> guiUtil.lblHtml(String.format(Intl.intl("%s:"), prop.getDisplayName()), prop.getDisplayDesc());
            GridBagHelper gb = SelectionEditorPanel.newHelper(this);
            gb.addRow(lbl.apply(GotoCurrentAttractor.PROP_TRACKING), trackingCombo, 1.0);
            gb.addRow(lbl.apply(GotoCurrentAttractor.PROP_ARRIVAL_RADIUS), arrivalRadiusFld, 1.0);
            gb.addRow(lbl.apply(GotoCurrentAttractor.PROP_UNREACHABLE), unreachableCombo, 1.0);
            this.addConnection(new ComboPropConn<GotoCurrentAttractor.Tracking>(new CompElementActions.DefProp(GotoCurrentAttractor.PROP_TRACKING), trackingCombo));
            this.addConnection(new ValueFieldPropConn<UnitDouble>(new CompElementActions.DefProp(GotoCurrentAttractor.PROP_ARRIVAL_RADIUS), arrivalRadiusFld, UnitDouble.class));
            this.addConnection(new ComboPropConn<GotoCurrentAttractor.TargetUnreachable>(new CompElementActions.DefProp(GotoCurrentAttractor.PROP_UNREACHABLE), unreachableCombo));
        }
    }

    private static class GotoOccSect2
    extends EditorPanel {
        private static final long serialVersionUID = 1L;

        public GotoOccSect2() {
            Function<INamedProp, guiMultiStateCheckBox> cb = prop -> {
                guiMultiStateCheckBox result = new guiMultiStateCheckBox(guiUtil.encodeToHtmlLabel(prop.getDisplayName()));
                result.setToolTipText(prop.getDisplayDesc().isEmpty() ? null : guiUtil.encodeToHtmlLabel(prop.getDisplayDesc()));
                return result;
            };
            ValueField<UnitDouble> arrivalRadiusFld = MerlinValueFields.udFld(0.0, DoubleVR.above(0.0, true), (Unit)SI.METER, 0);
            guiComboBox<GotoOcc.TargetNotFound> noOccs = guiUtil.newEnumCombo(GotoOcc.TargetNotFound.class);
            guiComboBox<GotoOcc.TargetUnreachable> unreachable = guiUtil.newEnumCombo(GotoOcc.TargetUnreachable.class);
            Function<INamedProp, guiLabel> lbl = prop -> guiUtil.lblHtml(String.format(Intl.intl("%s:"), prop.getDisplayName()), prop.getDisplayDesc());
            GridBagHelper gb = SelectionEditorPanel.newHelper(this);
            gb.addRow(lbl.apply(GotoOcc.PROP_ARRIVAL_RADIUS), arrivalRadiusFld, 1.0);
            gb.addRow(lbl.apply(GotoOcc.PROP_NO_OCCUPANTS), noOccs, 1.0);
            gb.addRow(lbl.apply(GotoOcc.PROP_UNREACHABLE), unreachable, 1.0);
            this.addConnection(new ValueFieldPropConn<UnitDouble>(new CompElementActions.DefProp(GotoOcc.PROP_ARRIVAL_RADIUS), arrivalRadiusFld, UnitDouble.class));
            this.addConnection(new ComboPropConn<GotoOcc.TargetNotFound>(new CompElementActions.DefProp(GotoOcc.PROP_NO_OCCUPANTS), noOccs));
            this.addConnection(new ComboPropConn<GotoOcc.TargetUnreachable>(new CompElementActions.DefProp(GotoOcc.PROP_UNREACHABLE), unreachable));
        }
    }

    private static class GotoOccSect1
    extends EditorPanel {
        private static final long serialVersionUID = 1L;

        public GotoOccSect1() {
            guiComboBox<GotoOcc.TagLogic> tagLogicCombo = guiUtil.newCombo(o -> o != null ? guiUtil.encodeToHtmlLabel(o.name, o.desc) : new Pair<String, String>(Intl.intl("<mixed>"), null), GotoOcc.TagLogic.values());
            TagsField tagsFld = new TagsField();
            tagsFld.setNullAllowed(true);
            tagsFld.setColumns(10);
            guiComboBox<GotoOcc.DistancePref> distPrefCombo = guiUtil.newEnumCombo(GotoOcc.DistancePref.class);
            guiComboBox<GotoOcc.Tracking> trackingCombo = guiUtil.newEnumCombo(GotoOcc.Tracking.class);
            guiPanel tagsComponents = new guiPanel();
            GridBagHelper gb = new GridBagHelper(tagsComponents);
            gb.addRow(tagLogicCombo, tagsFld, 1.0);
            Function<INamedProp, guiLabel> lbl = prop -> guiUtil.lblHtml(String.format(Intl.intl("%s:"), prop.getDisplayName()), prop.getDisplayDesc());
            GridBagHelper gb2 = SelectionEditorPanel.newHelper(this);
            gb2.addRow(lbl.apply(GotoOcc.PROP_TAGS), tagsComponents, 1.0);
            gb2.addRow(lbl.apply(GotoOcc.PROP_DIST_PREF), distPrefCombo, 1.0);
            gb2.addRow(lbl.apply(GotoOcc.PROP_TRACKING), trackingCombo, 1.0);
            this.addConnection(new ComboPropConn<GotoOcc.TagLogic>(new CompElementActions.DefProp(GotoOcc.PROP_TAG_LOGIC), tagLogicCombo));
            this.addConnection(new ValueFieldPropConn<Set>(new CompElementActions.DefProp(GotoOcc.PROP_TAGS), tagsFld, Set.class));
            this.addConnection(new ComboPropConn<GotoOcc.DistancePref>(new CompElementActions.DefProp(GotoOcc.PROP_DIST_PREF), distPrefCombo));
            this.addConnection(new ComboPropConn<GotoOcc.Tracking>(new CompElementActions.DefProp(GotoOcc.PROP_TRACKING), trackingCombo));
        }
    }

    private static class GotoOccTargetsSect
    extends EditorPanel {
        private static final long serialVersionUID = 1L;

        public GotoOccTargetsSect() {
            OccTargetsChooser chooser = new OccTargetsChooser(MerlinApp.getApp().getData());
            guiComboBox<GotoOccTarget.DistancePref> choices = guiUtil.newCombo(pref -> pref == null ? new Pair<String, String>(Intl.intl("<mixed>"), null) : guiUtil.encodeToHtmlLabel(pref.name, pref.desc), GotoOccTarget.DistancePref.values());
            guiComboBox<GotoOccTarget.PriorityPref> prefs = guiUtil.newCombo(pref -> pref == null ? new Pair<String, String>(Intl.intl("<mixed>"), null) : guiUtil.encodeToHtmlLabel(pref.name, pref.desc), GotoOccTarget.PriorityPref.values());
            this.addConnection(new ComboPropConn<GotoOccTarget.DistancePref>(new CompElementActions.DefProp(GotoOccTarget.PROP_DIST_PREF), choices));
            this.addConnection(new ComboPropConn<GotoOccTarget.PriorityPref>(new CompElementActions.DefProp(GotoOccTarget.PROP_PRIORITY_PREF), prefs));
            this.addConnection(new SetPropConnection<OccTarget>(GotoOccTarget.PROP_TARGETS, chooser));
            GridBagHelper gb = new GridBagHelper(this);
            gb.rowSpace = 1;
            gb.addRow(Intl.intl("Occ Targets:"), chooser);
            gb.addRow(guiUtil.lbl(Intl.intl("Priority Preference:"), "<html>" + Intl.intl("Defines the occupant's preference for a target based on the<br>target's priority. This interacts with the <b>Distance Preference</b><br>to define how the occupant chooses a target.")), prefs, 1.0);
            gb.addRow(guiUtil.lbl(Intl.intl("Distance Preference:"), "<html>" + Intl.intl("Defines the occupant's preference for a target based on the distance<br>to the target. This is secondary to the <b>Priority Preference</b>,<br>but also helps define how the occupant chooses a target.")), choices, 1.0);
        }
    }

    private static class GotoRoomsPropConn
    extends SetPropConnection<IEgressOccupiable> {
        public GotoRoomsPropConn(RoomChooser chooser) {
            super((Object)GotoRooms.PROP_ROOMS, chooser);
        }

        @Override
        public void initFromProp(Object prop, Collection<? extends ICompElement> objs, SetChooser<IEgressOccupiable> comp) {
            super.initFromProp(prop, objs, comp);
            Predicate<Object> filter = Predicates.alwaysTrue();
            for (GotoRooms room : MerlinUtil.flatten(objs, GotoRooms.class)) {
                filter = Predicates.and(filter, room.getFilter());
            }
            comp.setFilter(filter);
            comp.setAnyAllowed(GotoRooms.getAnyAllowed(filter));
        }
    }

    private static class GotoRoomsSect
    extends EditorPanel {
        private static final long serialVersionUID = -6920240952279377180L;

        public GotoRoomsSect() {
            RoomChooser chooser = new RoomChooser(MerlinApp.getApp().getData());
            this.addConnection(new GotoRoomsPropConn(chooser));
            GridBagHelper gb = new GridBagHelper(this);
            gb.addRow(Intl.intl("Rooms:"), chooser);
        }
    }

    private static class GotoQueueSect
    extends EditorPanel {
        private static final long serialVersionUID = -3147657023720063829L;

        public GotoQueueSect() {
            MerlinData md = MerlinApp.getApp().getData();
            QueueChooser chooser = new QueueChooser(md);
            this.addConnection(new SetPropConnection<IGotoQueueDestination>(GotoQueue.PROP_QUEUE_DESTINATIONS, chooser));
            GridBagHelper gbh = new GridBagHelper(this);
            gbh.addRow(Intl.intl("Queue:"), chooser);
        }
    }

    private static class GotoElevatorsSect
    extends EditorPanel {
        private static final long serialVersionUID = -780951003436714775L;

        public GotoElevatorsSect() {
            ElevatorChooser chooser = new ElevatorChooser(MerlinApp.getApp().getData());
            ElevatorFloorComboBox floor = new ElevatorFloorComboBox(MerlinApp.getApp().getData(), (Collection<Elevator>)chooser.getElevators());
            this.addConnection(new SetPropConnection<Elevator>(GotoElevators.PROP_ELEVATORS, chooser));
            this.addConnection(new ComboPropConn<Floor>(new CompElementActions.DefProp(GotoElevators.PROP_FLOOR), floor));
            chooser.addValueListener(e -> floor.setElevators(chooser.getElevators()));
            chooser.addPropertyChangeListener("edit", e -> {
                if (((Boolean)e.getNewValue()).booleanValue()) {
                    floor.setElevators(chooser.getElevators());
                }
            });
            GridBagHelper gb = new GridBagHelper(this);
            gb.addRow(Intl.intl("Elevators:"), chooser);
            gb.addRow(Intl.intl("Target Floor:"), floor);
        }
    }

    private static class GotoWaypointSect
    extends EditorPanel {
        private static final long serialVersionUID = -8858082683244902555L;

        public GotoWaypointSect() {
            MerlinUDF arriveRadFld = new MerlinUDF(0);
            this.addConnection(new UDPropConnection(new CompElementActions.DefProp<ICompElement, UnitDouble>(GotoWaypoint.PROP_ARRIVE_RADIUS), arriveRadFld));
            GridBagHelper gb = new GridBagHelper(this);
            gb.addRow(Intl.intl("Arrival Radius:"), arriveRadFld);
        }
    }

    private static class BehaviorActionSect
    extends ABehaviorSect {
        private static final long serialVersionUID = 6028576008727991985L;
        private final Collection<guiAction> d_availActions;
        private final DropDownButton d_button;
        private final guiLabel d_addLbl;
        private final Map<guiAction, String> d_shortDescs;

        public BehaviorActionSect(guiAction ... actions) {
            this.d_availActions = theUtil.filter(Arrays.asList(actions), a -> a != null);
            this.d_button = new DropDownButton(actions);
            this.d_shortDescs = new HashMap<guiAction, String>(this.d_availActions.size());
            for (guiAction action : this.d_availActions) {
                this.d_shortDescs.put(action, (String)action.getValue("ShortDescription"));
            }
            GridBagHelper gb = new GridBagHelper(this);
            gb.rowSpace = 1;
            this.d_addLbl = new guiLabel(Intl.intl("Add Action:"));
            gb.addRow(this.d_addLbl, this.d_button);
        }

        @Override
        protected void updateBinding(Collection<ICompElement> objs) {
            super.updateBinding(objs);
            this.setEnabled(this.d_behaviors.size() == 1 && this.d_actions.size() <= 1);
            if (this.isEnabled()) {
                this.d_availActions.stream().forEach(a -> {
                    a.setEnabled(true);
                    a.putValue("ShortDescription", this.d_shortDescs.get(a));
                });
            }
            if (this.d_actions.isEmpty()) {
                this.d_addLbl.setToolTipText(Intl.intl("Add a new action."));
            } else {
                this.d_addLbl.setToolTipText(Intl.intl("Insert a new action immediately after the current action."));
            }
        }
    }

    public static class SetPropConnection<T extends IMerlinObj>
    extends ASinglePropConnection<SetChooser<T>> {
        private final boolean d_inverted;

        public SetPropConnection(Object prop, SetChooser<T> control) {
            this(prop, control, false);
        }

        public SetPropConnection(Object prop, SetChooser<T> control, boolean invert) {
            super(prop, control);
            this.d_inverted = invert;
            control.addValueListener(e -> this.onControlChanged());
        }

        @Override
        public void initFromProp(Object prop, Collection<? extends ICompElement> objs, SetChooser<T> comp) {
            Set objSet;
            Object choice = Composite.getProperty(prop, objs);
            Set set = objSet = choice instanceof Set ? (Set)choice : null;
            if (this.d_inverted) {
                comp.setUnselectedObjs(objSet);
            } else {
                comp.setValue(objSet);
            }
            comp.setModified(false);
        }

        @Override
        public void setProp(Object prop, Collection<? extends ICompElement> objs, SetChooser<T> comp) {
            Set<T> objSet;
            Set<T> set = objSet = this.d_inverted ? comp.getUnselectedObjs() : comp.getObjs();
            if (objSet == null) {
                return;
            }
            MerlinData md = MerlinApp.getApp().getData();
            assert (md != null);
            Undo.begin(Intl.intl("Edit Property"));
            Undo.insertUndoEntry_propRestore(md, objs, prop);
            this.setProp(prop, objs, objSet);
            Undo.end(md);
        }

        @Override
        public void setProp(Object prop, Collection<? extends ICompElement> objs, Object val) {
            Composite.setProperty(prop, val, objs);
        }
    }

    private static class DiscretePropConnection<T extends IMerlinObj>
    extends ASinglePropConnection<DiscreteChooser<T>> {
        public DiscretePropConnection(Object prop, DiscreteChooser<T> control) {
            super(prop, control);
            control.getComm().addObserver((o, arg) -> this.onControlChanged());
        }

        @Override
        public void setProp(Object prop, Collection<? extends ICompElement> objs, DiscreteChooser<T> comp) {
            T selection = comp.getObj();
            if (selection == null) {
                return;
            }
            MerlinData md = MerlinApp.getApp().getData();
            assert (md != null);
            Undo.begin(Intl.intl("Edit Property"));
            Undo.insertUndoEntry_propRestore(md, objs, prop);
            Composite.setProperty(prop, selection, objs);
            Undo.end(md);
        }

        @Override
        public void initFromProp(Object prop, Collection<? extends ICompElement> objs, DiscreteChooser<T> comp) {
            Object choice = Composite.getProperty(prop, objs);
            IMerlinObj shownT = null;
            if (!choice.equals(ICompElement.NON_UNIFORM) && !choice.equals(ICompElement.NOT_SUPPORTED)) {
                shownT = (IMerlinObj)choice;
            }
            comp.setObj(Property.of(shownT));
            comp.setModified(false);
        }
    }

    private static class BehaviorPropSect
    extends ABehaviorSect {
        private static final long serialVersionUID = -7681869862008053558L;

        public BehaviorPropSect() {
            CompactDistributedValPnl delayPnl = new CompactDistributedValPnl(Intl.intl("Initial Delay"), 1);
            this.addConnection(new CurveConn<IDistributedVal<UnitDouble>>(Behavior.PROP_INI_DELAY, delayPnl));
            ColorComp color = new ColorComp(null, new ColorButton());
            this.addConnection(new ColorConn(color.btn));
            GridBagHelper bg = new GridBagHelper(this);
            bg.rowSpace = 1;
            bg.addRow(Intl.intl("Initial Delay:"), delayPnl, 1.0);
            bg.addRow(Intl.intl("Color:"), color.btn, 1.0);
        }

        @Override
        protected void updateBinding(Collection<ICompElement> objs) {
            super.updateBinding(objs);
            this.setEnabled(this.d_actions.isEmpty());
        }
    }

    private static class BehaviorSect
    extends ABehaviorSect {
        private static final long serialVersionUID = 59958309108072690L;
        private final guiLabel d_actionLbl;
        private final guiTextField d_behaviorFld = new guiTextField();
        private final guiTextField d_actionFld;
        private final JButton d_leftBtn;
        private final JButton d_rightBtn;
        private final NamePropConnection d_behaviorConn;
        private final NamePropConnection d_actionConn;

        public BehaviorSect() {
            Dimension dim = new Dimension(150, this.d_behaviorFld.getPreferredSize().height);
            this.d_behaviorFld.setPreferredSize(dim);
            this.d_behaviorConn = new NamePropConnection(this.d_behaviorFld);
            this.addConnection(this.d_behaviorConn);
            this.d_actionFld = new guiTextField();
            this.d_actionFld.setPreferredSize(dim);
            this.d_actionFld.setEditable(false);
            this.d_actionConn = new NamePropConnection(this.d_actionFld);
            this.addConnection(this.d_actionConn);
            this.d_actionLbl = new guiLabel(Intl.intl("Action:"));
            this.d_leftBtn = new BasicArrowButton(7);
            this.d_rightBtn = new BasicArrowButton(3);
            guiPanel btnPnl = new guiPanel(new FlowLayout(0, 1, 0));
            btnPnl.add(this.d_leftBtn);
            btnPnl.add(this.d_rightBtn);
            this.d_leftBtn.addActionListener(new ChangeAction(-1));
            this.d_rightBtn.addActionListener(new ChangeAction(1));
            GridBagHelper gb = new GridBagHelper(this);
            gb.rowSpace = 1;
            gb.addRow(Intl.intl("Behavior:"), this.d_behaviorFld, 2);
            gb.addRow(this.d_actionLbl, this.d_actionFld, btnPnl);
        }

        @Override
        protected void updateBinding(Collection<ICompElement> objs) {
            int actionix;
            super.updateBinding(objs);
            this.d_actionConn.bind(this.d_actions);
            this.d_behaviorConn.bind(this.d_behaviors);
            this.d_behaviorFld.setEditable(this.d_actions.isEmpty());
            this.d_actionFld.setVisible(!this.d_actions.isEmpty());
            this.d_actionLbl.setVisible(!this.d_actions.isEmpty());
            boolean scrollEnabled = this.d_behaviors.size() == 1 && this.getBehavior().getMembers().size() > 1 && this.d_actions.size() == 1;
            this.d_leftBtn.setVisible(scrollEnabled);
            this.d_rightBtn.setVisible(scrollEnabled);
            if (scrollEnabled && (actionix = this.getActionIndex()) >= 0) {
                this.d_leftBtn.setEnabled(actionix > 0);
                this.d_rightBtn.setEnabled(actionix < this.getBehavior().getMembers().size() - 1);
            }
        }

        private int getActionIndex() {
            int ix = 0;
            for (IBehaviorAction action : this.getBehavior().getMembers(IBehaviorAction.class)) {
                if (action == this.getAction()) {
                    return ix;
                }
                ++ix;
            }
            return -1;
        }

        private IBehaviorAction getAction(int ix) {
            int m = 0;
            for (IBehaviorAction action : this.getBehavior().getMembers(IBehaviorAction.class)) {
                if (m == ix) {
                    return action;
                }
                ++m;
            }
            return null;
        }

        private class ChangeAction
        implements ActionListener {
            private final int direction;

            public ChangeAction(int direction) {
                this.direction = direction;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                int currix = BehaviorSect.this.getActionIndex();
                int nextix = currix + this.direction;
                if (nextix < 0 || nextix >= BehaviorSect.this.getBehavior().getMembers().size()) {
                    return;
                }
                IBehaviorAction nextAction = BehaviorSect.this.getAction(nextix);
                if (nextAction != null) {
                    MerlinApp.getApp().getData().selection.set(nextAction);
                }
            }
        }
    }

    private static abstract class ABehaviorSect
    extends EditorPanel {
        private static final long serialVersionUID = 7515542689067740366L;
        protected Collection<Behavior> d_behaviors;
        protected Collection<IBehaviorAction> d_actions;

        private ABehaviorSect() {
        }

        @Override
        public void bind(Collection<ICompElement> objs) {
            this.d_actions = theUtil.filter(objs, IBehaviorAction.class);
            LinkedIdentityHashSet<Behavior> behaviors = new LinkedIdentityHashSet<Behavior>((Collection<Behavior>)theUtil.filter(objs, Behavior.class));
            for (IBehaviorAction action : theUtil.filter(objs, IBehaviorAction.class)) {
                behaviors.add((Behavior)MerlinApp.getApp().getData().hierarchy.getParent(action));
            }
            this.d_behaviors = behaviors;
            super.bind(this.d_behaviors);
            this.updateBinding(objs);
        }

        protected Behavior getBehavior() {
            return this.d_behaviors.isEmpty() ? null : this.d_behaviors.iterator().next();
        }

        protected IBehaviorAction getAction() {
            return this.d_actions.isEmpty() ? null : this.d_actions.iterator().next();
        }

        protected void updateBinding(Collection<ICompElement> objs) {
        }
    }

    private static class CameraRangeProp
    extends CompElementActions.DefProp<ICompElement, UnitDouble> {
        private final int d_ix;
        private final Unit d_storeUnit;

        public CameraRangeProp(IPropertySet.Prop<Camera.PTZSpec> prop, Unit storeUnit, int ix) {
            super(prop);
            this.d_storeUnit = storeUnit;
            this.d_ix = ix;
        }

        private static double[] asList(Camera.PTZSpec range) {
            return new double[]{range.rangeMin, range.rangeMax, range.maxSpeed};
        }

        private static Camera.PTZSpec newSpec(double[] list) {
            return new Camera.PTZSpec(list[0], list[1], list[2]);
        }

        @Override
        protected Object get(MerlinData md, Object prop, ICompElement obj) {
            if (!(obj instanceof Camera)) {
                return ICompElement.NOT_SUPPORTED;
            }
            Camera cam = (Camera)obj;
            IPropertySet.Prop rprop = (IPropertySet.Prop)prop;
            Camera.PTZSpec spec = (Camera.PTZSpec)cam.get(rprop);
            return new UnitDouble(CameraRangeProp.asList(spec)[this.d_ix], this.d_storeUnit);
        }

        @Override
        protected void set(MerlinData md, Object prop, ICompElement obj, UnitDouble newVal) {
            if (!(obj instanceof Camera)) {
                return;
            }
            IPropertySet.Prop rprop = (IPropertySet.Prop)prop;
            Camera cam = (Camera)obj;
            Camera.PTZSpec spec = (Camera.PTZSpec)cam.get(rprop);
            double[] newSpecList = CameraRangeProp.asList(spec);
            newSpecList[this.d_ix] = newVal.getValue(this.d_storeUnit);
            Camera.PTZSpec newSpec = CameraRangeProp.newSpec(newSpecList);
            if (spec.equals(newSpec)) {
                return;
            }
            cam.set(rprop, newSpec);
        }
    }

    private static class CameraLimitsSect
    extends EditorPanel {
        private static final long serialVersionUID = -8095722618467231604L;
        private Collection<? extends ICompElement> d_boundObjs = Collections.EMPTY_LIST;

        public CameraLimitsSect() {
            GridBagHelper gb = new GridBagHelper(this, false);
            gb.rowSpace = 1;
            this.addPTZSpec(gb, Intl.intl("Pan"), Camera.PROP_PAN_INFO, 7, SI.RADIAN, UnitDoubleVR.UNBOUNDED, 14, SI.RADIAN.divide(SI.SECOND), UnitDoubleVR.above(0.0, SI.RADIAN.divide(SI.SECOND), true));
            this.addPTZSpec(gb, Intl.intl("Tilt"), Camera.PROP_TILT_INFO, 7, SI.RADIAN, UnitDoubleVR.between(-90.0, 90.0, NonSI.DEGREE_ANGLE, true, true), 14, SI.RADIAN.divide(SI.SECOND), UnitDoubleVR.above(0.0, SI.RADIAN.divide(SI.SECOND), true));
            this.addPTZSpec(gb, Intl.intl("Zoom"), Camera.PROP_ZOOM_INFO, 10, Unit.ONE, UnitDoubleVR.above(1.0, Unit.ONE, true), 15, Unit.ONE.divide(SI.SECOND), UnitDoubleVR.above(0.0, Unit.ONE.divide(SI.SECOND), true));
        }

        private void addPTZSpec(GridBagHelper gb, String name, IPropertySet.Prop<Camera.PTZSpec> prop, int rangeUnitType, Unit rangeStoreUnit, UnitDoubleVR rangeRange, int speedUnitType, Unit speedStoreUnit, UnitDoubleVR speedRange) {
            guiUnitDoubleField minFld = CameraLimitsSect.newField(rangeUnitType, rangeRange);
            this.addConnection(new UDPropConnection(new CameraRangeProp(prop, rangeStoreUnit, 0), minFld));
            guiUnitDoubleField maxFld = CameraLimitsSect.newField(rangeUnitType, rangeRange);
            this.addConnection(new UDPropConnection(new CameraRangeProp(prop, rangeStoreUnit, 1), maxFld));
            guiUnitDoubleField speedFld = CameraLimitsSect.newField(speedUnitType, speedRange);
            this.addConnection(new UDPropConnection(new CameraRangeProp(prop, speedStoreUnit, 2), speedFld));
            gb.addRow(CameraLimitsSect.getBoldLbl(name), Intl.intl("Min:"), minFld, Intl.intl("Max:"), maxFld, Intl.intl("Max Speed:"), speedFld);
        }

        private static guiUnitDoubleField newField(int unitType, UnitDoubleVR range) {
            MerlinUDF fld = new MerlinUDF(unitType, range);
            fld.setColumns(7);
            return fld;
        }

        private static guiLabel getBoldLbl(String text) {
            return new guiLabel("<html><b>" + text + "</b></html>");
        }

        @Override
        public void bind(Collection<ICompElement> objs) {
            objs = new ArrayList<Camera>(MerlinUtil.flatten(objs, Camera.class));
            super.bind(objs);
            this.d_boundObjs = objs;
            this.updateEnabled();
        }

        @Override
        public void release() {
            super.release();
            this.d_boundObjs = Collections.EMPTY_LIST;
        }

        @Override
        public void update(Events events) {
            super.update(events);
            this.updateEnabled();
        }

        private void updateEnabled() {
            Object oval = Composite.getProperty(Camera.PROP_SECURITY, this.d_boundObjs);
            this.setEnabled(oval instanceof Boolean && (Boolean)oval != false || oval == ICompElement.NON_UNIFORM);
        }
    }

    private static class VectorProp
    extends CompElementActions.DefProp<ICompElement, Double> {
        private final int d_ix;

        public VectorProp(Object prop, int ix) {
            super(prop);
            this.d_ix = ix;
        }

        @Override
        protected Object get(MerlinData md, Object prop, ICompElement obj) {
            Object val = obj.getProperty(prop);
            if (val instanceof Vector3d) {
                Vector3d vec = (Vector3d)val;
                switch (this.d_ix) {
                    case 0: {
                        return vec.x;
                    }
                    case 1: {
                        return vec.y;
                    }
                }
                return vec.z;
            }
            return val;
        }

        @Override
        protected void set(MerlinData md, Object prop, ICompElement obj, Double newVal) {
            Vector3d vec = (Vector3d)obj.getProperty(prop);
            Vector3d newVec = new Vector3d(vec);
            switch (this.d_ix) {
                case 0: {
                    newVec.x = newVal;
                    break;
                }
                case 1: {
                    newVec.y = newVal;
                    break;
                }
                default: {
                    newVec.z = newVal;
                }
            }
            if (!newVec.equals(vec)) {
                obj.setProperty(prop, newVec);
            }
        }
    }

    private static class CameraOrientSect
    extends EditorPanel {
        private static final long serialVersionUID = 6159519025359868412L;

        public CameraOrientSect() {
            int numCols = 5;
            guiDoubleField xfld = new guiDoubleField();
            xfld.setColumns(numCols);
            this.addConnection(new DoublePropConn(new VectorProp(Camera.PROP_PTZ_ORIENT, 0), xfld));
            guiDoubleField yfld = new guiDoubleField();
            yfld.setColumns(numCols);
            this.addConnection(new DoublePropConn(new VectorProp(Camera.PROP_PTZ_ORIENT, 1), yfld));
            guiDoubleField zfld = new guiDoubleField();
            zfld.setColumns(numCols);
            this.addConnection(new DoublePropConn(new VectorProp(Camera.PROP_PTZ_ORIENT, 2), zfld));
            GridBagHelper gb = new GridBagHelper(this);
            gb.rowSpace = 1;
            gb.addRow(Intl.intl("Pan Axis (X):"), xfld, 0);
            gb.addRow(Intl.intl("Pan Axis (Y):"), yfld, 0);
            gb.addRow(Intl.intl("Pan Axis (Z):"), zfld, 0);
        }
    }

    private static class CameraControlSect
    extends EditorPanel {
        private static final long serialVersionUID = 735559975360379055L;

        public CameraControlSect() {
            guiMultiStateCheckBox controllableCB = new guiMultiStateCheckBox(Intl.intl("Security Camera"));
            controllableCB.setToolTipText(Intl.intl("Treats the camera as a security camera that can be controlled during the simulation."));
            this.addConnection(new BoolPropConnection(new CompElementActions.DefProp<ICompElement, Boolean>(Camera.PROP_SECURITY), controllableCB));
            GridBagHelper gb = new GridBagHelper(this);
            gb.addRow(controllableCB);
        }
    }

    public static class CurveConn<T extends IDistributedVal<UnitDouble>>
    extends ASinglePropConnection<JComponent> {
        private final IValEditor<T> d_editor;

        public CurveConn(Object prop, IValEditor<T> editor) {
            super(prop, editor.getComponent());
            this.d_editor = editor;
            PropertyChangeListener listener = e -> {
                if (!(editor.getComponent() instanceof Validateable) || ((Validateable)((Object)editor.getComponent())).validateData(true, true)) {
                    this.onControlChanged();
                }
            };
            editor.addValueListener(listener);
            MerlinApp.getApp().getData().getEvents().addObserver(this);
        }

        @Override
        public void initFromProp(Object prop, Collection<? extends ICompElement> objs, JComponent comp) {
            Object curveObj = Composite.getProperty(prop, objs);
            IDistributedVal curve = this.d_editor.getType().isInstance(curveObj) ? (IDistributedVal)this.d_editor.getType().cast(curveObj) : null;
            this.d_editor.setValue(curve);
            if (comp instanceof Modifiable) {
                ((Modifiable)((Object)comp)).setModified(false);
            }
        }

        @Override
        public void setProp(Object prop, Collection<? extends ICompElement> objs, Object val) {
            if (val != null) {
                Undo.begin(Intl.intl("Edit Property"));
                Undo.insertUndoEntry_propRestore(MerlinApp.getApp().getData(), objs, prop);
                Composite.setProperty(prop, val, objs);
                Undo.end(MerlinApp.getApp().getData());
            }
        }

        @Override
        public void setProp(Object prop, Collection<? extends ICompElement> objs, JComponent comp) {
            this.setProp(prop, objs, (Object)this.d_editor.getValue());
        }
    }

    private static class WaitConn<T extends IWaitUntilSrc>
    extends ASinglePropConnection<JComponent> {
        private final IValEditor<T> d_editor;

        public WaitConn(Object prop, IValEditor<T> editor) {
            super(prop, editor.getComponent());
            this.d_editor = editor;
            this.d_editor.addValueListener(e -> {
                if (!(editor.getComponent() instanceof Validateable) || ((Validateable)((Object)editor.getComponent())).validateData(true, true)) {
                    this.onControlChanged();
                }
            });
            MerlinApp.getApp().getData().getEvents().addObserver(this);
        }

        @Override
        public void initFromProp(Object prop, Collection<? extends ICompElement> objs, JComponent comp) {
            Object waitObj = Composite.getProperty(prop, objs);
            IWaitUntilSrc waitSrc = this.d_editor.getType().isInstance(waitObj) ? (IWaitUntilSrc)this.d_editor.getType().cast(waitObj) : null;
            this.d_editor.setValue(waitSrc);
            if (comp instanceof Modifiable) {
                ((Modifiable)((Object)comp)).setModified(false);
            }
        }

        @Override
        public void setProp(Object prop, Collection<? extends ICompElement> objs, JComponent comp) {
            this.setProp(prop, objs, (Object)this.d_editor.getValue());
        }

        @Override
        public void setProp(Object prop, Collection<? extends ICompElement> objs, Object val) {
            if (val != null) {
                Undo.begin(Intl.intl("Edit Property"));
                Undo.insertUndoEntry_propRestore(MerlinApp.getApp().getData(), objs, prop);
                Composite.setProperty(prop, val, objs);
                Undo.end(MerlinApp.getApp().getData());
            }
        }
    }

    private static class CorridorDoorPnl
    extends EditorPanel {
        private static final long serialVersionUID = 2279557250990357514L;
        private final Object d_doorProp;
        private List<ICompElement> d_boundDoors;

        public CorridorDoorPnl(Object doorProp) {
            this.d_doorProp = doorProp;
            MerlinUDF fldTopWid = new MerlinUDF(6);
            fldTopWid.aliasValue(EgressCorridor.DOOR_STAIR_WIDTH, Intl.intl("STAIR_WIDTH"));
            UDPropConnection connTopWid = new UDPropConnection(new CompElementActions.DefProp<ICompElement, UnitDouble>(EgressCorridor.DoorInfo.WIDTH), fldTopWid);
            this.addConnection(connTopWid);
            GridBagHelper gb = new GridBagHelper(this);
            gb.addRow(Intl.intl("Width:"), fldTopWid, 0, 1.0);
            SelectionEditorPanel.addFlowrate(this, gb);
            SelectionEditorPanel.addCorridorDoorState(this, gb);
            gb.finalizeRows();
        }

        @Override
        public void bind(Collection<ICompElement> objs) {
            this.d_boundDoors = new ArrayList<ICompElement>();
            for (EgressCorridor corr : theUtil.filter(objs, EgressCorridor.class)) {
                corr = (EgressCorridor)corr.clone();
                EgressCorridor.DoorInfo di = this.d_doorProp == EgressCorridor.TOP_DOOR ? corr.getTopDoor() : corr.getBottomDoor();
                this.d_boundDoors.add(di);
            }
            super.bind(this.d_boundDoors);
        }

        public void save(MerlinData md, Collection<ICompElement> objs) {
            if (this.d_boundDoors == null) {
                return;
            }
            IFilteredCollection<EgressCorridor> corridors = theUtil.filter(objs, EgressCorridor.class);
            Undo.insertUndoEntry_propRestore(md, corridors, this.d_doorProp);
            assert (corridors.size() == this.d_boundDoors.size());
            int ix = 0;
            for (EgressCorridor corr : corridors) {
                corr.setProperty(this.d_doorProp, this.d_boundDoors.get(ix++));
            }
        }

        @Override
        public void release() {
            super.release();
            this.d_boundDoors = null;
        }
    }

    private static class CorridorExtraPnl2
    extends EditorPanel {
        private static final long serialVersionUID = 5678849257367198406L;

        public CorridorExtraPnl2() {
            HTMLBtn extraInfoBtn = new HTMLBtn(Intl.intl("Additional Info"));
            ViewMoreProp vmProp = new ViewMoreProp(extraInfoBtn);
            this.addConnection(vmProp);
            OnewayComboBox ocb = new OnewayComboBox();
            this.addConnection(new ComboPropConn<EgressDoorDir>(new OnewayProp(), ocb));
            GridBagHelper gb = new GridBagHelper(this);
            gb.rowSpace = 1;
            gb.addRow(Intl.intl("One-way:"), ocb, 0);
            gb.addRow(extraInfoBtn, 0);
        }

        private static class ViewMoreProp
        implements IPropConnection,
        ActionListener {
            private final Component d_parent;
            private Collection<ICompElement> d_objs;

            public ViewMoreProp(HTMLBtn btn) {
                this.d_parent = btn;
                btn.addActionListener(this);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                BoundsSect bounds = new BoundsSect();
                RoomInfoSect roomInfo = new RoomInfoSect();
                guiDialog dlg = new guiDialog(SwingUtilities.getWindowAncestor(this.d_parent), Intl.intl("Stair and Ramp Information"), 16);
                guiPanel mainPnl = dlg.getDialogPane();
                GridBagHelper gb = new GridBagHelper(mainPnl);
                gb.addFilledRow(new TitleSeparator(Intl.intl("Bounds")));
                gb.indent();
                bounds.addToLayout(gb);
                gb.unindent();
                gb.addFilledRow(new TitleSeparator(Intl.intl("Occupancy")));
                gb.indent();
                roomInfo.addToLayout(gb);
                gb.finalizeRows();
                bounds.bind(this.d_objs);
                roomInfo.bind(this.d_objs);
                dlg.setResizable(true);
                dlg.doModal();
            }

            @Override
            public void bind(Collection<ICompElement> objs) {
                this.d_objs = objs;
            }

            @Override
            public void release() {
                this.d_objs = null;
            }

            @Override
            public void commit() {
            }

            @Override
            public void update(Events events) {
            }
        }
    }

    private static class CorridorExtraPnl1
    extends EditorPanel {
        private static final long serialVersionUID = -1516979897630973821L;

        public CorridorExtraPnl1() {
            GridBagHelper gb = new GridBagHelper(this);
            gb.rowSpace = 1;
            SelectionEditorPanel.addTagCheckBox(this, gb, IEgressComp.OCC_TAGS, PredefTags.SAFE.name);
            SelectionEditorPanel.addSpeedModifier(this, gb);
            SelectionEditorPanel.addCapacityEditor(this, gb);
        }
    }

    private static class CorridorDoorAction
    implements IPropConnection,
    ActionListener {
        private final Component d_parent;
        private final String d_dlgTitle;
        private final Object d_doorProp;
        private Collection<ICompElement> d_objs;

        public CorridorDoorAction(Component parent, String dlgTitle, Object doorProp) {
            this.d_parent = parent;
            this.d_dlgTitle = dlgTitle;
            this.d_doorProp = doorProp;
        }

        @Override
        public void update(Events events) {
        }

        @Override
        public void bind(Collection<ICompElement> objs) {
            this.d_objs = objs;
        }

        @Override
        public void release() {
            this.d_objs = null;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.d_objs == null) {
                return;
            }
            final CorridorDoorPnl pnl = new CorridorDoorPnl(this.d_doorProp);
            pnl.bind(this.d_objs);
            guiDialog dlg = new guiDialog(SwingUtilities.getWindowAncestor(this.d_parent), this.d_dlgTitle, 9);
            guiPanel mainPanel = dlg.getDialogPane();
            mainPanel.setLayout(new BorderLayout());
            mainPanel.add(pnl);
            if (dlg.doModal() == 1) {
                AMerlinOp op = new AMerlinOp(){

                    @Override
                    public void run(MerlinApp app, MerlinData md) {
                        Undo.begin(Intl.intl("Edit Door"));
                        md.beginWrite();
                        try {
                            pnl.save(md, d_objs);
                        }
                        finally {
                            md.endWrite();
                            Undo.end(md);
                        }
                    }
                };
                SwingUtilities.invokeLater(() -> UIHook.run(UIHook.getComponent(e), "SelectionEditorPane.CorridorDoorAction.actionPerformed", op, 16));
            }
        }

        @Override
        public void commit() {
        }
    }

    private static class CorridorDoorWidthProp
    extends CompElementActions.DefProp<ICompElement, UnitDouble> {
        public CorridorDoorWidthProp() {
            super(EgressCorridor.WIDTH);
        }

        @Override
        protected void saveState(MerlinData md, Object prop, Collection<? extends ICompElement> objs, UnitDouble newVal) {
            List<ICompElement> modObjs = CompElementActions.flattenToLocallyDefined(prop, objs);
            Undo.insertUndoEntry_restore(md, theUtil.filter(modObjs, IRestorable.class));
        }
    }

    private static class CorridorSect
    extends EditorPanel {
        private static final long serialVersionUID = 4575635054810992752L;

        public CorridorSect() {
            MerlinUDF fldWidth = new MerlinUDF(6);
            UDPropConnection connWidth = new UDPropConnection(new CorridorDoorWidthProp(), fldWidth);
            this.addConnection(connWidth);
            CorridorDoorAction topDoorAction = new CorridorDoorAction(this, Intl.intl("Top Door Properties"), EgressCorridor.TOP_DOOR);
            HTMLBtn topDoorBtn = new HTMLBtn(Intl.intl("Edit"));
            topDoorBtn.addActionListener(topDoorAction);
            this.addConnection(topDoorAction);
            CorridorDoorAction bottomDoorAction = new CorridorDoorAction(this, Intl.intl("Bottom Door Properties"), EgressCorridor.BOTTOM_DOOR);
            HTMLBtn bottomDoorBtn = new HTMLBtn(Intl.intl("Edit"));
            bottomDoorBtn.addActionListener(bottomDoorAction);
            this.addConnection(bottomDoorAction);
            GridBagHelper gb = new GridBagHelper(this);
            gb.rowSpace = 1;
            gb.addRow(Intl.intl("Width:"), fldWidth);
            gb.addRow(Intl.intl("Top Door:"), topDoorBtn, 0);
            gb.addRow(Intl.intl("Bottom Door:"), bottomDoorBtn, 0);
        }
    }

    private static class CountSect<T>
    extends EditorPanel {
        private static final long serialVersionUID = 554407319421097453L;
        private final Class<T> d_type;
        private final guiIntField occCountFld;

        public CountSect(MerlinData md, String label, Class<T> type) {
            this.d_type = type;
            this.occCountFld = new guiIntField(0);
            this.occCountFld.setEditable(false);
            this.addConnection(new IntPropConn(new CompElementActions.IObjectProp<ICompElement, Integer>(){

                @Override
                public void set(MerlinData md, Collection<? extends ICompElement> objs, Integer newVal) {
                }

                @Override
                public Object get(MerlinData md, Collection<? extends ICompElement> objs) {
                    return this.getNumObjs(objs);
                }
            }, this.occCountFld));
            GridBagHelper gb = new GridBagHelper(this);
            gb.rowSpace = 3;
            gb.addRow(label);
            gb.addRow(this.occCountFld, 1.0);
        }

        public int getNumObjs(Collection<? extends ICompElement> objs) {
            return MerlinUtil.flatten(objs, this.d_type).size();
        }
    }

    private static class OccCountSect
    extends EditorPanel {
        private static final long serialVersionUID = 554407319421097453L;
        private final MerlinData d_md;
        private final guiIntField occCountFld;

        public OccCountSect(MerlinData md) {
            this.d_md = md;
            this.occCountFld = new guiIntField(0);
            this.occCountFld.setEditable(false);
            this.addConnection(new IntPropConn(new CompElementActions.IObjectProp<ICompElement, Integer>(){

                @Override
                public void set(MerlinData md, Collection<? extends ICompElement> objs, Integer newVal) {
                }

                @Override
                public Object get(MerlinData md, Collection<? extends ICompElement> objs) {
                    return this.numEgressAgents(objs);
                }
            }, this.occCountFld));
            GridBagHelper gb = new GridBagHelper(this);
            gb.rowSpace = 3;
            gb.addRow(Intl.intl("Occupant Count: "));
            gb.addRow(this.occCountFld, 1.0);
        }

        public int numEgressAgents(Collection<? extends ICompElement> iCompElements) {
            int result = 0;
            for (ICompElement iCompElement : iCompElements) {
                if (iCompElement instanceof EgressAgent) {
                    ++result;
                    continue;
                }
                if (iCompElement instanceof OccSourceObj) {
                    result += SelectionEditorPanel.countOccupants(this.d_md, (OccSourceObj)iCompElement);
                    continue;
                }
                if (!(iCompElement instanceof Composite)) continue;
                result += this.numEgressAgents(((Composite)iCompElement).getMembers());
            }
            return result;
        }
    }

    private static class GenerateModelSect
    extends EditorPanel {
        private static final long serialVersionUID = -4666497424727293639L;

        public GenerateModelSect(boolean global) {
            JButton btn = global ? new JButton(GenerateModelFromBIM.UI_HOOK_GLOBAL) : new JButton(GenerateModelFromBIM.UI_HOOK_CONTEXT);
            GridBagHelper gb = new GridBagHelper(this);
            gb.addRow(btn, 1.0, 0);
        }
    }

    private static class FloorSect
    extends EditorPanel {
        private static final long serialVersionUID = 5269600870831455532L;

        public FloorSect() {
            MerlinUDF workingZFld = new MerlinUDF(0);
            MerlinUDF zminFld = new MerlinUDF(0);
            zminFld.aliasValue(Floor.CURR_FLOOR, Intl.intl("CURR_FLOOR"), "");
            MerlinUDF zmaxFld = new MerlinUDF(0);
            zmaxFld.aliasValue(Floor.NEXT_FLOOR, Intl.intl("NEXT_FLOOR"), "");
            this.addConnection(new UDPropConnection(new CompElementActions.DefProp<ICompElement, UnitDouble>(Floor.WORKING_Z), workingZFld));
            this.addConnection(new UDPropConnection(new CompElementActions.DefProp<ICompElement, UnitDouble>(Floor.ZMIN_FILTER), zminFld));
            this.addConnection(new UDPropConnection(new CompElementActions.DefProp<ICompElement, UnitDouble>(Floor.ZMAX_FILTER), zmaxFld));
            GridBagHelper gb = new GridBagHelper(this);
            gb.rowSpace = 3;
            gb.addRow(Intl.intl("Working Z:"), workingZFld, 1.0, 0);
            gb.addRow(Intl.intl("Z Min Filter:"), zminFld, 1.0, 0);
            gb.addRow(Intl.intl("Z Max Filter:"), zmaxFld, 1.0, 0);
        }
    }

    private static class DoorWidthProp
    extends CompElementActions.DefProp<ICompElement, Double> {
        public DoorWidthProp(Object prop) {
            super(prop);
        }

        @Override
        protected void saveState(MerlinData md, Object prop, Collection<? extends ICompElement> objs, Double newVal) {
            List<ICompElement> modObjs = CompElementActions.flattenToLocallyDefined(prop, objs);
            Undo.insertUndoEntry_restore(md, theUtil.filter(modObjs, IRestorable.class));
        }
    }

    private static class DoorSect2
    extends EditorPanel {
        private static final long serialVersionUID = -4387473523708437562L;

        public DoorSect2() {
            CompactDistributedValPnl delayPnl = new CompactDistributedValPnl(Intl.intl("Wait Time"), 1);
            this.addConnection(new CurveConn<IDistributedVal<UnitDouble>>(EgressDoor.WAIT_TIME, delayPnl));
            guiPanel p = new guiPanel();
            GridBagHelper gb = new GridBagHelper(p);
            gb.rowSpace = 2;
            gb.addRow(Intl.intl("Wait Time:"), delayPnl);
            this.setLayout(new BorderLayout());
            this.add((Component)p, "Center");
        }
    }

    private static class DoorSect1
    extends EditorPanel {
        private static final long serialVersionUID = -7130843676944061083L;

        public DoorSect1() {
            MerlinUDF fldWid = new MerlinUDF(6);
            UDPropConnection connWid = new UDPropConnection(new DToUDProp<ICompElement>(SI.METER, new DoorWidthProp(EgressDoor.WIDTH)), fldWid);
            this.addConnection(connWid);
            guiPanel p = new guiPanel();
            GridBagHelper gb = new GridBagHelper(p);
            gb.rowSpace = 2;
            gb.addRow(Intl.intl("Width:"), fldWid, 0, 1.0);
            SelectionEditorPanel.addFlowrate(this, gb);
            SelectionEditorPanel.addConnectorState(this, gb);
            this.setLayout(new BorderLayout());
            this.add((Component)p, "Center");
        }
    }

    private static class MaterialConn
    extends ASinglePropConnection<MaterialBtn>
    implements IObserver {
        public MaterialConn(MaterialBtn btn) {
            super(new MaterialProp(), btn);
            btn.addObserver(this, true);
        }

        @Override
        public void update(IObservable source, Object arg) {
            this.onControlChanged();
        }

        @Override
        public void setProp(Object prop, Collection<? extends ICompElement> objs, MaterialBtn comp) {
            Material mat = (Material)comp.getMaterial();
            SelectionEditorPanel.setPropRecursive(Intl.intl("Set Material"), (CompElementActions.IObjectProp)prop, objs, mat);
        }

        @Override
        public void initFromProp(Object prop, Collection<? extends ICompElement> objs, MaterialBtn comp) {
            Object val = ((CompElementActions.IObjectProp)prop).get(MerlinApp.getApp().getData(), objs);
            if (val instanceof Material || val == null) {
                comp.setMaterial((Material)val);
            } else {
                comp.setMultiple();
            }
            comp.setModified(false);
        }
    }

    private static class ColorDefProp
    extends CompElementActions.DefProp<ICompElement, Boolean> {
        public ColorDefProp() {
            super(MerlinData.COLOR);
        }

        @Override
        protected Object get(MerlinData md, Object prop, ICompElement obj) {
            Object val = obj.getProperty(prop);
            if (val == null) {
                return false;
            }
            if (val instanceof Color) {
                return true;
            }
            return val;
        }

        @Override
        protected void set(MerlinData md, Object prop, ICompElement obj, Boolean newVal) {
            Color newColor = this.getNewColor(md, prop, obj, newVal);
            obj.setProperty(prop, newColor);
        }

        private Color getNewColor(MerlinData md, Object prop, ICompElement obj, Boolean newVal) {
            if (!newVal.booleanValue()) {
                return null;
            }
            return Color.WHITE;
        }
    }

    private static class ColorConn
    extends ASinglePropConnection<ColorButton>
    implements Observer {
        public ColorConn(ColorButton cb) {
            this(cb, MerlinData.COLOR);
        }

        public ColorConn(ColorButton cb, Object prop) {
            super(new CompElementActions.DefProp(prop), cb);
            cb.addObserver(this);
        }

        @Override
        public void update(Observable o, Object arg) {
            this.onControlChanged();
        }

        @Override
        public void initFromProp(Object prop, Collection<? extends ICompElement> objs, ColorButton comp) {
            Object val = ((CompElementActions.IObjectProp)prop).get(MerlinApp.getApp().getData(), objs);
            if (val == null) {
                comp.setColor(Color.WHITE);
            } else if (val instanceof Color) {
                comp.setColor((Color)val);
            } else {
                comp.setColor(null);
            }
            comp.setModified(false);
        }

        @Override
        public void setProp(Object prop, Collection<? extends ICompElement> objs, ColorButton comp) {
            Color color = comp.getColor();
            if (color != null) {
                SelectionEditorPanel.setPropRecursive(Intl.intl("Set Color"), (CompElementActions.IObjectProp)prop, objs, color);
            }
        }
    }

    private static class ColorComp
    extends JPanel
    implements Modifiable {
        private static final long serialVersionUID = 6756524331734409410L;
        public final guiMultiStateCheckBox checkBox;
        public final ColorButton btn;

        public ColorComp(guiMultiStateCheckBox colorCB, ColorButton cb) {
            this.checkBox = colorCB;
            this.btn = cb;
        }

        @Override
        public boolean isModified() {
            return this.checkBox != null && this.checkBox.isModified() || this.btn.isModified();
        }

        @Override
        public void setModified(boolean modified) {
            if (this.checkBox != null) {
                this.checkBox.setModified(modified);
            }
            this.btn.setModified(modified);
        }
    }

    private static class OpacityConn
    extends UDPropConnection {
        public OpacityConn(guiUnitDoubleField fld) {
            super(new OpacityUDProp(), fld);
            fld.setEmptyAllowed(true);
            fld.setValueRange(UnitDoubleVR.between(0.0, 100.0, NonSI.PERCENT, true, true));
            fld.setColumns(5);
        }

        private static class OpacityUDProp
        implements CompElementActions.IObjectProp<ICompElement, UnitDouble> {
            private final CompElementActions.IObjectProp<ICompElement, IOpacity> d_opacity = new CompElementActions.DefProp<ICompElement, IOpacity>(MerlinData.OPACITY);

            private OpacityUDProp() {
            }

            @Override
            public Object get(MerlinData md, Collection<? extends ICompElement> objs) {
                Object val = this.d_opacity.get(md, objs);
                if (!(val instanceof IOpacity)) {
                    return val;
                }
                Double cval = ((IOpacity)val).getValue();
                return new UnitDouble(Math.round(cval * 100.0), NonSI.PERCENT);
            }

            @Override
            public void set(MerlinData md, Collection<? extends ICompElement> objs, UnitDouble newVal) {
                UnitDouble udval = newVal;
                Opacity opacityVal = new Opacity((float)(udval.getValue(NonSI.PERCENT) * 0.01));
                this.d_opacity.set(md, objs, opacityVal);
            }
        }
    }

    private static class PropBuilder {
        private final List<EditorPanel> activePanels;
        private GridBagHelper propgb;

        public PropBuilder(List<EditorPanel> activePanels) {
            this.activePanels = activePanels;
            this.propgb = SelectionEditorPanel.newHelper(new EditorPanel());
        }

        public EditorPanel getPanel() {
            return (EditorPanel)this.propgb.getPanel();
        }

        public void addConnection(IPropConnection conn) {
            this.getPanel().addConnection(conn);
        }

        public GridBagHelper prepareNewRowGroup(int rowsToAdd) {
            if (this.propgb.getCurrentRow() + rowsToAdd > 3) {
                this.activePanels.add((EditorPanel)this.propgb.getPanel());
                this.propgb = SelectionEditorPanel.newHelper(new EditorPanel());
            }
            return this.propgb;
        }

        public void finalizePropPnl() {
            if (this.propgb.getCurrentRow() > 0) {
                this.activePanels.add((EditorPanel)this.propgb.getPanel());
            }
        }
    }
}

