/*
 * Decompiled with CFR 0.152.
 */
package merlin.mv.gui;

import java.util.Observable;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import javax.swing.JButton;
import javax.swing.JSeparator;
import javax.vecmath.Vector3d;
import merlin.Intl;
import merlin.builders.AttractorBuilder;
import merlin.data.MerlinData;
import merlin.data.ObjsFilter;
import merlin.data.egress.geom.IEgressOccupiable;
import merlin.data.egress.scripting.Behavior;
import merlin.data.egress.scripting.attractors.Attractor;
import merlin.data.egress.scripting.attractors.IAttractorTime;
import merlin.geom.Geometry;
import merlin.gui.APropEditPanel;
import merlin.gui.AttractorBehaviorChooser;
import merlin.gui.IPropEditCommand;
import merlin.gui.MerlinComboBox;
import merlin.gui.MerlinUDF;
import merlin.gui.RoomChooser;
import merlin.gui.guiUtil;
import merlin.gui.stat.CompactDistributedValPnl;
import merlin.gui.value.UDVarEditor;
import merlin.gui.value.VariantButton;
import merlin.mv.gui.RoomLocPanel;
import merlin.unitsystem.UnitSystem;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiIntField;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.value.IValEditor;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitDoubleVR;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.DoubleVR;
import thunderheadeng.util.Pair;
import thunderheadeng.util.stat.IDistributedVal;

public class NewAttractorPanel
extends APropEditPanel<AttractorBuilder> {
    private static final long serialVersionUID = 1L;
    private final guiPanel d_locPnl;
    private final JSeparator d_locSep;
    private final guiIntField d_rankFld;
    private final MerlinComboBox<Behavior> d_behaviorsCB;
    private final guiCheckBox d_requiresCompletionCB;
    private final guiLabel d_waitTimeLbl;
    private final CompactDistributedValPnl d_waitTimeFld;
    private final guiLabel d_waitRadiusLbl;
    private final MerlinUDF d_waitRadiusFld;
    private final JSeparator d_waitSep;
    private final IValEditor<ObjsFilter<String>> d_allowedOccTagsEd;
    private final IValEditor<IAttractorTime> d_considerationTimeFld;
    private final guiCheckBox d_considerationPastAwarenessCB;
    private final guiComboBox<Attractor.Awareness> d_awarenessCB;
    private final guiLabel d_radiusLbl;
    private final MerlinUDF d_radiusFld;
    private final guiLabel d_roomsLbl;
    private final RoomChooser d_roomsChooser;
    private final VariantButton<UnitDouble> d_influenceFld;
    private final guiComboBox<Attractor.InfluenceFrom> d_influenceFromCB;
    private final guiLabel d_influenceFromLbl;
    private final guiCheckBox d_ignoreOccSusc;
    private boolean d_pauseUpdateTo;

    public NewAttractorPanel(MerlinData md) {
        super(Attractor.RANK, Attractor.INFLUENCE_RADIUS, Attractor.BEHAVIOR, Attractor.WAIT_TIME, Attractor.WAIT_RADIUS, Attractor.ATTR_INFLUENCE, Attractor.AWARENESS, Attractor.ATTR_INFLUENCE_FROM, Attractor.REMEMBER_OUTSIDE_AWARENESS, Attractor.OCC_REACT_TIME, Attractor.REQUIRES_COMPLETION, Attractor.IGNORE_OCC_SUSC, Attractor.OCC_TAG_FILTER);
        BiFunction<String, String, guiLabel> lbl = (desc, tt) -> guiUtil.lbl(desc, tt);
        this.d_rankFld = this.initValueField(new guiIntField(), new IPropEditCommand[0]);
        this.d_behaviorsCB = this.initComboBox(new AttractorBehaviorChooser(md));
        this.d_requiresCompletionCB = this.initButton(new guiCheckBox(Intl.intl("Resume if interrupted")), new IPropEditCommand[0]);
        this.d_requiresCompletionCB.setToolTipText("<html>" + Intl.intl("If the selected trigger is interrupted by another higher rank trigger with a <br><i>Resume Prior Behavior</i> action, this flag determines what happens when the <br>selected trigger's behavior is resumed: <br>If <b>checked</b>, the selected trigger's behavior resumes and is completed normally.<br>If <b>unchecked</b>, the remainder of the selected trigger's behavior is skipped, <br>replaced immediately with a <i>Resume Prior Behavior</i> action."));
        this.d_waitTimeFld = new CompactDistributedValPnl(Intl.intl("Wait Time"), 1, UnitDoubleVR.above(0.0, SI.SECOND, true));
        this.d_waitTimeLbl = lbl.apply(Intl.intl("Wait Time:"), Intl.intl("The amount of time to wait at the trigger."));
        this.d_waitRadiusFld = this.initValueField(new MerlinUDF(0, DoubleVR.above(0.0, false)), new IPropEditCommand[0]);
        this.d_waitRadiusFld.setColumns(8);
        this.d_waitRadiusLbl = guiUtil.lbl(Intl.intl("Wait Area Radius:"), Intl.intl("Defines the radius of the wait area for the trigger."));
        this.d_allowedOccTagsEd = Attractor.OCC_TAG_FILTER.newValueEditor(md, false).get();
        this.d_considerationTimeFld = IAttractorTime.newEditor(md, true);
        this.d_considerationPastAwarenessCB = this.initButton(new guiCheckBox(Intl.intl("Remain aware"), false), new IPropEditCommand[0]);
        this.d_considerationPastAwarenessCB.setToolTipText("<html>" + Intl.intl("Allows the occupant to consider the trigger if they become aware of it and then leave<br>the awareness region before the <b>Decision Time</b>.<br>If <b>checked</b>, the occupant will consider the trigger when it's time, even if they're no longer in the awareness region.<br>If <b>unchecked</b>, the occupant ignores the trigger if they are no longer in the awareness region."));
        this.d_awarenessCB = this.initComboBox(guiUtil.newCombo(awareness -> new Pair<String, String>(guiUtil.encodeToHtmlLabel(awareness.name), guiUtil.encodeToHtmlLabel(awareness.desc)), Attractor.Awareness.values()));
        this.d_radiusLbl = lbl.apply(Intl.intl("Awareness Radius"), Intl.intl("The maximum distance at which an occupant would be aware of this trigger."));
        this.d_radiusFld = this.initValueField(new MerlinUDF(0, DoubleVR.above(0.0, true)), new IPropEditCommand[0]);
        this.d_radiusFld.setColumns(8);
        this.d_roomsLbl = lbl.apply(Intl.intl("Rooms:"), Intl.intl("The rooms in which an occupant is aware of the trigger."));
        this.d_roomsChooser = new RoomChooser(md);
        this.d_influenceFld = new VariantButton<UnitDouble>(Intl.intl("Influence"), new UDVarEditor(ValueFields.udFld(100.0, DoubleVR.above(0.0, true), NonSI.PERCENT, UnitSystem.getType(10, true))));
        this.d_influenceFromCB = this.initComboBox(guiUtil.newCombo(influenceFrom -> new Pair<String, String>(influenceFrom.name, influenceFrom.desc), Attractor.InfluenceFrom.values()));
        this.d_influenceFromLbl = lbl.apply(Intl.intl("Influence Timeline:"), Intl.intl("The timeline on which the trigger's influence times are based."));
        this.d_ignoreOccSusc = this.initButton(new guiCheckBox(Attractor.IGNORE_OCC_SUSC.name), new IPropEditCommand[0]);
        this.d_ignoreOccSusc.setToolTipText(guiUtil.encodeToHtmlLabel(Attractor.IGNORE_OCC_SUSC.desc));
        this.d_locPnl = new guiPanel();
        GridBagHelper gb = new GridBagHelper(this.d_locPnl);
        gb.addRow(Intl.intl("Location:"), new RoomLocPanel<AttractorBuilder>((props, room, normal, loc) -> props.setLocation((IEgressOccupiable)room, (Vector3d)normal, loc.getPoint3dValue(Geometry.LENGTH_UNIT)), props -> new UnitPoint3D(props.get(Attractor.LOCATION), Geometry.LENGTH_UNIT), Attractor.LOCATION));
        guiPanel behaviorPnl = new guiPanel();
        gb = new GridBagHelper(behaviorPnl);
        gb.rowSpace = 1;
        gb.addRow(lbl.apply(Intl.intl("Rank:"), "<html>" + Intl.intl("Used to compare with other triggers if an occupant has multiple choices available<br>or has already started a trigger. Triggers with higher ranks are given priority<br>over those with lower and can interrupt a lower-rank trigger's behavior.")), this.d_rankFld, 1.0);
        guiLabel behaviorLbl = lbl.apply(Intl.intl("Behavior:"), Intl.intl("The behavior that occupants will use when influenced by this trigger."));
        gb.addRow(behaviorLbl, this.d_behaviorsCB, 1.0);
        gb.addRow(this.d_requiresCompletionCB, 0);
        guiPanel waitPnl = new guiPanel();
        gb = new GridBagHelper(waitPnl);
        gb.rowSpace = 1;
        gb.addRow(this.d_waitRadiusLbl, this.d_waitRadiusFld, 1.0);
        gb.addRow(this.d_waitTimeLbl, this.d_waitTimeFld, 1.0);
        guiPanel considerationPnl = new guiPanel();
        gb = new GridBagHelper(considerationPnl);
        gb.rowSpace = 1;
        gb.add(guiUtil.lbl(Attractor.OCC_TAG_FILTER.name, Attractor.OCC_TAG_FILTER.desc));
        this.d_allowedOccTagsEd.add(gb);
        gb.nextRow();
        gb.add(guiUtil.lbl(Intl.intl("Decision Time:"), Intl.intl("Specifies the time at which an occupant considers the trigger after becoming aware of it.")));
        this.d_considerationTimeFld.add(gb);
        gb.nextRow();
        gb.addRow(this.d_considerationPastAwarenessCB, 0);
        guiPanel awarenessPnl = new guiPanel();
        gb = new GridBagHelper(awarenessPnl);
        gb.rowSpace = 1;
        gb.addRow(lbl.apply(Intl.intl("Awareness:"), Intl.intl("Defines how an occupant becomes aware of the trigger.")), this.d_awarenessCB, 1.0);
        gb.addRow(this.d_radiusLbl, this.d_radiusFld, 1.0);
        gb.addRow(this.d_roomsLbl, this.d_roomsChooser, 1.0);
        guiPanel influencePnl = new guiPanel();
        gb = new GridBagHelper(influencePnl);
        gb.rowSpace = 1;
        gb.addRow(lbl.apply(Intl.intl("Influence:"), "<html>" + Intl.intl("The influence of this trigger. This is multiplied by an<br>occupant's susceptibility to triggers to create a probability<br>that this trigger will influence the occupant.")), this.d_influenceFld, 1.0);
        gb.addRow(this.d_influenceFromLbl, this.d_influenceFromCB);
        gb.addRow(this.d_ignoreOccSusc, 0);
        this.addSection(this.d_locPnl);
        this.d_locSep = this.addSeparator();
        this.addSection(behaviorPnl);
        this.addSeparator();
        this.addSection(waitPnl);
        this.d_waitSep = this.addSeparator();
        this.addSection(considerationPnl);
        this.addSeparator();
        this.addSection(awarenessPnl);
        this.addSeparator();
        this.addSection(influencePnl);
        this.addSeparator();
        this.addSection(new CreatePanel());
        Consumer<IValEditor> addValEditorListener = ed -> ed.addValueListener(e -> this.getUpdateToCommand().updateProp(ed.getComponent(), true));
        addValEditorListener.accept(this.d_waitTimeFld);
        addValEditorListener.accept(this.d_considerationTimeFld);
        addValEditorListener.accept(this.d_allowedOccTagsEd);
        this.d_influenceFld.addPropertyChangeListener("value", e -> this.getUpdateToCommand().updateProp(this.d_influenceFld, true));
        this.d_roomsChooser.addPropertyChangeListener("edit", e -> {
            if (((Boolean)e.getNewValue()).booleanValue()) {
                this.componentModified(this.d_roomsChooser, true);
            }
        });
    }

    @Override
    protected void updateFromProps(AttractorBuilder props) {
        this.d_pauseUpdateTo = true;
        boolean locVis = Attractor.requiresLocation(props);
        this.d_locPnl.setVisible(locVis);
        this.d_locSep.setVisible(locVis);
        this.d_rankFld.setValue(props.get(Attractor.RANK));
        this.d_behaviorsCB.setSelectedItem(props.get(Attractor.BEHAVIOR));
        this.d_requiresCompletionCB.setSelected(props.get(Attractor.REQUIRES_COMPLETION));
        boolean waitTimeVis = props.get(Attractor.BEHAVIOR) == Attractor.WAIT_AT_ATTRACTOR_BEHAVIOR;
        this.d_waitRadiusLbl.setVisible(waitTimeVis);
        this.d_waitRadiusFld.setVisible(waitTimeVis);
        this.d_waitRadiusFld.setValue(props.get(Attractor.WAIT_RADIUS));
        this.d_waitTimeLbl.setVisible(waitTimeVis);
        this.d_waitTimeFld.setVisible(waitTimeVis);
        this.d_waitTimeFld.setValue(props.get(Attractor.WAIT_TIME));
        this.d_waitSep.setVisible(waitTimeVis);
        this.d_allowedOccTagsEd.setValue(props.get(Attractor.OCC_TAG_FILTER));
        this.d_considerationTimeFld.setValue(props.get(Attractor.OCC_REACT_TIME));
        this.d_considerationPastAwarenessCB.setSelected(props.get(Attractor.REMEMBER_OUTSIDE_AWARENESS));
        this.d_awarenessCB.setSelectedItem((Object)props.get(Attractor.AWARENESS));
        boolean radiusVis = props.get(Attractor.AWARENESS) == Attractor.Awareness.LINE_OF_SIGHT;
        this.d_radiusLbl.setVisible(radiusVis);
        this.d_radiusFld.setVisible(radiusVis);
        this.d_radiusFld.setValue(props.get(Attractor.INFLUENCE_RADIUS));
        boolean roomsVis = props.get(Attractor.AWARENESS) == Attractor.Awareness.ROOMS;
        this.d_roomsChooser.setObjs(props.get(Attractor.ROOMS));
        this.d_roomsLbl.setVisible(roomsVis);
        this.d_roomsChooser.setVisible(roomsVis);
        this.d_influenceFld.setValue(props.get(Attractor.ATTR_INFLUENCE));
        this.d_influenceFromCB.setSelectedItem((Object)props.get(Attractor.ATTR_INFLUENCE_FROM));
        this.d_ignoreOccSusc.setSelected(props.get(Attractor.IGNORE_OCC_SUSC));
        this.d_pauseUpdateTo = false;
    }

    @Override
    protected void updateToProps(AttractorBuilder props) {
        if (!this.d_pauseUpdateTo) {
            props.set(Attractor.RANK, (Integer)this.d_rankFld.getValue());
            props.set(Attractor.BEHAVIOR, (Behavior)this.d_behaviorsCB.getSelectedItem());
            props.set(Attractor.REQUIRES_COMPLETION, this.d_requiresCompletionCB.isSelected());
            props.set(Attractor.WAIT_RADIUS, (UnitDouble)this.d_waitRadiusFld.getValue());
            props.set(Attractor.WAIT_TIME, (IDistributedVal)this.d_waitTimeFld.getValue());
            props.set(Attractor.OCC_TAG_FILTER, this.d_allowedOccTagsEd.getValue());
            props.set(Attractor.OCC_REACT_TIME, this.d_considerationTimeFld.getValue());
            props.set(Attractor.REMEMBER_OUTSIDE_AWARENESS, this.d_considerationPastAwarenessCB.isSelected());
            props.set(Attractor.AWARENESS, this.d_awarenessCB.getSelectedItem());
            props.set(Attractor.INFLUENCE_RADIUS, (UnitDouble)this.d_radiusFld.getValue());
            props.set(Attractor.ROOMS, this.d_roomsChooser.getObjs());
            props.set(Attractor.ATTR_INFLUENCE, this.d_influenceFld.getValue());
            props.set(Attractor.ATTR_INFLUENCE_FROM, this.d_influenceFromCB.getSelectedItem());
            props.set(Attractor.IGNORE_OCC_SUSC, this.d_ignoreOccSusc.isSelected());
        }
    }

    private static class CreatePanel
    extends APropEditPanel<AttractorBuilder> {
        private static final long serialVersionUID = 1L;
        private final JButton d_createBtn = this.initButton(new JButton(Intl.intl("Create")), (c, hardValidate) -> {
            if (!this.validateData(hardValidate, hardValidate)) {
                return;
            }
            ((AttractorBuilder)this.props()).create(c);
        });

        public CreatePanel() {
            super(new Object[0]);
            this.add(this.d_createBtn);
        }

        @Override
        public void update(Observable o, Object arg) {
            this.d_createBtn.setEnabled(((AttractorBuilder)this.props()).isValid());
        }
    }
}

