/*
 * Decompiled with CFR 0.152.
 */
package merlin.mv.displays;

import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import merlin.data.egress.agents.EgressAgent;
import merlin.mv.displays.AAgentDisplay;
import merlin.mv.displays.AgentDisplay;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.elem.IPrimElements;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.io.nativexfer.INativeObject;
import thunderheadeng.io.nativexfer.Native;
import thunderheadeng.io.nativexfer.NativeArrayInfo;
import thunderheadeng.io.nativexfer.NativeManager;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.nativebuffered.Camera;
import thunderheadeng.scene3d.nativebuffered.IRenderable;
import thunderheadeng.scene3d.nativebuffered.Object3D;
import thunderheadeng.scene3d.nativebuffered.PrimTransformAnim;
import thunderheadeng.scene3d.nativebuffered.nb3dUtil;
import thunderheadeng.scene3d.picking.CancelObjectPicking;
import thunderheadeng.scene3d.picking.GeomType;
import thunderheadeng.scene3d.picking.IBoxCollector;
import thunderheadeng.scene3d.picking.IIsectCollector;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.scene3d.picking.IPickable;
import thunderheadeng.util.Pair;

public class AgentRenderer
extends Object3D
implements IRenderable,
IPickable {
    private static final long serialVersionUID = -408220214156251269L;
    public static final int CHANGE_GENERAL = 1;
    public static final int CHANGE_VISIBILITY = 2;
    public static final int ET_MD5_GENERIC = 0;
    public static final int ET_MD5_CASUAL = 1;
    public static final int ET_SIMPLE_DISKS = 2;
    public static final int ET_SIMPLE_SPHERES = 3;
    public static final int ET_SIMPLE_CYL = 4;
    public static final int AGENTS_COLOR_BY_DEFAULT = 0;
    public static final int AGENTS_COLOR_BY_GROUP = 1;
    public static final int AGENTS_COLOR_BY_GROUP_TEMPLATE = 2;
    public static final int AGENTS_COLOR_BY_BEHAVIOR = 3;
    public static final int AGENTS_COLOR_BY_PROFILE = 4;
    public static final int AGENTS_COLOR_BY_OCC_COLOR = 9;
    private Supplier<Camera> d_getCamera;

    public AgentRenderer(Supplier<Camera> getCamera) {
        this.d_getCamera = getCamera;
    }

    @Override
    public Class<?> resolveNativeClass() {
        return AgentRenderer.class;
    }

    private void exec(Methods method, Object ... args) {
        Native.manager.execMethod(AgentRenderer.class, (INativeObject)this, method.ordinal(), args);
    }

    private <T> T exec(Methods method, Function<NativeManager, T> get, Object ... args) {
        return Native.manager.exec(AgentRenderer.class, (INativeObject)this, method.ordinal(), get, args);
    }

    public AABox getBoundingBox(Collection<AgentDisplay> agents) {
        if (agents.isEmpty()) {
            return new AABox();
        }
        AgentDisplay[] arr = agents.toArray(new AgentDisplay[agents.size()]);
        return this.exec(Methods.getAgentBoundingBox, (NativeManager m) -> new AABox(m.readFloat(), m.readFloat(), m.readFloat(), m.readFloat(), m.readFloat(), m.readFloat()), arr.length, arr);
    }

    public void addDisplays(Collection<? extends AAgentDisplay> disps) {
        Object[] adisps = disps.toArray(new Object[disps.size()]);
        this.exec(Methods.addAgents, disps.size(), adisps);
    }

    public void removeDisplays(Collection<? extends AAgentDisplay> disps) {
        Object[] adisps = disps.toArray(new Object[disps.size()]);
        this.exec(Methods.removeAgents, disps.size(), adisps);
    }

    public void agentsUpdated(Collection<? extends AAgentDisplay> disps, int changes) {
        Object[] adisps = disps.toArray(new Object[disps.size()]);
        this.exec(Methods.agentsUpdated, changes, adisps.length, adisps);
    }

    public void updateAgentSelection(Collection<? extends AAgentDisplay> disps, boolean[] selection) {
        assert (disps.size() == selection.length);
        Object[] adisps = disps.toArray(new Object[disps.size()]);
        this.exec(Methods.updateAgentSelection, adisps.length, adisps, selection.length, selection);
    }

    public void updateAgentXformAnims(Collection<? extends AAgentDisplay> disps, PrimTransformAnim[] anims) {
        assert (disps.size() == anims.length);
        Object[] adisps = disps.toArray(new Object[disps.size()]);
        this.exec(Methods.updateAgentXformAnims, adisps.length, adisps, anims.length, anims);
    }

    public void updateAnims() {
        this.exec(Methods.updateAnims, new Object[0]);
    }

    public void setAgentType(int type) {
        this.exec(Methods.setAgentType, type);
    }

    public void setAgentColorBy(int type) {
        this.exec(Methods.setAgentColorBy, type);
    }

    public void forceImmediate(boolean force) {
        this.exec(Methods.forceImmediateMode, force);
    }

    public void enableHardwareSkinning(boolean enableVP10, boolean enableGLSL140) {
        this.exec(Methods.enableHardwareSkinning, enableVP10, enableGLSL140);
    }

    public void setMaxVBSize(long maxSize) {
        this.exec(Methods.setVBSize, maxSize);
    }

    @Override
    public void getAll(Consumer<Object> result, IIsectFilter filter) {
    }

    @Override
    public void pickBox(IBoxCollector result, IIsectFilter filter, ConvexHull box) {
        if (!filter.acceptPickObjType(EgressAgent.class)) {
            return;
        }
        List<AgentDisplay> picks = this.pickAgents(box);
        for (AgentDisplay disp : picks) {
            if (!filter.acceptGeomType(disp.getAgent(), GeomType.FACE) || !filter.acceptPickObject(disp.getAgent())) continue;
            try {
                result.addFace(disp.getAgent(), -1, () -> new Pair<Point3d, Vector3d>(GeomConstants.PNT3D_ORIGIN, GeomConstants.VEC3D_ZPOS), IPrimElements.NONE, IPrimProps.DEF);
            }
            catch (CancelObjectPicking cancelObjectPicking) {}
        }
    }

    @Override
    public void pickPoints(IIsectCollector isects, IIsectFilter filter, Point3d rayBegin, Vector3d rayDirN, double maxDist, ITest<AABox> tester) {
        if (!filter.acceptPickObjType(EgressAgent.class)) {
            return;
        }
        Point3d origin = rayBegin;
        Vector3d dir = rayDirN;
        double length = maxDist;
        Pair<AgentDisplay, Double> pick = this.pickAgent(origin, dir, length);
        if (pick != null && filter.acceptGeomType(((AgentDisplay)pick.v1).getAgent(), GeomType.FACE) && filter.acceptPickObject(((AgentDisplay)pick.v1).getAgent())) {
            Point3d pickPoint = Util3D.add(rayBegin, (Tuple3d)Util3D.scale(rayDirN, (double)((Double)pick.v2)));
            isects.addFace(((AgentDisplay)pick.v1).getAgent(), pickPoint, -1, null, () -> GeomConstants.VEC3D_ZPOS, IPrimElements.NONE, IPrimProps.DEF);
        }
    }

    private Pair<AgentDisplay, Double> pickAgent(Point3d origin, Vector3d dir, double length) {
        Pair result = this.exec(Methods.pickAgent, (NativeManager m) -> new Pair<AAgentDisplay, Double>((AAgentDisplay)m.read(), m.readDouble()), origin, dir, length, this.d_getCamera.get());
        if (!(result.v1 instanceof AgentDisplay)) {
            return null;
        }
        return new Pair<AgentDisplay, Double>((AgentDisplay)result.v1, (Double)result.v2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<AgentDisplay> pickAgents(ConvexHull box) {
        Native.manager.lockWriteBuffer();
        try {
            double[] coords = new double[4 * box.getPlanes().length];
            int ix = 0;
            for (Plane3d plane : box.getPlanes()) {
                coords[ix++] = plane.x;
                coords[ix++] = plane.y;
                coords[ix++] = plane.z;
                coords[ix++] = plane.w;
            }
            NativeArrayInfo result = this.pickAgentsBox(this.getKey(), this.d_getCamera.get().getKey(), coords);
            List<Object> objs = result.toList(Native.manager);
            List<AgentDisplay> list = objs.stream().filter(o -> o instanceof AgentDisplay).map(o -> (AgentDisplay)o).collect(Collectors.toList());
            return list;
        }
        finally {
            Native.manager.unlockWriteBuffer();
        }
    }

    private native NativeArrayInfo pickAgentsBox(int var1, int var2, double[] var3);

    static {
        nb3dUtil.registerTypes();
    }

    private static enum Methods {
        addAgents,
        removeAgents,
        agentsUpdated,
        updateAgentSelection,
        updateAgentXformAnims,
        setAgentType,
        setAgentColorBy,
        forceImmediateMode,
        enableHardwareSkinning,
        setVBSize,
        pickAgent,
        getAgentBoundingBox,
        updateAnims;

    }
}

