/*
 * Decompiled with CFR 0.152.
 */
package merlin.legacy.v0160.data.egress.elevators;

import common.data.ElevatorType;
import common.data.IElevatorTimingModel;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import merlin.data.GeomComposite;
import merlin.data.egress.IEgressObj;
import merlin.data.egress.elevators.Elevator;
import merlin.data.egress.elevators.ElevatorRoom;
import merlin.legacy.v0160.data.egress.elevators.ITimingModel;
import org.jscience.physics.units.SI;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.theUtil;

public class Elevator
extends GeomComposite<ElevatorRoom>
implements Serializable {
    static final long serialVersionUID = 2273482934324398172L;
    private Map<ElevatorRoom, LevelData> d_roomLevelData;
    private ElevatorRoom d_dischargeRoom;
    private List<ElevatorRoom> d_levelPriority;
    private UnitDouble d_openDelay;
    private UnitDouble d_closeDelay;
    private UnitDouble d_nominalLoad;
    private boolean d_doubleDeck;
    private UnitDouble d_callDistance;
    private ElevatorRoom d_initRoom;
    private ElevatorType d_type;

    private Elevator(String name) {
        super(name);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.d_type = ElevatorType.EVAC;
        in.defaultReadObject();
        for (IEgressObj obj : this.getDeepMembers(IEgressObj.class)) {
            obj.readTopology(in);
        }
    }

    private Object readResolve() throws ObjectStreamException {
        merlin.data.egress.elevators.Elevator elev = new merlin.data.egress.elevators.Elevator(this.getName(), this.d_type);
        elev.addAll(this.getMembers());
        elev.setCallDistance(this.d_callDistance);
        elev.setDischargeRoom(this.d_dischargeRoom);
        elev.setDoubleDeck(this.d_doubleDeck);
        elev.setLevelPriority(this.d_levelPriority);
        elev.setDoorDelays(this.d_openDelay, this.d_closeDelay);
        elev.setInitRoom(this.d_initRoom);
        elev.setNominalLoad(this.d_nominalLoad);
        elev.setResultsId(this.getResultsId());
        elev.setVisible(this.isVisible());
        elev.setTimingModel(!this.d_roomLevelData.isEmpty() ? this.d_roomLevelData.values().iterator().next().timingModel.fromLegacy() : IElevatorTimingModel.DEF_MODEL);
        Map<ElevatorRoom, LevelData> levelDataMap = this.d_roomLevelData;
        for (ElevatorRoom room : levelDataMap.keySet()) {
            LevelData oldLevelData = levelDataMap.get(room);
            elev.setLevelData(room, new Elevator.LevelData(oldLevelData.openTime, oldLevelData.closeTime, oldLevelData.delay));
        }
        return elev;
    }

    public static class LevelData
    implements Serializable {
        static final long serialVersionUID = 525324190123487L;
        public final UnitDouble openTime;
        public final UnitDouble closeTime;
        public final UnitDouble pickupTime;
        public final UnitDouble dischargeTime;
        public final UnitDouble delay;
        public final ITimingModel timingModel;

        public LevelData(UnitDouble openTime, UnitDouble closeTime, UnitDouble pickupTime, UnitDouble dischargeTime, UnitDouble delay, ITimingModel timingModel) {
            this.openTime = openTime;
            this.closeTime = closeTime;
            this.pickupTime = pickupTime;
            this.dischargeTime = dischargeTime;
            this.delay = delay;
            this.timingModel = timingModel;
        }

        private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
            ois.defaultReadObject();
            if (this.openTime == null) {
                try {
                    theUtil.assignFinalField(this, LevelData.class, "openTime", new UnitDouble(3.5, SI.SECOND));
                    theUtil.assignFinalField(this, LevelData.class, "closeTime", new UnitDouble(3.5, SI.SECOND));
                    UnitDouble openClose = this.openTime.add(this.closeTime);
                    UnitDouble newPickup = openClose.compareTo(this.pickupTime) <= 0 ? this.pickupTime.sub(openClose) : new UnitDouble(0.0, SI.SECOND);
                    UnitDouble newDischarge = openClose.compareTo(this.dischargeTime) <= 0 ? this.dischargeTime.sub(openClose) : new UnitDouble(0.0, SI.SECOND);
                    theUtil.assignFinalField(this, LevelData.class, "pickupTime", newPickup);
                    theUtil.assignFinalField(this, LevelData.class, "dischargeTime", newDischarge);
                    theUtil.assignFinalField(this, LevelData.class, "timingModel", null);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

