/*
 * Decompiled with CFR 0.152.
 */
package merlin.legacy.v0025.data.egress.agents;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.vecmath.Point3f;
import merlin.Intl;
import merlin.data.egress.agents.OccProfile;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.stat.ConstantCurve;
import thunderheadeng.util.stat.ICurve;
import thunderheadeng.util.stat.IUrn;
import thunderheadeng.util.stat.Urn;

public class OccProfile
implements Serializable {
    static final long serialVersionUID = 1L;
    public static final OccProfile.Prop<String> PROP_NAME = OccProfile.newProp("OccProfile.NAME", 0L, "", false, Intl.intl("Name"), "");
    public static final OccProfile.Prop<String> PROP_DESC = OccProfile.newProp("OccProfile.DESC", 0L, "", false, Intl.intl("Description"), "");
    public static final OccProfile.Prop<ICurve> PROP_MAXVEL = OccProfile.newProp("OccProfile.MAXVEL", 160705858904975L, OccProfile.cc(1.19, SI.METER.divide(SI.SECOND)), false, Intl.intl("Speed"), "");
    public static final OccProfile.Prop<ICurve> PROP_DIAMETER = OccProfile.newProp("OccProfile.DIAMETER", 70367L, OccProfile.cc(0.4558, SI.METER), true, Intl.intl("Shoulder Width"), "");
    public static final OccProfile.Prop<Point3f> PROP_COLOR = OccProfile.newProp("OccProfile.COLOR", 0L, new Point3f(0.4f, 0.4f, 1.0f), true, Intl.intl("Color"), "");
    public static final OccProfile.Prop<Urn<String>> PROP_OCCMODEL = OccProfile.newProp("OccProfile.OCCMODEL", 59846346733L, new Urn<String>("BMan0001", "BMan0002", "BMan0003", "BWom0001", "BWom0002", "CMan0001", "CMan0002", "CMan0003", "CMan0012", "CWom0001", "CWom0018", "CWom0019", "CWom0001"), true, Intl.intl("3D Model"), "");
    public static final OccProfile.Prop<ICurve> PROP_INI_DELAY = OccProfile.newProp("OccProfile.DELAY", 275670542901161L, OccProfile.cc(0.0, SI.SECOND), true, Intl.intl("Initial Delay"), "");
    public static final List<OccProfile.Prop<?>> ALL_LEG_PROPS = Arrays.asList(PROP_NAME, PROP_DESC, PROP_COLOR, PROP_OCCMODEL, PROP_DIAMETER, PROP_MAXVEL, PROP_INI_DELAY);
    private Map<Object, Object> d_data;

    private static <T> OccProfile.Prop<T> newProp(String key, long seed, T defVal, boolean geometric, String displayName, String desc) {
        return new OccProfile.Prop<T>(OccProfile.Group.NONE, key, seed, defVal, geometric, displayName, desc, null, v -> v, null, null);
    }

    private static final ConstantCurve cc(double val, Unit unit) {
        return new ConstantCurve(new UnitDouble(val, unit));
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof OccProfile && this.d_data.equals(((OccProfile)obj).d_data);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        OccProfile.initAll(this.d_data);
    }

    private static void initAll(Map<Object, Object> data) {
        for (OccProfile.Prop<?> prop : ALL_LEG_PROPS) {
            if (data.containsKey(prop.key)) continue;
            data.put(prop.key, prop.defVal);
        }
    }

    private <T> T get(OccProfile.Prop<T> legProp) {
        return (T)this.d_data.getOrDefault(legProp.key, legProp.defVal);
    }

    private <T> void copyProp(merlin.data.egress.agents.OccProfile profile, OccProfile.Prop<T> legProp, OccProfile.Prop<T> currProp) {
        T value = this.get(legProp);
        profile.setIfNotDefault(currProp, value);
    }

    protected Object readResolve() throws ObjectStreamException {
        this.d_data.keySet().stream().forEach(OccProfile::findProp);
        merlin.data.egress.agents.OccProfile prof = new merlin.data.egress.agents.OccProfile();
        this.copyProp(prof, PROP_NAME, merlin.data.egress.agents.OccProfile.PROP_NAME);
        this.copyProp(prof, PROP_DESC, merlin.data.egress.agents.OccProfile.PROP_DESC);
        this.copyProp(prof, PROP_COLOR, merlin.data.egress.agents.OccProfile.PROP_COLOR);
        this.copyProp(prof, PROP_DIAMETER, merlin.data.egress.agents.OccProfile.PROP_DIAMETER);
        this.copyProp(prof, PROP_MAXVEL, merlin.data.egress.agents.OccProfile.PROP_MAXVEL);
        prof.setIfNotDefault(merlin.data.egress.agents.OccProfile.PROP_OCCMODEL, merlin.data.egress.agents.OccProfile.legacyConvertAvatars((IUrn<String>)this.get(PROP_OCCMODEL)));
        prof.setIfNotDefault(PROP_INI_DELAY, this.get(PROP_INI_DELAY));
        return prof;
    }

    private static <T> OccProfile.Prop<T> findProp(Object propName) {
        for (OccProfile.Prop<?> prop : ALL_LEG_PROPS) {
            if (!prop.key.equals(propName)) continue;
            return prop;
        }
        System.err.println("Could not find legacy prop " + propName);
        return null;
    }

    public static class Custom
    extends OccProfile {
        private static final long serialVersionUID = -1345983822464480721L;
    }
}

