/*
 * Decompiled with CFR 0.152.
 */
package merlin.legacy.v0009;

import java.util.Arrays;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.Inter2D;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util;
import thunderheadeng.geometry.Util2D;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.ICurve;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.util.theUtil;

public class StrutUtil {
    public static Point3d[] calcStrutBoundary(LineSeg edge1, LineSeg edge2, double midt1, double desiredStrutWidth) {
        double[] xyisect;
        Point3d e1mid = edge1.evaluate(midt1);
        double midt2 = StrutUtil.getCorrespondingT(edge1, edge2, e1mid);
        double[] ta = StrutUtil.getEdgeTs(edge1, midt1, desiredStrutWidth);
        double maxWid1 = Math.abs(ta[0] - ta[1]) * edge1.length();
        double[] tb = StrutUtil.getEdgeTs(edge2, midt2, desiredStrutWidth);
        double maxWid2 = Math.abs(tb[0] - tb[1]) * edge2.length();
        double width = Math.min(maxWid1, maxWid2);
        ta = StrutUtil.getEdgeTs(edge1, midt1, width);
        Point3d p1a = edge1.evaluate(ta[0]);
        Point3d p2a = edge1.evaluate(ta[1]);
        tb = StrutUtil.getEdgeTs(edge2, midt2, width);
        Point3d p1b = edge2.evaluate(tb[0]);
        Point3d p2b = edge2.evaluate(tb[1]);
        if (edge1.getTangent(0.0, ICurve.Orient.POSITIVE, false).dot(edge2.getTangent(0.0, ICurve.Orient.POSITIVE, false)) < 0.0) {
            Point3d temp = p1b;
            p1b = p2b;
            p2b = temp;
        }
        boolean p1eq = p1b.epsilonEquals(p1a, 1.0E-6);
        boolean p2eq = p2b.epsilonEquals(p2a, 1.0E-6);
        if (p1eq && p2eq) {
            return new Point3d[]{p1a, p2a};
        }
        Point2d p1a2d = new Point2d(p1a.x, p1a.y);
        Point2d p2a2d = new Point2d(p2a.x, p2a.y);
        Point2d p1b2d = new Point2d(p1b.x, p1b.y);
        Point2d p2b2d = new Point2d(p2b.x, p2b.y);
        if (p1a2d.distance(p1b2d) > 0.001 && p2a2d.distance(p2b2d) > 0.001 && (xyisect = StrutUtil.isectLinesegLineseg(p1a2d, p2a2d, p1b2d, p2b2d, 1.0E-6)) != null && (theUtil.gt0(xyisect[0], 1.0E-6) && theUtil.lt(xyisect[0], 1.0, 1.0E-6) || theUtil.gt0(xyisect[1], 1.0E-6) && theUtil.lt(xyisect[1], 1.0, 1.0E-6))) {
            boolean s2Valid;
            Point3d pia = Util3D.linesegPoint(p1a, p2a, xyisect[0]);
            Point3d pib = Util3D.linesegPoint(p1b, p2b, xyisect[1]);
            Point3d[] strut1 = new Point3d[]{pia, p1a, p1b, pib};
            Point3d[] strut2 = new Point3d[]{p2a, pia, pib, p2b};
            Vector3d normal1 = Util3D.simplePolygonNormal(Arrays.asList(strut1), true);
            Vector3d normal2 = Util3D.simplePolygonNormal(Arrays.asList(strut2), true);
            boolean s1Valid = normal1 == null || normal1.z > 0.0;
            boolean bl = s2Valid = normal2 == null || normal2.z > 0.0;
            if (s1Valid && s2Valid) {
                return strut1[0].distanceSquared(strut1[1]) > strut2[0].distanceSquared(strut2[1]) ? strut1 : strut2;
            }
            if (s1Valid) {
                return strut1;
            }
            if (s2Valid) {
                return strut2;
            }
            return null;
        }
        return new Point3d[]{p2a, p1a, p1b, p2b};
    }

    private static double[] isectLinesegLineseg(Point2d l1a, Point2d l1b, Point2d l2a, Point2d l2b, double tol) {
        double[] isect = Inter2D.isectLineLine(l1a, Util2D.vector(l1a, l1b), l2a, Util2D.vector(l2a, l2b), 1.0E-12);
        if (isect == null) {
            return null;
        }
        if (!Util.clampTIfValid(isect, 0.0, 1.0, tol)) {
            return null;
        }
        return isect;
    }

    private static double[] getEdgeTs(LineSeg edge, double midt, double desiredWidth) {
        double halfWidT1 = desiredWidth * 0.5 / edge.length();
        double t1a = midt - halfWidT1;
        double t2a = midt + halfWidT1;
        Util.clampT(t1a, 0.0, 1.0);
        Util.clampT(t2a, 0.0, 1.0);
        return new double[]{t1a, t2a};
    }

    private static double getCorrespondingT(LineSeg edge1, LineSeg edge2, Point3d pedge1, boolean clampt) {
        Vector3d planeNormal;
        Vector3d e1dir = edge1.getTangent(0.0, ICurve.Orient.POSITIVE, false);
        Vector3d e2dir = edge2.getTangent(0.0, ICurve.Orient.POSITIVE, false);
        Point3d e2p1 = edge2.p1;
        if (e1dir.dot(e2dir) < 0.0) {
            e2p1 = edge2.p2;
            e2dir.negate();
        }
        if (theUtil.eq0((planeNormal = Util3D.cross(e2dir, e1dir)).dot(planeNormal), 1.0E-12)) {
            e1dir.normalize();
            double t = Inter3D.nearestTOnLine(edge2.p1, edge2.getTangent(0.0, ICurve.Orient.POSITIVE, false), pedge1);
            if (clampt) {
                t = Util.clampT(t, 0.0, 1.0);
            }
            return t;
        }
        double rotAngle = Util3D.angle(e1dir, e2dir, planeNormal);
        planeNormal.normalize();
        Plane3d plane = new Plane3d(planeNormal, edge2.p1);
        Point3d e1p1Adjusted = plane.projectOntoPlane(edge1.p1);
        double[] st = new double[2];
        if (!Inter3D.copLineLine(e1p1Adjusted, e1dir, e2p1, e2dir, st, 1.0E-6)) {
            return Double.NaN;
        }
        Point3d rotpt = Util3D.linePoint(e1p1Adjusted, e1dir, st[0]);
        Matrix4d xform = Util.translateMat(rotpt.x, rotpt.y, rotpt.z);
        xform.mul(Util.rotMat(planeNormal.x, planeNormal.y, planeNormal.z, rotAngle));
        xform.mul(Util.translateMat(-rotpt.x, -rotpt.y, -rotpt.z));
        Point3d corresPt = new Point3d(pedge1);
        xform.transform(corresPt);
        double correst = Util3D.tOnLineSeg(edge2.p1, edge2.p2, corresPt);
        if (clampt) {
            correst = Util.clampT(correst, 0.0, 1.0);
        }
        return correst;
    }

    private static double getCorrespondingT(LineSeg edge1, LineSeg edge2, Point3d pedge1) {
        return StrutUtil.getCorrespondingT(edge1, edge2, pedge1, true);
    }
}

