/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui.value;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Function;
import merlin.Intl;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiUtil;
import thunderheadeng.gui.value.AValEditor;
import thunderheadeng.util.Pair;

public class DiscreteValEditor<T>
extends AValEditor<T> {
    private static final long serialVersionUID = 1L;
    private final guiComboBox<T> d_combo;

    public DiscreteValEditor(Class<T> type, Function<T, Pair<String, String>> formatter, T ... values) {
        this(type, formatter, (Collection<T>)Arrays.asList(values));
    }

    public DiscreteValEditor(Class<T> type, Function<T, Pair<String, String>> formatter, Collection<T> values) {
        this(type, DiscreteValEditor.prepareCombo(formatter, values));
    }

    private static <T> guiComboBox<T> prepareCombo(Function<T, Pair<String, String>> formatter, Collection<T> values) {
        ArrayList<T> tvalues = new ArrayList<T>(values.size() + 1);
        tvalues.addAll(values);
        tvalues.add(null);
        guiComboBox<Object> d_combo = guiUtil.newCombo(v -> {
            if (v == null) {
                return new Pair<String, Object>(Intl.intl("<mixed>"), null);
            }
            return (Pair)formatter.apply(v);
        }, tvalues);
        d_combo.setPreferredSize(d_combo.getPreferredSize());
        d_combo.removeItem(null);
        return d_combo;
    }

    public DiscreteValEditor(Class<T> type, guiComboBox<T> items) {
        super(type);
        this.d_combo = items;
        this.loadValue(this.getValue());
        GridBagHelper gb = new GridBagHelper(this);
        gb.addFilledRow(this.d_combo);
        gb.finalizeRows();
        this.d_combo.addItemListener(e -> {
            if (e.getStateChange() != 1) {
                return;
            }
            this.updateValue();
        });
    }

    public guiComboBox<T> getCombo() {
        return this.d_combo;
    }

    @Override
    public void add(GridBagHelper gb) {
        gb.add(this.d_combo);
    }

    @Override
    protected void loadValue(T value) {
        if (value == null) {
            this.d_combo.setSelectedIndex(-1);
        } else {
            this.d_combo.setSelectedItem(value);
        }
    }

    @Override
    protected T saveValue() {
        return this.d_combo.getSelectedItem();
    }
}

