/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui.agents;

import java.util.Objects;
import java.util.function.BiFunction;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import merlin.Intl;
import merlin.data.egress.agents.OccProfile;
import merlin.gui.guiUtil;
import merlin.gui.stat.VerboseCurveEditor;
import merlin.unitsystem.SIUS;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import thunderheadeng.gui.Comm;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.HTMLBtn;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.Modifiable;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiRadioButton;
import thunderheadeng.gui.value.IValEditor;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.stat.ConstantCurve;
import thunderheadeng.util.stat.ICurve;

public class PersonalDistanceEditor
extends HTMLBtn
implements Modifiable,
IValEditor<OccProfile.Spacing> {
    private static final long serialVersionUID = 1L;
    private final Comm d_comm;
    private OccProfile.Spacing d_spacing;
    private boolean d_modified;

    public PersonalDistanceEditor(Comm comm) {
        this(comm, 15);
    }

    public PersonalDistanceEditor(Comm comm, int options) {
        super("");
        this.d_comm = comm;
        this.d_modified = false;
        this.addActionListener(e -> {
            OccProfile.Spacing newSpacing;
            guiDialog dlg = new guiDialog(SwingUtilities.getWindowAncestor(this), Intl.intl("Personal Distance"), 9);
            SpacingPnl pnl = new SpacingPnl(options);
            pnl.load(this.d_spacing);
            dlg.getDialogPane().add(pnl);
            if (dlg.doModal() == 1 && !Objects.equals(newSpacing = pnl.save(), this.d_spacing)) {
                this.setValue(newSpacing);
                this.setModified(true);
                this.d_comm.touch(e);
            }
        });
        this.update();
    }

    @Override
    public void add(GridBagHelper gb) {
        gb.add(this, 1.0);
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public Class<OccProfile.Spacing> getType() {
        return OccProfile.Spacing.class;
    }

    @Override
    public boolean isModified() {
        return this.d_modified;
    }

    @Override
    public void setModified(boolean modified) {
        this.d_modified = modified;
    }

    @Override
    public void setValue(OccProfile.Spacing spacing) {
        if (Objects.equals(spacing, this.d_spacing)) {
            return;
        }
        OccProfile.Spacing oldVal = this.d_spacing;
        this.d_spacing = spacing;
        this.update();
        this.setModified(false);
        this.firePropertyChange("value", oldVal, this.d_spacing);
    }

    @Override
    public OccProfile.Spacing getValue() {
        return this.d_spacing;
    }

    private void update() {
        this.setText(this.d_spacing != null ? PersonalDistanceEditor.format(this.d_spacing) : Intl.intl("&lt;mixed&gt;"));
    }

    private static String format(OccProfile.Spacing spacing) {
        return spacing.format();
    }

    private static <T extends JComponent> T setTooltip(T c, String tt) {
        if (!((String)tt).isEmpty()) {
            tt = ((String)tt).replace("\n", "<br>");
            tt = "<html>" + (String)tt + "</html>";
        }
        c.setToolTipText((String)tt);
        return c;
    }

    private static class SpacingPnl
    extends guiPanel {
        private static final long serialVersionUID = 1L;
        private final IValEditor<ICurve> d_personalDist;
        private final IValEditor<ICurve> d_queueDensity;
        private final IValEditor<ICurve> d_queueArea;
        private final guiRadioButton d_comfortDistRB;
        private final guiRadioButton d_queueDensityRB;
        private final guiRadioButton d_queueAreaRB;

        public SpacingPnl(int curveOpts) {
            BiFunction<String, String, guiRadioButton> newRB = (lbl, tt) -> PersonalDistanceEditor.setTooltip(new guiRadioButton((String)lbl), tt);
            BiFunction<Double, Unit, ConstantCurve> cc = (val, unit) -> new ConstantCurve(new UnitDouble((double)val, (Unit)unit));
            this.d_comfortDistRB = newRB.apply(Intl.intl("Personal Distance:"), Intl.intl("The desired separation distance to maintain with other occupants."));
            this.d_personalDist = new VerboseCurveEditor(0, false, curveOpts);
            this.d_personalDist.setValue(cc.apply(0.08, SI.METER));
            LinkStatus.link((AbstractButton)this.d_comfortDistRB, this.d_personalDist.getComponent());
            this.d_queueDensityRB = newRB.apply(Intl.intl("From Queue Density:"), Intl.intl("An approximate occupant density to maintain."));
            this.d_queueDensity = new VerboseCurveEditor(3, false, curveOpts);
            this.d_queueDensity.setValue(cc.apply(4.0, SIUS.unit(3)));
            LinkStatus.link((AbstractButton)this.d_queueDensityRB, this.d_queueDensity.getComponent());
            this.d_queueAreaRB = newRB.apply(Intl.intl("From Queue Area:"), Intl.intl("An approximate amount of area to maintain around the occupant."));
            this.d_queueArea = new VerboseCurveEditor(2, false, curveOpts);
            this.d_queueArea.setValue(cc.apply(0.25, SIUS.unit(2)));
            LinkStatus.link((AbstractButton)this.d_queueAreaRB, this.d_queueArea.getComponent());
            guiUtil.group(new AbstractButton[]{this.d_comfortDistRB, this.d_queueDensityRB, this.d_queueAreaRB});
            GridBagHelper gb = new GridBagHelper(this);
            gb.addIdentRow(this.d_comfortDistRB, this.d_personalDist, 1.0, 0);
            gb.addIdentRow(this.d_queueDensityRB, this.d_queueDensity, 1.0, 0);
            gb.addIdentRow(this.d_queueAreaRB, this.d_queueArea, 1.0, 0);
            gb.finalizeRows();
        }

        public void load(OccProfile.Spacing spacing) {
            if (spacing == null) {
                this.d_queueAreaRB.setSelected(false);
                this.d_queueDensityRB.setSelected(false);
                this.d_comfortDistRB.setSelected(false);
            } else {
                switch (spacing.type) {
                    case AREA: {
                        this.d_queueAreaRB.setSelected(true);
                        this.d_queueArea.setValue(spacing.val);
                        break;
                    }
                    case DENSITY: {
                        this.d_queueDensityRB.setSelected(true);
                        this.d_queueDensity.setValue(spacing.val);
                        break;
                    }
                    case COMFORT_DIST: {
                        this.d_comfortDistRB.setSelected(true);
                        this.d_personalDist.setValue(spacing.val);
                    }
                }
            }
        }

        public OccProfile.Spacing save() {
            ICurve val;
            OccProfile.SpacingType type;
            if (this.d_comfortDistRB.isSelected()) {
                type = OccProfile.SpacingType.COMFORT_DIST;
                val = this.d_personalDist.getValue();
            } else if (this.d_queueAreaRB.isSelected()) {
                type = OccProfile.SpacingType.AREA;
                val = this.d_queueArea.getValue();
            } else if (this.d_queueDensityRB.isSelected()) {
                type = OccProfile.SpacingType.DENSITY;
                val = this.d_queueDensity.getValue();
            } else {
                return null;
            }
            return new OccProfile.Spacing(type, val);
        }
    }
}

