/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui.agents;

import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.data.AMerlinObj;
import merlin.data.Composite;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.data.egress.agents.OccProfile;
import merlin.data.egress.elevators.Elevator;
import merlin.data.egress.geom.EgressCorridor;
import merlin.data.egress.geom.EgressDoor;
import merlin.data.egress.geom.EgressRoom;
import merlin.data.egress.geom.EgressStair;
import merlin.gui.filter.ObjRestrictionEditorComponents;
import merlin.gui.guiUtil;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.theUtil;

public class CompRestrictionsPanel {
    private CompRestriction<EgressDoor> d_doorChooser;
    private CompRestriction<EgressRoom> d_roomChooser;
    private CompRestriction<EgressStair> d_stairChooser;
    private CompRestriction<EgressStair> d_escalatorChooser;
    private CompRestriction<EgressCorridor> d_rampChooser;
    private CompRestriction<EgressCorridor> d_movingWalkwayChooser;
    private CompRestriction<Elevator> d_elevatorChooser;
    private final List<CompRestriction> d_allRestrictions = new ArrayList<CompRestriction>();

    public CompRestrictionsPanel() {
        MerlinData md = MerlinApp.getApp().getData();
        this.d_doorChooser = new CompRestriction<EgressDoor>(md, Intl.intl("Use Doors:"), Intl.intl("Restricted Doors"), md.floors, EgressDoor.class, Predicates.alwaysTrue(), cr -> cr.doorInfo, (cr, info) -> {
            cr.doorInfo = info;
        }, OccProfile.CompRestrictions.Mode.ALL, OccProfile.CompRestrictions.Mode.NONE, OccProfile.CompRestrictions.Mode.FROM_LIST);
        this.d_allRestrictions.add(this.d_doorChooser);
        this.d_roomChooser = new CompRestriction<EgressRoom>(md, Intl.intl("Use Rooms:"), Intl.intl("Restricted Rooms"), md.floors, EgressRoom.class, Predicates.alwaysTrue(), cr -> cr.roomInfo, (cr, info) -> {
            cr.roomInfo = info;
        }, OccProfile.CompRestrictions.Mode.ALL, OccProfile.CompRestrictions.Mode.NONE, OccProfile.CompRestrictions.Mode.FROM_LIST);
        this.d_allRestrictions.add(this.d_roomChooser);
        this.d_stairChooser = new CompRestriction<EgressStair>(md, Intl.intl("Use Stairs:"), Intl.intl("Restricted Stairs"), md.floors, EgressStair.class, stair -> !stair.isEscalator(), cr -> cr.stairInfo, (cr, info) -> {
            cr.stairInfo = info;
        }, OccProfile.CompRestrictions.Mode.ALL, OccProfile.CompRestrictions.Mode.NONE, OccProfile.CompRestrictions.Mode.FROM_LIST);
        this.d_allRestrictions.add(this.d_stairChooser);
        this.d_escalatorChooser = new CompRestriction<EgressStair>(md, Intl.intl("Use Escalators:"), Intl.intl("Restricted Escalators"), md.floors, EgressStair.class, stair -> stair.isEscalator(), cr -> cr.escalatorInfo, (cr, info) -> {
            cr.escalatorInfo = info;
        }, OccProfile.CompRestrictions.Mode.ALL, OccProfile.CompRestrictions.Mode.NONE, OccProfile.CompRestrictions.Mode.UP_ONLY, OccProfile.CompRestrictions.Mode.DOWN_ONLY, OccProfile.CompRestrictions.Mode.FROM_LIST);
        this.d_allRestrictions.add(this.d_escalatorChooser);
        this.d_rampChooser = new CompRestriction<EgressCorridor>(md, Intl.intl("Use Ramps:"), Intl.intl("Restricted Ramps"), md.floors, EgressCorridor.class, comp -> !(comp instanceof EgressStair) && !comp.isMovingWalkway(), cr -> cr.rampInfo, (cr, info) -> {
            cr.rampInfo = info;
        }, OccProfile.CompRestrictions.Mode.ALL, OccProfile.CompRestrictions.Mode.NONE, OccProfile.CompRestrictions.Mode.FROM_LIST);
        this.d_allRestrictions.add(this.d_rampChooser);
        this.d_movingWalkwayChooser = new CompRestriction<EgressCorridor>(md, Intl.intl("Use Moving Walkways:"), Intl.intl("Restricted Moving Walkways"), md.floors, EgressCorridor.class, comp -> !(comp instanceof EgressStair) && comp.isMovingWalkway(), cr -> cr.movingWalkwayInfo, (cr, info) -> {
            cr.movingWalkwayInfo = info;
        }, OccProfile.CompRestrictions.Mode.ALL, OccProfile.CompRestrictions.Mode.NONE, OccProfile.CompRestrictions.Mode.FROM_LIST);
        this.d_allRestrictions.add(this.d_movingWalkwayChooser);
        this.d_elevatorChooser = new CompRestriction<Elevator>(md, Intl.intl("Use Elevators:"), Intl.intl("Restricted Elevators"), md.elevators, Elevator.class, Predicates.alwaysTrue(), cr -> cr.elevatorInfo, (cr, info) -> {
            cr.elevatorInfo = info;
        }, OccProfile.CompRestrictions.Mode.ALL, OccProfile.CompRestrictions.Mode.NONE, OccProfile.CompRestrictions.Mode.FROM_LIST, OccProfile.CompRestrictions.Mode.FROM_BEHAVIOR);
        this.d_allRestrictions.add(this.d_elevatorChooser);
        int maxModeWidth = this.d_allRestrictions.stream().mapToInt(r -> r.d_modeCB.getPreferredSize().width).max().getAsInt();
        this.d_allRestrictions.stream().forEach(r -> r.d_modeCB.setPreferredSize(new Dimension(maxModeWidth, r.d_modeCB.getPreferredSize().height)));
    }

    public boolean validateData(Component parent, boolean allowWarn, boolean allowEdit) {
        return this.d_allRestrictions.stream().allMatch(r -> r.validateData(parent, allowWarn, allowEdit));
    }

    public void init(OccProfile dataObj) {
        OccProfile.CompRestrictions compRestrictions = dataObj.getProperty(OccProfile.PROP_RESTRICTED_COMPONENTS);
        this.init(compRestrictions);
    }

    public void init(OccProfile.CompRestrictions compRestrictions) {
        for (CompRestriction restr : this.d_allRestrictions) {
            restr.initCompRestrictions(compRestrictions);
        }
    }

    public OccProfile.CompRestrictions commit() {
        OccProfile.CompRestrictions restrictions = new OccProfile.CompRestrictions();
        for (CompRestriction restr : this.d_allRestrictions) {
            restr.commitRestrictions(restrictions);
        }
        return restrictions;
    }

    public void addToLayout(GridBagHelper gb) {
        for (CompRestriction restr : this.d_allRestrictions) {
            restr.addToLayout(gb);
        }
    }

    private static class CompRestriction<T extends IMerlinObj>
    extends ObjRestrictionEditorComponents<OccProfile.CompRestrictions.Mode, T> {
        private final Function<OccProfile.CompRestrictions, OccProfile.CompRestrictions.CompRestrictionsInfo> d_getInfo;
        private final BiConsumer<OccProfile.CompRestrictions, OccProfile.CompRestrictions.CompRestrictionsInfo> d_setInfo;
        private final Predicate<? super T> d_allowedObjs;

        public CompRestriction(MerlinData md, String compLbl, String chooserLbl, Composite<?> objRoot, Class<T> objType, Predicate<? super T> allowedObjs, Function<OccProfile.CompRestrictions, OccProfile.CompRestrictions.CompRestrictionsInfo> getInfo, BiConsumer<OccProfile.CompRestrictions, OccProfile.CompRestrictions.CompRestrictionsInfo> setInfo, OccProfile.CompRestrictions.Mode ... allowedModes) {
            super(compLbl, objType, ObjRestrictionEditorComponents.newChooser(md, chooserLbl, objType, objRoot, allowedObjs), (ModeT mode) -> guiUtil.encodeToHtmlLabel(mode.name, mode.desc), OccProfile.CompRestrictions.Mode.FROM_LIST, allowedModes);
            this.d_allowedObjs = allowedObjs;
            this.d_getInfo = getInfo;
            this.d_setInfo = setInfo;
        }

        public void initCompRestrictions(OccProfile.CompRestrictions restrictions) {
            MerlinData md = MerlinApp.getApp().getData();
            if (restrictions == null) {
                this.load(null, true, Collections.emptySet());
                return;
            }
            OccProfile.CompRestrictions.CompRestrictionsInfo compInfo = this.d_getInfo.apply(restrictions);
            this.load(compInfo.mode, !compInfo.rejected, theUtil.filter(restrictions.getObjs(this.clazz), this.d_allowedObjs.and(obj -> obj instanceof AMerlinObj && ((AMerlinObj)obj).getDomain() == md)));
        }

        public void commitRestrictions(OccProfile.CompRestrictions restrictions) {
            ObjRestrictionEditorComponents.Data data = this.save();
            boolean rejected = true;
            switch ((OccProfile.CompRestrictions.Mode)((Object)data.mode)) {
                case NONE: 
                case FROM_BEHAVIOR: {
                    rejected = false;
                    break;
                }
                case ALL: 
                case UP_ONLY: 
                case DOWN_ONLY: {
                    rejected = true;
                    break;
                }
                case FROM_LIST: {
                    rejected = !data.accepted;
                    restrictions.addAll(data.objs);
                }
            }
            OccProfile.CompRestrictions.CompRestrictionsInfo info = new OccProfile.CompRestrictions.CompRestrictionsInfo(rejected, (OccProfile.CompRestrictions.Mode)((Object)data.mode));
            this.d_setInfo.accept(restrictions, info);
        }
    }
}

