/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui;

import inferno.data2.PredefTag;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JFormattedTextField;
import javax.swing.text.DefaultFormatterFactory;
import merlin.Intl;
import merlin.data.PredefTags;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.format.AFormat;
import thunderheadeng.gui.guiFormattedFld;
import thunderheadeng.util.Filters;

public class TagsField
extends ValueField<Set<String>> {
    private static final long serialVersionUID = 1L;
    private static final Set<String> s_predefTags = Stream.concat(Stream.of(PredefTags.values()).map(t -> t.name), Stream.of(PredefTag.values()).map(t -> t.name)).sorted((t1, t2) -> t1.compareToIgnoreCase((String)t2)).collect(Collectors.toCollection(() -> new LinkedHashSet()));
    private static final RejectReservedForFutureUse REJECT_RESERVED = new RejectReservedForFutureUse();
    private boolean d_emptyAllowed = true;
    private boolean d_nullAllowed = false;
    private final boolean d_allowPredef;

    public TagsField() {
        this(false);
    }

    public TagsField(boolean allowPredef) {
        super(TagsField.getFormatterFactory(true, false, allowPredef), Collections.emptySet());
        this.d_allowPredef = allowPredef;
        this.setToolTipText(Intl.intl("Enter a space-separated list of tags."));
        this.setColumns(20);
    }

    @Override
    public void setValue(Object value) {
        super.setValue(value);
    }

    public void setEmptyAllowed(boolean allowed) {
        if (this.d_emptyAllowed == allowed) {
            return;
        }
        this.d_emptyAllowed = allowed;
        this.updateFormatterFactory();
    }

    @Override
    public void setNullAllowed(boolean allowed) {
        if (allowed == this.d_nullAllowed) {
            return;
        }
        this.d_nullAllowed = allowed;
        this.updateFormatterFactory();
    }

    private void updateFormatterFactory() {
        this.setFormatterFactory(TagsField.getFormatterFactory(this.d_emptyAllowed, this.d_nullAllowed, this.d_allowPredef));
    }

    @Override
    public boolean getNullAllowed() {
        return this.d_nullAllowed;
    }

    private static JFormattedTextField.AbstractFormatterFactory getFormatterFactory(boolean allowEmpty, boolean allowNull, boolean allowPredef) {
        guiFormattedFld.Formatter defFormatter = new guiFormattedFld.Formatter(new TagFormat(allowPredef, allowEmpty, false));
        defFormatter.setNullAllowed(allowNull);
        guiFormattedFld.Formatter displayFormatter = new guiFormattedFld.Formatter(new TagFormat(allowPredef, allowEmpty, true));
        displayFormatter.setNullAllowed(allowNull);
        return new DefaultFormatterFactory(defFormatter, displayFormatter);
    }

    private static class TagFormat
    extends AFormat<Set<String>> {
        private static final long serialVersionUID = 1L;
        private static final String s_mixed = Intl.intl("<mixed>");
        private final boolean d_allowPredefs;
        private final boolean d_display;
        private final boolean d_allowEmpty;

        private TagFormat(boolean allowPredefs, boolean allowEmpty, boolean display) {
            this.d_allowPredefs = allowPredefs;
            this.d_display = display;
            this.d_allowEmpty = allowEmpty;
        }

        @Override
        protected Map<String, Set<String>> newAliasMap() {
            return new LinkedHashMap<String, Set<String>>();
        }

        @Override
        protected Set<String> parse(String text) throws ParseException {
            if (this.d_display && text.equals(s_mixed)) {
                return null;
            }
            List tags = Stream.of(text.split("[ ,;]+")).map(s -> s.trim().toLowerCase(Locale.ROOT)).filter(s -> !s.isEmpty()).collect(Collectors.toCollection(() -> new ArrayList()));
            if (!this.d_allowEmpty && tags.isEmpty()) {
                throw new ParseException(Intl.intl("At least one tag must be specified."), 0);
            }
            if (!this.d_allowPredefs) {
                Predicate<String> filter = Filters.reject(s_predefTags).and(REJECT_RESERVED);
                Optional<String> badTag = tags.stream().filter(filter.negate()).findFirst();
                if (badTag.isPresent()) {
                    String message = !REJECT_RESERVED.test(badTag.get()) ? REJECT_RESERVED.toString() : String.format(Intl.intl("The following tags are reserved:\n    %s"), String.join((CharSequence)"\n    ", s_predefTags));
                    int offset = text.indexOf(badTag.get());
                    throw new ParseException(message, offset);
                }
            }
            if (tags.isEmpty()) {
                return Collections.emptySet();
            }
            if (tags.size() == 1) {
                return Collections.singleton((String)tags.get(0));
            }
            return new LinkedHashSet<String>(tags);
        }

        @Override
        protected String toString(Set<String> val) {
            if (val == null) {
                if (this.d_display) {
                    return s_mixed;
                }
                return "";
            }
            return String.join((CharSequence)" ", val);
        }
    }

    private static final class RejectReservedForFutureUse
    implements Predicate<String> {
        private RejectReservedForFutureUse() {
        }

        @Override
        public boolean test(String t) {
            return !t.startsWith("pf_");
        }

        public String toString() {
            return String.format(Intl.intl("Tags must not start with \"%s\"."), "pf_");
        }
    }
}

