/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui;

import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import merlin.Intl;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.HTMLBtn;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.util.IObservable;
import thunderheadeng.util.IObserver;
import thunderheadeng.util.ObservableProxy;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.theUtil;

public class SearchField<T>
extends guiPanel
implements IObservable {
    private static final long serialVersionUID = 1L;
    public static final Object FILTER_CHANGED = new Object();
    public static final Object SHOW_ALL_MATCHES = new Object();
    private final Supplier<Stream<? extends T>> d_getItems;
    private final Function<T, String> d_getName;
    private final guiTextField d_filter;
    private final HTMLBtn d_matchesLbl;
    private final ObservableProxy d_observers;

    public SearchField(Supplier<Stream<? extends T>> getItems, Function<T, String> getName) {
        this.d_getItems = getItems;
        this.d_getName = getName;
        this.d_filter = new guiTextField();
        this.d_filter.setToolTipText("<html>" + Intl.intl("Enter a search term to filter the rows in the list. Wildcards are accepted.<br>* matches any number of characters.<br>? matches a single character.<br>Surround in quotes to match exactly (e.g. \"Door01\")"));
        this.d_observers = new ObservableProxy(this);
        this.d_filter.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                SearchField.this.update(true);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                SearchField.this.update(true);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        this.d_matchesLbl = new HTMLBtn("");
        this.d_matchesLbl.setToolTipText(Intl.intl("Click to display all matches."));
        Runnable showAllMatches = () -> this.d_observers.modified(SHOW_ALL_MATCHES);
        this.d_matchesLbl.addActionListener(e -> showAllMatches.run());
        this.d_filter.addActionListener(e -> showAllMatches.run());
        GridBagHelper gbf = new GridBagHelper(this);
        gbf.addRow(this.d_filter, 1.0, 1, this.d_matchesLbl);
        this.update(false);
    }

    private void update(boolean notifyObservers) {
        Predicate<T> filter = this.getFilter();
        if (!Predicates.alwaysTrue(filter)) {
            long nNameMatches = this.d_getItems.get().filter(filter).count();
            if (nNameMatches == 0L) {
                this.d_matchesLbl.setText(Intl.intl("No matches"));
            } else if (nNameMatches == 1L) {
                this.d_matchesLbl.setText(Intl.intl("1 match"));
            } else {
                this.d_matchesLbl.setText(String.format("%d matches", nNameMatches));
            }
            this.d_matchesLbl.setVisible(true);
        } else {
            this.d_matchesLbl.setVisible(false);
        }
        if (notifyObservers) {
            this.d_observers.modified(FILTER_CHANGED);
        }
    }

    public Predicate<T> getFilter() {
        Object nameFilter = this.d_filter.getText();
        if (!((String)nameFilter).isEmpty()) {
            if (((String)nameFilter).length() >= 3 && ((String)nameFilter).startsWith("\"") && ((String)nameFilter).endsWith("\"")) {
                String matchName = ((String)nameFilter).substring(1, ((String)nameFilter).length() - 1);
                return obj -> this.d_getName.apply(obj).equals(matchName);
            }
            if (!((String)nameFilter).startsWith("*")) {
                nameFilter = "*" + (String)nameFilter;
            }
            if (!((String)nameFilter).endsWith("*")) {
                nameFilter = (String)nameFilter + "*";
            }
            Object pattern = nameFilter;
            return arg_0 -> this.lambda$getFilter$4((String)pattern, arg_0);
        }
        return Predicates.alwaysTrue();
    }

    public boolean isEmpty() {
        return this.d_filter.getText().isEmpty();
    }

    public void clear() {
        this.d_filter.setText("");
    }

    @Override
    public void addObserver(IObserver observer, boolean weakRef) {
        this.d_observers.addObserver(observer, weakRef);
    }

    @Override
    public void deleteObserver(IObserver observer) {
        this.d_observers.deleteObserver(observer);
    }

    private /* synthetic */ boolean lambda$getFilter$4(String pattern, Object obj) {
        String name = this.d_getName.apply(obj);
        return theUtil.wildcardMatch(name, pattern, true);
    }
}

