/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui;

import common.data.EscalatorPreference;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.vecmath.Point3f;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.data.MerlinData;
import merlin.data.MerlinSelectionModel;
import merlin.data.egress.agents.EgressAgent;
import merlin.data.egress.agents.OccProfile;
import merlin.data.egress.agents.ResourceAvatar;
import merlin.data.property.Function1dProp;
import merlin.data.property.INamedProp;
import merlin.data.value.IFunction1d;
import merlin.gui.AvatarEditor;
import merlin.gui.TagsField;
import merlin.gui.agents.AttractorsFilterEditorComponents;
import merlin.gui.agents.CompRestrictionsPanel;
import merlin.gui.agents.PersonalDistanceEditor;
import merlin.gui.agents.ShapeEditor;
import merlin.gui.agents.SpeedInSmokeEditor;
import merlin.gui.guiUtil;
import merlin.gui.stat.VerboseCurveEditor;
import merlin.gui.stat.guiCurveUtil;
import merlin.gui.value.Function1dEditorFactory;
import merlin.gui.value.MultiValEditor;
import merlin.gui.value.PopupValEditor;
import merlin.unitsystem.SIUS;
import net.miginfocom.swing.MigLayout;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.IEditor;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.colorscheme.ColorButton;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiIntField;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.gui.value.AValEditor;
import thunderheadeng.gui.value.IValEditor;
import thunderheadeng.units.UnitDoubleVR;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.IntVR;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Property;
import thunderheadeng.util.stat.ICurve;
import thunderheadeng.util.stat.IUrn;
import thunderheadeng.util.stat.Urn;
import thunderheadeng.util.stat.UrnUtil;

public class ProfilesPanel
extends guiPanel
implements IEditor<OccProfile> {
    private static final long serialVersionUID = 1L;
    private final guiTextField d_name;
    private final guiTextField d_desc;
    private final TagsField d_tags;
    private final AvatarEditor d_model;
    private final ColorButton d_colorBtn;
    private final CharPanel d_propsPnl;
    private final MovementPanel d_behaviorPnl;
    private final RestrictionsPanel d_restrictionsPnl;
    private final DoorChoicePanel d_doorChoicePnl;
    private final OutputPanel d_outputPnl;
    private final AdvancedPanel d_advancedPnl;
    private static List<IPropertySet.Prop<?>> ADVANCED_SPEED_PROPS = Arrays.asList(OccProfile.PROP_MAXVEL, OccProfile.PROP_FUNDAMENTAL, OccProfile.PROP_STAIR_SPEED_UP, OccProfile.PROP_STAIR_FUNDAMENTAL_UP, OccProfile.PROP_STAIR_SPEED_DOWN, OccProfile.PROP_STAIR_FUNDAMENTAL_DOWN, OccProfile.PROP_RAMP_SPEED_UP, OccProfile.PROP_RAMP_FUNDAMENTAL_UP, OccProfile.PROP_RAMP_SPEED_DOWN, OccProfile.PROP_RAMP_FUNDAMENTAL_DOWN);

    public ProfilesPanel(Window owner) {
        this.setLayout(new GridBagLayout());
        this.d_name = new guiTextField();
        this.d_name.setEditable(false);
        this.d_desc = new guiTextField();
        this.d_desc.getDocument().addDocumentListener(this.d_comm);
        this.d_tags = new TagsField();
        this.d_colorBtn = new ColorButton(1);
        this.d_model = new AvatarEditor(3, ResourceAvatar.Type.OCCUPANT);
        this.d_model.addValueListener(e -> this.setModified(true));
        Border border = BorderFactory.createEmptyBorder(12, 12, 12, 12);
        this.d_propsPnl = new CharPanel();
        this.d_propsPnl.setBorder(border);
        this.d_behaviorPnl = new MovementPanel();
        this.d_behaviorPnl.setBorder(border);
        this.d_restrictionsPnl = new RestrictionsPanel();
        this.d_restrictionsPnl.setBorder(border);
        this.d_advancedPnl = new AdvancedPanel();
        this.d_advancedPnl.setBorder(border);
        this.d_doorChoicePnl = new DoorChoicePanel();
        this.d_doorChoicePnl.setBorder(border);
        this.d_outputPnl = new OutputPanel();
        this.d_outputPnl.setBorder(border);
        JTabbedPane tb = new JTabbedPane();
        tb.addTab(CharPanel.TITLE, this.d_propsPnl);
        tb.addTab(MovementPanel.TITLE, this.d_behaviorPnl);
        tb.addTab(RestrictionsPanel.TITLE, this.d_restrictionsPnl);
        tb.addTab(DoorChoicePanel.TITLE, this.d_doorChoicePnl);
        tb.addTab(OutputPanel.TITLE, this.d_outputPnl);
        tb.addTab(AdvancedPanel.TITLE, this.d_advancedPnl);
        this.setLayout(new MigLayout("insets 0, gap 6, wrap 2", "[fill][fill]"));
        this.add(new guiLabel(Intl.intl("Name:")));
        this.add(this.d_name);
        this.add(new guiLabel(Intl.intl("Description:")));
        this.add(this.d_desc);
        this.add(guiUtil.lbl(Intl.intl("Tags:"), Intl.intl("Defines the occupants' tags.")));
        this.add(this.d_tags);
        this.add(new guiLabel(Intl.intl("3D Model:")));
        this.add((Component)this.d_model, "height 25::");
        this.add(new guiLabel(Intl.intl("Color:")));
        this.add((Component)this.d_colorBtn, "grow 0");
        this.add((Component)tb, "span");
    }

    private static guiLabel newLbl(String text, String tt) {
        guiLabel result = new guiLabel(text);
        return ProfilesPanel.setTooltip(result, tt);
    }

    private static <T extends JComponent> T setTooltip(T c, String tt) {
        if (!((String)tt).isEmpty()) {
            tt = ((String)tt).replace("\n", "<br>");
            tt = "<html>" + (String)tt + "</html>";
        }
        c.setToolTipText((String)tt);
        return c;
    }

    @Override
    public OccProfile preview(OccProfile previewObj) {
        return previewObj;
    }

    @Override
    public guiPanel getEditorPanel() {
        return this;
    }

    @Override
    public void init(OccProfile dataObj) {
        if (dataObj != null) {
            MerlinData md = MerlinApp.getApp().getData();
            try (MerlinData.ReadLock lock = md.lockRead();){
                this.d_name.setText(dataObj.getProperty(OccProfile.PROP_NAME));
                this.d_desc.setText(dataObj.getProperty(OccProfile.PROP_DESC));
                this.d_tags.setTypedValue(UrnUtil.getDominant(dataObj.getProperty(OccProfile.PROP_TAGS)));
                Point3f c3f = dataObj.getProperty(OccProfile.PROP_COLOR);
                this.d_colorBtn.setColor(new Color(c3f.x, c3f.y, c3f.z, 1.0f));
                this.d_model.setValue(Property.of(dataObj.getProperty(OccProfile.PROP_OCCMODEL)));
                this.d_propsPnl.init(dataObj);
                this.d_behaviorPnl.init(dataObj);
                this.d_restrictionsPnl.init(dataObj);
                this.d_advancedPnl.init(dataObj);
                this.d_outputPnl.init(dataObj);
                this.d_doorChoicePnl.init(dataObj);
            }
        }
        this.setModified(false);
    }

    @Override
    public OccProfile commit(final OccProfile dataObj) {
        if (dataObj != null) {
            AMerlinOp op = new AMerlinOp(){

                @Override
                public void run(MerlinApp app, MerlinData md) {
                    try (MerlinData.WriteLock lock = md.lockWrite();){
                        Undo.begin(Intl.intl("Edit Profile"));
                        ProfilesPanel.insertUndoOp(md, dataObj);
                        ProfilesPanel.this.commitProfile(dataObj, true);
                        Undo.end(MerlinApp.getApp().getData());
                    }
                }
            };
            UIHook.run(this, "ProfilesPanel.commit", op, 2);
        }
        this.setModified(false);
        return dataObj;
    }

    private void commitProfile(OccProfile profile, boolean changeModified) {
        if (profile == null) {
            return;
        }
        profile.setIfNotDefault(OccProfile.PROP_DESC, this.d_desc.getText());
        Color c = this.d_colorBtn.getColor();
        Point3f c3f = new Point3f((float)c.getRed() / 255.0f, (float)c.getGreen() / 255.0f, (float)c.getBlue() / 255.0f);
        profile.setIfNotDefault(OccProfile.PROP_COLOR, c3f);
        profile.setIfNotDefault(OccProfile.PROP_OCCMODEL, (IUrn)((Property)this.d_model.getValue()).get());
        profile.setIfNotDefault(OccProfile.PROP_TAGS, new Urn<Set>((Collection<Set>)Collections.singleton((Set)this.d_tags.getValue())));
        this.d_propsPnl.commit(profile, changeModified);
        this.d_behaviorPnl.commit(profile, changeModified);
        this.d_restrictionsPnl.commit(profile, changeModified);
        this.d_advancedPnl.commit(profile, changeModified);
        this.d_outputPnl.commit(profile, changeModified);
        this.d_doorChoicePnl.commit(profile, changeModified);
    }

    public Collection<INamedProp> getChanges(OccProfile origProf) {
        OccProfile tempProf = origProf.clone();
        this.commitProfile(tempProf, false);
        ArrayList<INamedProp> changes = new ArrayList<INamedProp>();
        for (Object o : tempProf.getPropTypes(0)) {
            IPropertySet.Prop prop;
            if (!(o instanceof IPropertySet.Prop) || Objects.equals(tempProf.getProperty(prop = (IPropertySet.Prop)o), origProf.getProperty(prop))) continue;
            assert (prop instanceof INamedProp);
            if (!(prop instanceof INamedProp)) continue;
            changes.add((INamedProp)((Object)prop));
        }
        return changes;
    }

    private static void insertUndoOp(MerlinData md, OccProfile prof) {
        Collection<EgressAgent> agents = ProfilesPanel.getAgentsUsing(md, prof);
        Op op = new Op(prof, prof.getRestoreObj(), md.selection.isSelected(prof), agents);
        Undo.insertEntry(md, op);
        ProfilesPanel.updateAgents(agents);
    }

    private static Collection<EgressAgent> getAgentsUsing(MerlinData md, OccProfile profile) {
        ArrayList<EgressAgent> agents = new ArrayList<EgressAgent>();
        for (EgressAgent agent : md.agents.getDeepMembers(EgressAgent.class)) {
            if (agent.getProfile().getProfParent() != profile) continue;
            agents.add(agent);
        }
        return agents;
    }

    private static void updateAgents(Collection<EgressAgent> agents) {
        for (EgressAgent agent : agents) {
            agent.updateProps();
        }
    }

    public static boolean checkReset(Component comp, String valType) {
        int option = JOptionPane.showConfirmDialog(SwingUtilities.getWindowAncestor(comp), String.format("<html>" + Intl.intl("Are you sure you want to reset to the default <b>%s</b> values?") + "</html>", valType), Intl.intl("Confirm Reset"), 0);
        return option == 0;
    }

    private static IValEditor<OccProfile> newSpeedEditor() {
        Predicate<OccProfile> isAdvanced = prof -> ADVANCED_SPEED_PROPS.stream().anyMatch(prop -> prop != OccProfile.PROP_MAXVEL && !Objects.equals(prof.getProperty(prop), prop.defVal));
        Collection<MultiValEditor.Entry<ICurve, ? extends ICurve>> curveEntries = VerboseCurveEditor.getEntries(5, 15, false, UnitDoubleVR.above(0.0, SIUS.unit(5), true));
        ArrayList speedEntries = new ArrayList();
        for (MultiValEditor.Entry<ICurve, ? extends ICurve> entry : curveEntries) {
            MultiValEditor.Entry<OccProfile, OccProfile> newEntry = new MultiValEditor.Entry<OccProfile, OccProfile>(entry.key, entry.tooltip, new ProfileSpeedEditor(entry.editor), prof -> {
                if (prof == null || isAdvanced.test((OccProfile)prof)) {
                    return false;
                }
                ICurve curve = prof.getProperty(OccProfile.PROP_MAXVEL);
                return entry.editor.getType().isInstance(curve) && entry.filter.test(curve);
            }, entry.init, prof -> {
                OccProfile result = new OccProfile();
                ICurve newCurve = (ICurve)entry.converter.apply(prof.getProperty(OccProfile.PROP_MAXVEL));
                result.setProperty(OccProfile.PROP_MAXVEL, newCurve);
                return result;
            });
            speedEntries.add(newEntry);
        }
        PopupValEditor<OccProfile> advSpeedEditor = new PopupValEditor<OccProfile>(PopupValEditor.Mode.BUTTON, OccProfile.class, Intl.intl("Advanced Speed Properties"), () -> new AdvancedSpeedEditor(), profile -> AdvancedSpeedEditor.format(profile));
        speedEntries.add(new MultiValEditor.Entry<OccProfile, OccProfile>(Intl.intl("Advanced"), "<html>" + Intl.intl("Enter advanced speed properties, such as the speed-density profile<br>and ramp and stair speeds."), advSpeedEditor, o -> o != null, () -> advSpeedEditor.editValue(), o -> o));
        return new MultiValEditor(OccProfile.class, speedEntries, false);
    }

    private static guiLabel newLabel(Function1dProp prop) {
        guiLabel lbl = new guiLabel(prop.desc + ":");
        if (prop.longDesc != null) {
            lbl.setToolTipText(prop.longDesc);
        }
        return lbl;
    }

    private static <T> IUrn<T> toUrn(T value) {
        return new Urn<Object>(value);
    }

    private static class AdvancedPanel
    extends guiPanel {
        private static final long serialVersionUID = 1L;
        private static final String TITLE = Intl.intl("Advanced");
        private final IValEditor<ICurve> d_persist;
        private final IValEditor<ICurve> d_collResponseTime;
        private final IValEditor<ICurve> d_slowFactor;
        private final IValEditor<ICurve> d_accelTime;
        private final IValEditor<ICurve> d_boundaryLayer;
        private final PersonalDistanceEditor d_spacingPnl;
        private final IValEditor<ICurve> d_socialDist;
        private final SpeedInSmokeEditor d_velSmokePnl;
        private final JButton d_resetBtn = new JButton(Intl.intl("Reset to Defaults..."));

        public AdvancedPanel() {
            this.d_resetBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    if (!ProfilesPanel.checkReset(this, TITLE)) {
                        return;
                    }
                    this.init(new OccProfile());
                    this.setModified(true);
                }
            });
            MerlinData md = MerlinApp.getAppData();
            Function<INamedProp, guiLabel> lbl = prop -> ProfilesPanel.newLbl(String.format(Intl.intl("%s:"), prop.getDisplayName()), prop.getDisplayDesc());
            guiLabel accelLbl = lbl.apply(OccProfile.PROP_ACCEL_TIME);
            this.d_accelTime = OccProfile.PROP_ACCEL_TIME.getValEditor.get(md, false);
            guiLabel persistLbl = ProfilesPanel.newLbl(Intl.intl("Persist Time:"), OccProfile.PROP_PERSIST_TIME.description);
            this.d_persist = OccProfile.PROP_PERSIST_TIME.getValEditor.get(md, false);
            guiLabel collResponseTimeLbl = ProfilesPanel.newLbl(Intl.intl("Collision Response Time:"), OccProfile.PROP_COLLISION_RESPONSE_TIME.description);
            this.d_collResponseTime = OccProfile.PROP_COLLISION_RESPONSE_TIME.getValEditor.get(md, false);
            guiLabel slowFactorLbl = ProfilesPanel.newLbl(Intl.intl("Slow Factor:"), OccProfile.PROP_SLOW_FACTOR.description);
            this.d_slowFactor = OccProfile.PROP_SLOW_FACTOR.getValEditor.get(md, false);
            guiLabel blayerLbl = ProfilesPanel.newLbl(Intl.intl("Wall Boundary Layer:"), OccProfile.PROP_BOUNDARY_LAYER.description);
            this.d_boundaryLayer = OccProfile.PROP_BOUNDARY_LAYER.getValEditor.get(md, false);
            guiLabel spacingLbl = ProfilesPanel.newLbl(Intl.intl("Personal Distance:"), OccProfile.PROP_SPACING.description);
            this.d_spacingPnl = new PersonalDistanceEditor(this.getComm());
            guiLabel socialDistLbl = ProfilesPanel.newLbl(Intl.intl("Social Distancing:"), OccProfile.PROP_SOCIAL_DIST.description);
            this.d_socialDist = OccProfile.PROP_SOCIAL_DIST.getValEditor.get(md, false);
            guiLabel speedVisFuncLbl = lbl.apply(OccProfile.PROP_SPEED_IN_SMOKE);
            this.d_velSmokePnl = new SpeedInSmokeEditor(this.getComm());
            GridBagHelper gb = new GridBagHelper(this);
            gb.addRow(accelLbl, this.d_accelTime, 1.0, 0);
            gb.addRow(persistLbl, this.d_persist, 1.0, 0);
            gb.addRow(collResponseTimeLbl, this.d_collResponseTime, 1.0, 0);
            gb.addRow(slowFactorLbl, this.d_slowFactor, 1.0, 0);
            gb.addRow(blayerLbl, this.d_boundaryLayer, 1.0, 0);
            gb.addRow(socialDistLbl, this.d_socialDist, 1.0, 0);
            gb.addRow(spacingLbl, this.d_spacingPnl, 1.0, 0);
            gb.addRow(speedVisFuncLbl, this.d_velSmokePnl, 1.0, 0);
            gb.addRow(Box.createGlue(), new double[]{0.0, 1.0});
            gb.addRow(this.d_resetBtn, 0);
        }

        public void init(OccProfile dataObj) {
            assert (dataObj != null);
            this.d_accelTime.setValue(dataObj.getProperty(OccProfile.PROP_ACCEL_TIME));
            this.d_collResponseTime.setValue(dataObj.getProperty(OccProfile.PROP_COLLISION_RESPONSE_TIME));
            this.d_persist.setValue(dataObj.getProperty(OccProfile.PROP_PERSIST_TIME));
            this.d_slowFactor.setValue(dataObj.getProperty(OccProfile.PROP_SLOW_FACTOR));
            this.d_boundaryLayer.setValue(dataObj.getProperty(OccProfile.PROP_BOUNDARY_LAYER));
            this.d_spacingPnl.setValue(dataObj.getProperty(OccProfile.PROP_SPACING));
            this.d_socialDist.setValue(dataObj.getProperty(OccProfile.PROP_SOCIAL_DIST));
            this.d_velSmokePnl.setValue(dataObj.getProperty(OccProfile.PROP_SPEED_IN_SMOKE));
            this.setModified(false);
        }

        public OccProfile commit(OccProfile dataObj, boolean changeModified) {
            assert (dataObj != null);
            dataObj.setIfNotDefault(OccProfile.PROP_ACCEL_TIME, this.d_accelTime.getValue());
            dataObj.setIfNotDefault(OccProfile.PROP_COLLISION_RESPONSE_TIME, this.d_collResponseTime.getValue());
            dataObj.setIfNotDefault(OccProfile.PROP_PERSIST_TIME, this.d_persist.getValue());
            dataObj.setIfNotDefault(OccProfile.PROP_SLOW_FACTOR, this.d_slowFactor.getValue());
            dataObj.setIfNotDefault(OccProfile.PROP_BOUNDARY_LAYER, this.d_boundaryLayer.getValue());
            dataObj.setIfNotDefault(OccProfile.PROP_SPACING, this.d_spacingPnl.getValue());
            dataObj.setIfNotDefault(OccProfile.PROP_SOCIAL_DIST, this.d_socialDist.getValue());
            dataObj.setIfNotDefault(OccProfile.PROP_SPEED_IN_SMOKE, this.d_velSmokePnl.getValue());
            if (changeModified) {
                this.setModified(false);
            }
            return dataObj;
        }
    }

    public static enum CorridorType {
        STAIR(Intl.intl("Stair")),
        RAMP(Intl.intl("Ramp"));

        public final String desc;

        private CorridorType(String desc) {
            this.desc = desc;
        }
    }

    private static class DoorChoicePanel
    extends guiPanel {
        private static final long serialVersionUID = 1L;
        private static final String TITLE = Intl.intl("Door Choice");
        private final IValEditor<ICurve> d_localTime;
        private final IValEditor<ICurve> d_queueTime;
        private final IValEditor<ICurve> d_tailTime;
        private final IValEditor<ICurve> d_elevatorWaitTime;
        private final IValEditor<ICurve> d_currDoorPref;
        private final IValEditor<ICurve> d_doubleDist;
        private final JButton d_resetBtn;

        public DoorChoicePanel() {
            MerlinData md = MerlinApp.getAppData();
            this.d_resetBtn = new JButton(Intl.intl("Reset to Defaults..."));
            this.d_resetBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    if (!ProfilesPanel.checkReset(this, TITLE)) {
                        return;
                    }
                    this.init(new OccProfile());
                    this.setModified(true);
                }
            });
            guiLabel localTimeLbl = ProfilesPanel.newLbl(Intl.intl("Current Room Travel Time:"), OccProfile.PROP_LOCAL_TRAVEL_TIME_FACTOR.description);
            this.d_localTime = OccProfile.PROP_LOCAL_TRAVEL_TIME_FACTOR.getValEditor.get(md, false);
            guiLabel queueLbl = ProfilesPanel.newLbl(Intl.intl("Current Room Queue Time:"), OccProfile.PROP_LOCAL_QUEUE_TIME_FACTOR.description);
            this.d_queueTime = OccProfile.PROP_LOCAL_QUEUE_TIME_FACTOR.getValEditor.get(md, false);
            guiLabel tailLbl = ProfilesPanel.newLbl(Intl.intl("Global Travel Time:"), OccProfile.PROP_TAIL_TIME_FACTOR.description);
            this.d_tailTime = OccProfile.PROP_TAIL_TIME_FACTOR.getValEditor.get(md, false);
            guiLabel elevatorWaitTimeLbl = ProfilesPanel.newLbl(Intl.intl("Elevator Wait Time:"), OccProfile.PROP_ELEVATOR_WAIT_TIME.description);
            this.d_elevatorWaitTime = OccProfile.PROP_ELEVATOR_WAIT_TIME.getValEditor.get(md, false);
            guiLabel currDoorPrefLbl = ProfilesPanel.newLbl(Intl.intl("Current Door Preference:"), OccProfile.PROP_CURR_DOOR_PREF.description);
            this.d_currDoorPref = OccProfile.PROP_CURR_DOOR_PREF.getValEditor.get(md, false);
            guiLabel doubleLbl = ProfilesPanel.newLbl(Intl.intl("Current Room Distance Penalty:"), OccProfile.PROP_CURRENT_ROOM_DIST_PENALTY.description);
            this.d_doubleDist = OccProfile.PROP_CURRENT_ROOM_DIST_PENALTY.getValEditor.get(md, false);
            GridBagHelper gb = new GridBagHelper(this);
            gb.addFilledRow(new TitleSeparator(Intl.intl("Cost Factors")));
            gb.indent();
            gb.addRow(localTimeLbl, this.d_localTime, 1.0, 0);
            gb.addRow(queueLbl, this.d_queueTime, 1.0, 0);
            gb.addRow(tailLbl, this.d_tailTime, 1.0, 0);
            gb.addRow(elevatorWaitTimeLbl, this.d_elevatorWaitTime, 1.0, 0);
            gb.unindent();
            gb.addFilledRow(new TitleSeparator(Intl.intl("Advanced")));
            gb.indent();
            gb.addRow(currDoorPrefLbl, this.d_currDoorPref, 1.0, 0);
            gb.addRow(doubleLbl, this.d_doubleDist, 1.0, 0);
            gb.addRow(Box.createGlue(), new double[]{0.0, 1.0});
            gb.unindent();
            gb.addRow(this.d_resetBtn, 0);
        }

        public void init(OccProfile dataObj) {
            assert (dataObj != null);
            this.d_localTime.setValue(dataObj.getProperty(OccProfile.PROP_LOCAL_TRAVEL_TIME_FACTOR));
            this.d_queueTime.setValue(dataObj.getProperty(OccProfile.PROP_LOCAL_QUEUE_TIME_FACTOR));
            this.d_tailTime.setValue(dataObj.getProperty(OccProfile.PROP_TAIL_TIME_FACTOR));
            this.d_elevatorWaitTime.setValue(dataObj.getProperty(OccProfile.PROP_ELEVATOR_WAIT_TIME));
            this.d_currDoorPref.setValue(dataObj.getProperty(OccProfile.PROP_CURR_DOOR_PREF));
            this.d_doubleDist.setValue(dataObj.getProperty(OccProfile.PROP_CURRENT_ROOM_DIST_PENALTY));
            this.setModified(false);
        }

        public OccProfile commit(OccProfile dataObj, boolean changeModified) {
            assert (dataObj != null);
            dataObj.setIfNotDefault(OccProfile.PROP_LOCAL_TRAVEL_TIME_FACTOR, this.d_localTime.getValue());
            dataObj.setIfNotDefault(OccProfile.PROP_LOCAL_QUEUE_TIME_FACTOR, this.d_queueTime.getValue());
            dataObj.setIfNotDefault(OccProfile.PROP_TAIL_TIME_FACTOR, this.d_tailTime.getValue());
            dataObj.setIfNotDefault(OccProfile.PROP_ELEVATOR_WAIT_TIME, this.d_elevatorWaitTime.getValue());
            dataObj.setIfNotDefault(OccProfile.PROP_CURR_DOOR_PREF, this.d_currDoorPref.getValue());
            dataObj.setIfNotDefault(OccProfile.PROP_CURRENT_ROOM_DIST_PENALTY, this.d_doubleDist.getValue());
            if (changeModified) {
                this.setModified(false);
            }
            return dataObj;
        }
    }

    private static class OutputPanel
    extends guiPanel {
        private static final long serialVersionUID = 1L;
        private static final String TITLE = Intl.intl("Output");
        private final guiCheckBox d_extraOutput = new guiCheckBox(Intl.intl("Print CSV Data"), false);

        public OutputPanel() {
            GridBagHelper gb = new GridBagHelper(this);
            gb.addRow(this.d_extraOutput, 0);
            gb.finalizeRows();
        }

        public void init(OccProfile dataObj) {
            assert (dataObj != null);
            this.d_extraOutput.setSelected(UrnUtil.getDominant(dataObj.getProperty(OccProfile.PROP_PRINT_EXTRA_OUTPUT)));
            ProfilesPanel.setTooltip(this.d_extraOutput, OccProfile.PROP_PRINT_EXTRA_OUTPUT.description);
            this.setModified(false);
        }

        public OccProfile commit(OccProfile dataObj, boolean changeModified) {
            assert (dataObj != null);
            dataObj.setIfNotDefault(OccProfile.PROP_PRINT_EXTRA_OUTPUT, ProfilesPanel.toUrn(this.d_extraOutput.isSelected()));
            if (changeModified) {
                this.setModified(false);
            }
            return dataObj;
        }

        @Override
        public boolean validateData(boolean showWarn, boolean allowModify) {
            if (!super.validateData(showWarn, allowModify)) {
                return false;
            }
            if (this.d_extraOutput.isModified() && this.d_extraOutput.isSelected() && showWarn) {
                String msg = Intl.intl("WARNING: Enabling CSV output for many occupants may use significant computing\nresources and/or disk space during simulation. Are you sure you want to enable\nthis feature?");
                int opt = JOptionPane.showConfirmDialog(SwingUtilities.getWindowAncestor(this), msg, Intl.intl("CSV Output"), 0, 2);
                if (opt != 0) {
                    return false;
                }
            }
            return true;
        }
    }

    private static class MovementPanel
    extends guiPanel {
        private static final long serialVersionUID = 1L;
        private static final String TITLE = Intl.intl("Movement");
        private final JButton d_resetBtn;
        private final guiCheckBox d_assisted;
        private final guiCheckBox d_requiresAssistance;
        private final guiCheckBox d_ignoreOnewayDoors;
        private final guiComboBox<EscalatorPreference> d_escalatorPreference;
        private final IValEditor<ICurve> d_orient;
        private final IValEditor<ICurve> d_attractorSuscSeek;
        private final IValEditor<ICurve> d_attractorSuscWait;
        private final AttractorsFilterEditorComponents d_attrRestrictions;

        public MovementPanel() {
            MerlinData md = MerlinApp.getApp().getData();
            guiLabel orientLbl = new guiLabel(Intl.intl("Initial Orientation:"));
            orientLbl.setToolTipText(OccProfile.PROP_INIT_ORIENT.description);
            this.d_orient = OccProfile.PROP_INIT_ORIENT.getValEditor.get(md, false);
            this.d_assisted = new guiCheckBox(Intl.intl("Requires Assistance"), false);
            this.d_assisted.setToolTipText(OccProfile.PROP_ASSIST.description);
            this.d_requiresAssistance = new guiCheckBox(Intl.intl("Requires Assistance to Move"), false);
            ProfilesPanel.setTooltip(this.d_requiresAssistance, OccProfile.PROP_REQUIRES_ASSISTANCE.description);
            this.d_ignoreOnewayDoors = new guiCheckBox(Intl.intl("Ignore One-way Door Restrictions"), true);
            String ignoreOnewayTT = OccProfile.PROP_OBEY_ONEWAY_DOORS.description;
            ProfilesPanel.setTooltip(this.d_ignoreOnewayDoors, ignoreOnewayTT);
            guiLabel escalatorPrefLabel = new guiLabel(Intl.intl("Escalator Preference:"));
            this.d_escalatorPreference = guiUtil.newCombo(val -> new Pair<String, Object>(val.name, null), EscalatorPreference.values());
            escalatorPrefLabel.setToolTipText(OccProfile.PROP_ESCALATOR_PREF.description);
            this.d_attractorSuscSeek = OccProfile.PROP_ATTRACTOR_SUSCEPTIBILITY_SEEK.getValEditor.get(md, false);
            this.d_attractorSuscWait = OccProfile.PROP_ATTRACTOR_SUSCEPTIBILITY_IDLE.getValEditor.get(md, false);
            this.d_attrRestrictions = new AttractorsFilterEditorComponents(md, true);
            this.d_resetBtn = new JButton(Intl.intl("Reset to Defaults..."));
            this.d_resetBtn.addActionListener(evt -> {
                if (!ProfilesPanel.checkReset(this, TITLE)) {
                    return;
                }
                this.init(new OccProfile());
                this.setModified(true);
            });
            GridBagHelper gb = new GridBagHelper(this);
            if (MerlinApp.isFP()) {
                gb.addRow(this.d_assisted, 1.0, 0);
            }
            gb.addRow(orientLbl, this.d_orient, 1.0, 0);
            gb.addRow(this.d_requiresAssistance, 0);
            gb.addRow(this.d_ignoreOnewayDoors, 0);
            gb.addRow(escalatorPrefLabel, this.d_escalatorPreference, 0);
            gb.addRow(guiUtil.lbl(OccProfile.PROP_ATTRACTOR_SUSCEPTIBILITY_SEEK.displayName, OccProfile.PROP_ATTRACTOR_SUSCEPTIBILITY_SEEK.getHtmlDescr()), this.d_attractorSuscSeek, 0);
            gb.addRow(guiUtil.lbl(OccProfile.PROP_ATTRACTOR_SUSCEPTIBILITY_IDLE.displayName, OccProfile.PROP_ATTRACTOR_SUSCEPTIBILITY_IDLE.getHtmlDescr()), this.d_attractorSuscWait, 0);
            this.d_attrRestrictions.addToLayout(gb);
            gb.addRow(Box.createGlue(), new double[]{0.0, 1.0});
            gb.addRow(this.d_resetBtn, 0);
        }

        @Override
        public boolean validateData(boolean showWarn, boolean allowModify) {
            if (!super.validateData(showWarn, allowModify)) {
                return false;
            }
            return this.d_attrRestrictions.validateData(this, showWarn, allowModify);
        }

        public void init(OccProfile dataObj) {
            assert (dataObj != null);
            this.d_orient.setValue(dataObj.getProperty(OccProfile.PROP_INIT_ORIENT));
            this.d_assisted.setSelected(UrnUtil.getDominant(dataObj.getProperty(OccProfile.PROP_ASSIST)));
            this.d_requiresAssistance.setSelected(UrnUtil.getDominant(dataObj.getProperty(OccProfile.PROP_REQUIRES_ASSISTANCE)));
            this.d_ignoreOnewayDoors.setSelected(UrnUtil.getDominant(dataObj.getProperty(OccProfile.PROP_OBEY_ONEWAY_DOORS)) == false);
            this.d_escalatorPreference.setSelectedItem((Object)UrnUtil.getDominant(dataObj.getProperty(OccProfile.PROP_ESCALATOR_PREF)));
            this.d_attractorSuscSeek.setValue(dataObj.getProperty(OccProfile.PROP_ATTRACTOR_SUSCEPTIBILITY_SEEK));
            this.d_attractorSuscWait.setValue(dataObj.getProperty(OccProfile.PROP_ATTRACTOR_SUSCEPTIBILITY_IDLE));
            this.d_attrRestrictions.setValue(dataObj.getProperty(OccProfile.PROP_ATTRACTOR_RESTRICTIONS));
            this.setModified(false);
        }

        public void commit(OccProfile dataObj, boolean changeModified) {
            assert (dataObj != null);
            dataObj.setIfNotDefault(OccProfile.PROP_ASSIST, ProfilesPanel.toUrn(this.d_assisted.isSelected()));
            dataObj.setIfNotDefault(OccProfile.PROP_REQUIRES_ASSISTANCE, ProfilesPanel.toUrn(this.d_requiresAssistance.isSelected()));
            dataObj.setIfNotDefault(OccProfile.PROP_OBEY_ONEWAY_DOORS, ProfilesPanel.toUrn(!this.d_ignoreOnewayDoors.isSelected()));
            dataObj.setIfNotDefault(OccProfile.PROP_ESCALATOR_PREF, ProfilesPanel.toUrn(this.d_escalatorPreference.getSelectedItem()));
            dataObj.setIfNotDefault(OccProfile.PROP_INIT_ORIENT, this.d_orient.getValue());
            dataObj.setIfNotDefault(OccProfile.PROP_ATTRACTOR_SUSCEPTIBILITY_SEEK, this.d_attractorSuscSeek.getValue());
            dataObj.setIfNotDefault(OccProfile.PROP_ATTRACTOR_SUSCEPTIBILITY_IDLE, this.d_attractorSuscWait.getValue());
            dataObj.setIfNotDefault(OccProfile.PROP_ATTRACTOR_RESTRICTIONS, this.d_attrRestrictions.getValue());
            if (changeModified) {
                this.setModified(false);
            }
        }
    }

    public static class RestrictionsPanel
    extends guiPanel {
        private static final long serialVersionUID = 1L;
        public static final String TITLE = Intl.intl("Restrictions");
        private final JButton d_resetBtn;
        private final CompRestrictionsPanel d_restrictionsPnl = new CompRestrictionsPanel();

        public RestrictionsPanel() {
            this.d_resetBtn = new JButton(Intl.intl("Reset to Defaults..."));
            this.d_resetBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    if (!ProfilesPanel.checkReset(this, TITLE)) {
                        return;
                    }
                    this.init(new OccProfile());
                    this.setModified(true);
                }
            });
            GridBagHelper gb = new GridBagHelper(this);
            this.d_restrictionsPnl.addToLayout(gb);
            gb.addRow(Box.createGlue(), new double[]{0.0, 1.0});
            gb.addRow(this.d_resetBtn, 0);
        }

        public void init(OccProfile dataObj) {
            this.d_restrictionsPnl.init(dataObj);
        }

        public void commit(OccProfile dataObj, boolean changeModified) {
            assert (dataObj != null);
            dataObj.setIfNotDefault(OccProfile.PROP_RESTRICTED_COMPONENTS, this.d_restrictionsPnl.commit());
            if (changeModified) {
                this.setModified(false);
            }
        }
    }

    private static class SlopedSpeedEditor
    extends guiPanel {
        private static final long serialVersionUID = 1L;
        private final Function1dProp d_upSpeedProp;
        private final OccProfile.ProfileFunctionProp d_upFundProp;
        private final Function1dProp d_downSpeedProp;
        private final OccProfile.ProfileFunctionProp d_downFundProp;
        private final IValEditor<IFunction1d> d_upEditor;
        private final IValEditor<OccProfile.IProfileFunction> d_upFundEditor;
        private final IValEditor<IFunction1d> d_downEditor;
        private final IValEditor<OccProfile.IProfileFunction> d_downFundEditor;

        public SlopedSpeedEditor(String compDesc, Supplier<IFunction1d> levelFund, Function1dProp upSpeedProp, OccProfile.ProfileFunctionProp upFundProp, Function1dProp downSpeedProp, OccProfile.ProfileFunctionProp downFundProp, IFunction1d sfpeFunc) {
            this.d_upSpeedProp = upSpeedProp;
            this.d_upFundProp = upFundProp;
            this.d_downSpeedProp = downSpeedProp;
            this.d_downFundProp = downFundProp;
            this.d_upEditor = this.registerEd(Function1dEditorFactory.nonNullable(upSpeedProp, false, () -> null, Function1dEditorFactory.GENERAL_TYPES));
            this.d_upFundEditor = this.registerEd(OccProfile.newSlopedFundEditor(this.d_upFundProp, levelFund));
            this.d_downEditor = this.registerEd(Function1dEditorFactory.nonNullable(downSpeedProp, false, () -> null, Function1dEditorFactory.GENERAL_TYPES));
            this.d_downFundEditor = this.registerEd(OccProfile.newSlopedFundEditor(this.d_downFundProp, levelFund));
            guiLabel fracUp = ProfilesPanel.newLabel(upSpeedProp);
            guiLabel densUp = ProfilesPanel.newLabel(upFundProp.fprop);
            guiLabel fracDown = ProfilesPanel.newLabel(downSpeedProp);
            guiLabel densDown = ProfilesPanel.newLabel(downFundProp.fprop);
            GridBagHelper gb = new GridBagHelper(this);
            gb.add(fracUp);
            this.d_upEditor.add(gb);
            gb.nextRow();
            gb.add(densUp);
            this.d_upFundEditor.add(gb);
            gb.nextRow();
            gb.add(fracDown);
            this.d_downEditor.add(gb);
            gb.nextRow();
            gb.add(densDown);
            this.d_downFundEditor.add(gb);
            gb.nextRow();
            gb.finalizeRows();
        }

        private <T extends IValEditor<?>> T registerEd(T editor) {
            editor.addValueListener(e -> this.firePropertyChange("value", e.getOldValue(), e.getNewValue()));
            return editor;
        }

        public void load(OccProfile profile) {
            this.d_upEditor.setValue(profile.getProperty(this.d_upSpeedProp));
            this.d_upFundEditor.setValue(profile.getProperty(this.d_upFundProp));
            this.d_downEditor.setValue(profile.getProperty(this.d_downSpeedProp));
            this.d_downFundEditor.setValue(profile.getProperty(this.d_downFundProp));
        }

        public void save(OccProfile profile) {
            profile.setIfNotDefault(this.d_upSpeedProp, this.d_upEditor.getValue());
            profile.setIfNotDefault(this.d_upFundProp, this.d_upFundEditor.getValue());
            profile.setIfNotDefault(this.d_downSpeedProp, this.d_downEditor.getValue());
            profile.setIfNotDefault(this.d_downFundProp, this.d_downFundEditor.getValue());
        }
    }

    private static class AdvancedSpeedEditor
    extends AValEditor<OccProfile> {
        private static final long serialVersionUID = 1L;
        private final VerboseCurveEditor d_levelSpeed = this.registerEd(new VerboseCurveEditor(5, false));
        private final IValEditor<IFunction1d> d_levelFundamental = this.registerEd(Function1dEditorFactory.nonNullable(OccProfile.PROP_FUNDAMENTAL, false, () -> null, Function1dEditorFactory.GENERAL_TYPES));
        private final SlopedSpeedEditor d_stairEditor;
        private final SlopedSpeedEditor d_rampEditor;

        public AdvancedSpeedEditor() {
            super(OccProfile.class);
            guiPanel levelPnl = new guiPanel();
            GridBagHelper gb = new GridBagHelper(levelPnl, true);
            gb.add(Intl.intl("Speed:"));
            this.d_levelSpeed.add(gb);
            gb.nextRow();
            gb.add(ProfilesPanel.newLabel(OccProfile.PROP_FUNDAMENTAL));
            this.d_levelFundamental.add(gb);
            gb.nextRow();
            gb.finalizeRows();
            this.d_stairEditor = this.registerEd(new SlopedSpeedEditor(Intl.intl("Stair"), () -> this.d_levelFundamental.getValue(), OccProfile.PROP_STAIR_SPEED_UP, OccProfile.PROP_STAIR_FUNDAMENTAL_UP, OccProfile.PROP_STAIR_SPEED_DOWN, OccProfile.PROP_STAIR_FUNDAMENTAL_DOWN, OccProfile.SFPE_STAIR_FUNCTION));
            this.d_rampEditor = this.registerEd(new SlopedSpeedEditor(Intl.intl("Ramp"), () -> this.d_levelFundamental.getValue(), OccProfile.PROP_RAMP_SPEED_UP, OccProfile.PROP_RAMP_FUNDAMENTAL_UP, OccProfile.PROP_RAMP_SPEED_DOWN, OccProfile.PROP_RAMP_FUNDAMENTAL_DOWN, OccProfile.SFPE_RAMP_FUNCTION));
            guiPanel stairsPnl = new guiPanel();
            gb = new GridBagHelper(stairsPnl, true);
            gb.addFilledRow(this.d_stairEditor);
            gb.finalizeRows();
            guiPanel rampsPnl = new guiPanel();
            gb = new GridBagHelper(rampsPnl, true);
            gb.addFilledRow(this.d_rampEditor);
            gb.finalizeRows();
            JTabbedPane tabs = new JTabbedPane();
            tabs.addTab(Intl.intl("Level Terrain"), levelPnl);
            tabs.addTab(Intl.intl("Stairs"), stairsPnl);
            tabs.addTab(Intl.intl("Ramps"), rampsPnl);
            JButton resetButton = new JButton(Intl.intl("Reset to Defaults..."));
            resetButton.setToolTipText(Intl.intl("Resets the advanced speed properties."));
            resetButton.addActionListener(e -> {
                if (!ProfilesPanel.checkReset(this, Intl.intl("Speed"))) {
                    return;
                }
                this.setValue(new OccProfile());
            });
            gb = new GridBagHelper(this);
            gb.addFilledRow(tabs);
            gb.addFilledRow("<html>" + Intl.intl("NOTE: When simulating in SFPE mode, all advanced speed properties are ignored except for <i>Speed</i>."));
            gb.addRow(resetButton, 0);
            gb.finalizeRows();
        }

        @Override
        protected void updateValue() {
            super.updateValue();
        }

        @Override
        public void add(GridBagHelper gb) {
            gb.add(this, 1.0);
        }

        @Override
        protected void loadValue(OccProfile value) {
            this.d_levelSpeed.setValue(value.getProperty(OccProfile.PROP_MAXVEL));
            this.d_levelFundamental.setValue(value.getProperty(OccProfile.PROP_FUNDAMENTAL));
            this.d_stairEditor.load(value);
            this.d_rampEditor.load(value);
        }

        @Override
        protected OccProfile saveValue() {
            OccProfile adv = new OccProfile();
            adv.setIfNotDefault(OccProfile.PROP_MAXVEL, (ICurve)this.d_levelSpeed.getValue());
            adv.setIfNotDefault(OccProfile.PROP_FUNDAMENTAL, this.d_levelFundamental.getValue());
            this.d_stairEditor.save(adv);
            this.d_rampEditor.save(adv);
            return adv;
        }

        public static String format(OccProfile adv) {
            StringBuilder str = new StringBuilder();
            str.append(String.format(Intl.intl("Speed=%s"), guiCurveUtil.format(adv.getProperty(OccProfile.PROP_MAXVEL))));
            if (AdvancedSpeedEditor.isCustom(adv, OccProfile.PROP_FUNDAMENTAL)) {
                str.append("; ");
                str.append(Intl.intl("Custom speed-density profile"));
            }
            if (AdvancedSpeedEditor.isCustom(adv, OccProfile.PROP_STAIR_FUNDAMENTAL_DOWN, OccProfile.PROP_STAIR_FUNDAMENTAL_UP, OccProfile.PROP_STAIR_SPEED_DOWN, OccProfile.PROP_STAIR_SPEED_UP)) {
                str.append("; ");
                str.append(Intl.intl("Custom stair speed"));
            }
            if (AdvancedSpeedEditor.isCustom(adv, OccProfile.PROP_RAMP_FUNDAMENTAL_DOWN, OccProfile.PROP_RAMP_FUNDAMENTAL_UP, OccProfile.PROP_RAMP_SPEED_DOWN, OccProfile.PROP_RAMP_SPEED_UP)) {
                str.append("; ");
                str.append(Intl.intl("Custom ramp speed"));
            }
            return str.toString();
        }

        private static boolean isCustom(OccProfile profile, IPropertySet.Prop<?> ... props) {
            for (IPropertySet.Prop<?> prop : props) {
                if (Objects.equals(profile.getProperty(prop), prop.defVal)) continue;
                return true;
            }
            return false;
        }
    }

    private static class ProfileSpeedEditor
    extends AValEditor<OccProfile> {
        private static final long serialVersionUID = 1L;
        private final IValEditor<? extends ICurve> d_curveEditor;

        public ProfileSpeedEditor(IValEditor<? extends ICurve> curveEditor) {
            super(OccProfile.class);
            this.d_curveEditor = curveEditor;
            this.d_curveEditor.addValueListener(e -> this.updateValue());
            this.add(this.d_curveEditor.getComponent());
        }

        @Override
        public void add(GridBagHelper gb) {
            gb.add(this.d_curveEditor.getComponent(), 1.0);
        }

        @Override
        protected void loadValue(OccProfile value) {
            this.d_curveEditor.setValue(value.getProperty(OccProfile.PROP_MAXVEL));
        }

        @Override
        protected OccProfile saveValue() {
            OccProfile result = new OccProfile();
            result.setProperty(OccProfile.PROP_MAXVEL, this.d_curveEditor.getValue());
            return result;
        }
    }

    private static class CharPanel
    extends guiPanel {
        private static final long serialVersionUID = 1L;
        private static final String TITLE = Intl.intl("Characteristics");
        private final IValEditor<OccProfile> d_speed;
        private final guiIntField d_priorityFld;
        private final JButton d_resetBtn;
        private final ShapeEditor.ShapePnl d_shapePnl;

        public CharPanel() {
            guiLabel speedLbl = ProfilesPanel.newLbl(Intl.intl("Speed:"), Intl.intl("The occupant's maximum velocity"));
            this.d_speed = ProfilesPanel.newSpeedEditor();
            guiLabel priorityLbl = ProfilesPanel.newLbl(Intl.intl("Priority Level:"), OccProfile.PROP_PRIORITY_LEVEL.description);
            this.d_priorityFld = new guiIntField(IntVR.above(0, true));
            this.d_priorityFld.setColumns(6);
            this.d_shapePnl = new ShapeEditor.ShapePnl(15);
            this.d_resetBtn = new JButton(Intl.intl("Reset to Defaults..."));
            this.d_resetBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    if (!ProfilesPanel.checkReset(this, TITLE)) {
                        return;
                    }
                    this.init(new OccProfile());
                    this.setModified(true);
                }
            });
            GridBagHelper gb = new GridBagHelper(this);
            gb.addRow(new Object[]{priorityLbl, this.d_priorityFld, 1, GridBagHelper.Fill.HORIZONTAL});
            gb.add(speedLbl);
            this.d_speed.add(gb);
            this.d_shapePnl.add(gb, (Component)this);
            gb.addRow(Box.createGlue(), new double[]{0.0, 1.0});
            gb.addRow(this.d_resetBtn, 0);
        }

        public void init(OccProfile dataObj) {
            assert (dataObj != null);
            this.d_speed.setValue(this.getSpeedVal(dataObj));
            this.d_priorityFld.setValue(UrnUtil.getDominant(dataObj.getProperty(OccProfile.PROP_PRIORITY_LEVEL)));
            this.d_shapePnl.load(dataObj.getProperty(OccProfile.PROP_SHAPE));
            this.setModified(false);
        }

        private static <T> IUrn<T> toUrn(T value) {
            return new Urn<Object>(value);
        }

        public void commit(OccProfile dataObj, boolean changeModified) {
            assert (dataObj != null);
            this.saveSpeed(dataObj, this.d_speed.getValue());
            dataObj.setIfNotDefault(OccProfile.PROP_PRIORITY_LEVEL, CharPanel.toUrn((Integer)this.d_priorityFld.getValue()));
            dataObj.setIfNotDefault(OccProfile.PROP_SHAPE, this.d_shapePnl.save());
            if (changeModified) {
                this.setModified(false);
            }
        }

        private OccProfile getSpeedVal(OccProfile val) {
            OccProfile adv = new OccProfile();
            CharPanel.copyAdvancedVals(val, adv);
            return adv;
        }

        private void saveSpeed(OccProfile val, OccProfile speed) {
            CharPanel.copyAdvancedVals(speed, val);
        }

        private static void copyAdvancedVals(OccProfile src, OccProfile target) {
            for (IPropertySet.Prop<?> prop : ADVANCED_SPEED_PROPS) {
                target.setIfNotDefault(prop, src.getProperty(prop));
            }
        }

        @Override
        public boolean validateData(boolean showWarn, boolean allowModify) {
            if (!super.validateData(showWarn, allowModify)) {
                return false;
            }
            return this.d_shapePnl.validateData(showWarn, allowModify);
        }
    }

    public static class Op
    extends Undo.RestoreOp {
        private Collection<EgressAgent> d_agentsUsing;

        public Op(OccProfile prof, Object restoreObj, boolean selected, Collection<EgressAgent> agentsUsing) {
            super(prof, restoreObj, selected);
            this.d_agentsUsing = agentsUsing;
        }

        @Override
        public Undo.RestoreOp perform(MerlinSelectionModel sel) {
            Undo.RestoreOp op = super.perform(sel);
            ProfilesPanel.updateAgents(this.d_agentsUsing);
            return new Op((OccProfile)op.getObj(), op.getMomento(), op.getSelect(), this.d_agentsUsing);
        }
    }
}

