/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui;

import common.data.IElevatorTimingModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Consumer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import merlin.Intl;
import merlin.data.egress.Floor;
import merlin.data.egress.elevators.Elevator;
import merlin.gui.NewElevatorDlg;
import org.jscience.physics.units.SI;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.table.guiDefaultTableModel;
import thunderheadeng.gui.table.guiTable;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Pair;

public class ElevatorLevelDlg
extends guiDialog {
    private static final long serialVersionUID = -262599694019603607L;
    private IElevatorTimingModel d_timingModel;
    private final Map<Floor, Double> d_distsToPickup;
    private guiTable d_table;
    private guiLabel d_timingModelLabel;
    private JButton d_btnEditTiming;

    public ElevatorLevelDlg(Window parent, Map<Floor, Elevator.LevelData> data, Map<Floor, Double> distsToPickup, IElevatorTimingModel timingModel) {
        super(parent, Intl.intl("Elevator Levels"), 9);
        this.d_distsToPickup = distsToPickup;
        this.d_timingModel = timingModel;
        this.setResizable(true);
        guiDefaultTableModel model = new guiDefaultTableModel(data.size(), 5, false, data.size(), false, 4);
        model.setColumnClass(UnitDouble.class);
        model.setColumnClass(0, Floor.class);
        ArrayList<Map.Entry<Floor, Elevator.LevelData>> sortedFloors = new ArrayList<Map.Entry<Floor, Elevator.LevelData>>(data.entrySet());
        Collections.sort(sortedFloors, (o1, o2) -> ((Floor)o1.getKey()).getWorkingZ().compareTo(((Floor)o2.getKey()).getWorkingZ()));
        for (int m = 0; m < sortedFloors.size(); ++m) {
            Elevator.LevelData ls = (Elevator.LevelData)((Map.Entry)sortedFloors.get(m)).getValue();
            model.setValueAt(((Map.Entry)sortedFloors.get(m)).getKey(), m, 0);
            if (ls == null) continue;
            model.setValueAt(ls.delay, m, 1);
            model.setValueAt(ls.openTime.add(ls.closeTime), m, 2);
        }
        this.d_table = new guiTable((TableModel)model, 0);
        this.d_table.setDefaultRenderer(Floor.class, new DefaultTableCellRenderer(){
            private static final long serialVersionUID = -4522168946834984796L;

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                this.setText(((Floor)value).getName());
                return this;
            }
        });
        this.d_table.setDefaultRenderer(UnitDouble.class, new guiTable.UnitDoubleRenderer());
        this.d_table.setDefaultEditor(UnitDouble.class, new guiTable.UnitDoubleEditor(SI.SECOND));
        this.d_table.setColumnEditable(0, false);
        TableColumnModel tcm = this.d_table.getColumnModel();
        tcm.getColumn(0).setHeaderValue(Intl.intl("Floor"));
        tcm.getColumn(1).setHeaderValue(Intl.intl("Delay"));
        tcm.getColumn(2).setHeaderValue(Intl.intl("Open+Close Time"));
        tcm.getColumn(3).setHeaderValue(Intl.intl("Pickup Time"));
        tcm.getColumn(4).setHeaderValue(Intl.intl("Discharge Time"));
        IElevatorTimingModel initTimingModel = timingModel;
        if (!(initTimingModel instanceof IElevatorTimingModel.DistModel)) {
            this.d_table.removeColumn(tcm.getColumn(4));
            this.d_table.removeColumn(tcm.getColumn(3));
        }
        this.d_table.autoSizeColumns();
        this.d_btnEditTiming = new JButton(Intl.intl("Edit Elevator Timing..."));
        this.d_timingModelLabel = new guiLabel("");
        this.updateButtonBar();
        Consumer<IElevatorTimingModel> loadTimingModel = timMdl -> {
            this.d_timingModelLabel.setText(String.format(Intl.intl("Timing Model: %s"), timMdl != null ? timMdl.getModelName() : "<mixed>"));
            if (initTimingModel instanceof IElevatorTimingModel.DistModel) {
                for (int m = 0; m < sortedFloors.size(); ++m) {
                    Floor floor = (Floor)((Map.Entry)sortedFloors.get(m)).getKey();
                    Double pickupDist = (Double)distsToPickup.get(floor);
                    if (pickupDist == null) continue;
                    UnitDouble pickupTime = new UnitDouble(timMdl.getTime(pickupDist), SI.SECOND);
                    UnitDouble dischargeTime = new UnitDouble(timMdl.getTime(-pickupDist.doubleValue()), SI.SECOND);
                    this.d_table.getModel().setValueAt(pickupTime, m, 3);
                    this.d_table.getModel().setValueAt(dischargeTime, m, 4);
                }
            }
        };
        loadTimingModel.accept(initTimingModel);
        this.d_btnEditTiming.addActionListener(e -> {
            IElevatorTimingModel timMdl;
            guiDialog timingDlg = new guiDialog((Window)this, Intl.intl("Elevator Timing"), 9);
            NewElevatorDlg.TimingPnl timingPnl = new NewElevatorDlg.TimingPnl();
            timingDlg.getDialogPane().add(timingPnl);
            timingPnl.load(this.d_timingModel == null ? IElevatorTimingModel.DEF_MODEL : this.d_timingModel);
            if (timingDlg.doModal() == 1 && (timMdl = timingPnl.save()) != null) {
                this.d_timingModel = timMdl;
                loadTimingModel.accept(timMdl);
                this.d_table.setColumnEditable(3, false);
                this.d_table.setColumnEditable(4, false);
            }
        });
        JScrollPane tablesp = new JScrollPane(this.d_table);
        tablesp.setPreferredSize(new Dimension(tablesp.getPreferredSize().width, 200));
        this.getDialogPane().add((Component)tablesp, "Center");
    }

    private void updateButtonBar() {
        guiPanel buttonPanel = this.getButtonPanel();
        buttonPanel.removeAll();
        buttonPanel.setLayout(new GridBagLayout());
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(6, 11, 11, 10));
        GridBagHelper gbh = new GridBagHelper(buttonPanel);
        gbh.addRow(this.d_timingModelLabel);
        gbh.addRow(this.d_btnEditTiming, Box.createHorizontalGlue(), 1.0, this.getButton(1), this.getButton(8));
        this.getRootPane().setDefaultButton(this.getButton(1));
    }

    @Override
    public boolean validateData(boolean showWarn, boolean allowModify) {
        if (!super.validateData(showWarn, allowModify)) {
            return false;
        }
        int maxColumn = 3;
        for (int m = 0; m < this.d_table.getModel().getRowCount(); ++m) {
            int emptyCount = 0;
            for (int n = 1; n < maxColumn; ++n) {
                Object val = this.d_table.getModel().getValueAt(m, n);
                if (val != null) continue;
                ++emptyCount;
            }
            if (emptyCount <= 0 || emptyCount >= maxColumn - 1) continue;
            if (allowModify) {
                this.d_table.setRowSelectionInterval(m, m);
                this.d_table.setColumnSelectionInterval(1, maxColumn - 1);
            }
            if (showWarn) {
                ElevatorLevelDlg.showInvalidEntryMessage(this, Intl.intl("Delay and Open+Close Time must be completely filled on each row or left empty."));
            }
            return false;
        }
        return true;
    }

    public Map<Floor, Elevator.LevelData> getLevelData() {
        IdentityHashMap<Floor, Elevator.LevelData> levelData = new IdentityHashMap<Floor, Elevator.LevelData>();
        for (int m = 0; m < this.d_table.getModel().getRowCount(); ++m) {
            Floor floor = (Floor)this.d_table.getModel().getValueAt(m, 0);
            UnitDouble delay = (UnitDouble)this.d_table.getModel().getValueAt(m, 1);
            UnitDouble openClose = (UnitDouble)this.d_table.getModel().getValueAt(m, 2);
            if (delay == null || openClose == null) continue;
            UnitDouble halfOpenClose = openClose.scale(0.5);
            levelData.put(floor, new Elevator.LevelData(halfOpenClose, halfOpenClose, delay));
        }
        return levelData;
    }

    public IElevatorTimingModel getTimingModel() {
        if (!(this.d_timingModel instanceof IElevatorTimingModel.DistModel)) {
            return this.d_timingModel;
        }
        IdentityHashMap<Object, Pair<UnitDouble, UnitDouble>> dischargePickupTimeMap = new IdentityHashMap<Object, Pair<UnitDouble, UnitDouble>>();
        for (int m = 0; m < this.d_table.getModel().getRowCount(); ++m) {
            Floor floor = (Floor)this.d_table.getModel().getValueAt(m, 0);
            UnitDouble unitDouble = (UnitDouble)this.d_table.getModel().getValueAt(m, 3);
            UnitDouble discharge = (UnitDouble)this.d_table.getModel().getValueAt(m, 4);
            if (discharge == null || unitDouble == null) {
                return null;
            }
            dischargePickupTimeMap.put(floor, new Pair<UnitDouble, UnitDouble>(unitDouble, discharge));
        }
        if (dischargePickupTimeMap.keySet().stream().anyMatch(f -> !this.d_distsToPickup.containsKey(f))) {
            return null;
        }
        HashMap<Double, Double> distTimeMap = new HashMap<Double, Double>();
        for (Map.Entry entry : dischargePickupTimeMap.entrySet()) {
            Double dist = this.d_distsToPickup.get(entry.getKey());
            assert (dist != null);
            distTimeMap.put(dist, ((UnitDouble)((Pair)entry.getValue()).v1).get(SI.SECOND));
            distTimeMap.put(-dist.doubleValue(), ((UnitDouble)((Pair)entry.getValue()).v2).get(SI.SECOND));
        }
        double defaultVel = distTimeMap.entrySet().stream().filter(e -> (Double)e.getValue() != 0.0).mapToDouble(e -> Math.abs((Double)e.getKey()) / (Double)e.getValue()).average().orElseGet(() -> IElevatorTimingModel.DEF_MODEL.maxVel);
        return new IElevatorTimingModel.DistModel(distTimeMap, defaultVel);
    }
}

