/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayDeque;
import java.util.Observable;
import java.util.Observer;
import java.util.Optional;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import merlin.gui.IPropEditCommand;
import merlin.gui.IPropEditor;
import merlin.util.MerlinProps;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.value.IValEditor;

public abstract class APropEditPanel<PropType extends MerlinProps>
extends guiPanel
implements Observer,
IPropEditor {
    private static final long serialVersionUID = 1L;
    private final MerlinProps.WeakRef<PropType> d_props = new MerlinProps.WeakRef(this);
    private int d_col = 0;
    int d_numSections = 0;
    private final Object[] d_interestingChanges;
    private final IPropEditCommand d_updateToCommand;

    @Override
    public void activate() {
    }

    public <T> Optional<T> getComponent(Class<? extends T> type) {
        if (type.isInstance(this)) {
            return Optional.of(type.cast(this));
        }
        ArrayDeque<Container> open = new ArrayDeque<Container>();
        open.addLast(this);
        while (!open.isEmpty()) {
            Container cont = (Container)open.removeFirst();
            int ccount = cont.getComponentCount();
            for (int m = 0; m < ccount; ++m) {
                Component child = cont.getComponent(m);
                if (type.isInstance(child)) {
                    return Optional.of(type.cast(child));
                }
                if (!(child instanceof Container)) continue;
                open.addLast((Container)child);
            }
        }
        return Optional.empty();
    }

    protected void updateToProps(PropType props) {
    }

    protected void updateFromProps(PropType props) {
    }

    @Override
    public void update(Observable o, Object arg) {
        if (this.props() == null || ((MerlinProps)this.props()).wasSource(this)) {
            return;
        }
        if (this.aPropChanged(this.d_interestingChanges)) {
            this.updateFromProps(this.props());
        }
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public void commit() {
    }

    public APropEditPanel(Object ... interestingChanges) {
        super(new GridBagLayout());
        this.d_interestingChanges = interestingChanges;
        this.d_updateToCommand = new IPropEditCommand(){

            @Override
            public void updateProp(Component c, boolean hardValidate) {
                APropEditPanel.this.componentModified(c, hardValidate);
            }
        };
        this.setBorder(BorderFactory.createEmptyBorder(3, 0, 3, 0));
    }

    protected void componentModified(Component c, boolean hardValidate) {
        if (this.props() == null || !this.validateData(hardValidate, hardValidate)) {
            return;
        }
        APropEditPanel source = hardValidate ? null : this;
        ((MerlinProps)this.props()).pause(source);
        this.updateToProps(this.props());
        ((MerlinProps)this.props()).resume();
    }

    protected IPropEditCommand getUpdateToCommand() {
        return this.d_updateToCommand;
    }

    public void setProps(PropType props) {
        this.d_props.set(props);
        APropEditPanel.setChildProps(this, props);
        if (props == null) {
            return;
        }
        this.updateFromProps(props);
    }

    private static <T extends MerlinProps> void setChildProps(Container parent, T props) {
        int compCount = parent.getComponentCount();
        for (int m = 0; m < compCount; ++m) {
            Component child = parent.getComponent(m);
            if (child instanceof APropEditPanel) {
                ((APropEditPanel)child).setProps(props);
                continue;
            }
            if (!(child instanceof Container)) continue;
            APropEditPanel.setChildProps((Container)child, props);
        }
    }

    public PropType props() {
        return this.d_props.val();
    }

    protected boolean propChanged(Object prop) {
        return ((MerlinProps)this.props()).propChanged(prop);
    }

    protected boolean aPropChanged(Object ... props) {
        return ((MerlinProps)this.props()).aPropChanged(props);
    }

    @Override
    public void removeAll() {
        super.removeAll();
        this.d_numSections = 0;
        this.d_col = 0;
    }

    protected void add(guiPanel p, JComponent comp, int r, int c, int up, int left, int down, int right) {
        GridBagUtil.add(p, comp, r, c, 1, 1, up, left, down, right, 0, 0.0, 0.0, 17);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPriorSeparatorVisible(Component cont, boolean visible) {
        JComponent prevSep = null;
        boolean found = false;
        Object object = this.getTreeLock();
        synchronized (object) {
            int ccount = this.getComponentCount();
            for (int m = 0; m < ccount; ++m) {
                Component comp = this.getComponent(m);
                if (comp == cont) {
                    found = true;
                    break;
                }
                if (!(comp instanceof JSeparator)) continue;
                prevSep = (JSeparator)comp;
            }
        }
        if (prevSep != null && found) {
            prevSep.setVisible(visible);
        }
    }

    protected void addSection(Component cont) {
        this.setBorder(null);
        if (!(cont instanceof APropEditPanel) && cont instanceof JComponent) {
            ((JComponent)cont).setBorder(BorderFactory.createEmptyBorder(3, 0, 3, 0));
        }
        if (this.d_col == 0) {
            Component spacer = Box.createHorizontalStrut(1);
            GridBagUtil.add(this, spacer, this.d_col++, 0, 1, 1, 0, 0, 0, 0, 0, 0.0, 0.0, 10);
        }
        int leftSep = this.d_numSections == 0 ? 12 : 6;
        this.addComponent(cont, leftSep);
        ++this.d_numSections;
        if (!cont.isVisible()) {
            this.setPriorSeparatorVisible(cont, false);
        }
    }

    protected JSeparator addSeparator() {
        this.setBorder(null);
        if (this.d_numSections > 0) {
            JSeparator sep = new JSeparator(1);
            this.addComponent(sep, 6);
            return sep;
        }
        return null;
    }

    private void addComponent(Component c, int leftSep) {
        GridBagUtil.add(this, c, this.d_col++, 0, 1, 1, 0, leftSep, 0, 0, 3, 0.0, 1.0, 10);
        GridBagUtil.addHorizontalGlue(this);
    }

    protected void addDefaultTFAction(JTextField ... fields) {
        this.addDefaultTFAction(true, fields);
    }

    protected void addDefaultTFAction(boolean resondToKeys, JTextField ... fields) {
        for (JTextField f : fields) {
            this.addTFAction(f, resondToKeys, this.d_updateToCommand);
        }
    }

    protected void addTFActions(JTextField field, boolean respondToKeys, IPropEditCommand ... actions) {
        for (IPropEditCommand action : actions) {
            this.addTFAction(field, respondToKeys, action);
        }
        this.addTFAction(field, respondToKeys, this.d_updateToCommand);
    }

    protected void addTFAction(final JTextField field, boolean respondToKeys, final IPropEditCommand action) {
        if (respondToKeys) {
            field.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    action.updateProp(field, false);
                }
            });
        }
        field.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (!e.isTemporary()) {
                    action.updateProp(field, true);
                }
            }
        });
    }

    protected <T extends JTextField> T initValueField(T field, IPropEditCommand ... actions) {
        return this.initValueField(field, true, actions);
    }

    protected <T extends JTextField> T initValueField(T field, boolean respondToKeys, IPropEditCommand ... actions) {
        Dimension ps = field.getPreferredSize();
        ps.height -= 2;
        field.setPreferredSize(ps);
        field.setColumns(10);
        this.addTFActions(field, respondToKeys, actions);
        return field;
    }

    protected void addDefaultListener(AbstractButton ... btns) {
        for (AbstractButton btn : btns) {
            this.addActionListener(btn, this.d_updateToCommand);
        }
    }

    protected void addActionListeners(AbstractButton btn, IPropEditCommand ... actions) {
        for (IPropEditCommand cmd : actions) {
            this.addActionListener(btn, cmd);
        }
        this.addActionListener(btn, this.d_updateToCommand);
    }

    protected void addActionListener(final AbstractButton btn, final IPropEditCommand cmd) {
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                cmd.updateProp(btn, true);
            }
        });
    }

    protected void addDefaultListener(IValEditor<?> ... editors) {
        for (IValEditor<?> editor : editors) {
            editor.addValueListener(e -> this.d_updateToCommand.updateProp(editor.getComponent(), true));
        }
    }

    protected <T extends JComboBox> T initComboBox(final T cb) {
        Dimension ps = cb.getPreferredSize();
        ps.height -= 2;
        cb.setPreferredSize(ps);
        cb.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    APropEditPanel.this.d_updateToCommand.updateProp(cb, true);
                }
            }
        });
        return cb;
    }

    protected <T extends AbstractButton> T initButton(T btn, IPropEditCommand ... actions) {
        if (btn instanceof JButton) {
            Dimension ps = btn.getPreferredSize();
            ps.height -= 4;
            btn.setPreferredSize(ps);
        }
        this.addActionListeners(btn, actions);
        return btn;
    }
}

