/*
 * Decompiled with CFR 0.152.
 */
package merlin.geom;

import common.geom.Intersect;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import javax.vecmath.Point3d;
import merlin.data.MerlinData;
import merlin.data.egress.agents.EgressAgent;
import merlin.data.egress.agents.OccProfile;
import merlin.data.egress.agents.VehicleShape;
import merlin.geom.GeomLocator;
import merlin.geom.Geometry;
import merlin.geom.SphereSearch;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.search.Containment;
import thunderheadeng.geometry.search.IResult;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.scene3d.geom.IDisplayableGeomSrc;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Filters;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Predicates;

public class AgentOverlapDetector {
    private final GeomLocator d_locator;
    private Set<EgressAgent> d_dirtyAgents;

    public AgentOverlapDetector(MerlinData data) {
        this.d_locator = new GeomLocator(data);
        this.clearDirty();
    }

    private void clearDirty() {
        this.d_dirtyAgents = new LinkedIdentityHashSet<EgressAgent>();
    }

    public GeomLocator getLocator() {
        return this.d_locator;
    }

    public void add(EgressAgent agent) {
        this.d_dirtyAgents.add(agent);
    }

    public void update(EgressAgent agent) {
        this.d_dirtyAgents.add(agent);
    }

    public void remove(EgressAgent agent) {
        this.d_locator.remove(agent);
        this.d_dirtyAgents.remove(agent);
    }

    public void updateDirty() {
        if (this.d_dirtyAgents.isEmpty()) {
            return;
        }
        for (EgressAgent agent : this.d_dirtyAgents) {
            this.updateDirtyObj(agent);
        }
        this.clearDirty();
    }

    private void updateDirty(Predicate<EgressAgent> toIgnore) {
        if (this.d_dirtyAgents.isEmpty()) {
            return;
        }
        if (toIgnore.equals(Predicates.alwaysFalse())) {
            this.updateDirty();
            return;
        }
        Iterator<EgressAgent> it = this.d_dirtyAgents.iterator();
        while (it.hasNext()) {
            EgressAgent agent = it.next();
            if (toIgnore.test(agent)) continue;
            this.updateDirtyObj(agent);
            it.remove();
        }
    }

    private void updateDirtyObj(EgressAgent agent) {
        this.d_locator.update(agent);
    }

    private static double getRadius(EgressAgent agent) {
        return agent.getShoulderWidth().getValue(Geometry.LENGTH_UNIT) * 0.5;
    }

    public Collection<EgressAgent> detectOverlap(EgressAgent agent) {
        return this.detectOverlap(agent.getProfile().getProperty(OccProfile.PROP_SHAPE), agent.getLocation(), agent.getShoulderWidth().getValue(Geometry.LENGTH_UNIT) * 0.5, agent.getAngle().getValue(Geometry.ANGLE_UNIT), true, Filters.accept(agent));
    }

    public Collection<EgressAgent> detectOverlap(OccProfile.OccShape occShape, Point3d loc, double radius, double angle, boolean checkAttachedPositions) {
        return this.detectOverlap(occShape, loc, radius, angle, checkAttachedPositions, Predicates.alwaysFalse());
    }

    public Collection<EgressAgent> detectOverlap(final OccProfile.OccShape shape, final Point3d loc, final double radius, double angle, final boolean checkAttachedPositions, final Predicate<EgressAgent> toIgnore) {
        Point3d[] points;
        AABox oabb;
        this.updateDirty(toIgnore);
        if (shape.type.equals((Object)VehicleShape.ShapeType.CYLINDER)) {
            SphereSearch search = new SphereSearch(loc, radius);
            oabb = search.getBounds();
            points = null;
        } else {
            assert (shape.type.equals((Object)VehicleShape.ShapeType.POLYGON));
            points = checkAttachedPositions ? shape.vehicleShape.getOuterPoints(loc, angle) : shape.vehicleShape.getBodyPoints(loc, angle);
            oabb = new AABox(points);
        }
        final LinkedIdentityHashSet overlapping = new LinkedIdentityHashSet();
        AABox test = oabb;
        IResult<IDisplayableGeomSrc> result = new IResult<IDisplayableGeomSrc>(){

            @Override
            public void mark(IDisplayableGeomSrc obj, Containment ctmt) {
                boolean isect;
                assert (obj instanceof EgressAgent);
                EgressAgent otherAgent = (EgressAgent)obj;
                if (toIgnore.test(otherAgent)) {
                    return;
                }
                OccProfile.OccShape otherShape = otherAgent.getProfile().getProperty(OccProfile.PROP_SHAPE);
                double otherAngle = ((UnitDouble)otherAgent.calcDistributedProfileVal(OccProfile.PROP_INIT_ORIENT, new Random())).getValue(Geometry.ANGLE_UNIT);
                if (otherShape.type.equals((Object)VehicleShape.ShapeType.CYLINDER)) {
                    if (shape.type.equals((Object)VehicleShape.ShapeType.CYLINDER)) {
                        isect = Inter3D.sphereSphereIsect(loc, radius, otherAgent.getLocation(), AgentOverlapDetector.getRadius(otherAgent), 1.0E-6);
                    } else {
                        assert (shape.type.equals((Object)VehicleShape.ShapeType.POLYGON));
                        isect = Intersect.circlePoly(otherAgent.getLocation(), AgentOverlapDetector.getRadius(otherAgent), points);
                    }
                } else {
                    assert (otherShape.type.equals((Object)VehicleShape.ShapeType.POLYGON));
                    Point3d[] otherPoints = checkAttachedPositions ? otherShape.vehicleShape.getOuterPoints(otherAgent.getLocation(), otherAngle) : otherShape.vehicleShape.getBodyPoints(otherAgent.getLocation(), otherAngle);
                    isect = shape.type.equals((Object)VehicleShape.ShapeType.CYLINDER) ? Intersect.circlePoly(loc, radius, otherPoints) : Inter3D.testCoplanarCPolyCPoly(points, otherPoints, 1.0E-6);
                }
                if (isect) {
                    overlapping.add(otherAgent);
                }
            }
        };
        this.d_locator.find((ITest<AABox>)test, (IResult<? super IDisplayableGeomSrc>)result, 1);
        return overlapping.isEmpty() ? Collections.EMPTY_LIST : overlapping;
    }
}

