/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.egress.scripting;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import merlin.Intl;
import merlin.data.ICompElement;
import merlin.data.MerlinData;
import merlin.data.NamedMerlinObj;
import merlin.data.egress.agents.OccProfile;
import merlin.data.egress.scripting.IBehaviorAction;
import thunderheadeng.dependencies.DLink;
import thunderheadeng.dependencies.DepList;
import thunderheadeng.dependencies.IDirectDependent;
import thunderheadeng.util.ICyclicSurrogate;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.PropertySet;
import thunderheadeng.util.Sets;
import thunderheadeng.util.UnorderedPair;
import thunderheadeng.util.stat.IUrn;
import thunderheadeng.util.stat.UrnUtil;
import thunderheadeng.util.theUtil;

public class ChangeProfile
extends NamedMerlinObj
implements IBehaviorAction,
IDirectDependent<MerlinData>,
ICyclicSurrogate {
    private static final long serialVersionUID = 1L;
    public static final IPropertySet.Prop<IUrn<OccProfile>> PROP_PROFILE_DIST = new IPropertySet.Prop<Object>("ChangeProfile.PROFILE_DIST", null);
    public static final Set<Object> PROP_TYPES = Sets.fromArrayLHS(NamedMerlinObj.NAME, PROP_PROFILE_DIST);
    public static final List<IPropertySet.Prop<?>> ALL_PROPS = IPropertySet.getAllDeclaredPublicStaticProps(ChangeProfile.class);
    private PropertySet d_props = new PropertySet();

    public ChangeProfile(IUrn<OccProfile> profileDistribution) {
        this.setProperty(PROP_PROFILE_DIST, profileDistribution);
    }

    @Override
    public Set<Object> getPropTypes(int options) {
        return PROP_TYPES;
    }

    @Override
    public <T> void setProperty(Object property, T value) {
        if (property instanceof IPropertySet.Prop) {
            this.set((IPropertySet.Prop)property, value);
        } else if (property == NamedMerlinObj.NAME) {
            this.setName((String)value);
        }
    }

    public <T> void set(IPropertySet.Prop<T> prop, T value) {
        this.d_props.setIfNotDefault(prop, value);
        this.changedEvt(prop);
    }

    @Override
    public Object getProperty(Object property) {
        if (property instanceof IPropertySet.Prop) {
            return this.get((IPropertySet.Prop)property);
        }
        if (property == NamedMerlinObj.NAME) {
            return this.getName();
        }
        return ICompElement.NOT_SUPPORTED;
    }

    public <T> T get(IPropertySet.Prop<T> prop) {
        return this.d_props.get(prop);
    }

    @Override
    public void restoreFrom(Object obj) {
        if (!(obj instanceof ChangeProfile)) {
            return;
        }
        ChangeProfile changeProfile = (ChangeProfile)obj;
        this.pauseUpdates();
        for (IPropertySet.Prop<?> prop : ALL_PROPS) {
            this.d_props.setIfNotDefault(prop, changeProfile.d_props.get(prop));
        }
        this.resumeUpdates();
    }

    @Override
    public Object getRestoreObj() {
        return this.clone();
    }

    @Override
    public Object clone() {
        IUrn<OccProfile> profiles = this.get(PROP_PROFILE_DIST);
        IUrn<OccProfile> newProfiles = null;
        if (profiles != null) {
            newProfiles = UrnUtil.newUrn(profiles.getWeights());
        }
        return new ChangeProfile(newProfiles);
    }

    @Override
    public boolean mustBeLast() {
        return false;
    }

    @Override
    public boolean isTerminal() {
        return false;
    }

    @Override
    public boolean isImmediate() {
        return true;
    }

    @Override
    public String getName() {
        Set<OccProfile> targetProfiles = this.getAllTargetProfiles();
        if (targetProfiles.size() == 1) {
            return String.format(Intl.intl("Change Profile <%s>"), targetProfiles.iterator().next().getName());
        }
        return Intl.intl("Change Profile");
    }

    @Override
    public void setName(String name) {
    }

    @Override
    public boolean isSetNameSupported() {
        return false;
    }

    public Set<OccProfile> getAllTargetProfiles() {
        IUrn<OccProfile> profileUrn = this.get(PROP_PROFILE_DIST);
        return profileUrn != null ? Collections.unmodifiableSet(profileUrn.getWeights().keySet()) : Collections.emptySet();
    }

    @Override
    public void replaceDependency(MerlinData md, Object old, Object replacement) {
        assert (old != null);
        if (old instanceof OccProfile) {
            OccProfile replacementProfile = (OccProfile)replacement;
            OccProfile noChange = md.profiles.NO_CHANGE;
            double totalNoChange = 0.0;
            Map<OccProfile, Double> profiles = this.get(PROP_PROFILE_DIST).getWeights();
            LinkedIdentityHashMap<OccProfile, Double> newProfiles = new LinkedIdentityHashMap<OccProfile, Double>(profiles.size());
            for (Map.Entry<OccProfile, Double> entry : profiles.entrySet()) {
                if (entry.getKey() == old) {
                    if (theUtil.equal(replacementProfile, md.profiles.NO_CHANGE)) {
                        newProfiles.put(noChange, 0.0);
                        totalNoChange += entry.getValue().doubleValue();
                        continue;
                    }
                    if (replacementProfile != null) {
                        newProfiles.put(replacementProfile, entry.getValue());
                        continue;
                    }
                    totalNoChange += entry.getValue().doubleValue();
                    continue;
                }
                if (theUtil.equal(entry.getKey(), md.profiles.NO_CHANGE)) {
                    newProfiles.put(noChange, 0.0);
                    totalNoChange += entry.getValue().doubleValue();
                    continue;
                }
                newProfiles.put(entry.getKey(), entry.getValue());
            }
            if (totalNoChange > 0.0) {
                newProfiles.put(noChange, totalNoChange);
            }
            this.setProperty(PROP_PROFILE_DIST, UrnUtil.newUrn(newProfiles));
        }
    }

    @Override
    public void takeDepSnapshot(DepList deps) {
        deps.add(DLink.WEAK, this.getAllTargetProfiles());
    }

    private int surrogateHashCode() {
        int hash = 7;
        return 31 * hash + theUtil.hashCode(this.getProperty(PROP_PROFILE_DIST));
    }

    @Override
    public boolean cyclicEquals(Object comparable, HashSet<UnorderedPair<Object, Object>> comparedSet) {
        if (comparable == this) {
            return true;
        }
        if (comparable == null || this.getClass() != comparable.getClass()) {
            return false;
        }
        ChangeProfile comparableBehavior = (ChangeProfile)comparable;
        return theUtil.equal(this.get(PROP_PROFILE_DIST), comparableBehavior.get(PROP_PROFILE_DIST), comparedSet);
    }
}

