/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.egress.elevators;

import java.util.Set;
import javax.vecmath.Point3d;
import merlin.data.MerlinData;
import merlin.data.egress.IEgressObj;
import merlin.data.egress.elevators.ElevatorRoom;
import merlin.data.egress.elevators.IElevatorComp;
import merlin.data.egress.geom.EgressDoor;
import merlin.data.egress.geom.EgressRoom;
import merlin.data.egress.geom.IEgressOccupiable;
import thunderheadeng.dependencies.SkipDep;
import thunderheadeng.geometry.LineSeg3D;
import thunderheadeng.util.EventChannel;
import thunderheadeng.util.Sets;

public class ElevatorDoor
extends EgressDoor
implements IElevatorComp {
    static final long serialVersionUID = 234111234908734L;
    public static final Set<Object> PROP_TYPES = Sets.appendLHS(EgressDoor.PROP_TYPES, MerlinData.ENABLED);
    private boolean d_enabled = true;
    @SkipDep
    private EgressRoom d_disconnectedRoom;

    public ElevatorDoor(EgressDoor door) {
        this(door.getName(), false, door.getRoom1(), door.getRoom2(), door.getEdge1(), door.getEdge2(), door.getBoundary());
    }

    public ElevatorDoor(String name, boolean forceAsExit, IEgressOccupiable comp1, IEgressOccupiable comp2, LineSeg3D attachedEdge1, LineSeg3D attachedEdge2, Point3d[] boundary) {
        super(name, forceAsExit, comp1, comp2, attachedEdge1, attachedEdge2, boundary);
    }

    @Override
    public void restoreFrom(Object obj) {
        if (!(obj instanceof ElevatorDoor)) {
            return;
        }
        ElevatorDoor door = (ElevatorDoor)obj;
        this.pauseUpdates();
        super.restoreFrom(obj);
        this.d_enabled = door.isEnabled();
        this.d_disconnectedRoom = door.getDisconnectedRoom();
        this.resumeUpdates();
    }

    @Override
    public boolean hasOpenSpots(Class<? extends IEgressObj> type) {
        if (!ElevatorRoom.class.isAssignableFrom(type) && !this.isEnabled()) {
            return false;
        }
        return super.hasOpenSpots(type);
    }

    @Override
    public void connectTo(IEgressObj obj) {
        if (!(obj instanceof ElevatorRoom) && !this.isEnabled()) {
            return;
        }
        super.connectTo(obj);
    }

    @Override
    public void disconnectFrom(IEgressObj obj) {
        if (!(this.getRoom1() instanceof ElevatorRoom) || !(this.getRoom2() instanceof ElevatorRoom)) {
            if (obj instanceof ElevatorRoom) {
                return;
            }
            if (obj instanceof EgressRoom) {
                this.d_disconnectedRoom = (EgressRoom)obj;
            }
        }
        super.disconnectFrom(obj);
    }

    @Override
    public void setWidth(double width) {
    }

    @Override
    public boolean isVisible() {
        return this.d_enabled && super.isVisible();
    }

    @Override
    public boolean isEnabled() {
        return this.d_enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (enabled != this.d_enabled) {
            this.d_enabled = enabled;
            this.changedEvt(MerlinData.VISIBILITY, MerlinData.ENABLED, EventChannel.EVT_GENERAL, MerlinData.TOPOLOGY);
        }
    }

    @Override
    public boolean getModificationsAllowed() {
        return false;
    }

    @Override
    public Set<Object> getPropTypes(int options) {
        return PROP_TYPES;
    }

    @Override
    public Object getProperty(Object prop) {
        if (prop == MerlinData.ENABLED) {
            return this.isEnabled();
        }
        return super.getProperty(prop);
    }

    public void setProperty(Object property, Object value) {
        if (property == MerlinData.ENABLED) {
            this.setEnabled((Boolean)value);
        } else {
            super.setProperty(property, value);
        }
    }

    public EgressRoom getDisconnectedRoom() {
        return this.d_disconnectedRoom;
    }
}

