/*
 * Decompiled with CFR 0.152.
 */
package merlin.data;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Objects;
import merlin.MerlinPrefs;
import merlin.actions.InfernoGeomBuilder;
import merlin.geom.Geometry;
import merlin.io.MerlinIO;
import merlin.io.MerlinOIS;
import merlin.unitsystem.SIUS;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import thunderheadeng.geometry.nmt.Face;
import thunderheadeng.gui.Application;
import thunderheadeng.units.UnitDouble;

public class SimParams
implements Serializable {
    static final long serialVersionUID = 8116442157363966490L;
    public boolean runTimeMaxFlag = true;
    public UnitDouble runTimeMax = new UnitDouble(3600.0, SI.SECOND);
    public boolean showVis = false;
    @Deprecated
    public boolean maxEdgeLengthFlag = false;
    public NavMeshRefinement navmeshRefinement = NavMeshRefinement.NONE;
    public UnitDouble maxEdgeLength = new UnitDouble(2.5, SI.METER);
    public double minAngle = 0.0;
    public UnitDouble maxTriangleArea = new UnitDouble(2.0, SI.METER.pow(2));
    public UnitDouble dtSim = new UnitDouble(0.025, SI.SECOND);
    public UnitDouble dtVis = new UnitDouble(0.25, SI.SECOND);
    public UnitDouble dtStatus = new UnitDouble(0.5, SI.SECOND);
    public UnitDouble dtCSV = new UnitDouble(1.0, SI.SECOND);
    public UnitDouble dtSnapshot = new UnitDouble(120.0, SI.SECOND);
    public UnitDouble dtSteerUpdate = new UnitDouble(0.1, SI.SECOND);
    public boolean handleCollisions = true;
    public boolean forceSeparation = false;
    public boolean reactiveSteering = true;
    public boolean useProfileFundamental = false;
    public boolean useAdvancedProfileSpeeds = false;
    public double minSFPEVelFrac = 0.15;
    @Deprecated
    public boolean inertia = true;
    public boolean useDoorQueues = false;
    @Deprecated
    public UnitDouble specificFlowrateMax = new UnitDouble(1.32, Unit.ONE.divide(SI.SECOND).divide(SI.METER));
    public UnitDouble specificFlowSteering = new UnitDouble(1.32, Unit.ONE.divide(SI.SECOND).divide(SI.METER));
    public boolean wallSlide = true;
    public boolean printPerformance = false;
    public UnitDouble densityMax = new UnitDouble(1.88, SIUS.unit(3));
    public UnitDouble doorBoundaryLayer = new UnitDouble(150.0, SI.MILLI(SI.METER));
    public double minFlowrateFactor = 0.1;
    public boolean doorFlowDensityFlag = true;
    @Deprecated
    public UnitDouble doorFlowDensityMin = new UnitDouble(1.9, SIUS.unit(3));
    @Deprecated
    public UnitDouble doorFlowDensityMax = new UnitDouble(3.0, SIUS.unit(3));
    @Deprecated
    public double elevatorSizeFactor = 0.6;
    @Deprecated
    public UnitDouble elevatorFillDensity = new UnitDouble(5.5, SIUS.unit(3));
    public UnitDouble maxTrimError = new UnitDouble(1.0, NonSI.INCH);
    public UnitDouble lowSpeedThreshold = new UnitDouble(0.25, SI.METER.divide(SI.SECOND));
    public UnitDouble lowSpeedAveragingTime = new UnitDouble(10.0, SI.SECOND);
    public boolean occCSVFileAsOne = true;
    public boolean writeOccParamsFile = true;
    public boolean socialDistanceEnable = false;
    public UnitDouble socialDistance = new UnitDouble(2.0, SI.METER);
    public boolean measurementRegionSeekSpeed = true;
    public double edgeError = 0.1;
    public double faceError = 0.1;
    public boolean smvDataEnable = false;
    @Deprecated
    public boolean smvSmokeSlowEnable = false;
    public String smvDataFileName = null;
    public UnitDouble hypoxiaLimit = new UnitDouble(19.5, NonSI.PERCENT);
    public boolean enableVehicleLateralMovementVis = false;
    public UnitDouble attractorDefaultIdleTime = new UnitDouble(15.0, NonSI.MINUTE);
    public UnitDouble occTargetConflictResolveTime = new UnitDouble(5.0, SI.SECOND);
    public UnitDouble dynamicTargetSearchDt = new UnitDouble(0.25, SI.SECOND);

    public SimParams() {
        if (Application.getApp() != null && !MerlinPrefs.getBoolean(MerlinPrefs.BACKUP_WRITE_SNAPSHOTS_BY_DEFAULT)) {
            this.dtSnapshot = new UnitDouble(0.0, SI.SECOND);
        }
    }

    public void reset() {
        this.restoreFrom(new SimParams());
    }

    public void restoreFrom(SimParams sp) {
        Field[] fields;
        for (Field f : fields = this.getClass().getFields()) {
            try {
                if (f.get(sp) == null) continue;
                f.set(this, f.get(sp));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean equals(Object obj) {
        Field[] fields;
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SimParams)) {
            return false;
        }
        SimParams sp = (SimParams)obj;
        for (Field f : fields = this.getClass().getFields()) {
            if (f.getAnnotation(Deprecated.class) != null) continue;
            try {
                Object val1 = f.get(this);
                Object val2 = f.get(sp);
                if (Objects.equals(val1, val2)) continue;
                return false;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        if (this.navmeshRefinement == null) {
            NavMeshRefinement navMeshRefinement = this.maxEdgeLengthFlag ? NavMeshRefinement.EDGE_LENGTH : (this.navmeshRefinement = this.maxTriangleArea != null ? NavMeshRefinement.TRIANGLE_AREA : NavMeshRefinement.NONE);
        }
        if (this.maxTriangleArea == null) {
            this.maxTriangleArea = new SimParams().maxTriangleArea;
        }
        if (MerlinOIS.isPrior(ois, MerlinIO.Version.VER_0004)) {
            this.dtSteerUpdate = new UnitDouble(0.0, SI.SECOND);
        }
        if (MerlinOIS.isPrior(ois, MerlinIO.Version.VER_0007)) {
            this.maxTrimError = new UnitDouble(1.0, NonSI.INCH);
        }
        if (MerlinOIS.isPrior(ois, MerlinIO.Version.VER_0021)) {
            this.elevatorSizeFactor = 0.6;
        }
        if (MerlinOIS.isPrior(ois, MerlinIO.Version.VER_0022)) {
            this.elevatorFillDensity = new UnitDouble(5.5, SIUS.unit(3));
        }
        if (MerlinOIS.isPrior(ois, MerlinIO.Version.VER_0105)) {
            this.minSFPEVelFrac = 0.15;
            this.useProfileFundamental = false;
        }
        if (MerlinOIS.isPrior(ois, MerlinIO.Version.VER_0120)) {
            this.minFlowrateFactor = 0.1;
        }
        if (MerlinOIS.isPrior(ois, MerlinIO.Version.VER_0135)) {
            this.writeOccParamsFile = true;
        }
        if (MerlinOIS.isPrior(ois, MerlinIO.Version.VER_0136)) {
            this.socialDistanceEnable = false;
            this.socialDistance = new UnitDouble(2.0, SI.METER);
            if (System.getProperty("social_distance") != null) {
                this.socialDistanceEnable = true;
                try {
                    double sd = Double.parseDouble(System.getProperty("social_distance"));
                    if (0.0 < sd && sd < 50.0) {
                        this.socialDistance = new UnitDouble(sd, SI.METER);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (MerlinOIS.isPrior(ois, MerlinIO.Version.VER_0137)) {
            boolean bl = this.forceSeparation = System.getProperty("ASeek.FORCE_SEPARATION") != null;
        }
        if (MerlinOIS.isPrior(ois, MerlinIO.Version.VER_0138)) {
            this.smvSmokeSlowEnable = false;
        }
        if (this.hypoxiaLimit == null) {
            this.hypoxiaLimit = new UnitDouble(19.5, NonSI.PERCENT);
        }
        if (this.faceError == 0.0) {
            this.faceError = 0.1;
        }
        if (this.edgeError == 0.0) {
            this.edgeError = 0.1;
        }
        if (this.attractorDefaultIdleTime == null) {
            this.attractorDefaultIdleTime = new SimParams().attractorDefaultIdleTime;
        }
        if (this.occTargetConflictResolveTime == null) {
            this.occTargetConflictResolveTime = new SimParams().occTargetConflictResolveTime;
        }
        if (this.dynamicTargetSearchDt == null) {
            this.dynamicTargetSearchDt = new SimParams().dynamicTargetSearchDt;
        }
        if (this.lowSpeedAveragingTime == null) {
            this.lowSpeedAveragingTime = new SimParams().lowSpeedAveragingTime;
        }
    }

    public Face.RefinementOptions getFaceRefinementOptions() {
        switch (this.navmeshRefinement) {
            case EDGE_LENGTH: {
                return new Face.RefinementOptions(this.minAngle);
            }
            case TRIANGLE_AREA: {
                return new Face.RefinementOptions(this.maxTriangleArea.get(Geometry.AREA_UNIT), 0);
            }
        }
        return Face.NO_REFINEMENT;
    }

    public InfernoGeomBuilder.Param getMeshBuilderParams() {
        UnitDouble maxEdgeLen;
        Face.RefinementOptions refOptions = this.getFaceRefinementOptions();
        switch (this.navmeshRefinement) {
            case EDGE_LENGTH: {
                maxEdgeLen = this.maxEdgeLength;
                break;
            }
            case TRIANGLE_AREA: {
                double area = this.maxTriangleArea.get(Geometry.AREA_UNIT);
                double len = Math.sqrt(area) * 2.0 / 3.0 * Math.pow(3.0, 0.75);
                maxEdgeLen = new UnitDouble(len, Geometry.LENGTH_UNIT);
                break;
            }
            default: {
                maxEdgeLen = new UnitDouble(Double.MAX_VALUE, SI.METER);
            }
        }
        return new InfernoGeomBuilder.Param(maxEdgeLen, refOptions);
    }

    public static enum NavMeshRefinement {
        NONE,
        EDGE_LENGTH,
        TRIANGLE_AREA;

    }
}

