/*
 * Decompiled with CFR 0.152.
 */
package merlin.builders;

import java.awt.Component;
import java.util.Collections;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.AddObject;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.data.MerlinData;
import merlin.data.egress.agents.OccTarget;
import merlin.data.egress.geom.IEgressOccupiable;
import merlin.util.MerlinProps;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.IPropertySet;

public class OccTargetBuilder
extends MerlinProps {
    public static final IPropertySet.Prop<IEgressOccupiable> ROOM = new IPropertySet.Prop<Object>(6435503, null);

    public OccTargetBuilder(MerlinData md) {
    }

    public void setLocation(IEgressOccupiable room, Vector3d roomNormal, Point3d loc) {
        this.pause();
        this.set(ROOM, room);
        this.set(OccTarget.LOCATION, loc);
        this.set(OccTarget.ROOM_NORMAL, roomNormal);
        this.resume();
    }

    public boolean isValid() {
        return this.get(ROOM) != null;
    }

    public void create(Component c) {
        if (!this.isValid()) {
            return;
        }
        final Point3d loc = this.get(OccTarget.LOCATION);
        final IEgressOccupiable room = this.get(ROOM);
        final Vector3d rnorm = this.get(OccTarget.ROOM_NORMAL);
        final UnitDouble orient = this.get(OccTarget.ORIENT);
        final UnitDouble radius = this.get(OccTarget.RADIUS);
        final Double priority = this.get(OccTarget.PRIORITY);
        AMerlinOp op = new AMerlinOp(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run(MerlinApp app, MerlinData md) {
                md.beginWrite();
                try {
                    Undo.begin(Intl.intl("New Occupant Target"));
                    String name = md.occTargetsNameGen.getCurrentName();
                    md.occTargetsNameGen.nextName();
                    OccTarget attr = new OccTarget(name);
                    attr.set(OccTarget.RADIUS, radius);
                    attr.setLocation(room, rnorm, loc);
                    attr.set(OccTarget.ORIENT, orient);
                    attr.set(OccTarget.PRIORITY, priority);
                    AddObject.add(md, md.occTargets, md.occTargets.getMembers().size(), Collections.singleton(attr));
                    Undo.end(md);
                }
                finally {
                    md.endWrite();
                }
            }
        };
        UIHook.run(c, "OccLocBuilder.create", op, 4);
    }
}

