/*
 * Decompiled with CFR 0.152.
 */
package merlin.builders;

import java.util.Collection;
import java.util.Set;
import merlin.MerlinApp;
import merlin.builders.ABehaviorActionBuilder;
import merlin.data.MerlinData;
import merlin.data.OccGroupObj;
import merlin.data.egress.scripting.IBehaviorAction;
import merlin.data.egress.scripting.JoinOccGroup;
import thunderheadeng.util.EventChannel;
import thunderheadeng.util.Events;

public class OccGroupBuilder
extends ABehaviorActionBuilder {
    public static final Object GROUP_CHANGED = "OccGroupBuilder.GROUP_CHANGED";
    private OccGroupObj d_group;
    private Type d_type;

    public OccGroupBuilder(MerlinData md, Type type) {
        super(md);
        if (type.equals((Object)Type.JOIN_GROUP) || type.equals((Object)Type.LEAD_GROUP)) {
            MerlinApp.getApp().getData().getEvents().addObserver(this);
        }
        this.d_type = type;
        this.reset();
    }

    @Override
    protected IBehaviorAction create() {
        switch (this.d_type) {
            case LEAD_GROUP: {
                return new JoinOccGroup(this.d_group, JoinOccGroup.Type.LEAD_GROUP);
            }
        }
        return new JoinOccGroup(this.d_group, JoinOccGroup.Type.JOIN_GROUP);
    }

    @Override
    protected void reset() {
        Collection<OccGroupObj> groups;
        if (!(this.d_type != Type.JOIN_GROUP && this.d_type != Type.LEAD_GROUP || this.d_group != null || (groups = MerlinApp.getApp().getData().occGroups.flatten(OccGroupObj.class)).isEmpty())) {
            this.setGroup(groups.iterator().next());
        }
    }

    @Override
    public boolean isValid() {
        return this.d_group != null;
    }

    public OccGroupObj getGroup() {
        return this.d_group;
    }

    public void setGroup(OccGroupObj obj) {
        this.d_group = obj;
        this.firePropChanged(ABehaviorActionBuilder.VALIDITY);
        this.firePropChanged(GROUP_CHANGED);
    }

    @Override
    public void update(Events events) {
        super.update(events);
        for (EventChannel<OccGroupObj> channel : events.getAffectedChannels(OccGroupObj.class, new Class[0])) {
            Set<OccGroupObj> addedGroups;
            for (OccGroupObj group : channel.getRemovedObjs()) {
                if (this.d_group != group) continue;
                this.setGroup(null);
                this.reset();
                break;
            }
            if (this.d_group != null || (addedGroups = channel.getAddedObjs()).isEmpty()) continue;
            this.setGroup(addedGroups.iterator().next());
        }
    }

    public static enum Type {
        JOIN_GROUP,
        LEAD_GROUP;

    }
}

