/*
 * Decompiled with CFR 0.152.
 */
package merlin.builders;

import java.awt.Component;
import java.util.ArrayList;
import java.util.function.Consumer;
import javax.vecmath.Point3d;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.SubtractAction;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.builders.NewCompUtil;
import merlin.data.MerlinData;
import merlin.data.egress.IEgressObj;
import merlin.data.egress.agents.OccProfile;
import merlin.data.egress.geom.EgressDoor;
import merlin.data.egress.geom.EgressRoom;
import merlin.geom.Geometry;
import merlin.util.MerlinProps;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import thunderheadeng.geometry.nmt.Model;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.stat.ICurve;

public class DoorBuilder
extends MerlinProps {
    public static final Object NAME_CHANGED = "DoorBuilder.NAME_CHANGED";
    public static final Object LOC_CHANGED = "DoorBuilder.CENTER_CHANGED";
    public static final Object WIDTH_CHANGED = "DoorBuilder.WIDTH_CHANGED";
    public static final Object DEPTH_CHANGED = "DoorBuilder.DEPTH_CHANGED";
    public static final Object FORCEEXIT_CHANGED = "DoorBuilder.FORCEEXIT_CHANGED";
    private final MerlinData d_data;
    private UnitPoint3D d_p1 = new UnitPoint3D(0.0, 0.0, 0.0, SI.METER);
    private UnitPoint3D d_p2 = null;
    private UnitDouble d_minWidth;
    private UnitDouble d_maxWidth;
    private UnitDouble d_maxDepth;
    private UnitDouble d_maxEdgeAngle;
    private boolean d_forceAsExit;
    private boolean d_doorSearchDirty;
    private EgressDoor.SearchResult d_doorSearch;

    public DoorBuilder(MerlinData data) {
        this.d_minWidth = new UnitDouble(((ICurve)OccProfile.PROP_DIAMETER.defVal).getMax().getValue(NonSI.INCH), NonSI.INCH);
        this.d_maxWidth = new UnitDouble(32.0, NonSI.INCH);
        this.d_maxDepth = new UnitDouble(10.0, NonSI.INCH);
        this.d_maxEdgeAngle = EgressDoor.DEF_MAX_EDGE_ANGLE;
        this.d_forceAsExit = false;
        this.d_doorSearchDirty = true;
        this.d_doorSearch = null;
        this.d_data = data;
    }

    public UnitDouble getMinWidth() {
        return this.d_minWidth;
    }

    public void setMinWidth(UnitDouble minWidth) {
        if (!this.lock()) {
            return;
        }
        this.d_minWidth = minWidth;
        this.markSearchDirty();
        this.firePropChanged(WIDTH_CHANGED);
        this.release();
    }

    public UnitDouble getMaxWidth() {
        return this.d_maxWidth;
    }

    public void setMaxWidth(UnitDouble maxWidth) {
        if (!this.lock()) {
            return;
        }
        this.d_maxWidth = maxWidth;
        this.markSearchDirty();
        this.firePropChanged(WIDTH_CHANGED);
        this.release();
    }

    public UnitDouble getMaxDepth() {
        return this.d_maxDepth;
    }

    public void setMaxDepth(UnitDouble maxDepth) {
        if (!this.lock()) {
            return;
        }
        this.d_maxDepth = maxDepth;
        this.markSearchDirty();
        this.firePropChanged(DEPTH_CHANGED);
        this.release();
    }

    public boolean isForceAsExit() {
        return this.d_forceAsExit;
    }

    public void setForceAsExit(boolean forceAsExit) {
        if (!this.lock()) {
            return;
        }
        this.d_forceAsExit = forceAsExit;
        this.markSearchDirty();
        this.firePropChanged(FORCEEXIT_CHANGED);
        this.release();
    }

    public UnitPoint3D getP1() {
        return this.d_p1;
    }

    public void setP1(UnitPoint3D p1) {
        if (!this.lock()) {
            return;
        }
        this.d_p1 = p1;
        this.markSearchDirty();
        this.firePropChanged(LOC_CHANGED);
        this.release();
    }

    public UnitPoint3D getP2() {
        return this.d_p1;
    }

    public void setP2(UnitPoint3D p2) {
        if (!this.lock()) {
            return;
        }
        this.d_p2 = p2;
        this.markSearchDirty();
        this.firePropChanged(LOC_CHANGED);
        this.release();
    }

    private void markSearchDirty() {
        this.d_doorSearchDirty = true;
        this.d_doorSearch = null;
    }

    public EgressDoor.SearchResult getSearchResult() {
        this.d_data.beginRead();
        try {
            if (this.d_doorSearchDirty) {
                if (this.d_p2 == null) {
                    this.d_doorSearch = EgressDoor.findDoor(this.d_data, this.d_p1.getPoint3dValue(Geometry.LENGTH_UNIT), this.d_data.doorNameGen.getCurrentName(), this.d_forceAsExit, this.d_minWidth.getValue(Geometry.LENGTH_UNIT), this.d_maxWidth.getValue(Geometry.LENGTH_UNIT), 0.0, this.d_maxDepth.getValue(Geometry.LENGTH_UNIT), this.d_maxEdgeAngle.getValue(SI.RADIAN), 0);
                } else {
                    Point3d p1 = this.d_p1.getPoint3dValue(Geometry.LENGTH_UNIT);
                    Point3d p2 = this.d_p2.getPoint3dValue(Geometry.LENGTH_UNIT);
                    this.d_doorSearch = EgressDoor.findDoor(this.d_data, p1, p2, this.d_data.doorNameGen.getCurrentName(), this.d_forceAsExit, this.d_maxEdgeAngle.getValue(SI.RADIAN), p1.distance(p2) * 0.5, 0);
                }
                this.d_doorSearchDirty = false;
            }
            EgressDoor.SearchResult searchResult = this.d_doorSearch;
            return searchResult;
        }
        finally {
            this.d_data.endRead();
        }
    }

    public boolean isValidDoor() {
        return this.getSearchResult() != null;
    }

    public void addDoor(Component c) {
        final EgressDoor.SearchResult searchResult = this.getSearchResult();
        if (searchResult != null) {
            AMerlinOp op = new AMerlinOp(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run(MerlinApp app, MerlinData md) {
                    md.beginWrite();
                    try {
                        Undo.begin(Intl.intl("New Door"));
                        ArrayList toClean = new ArrayList();
                        DoorBuilder.addDoorToModel(md, searchResult, toClean::add);
                        DoorBuilder.this.d_data.doorNameGen.nextName();
                        EgressRoom.cleanup(md, toClean);
                        Undo.end(md);
                    }
                    finally {
                        md.endWrite();
                    }
                }
            };
            UIHook.run(c, "DoorBuilder.addDoor", op, 4);
        }
    }

    private static EgressRoom toRoom(EgressDoor door) {
        Model model = door.getDoorGeom().asModel();
        return new EgressRoom("", model);
    }

    private static void addDoorToModel(MerlinData data, EgressDoor.SearchResult searchResult, Consumer<? super EgressRoom> toClean) {
        if (!searchResult.door.isThin() && searchResult.door.getRoom1() == searchResult.door.getRoom2()) {
            for (IEgressObj iEgressObj : new ArrayList<IEgressObj>(searchResult.door.getConnections())) {
                searchResult.door.disconnectFrom(iEgressObj);
            }
            EgressRoom subRoom = DoorBuilder.toRoom(searchResult.door);
            SubtractAction.subtract(MerlinApp.getApp(), data, 0, toClean, subRoom);
        }
        NewCompUtil.addEgressComp(data, searchResult.door);
    }
}

