/*
 * Decompiled with CFR 0.152.
 */
package merlin.builders;

import java.util.Collections;
import java.util.Set;
import javax.vecmath.Vector3d;
import merlin.builders.ABehaviorActionBuilder;
import merlin.data.MerlinData;
import merlin.data.egress.geom.IEgressOccupiable;
import merlin.data.egress.scripting.CreateAttractor;
import merlin.data.egress.scripting.IBehaviorAction;
import merlin.data.egress.scripting.attractors.Attractor;
import merlin.geom.Geometry;
import thunderheadeng.units.UnitPoint3D;

public class CreateAttractorActionBuilder
extends ABehaviorActionBuilder {
    public static final Object LOCATION_CHANGED = "CreateAttractorActionBuilder.LOCATION_CHANGED";
    private Set<Attractor> d_attractors = Collections.emptySet();
    private CreateAttractor.LocationMode d_locationMode = CreateAttractor.LocationMode.FOLLOW_OCC;
    private IEgressOccupiable d_room;
    private Vector3d d_roomNormal;
    private UnitPoint3D d_loc;
    private boolean d_locFinalized;

    public CreateAttractorActionBuilder(MerlinData md) {
        super(md);
    }

    public Set<Attractor> getAttractors() {
        return this.d_attractors;
    }

    public void setAttractors(Set<Attractor> attractors) {
        if (attractors.equals(this.d_attractors)) {
            return;
        }
        if (!this.lock()) {
            return;
        }
        this.d_attractors = attractors;
        this.pause();
        this.firePropChanged(VALIDITY);
        this.resume();
        this.release();
    }

    public CreateAttractor.LocationMode getLocationMode() {
        return this.d_locationMode;
    }

    public void setLocationMode(CreateAttractor.LocationMode locationMode) {
        if (this.d_locationMode == locationMode) {
            return;
        }
        if (!this.lock()) {
            return;
        }
        this.d_locationMode = locationMode;
        this.d_locFinalized = false;
        this.pause();
        this.firePropChanged(LOCATION_CHANGED);
        this.firePropChanged(VALIDITY);
        this.resume();
        this.release();
    }

    public boolean isLocFinalized() {
        return this.d_locFinalized;
    }

    public void finalizeLoc() {
        if (this.d_locFinalized) {
            return;
        }
        if (!this.lock()) {
            return;
        }
        this.d_locFinalized = true;
        this.pause();
        this.firePropChanged(LOCATION_CHANGED);
        this.firePropChanged(VALIDITY);
        this.resume();
        this.release();
    }

    public UnitPoint3D getFixedLoc() {
        return this.d_loc;
    }

    public Vector3d getFixedRoomNormal() {
        return this.d_roomNormal;
    }

    public IEgressOccupiable getFixedRoom() {
        return this.d_room;
    }

    public void setFixedLoc(IEgressOccupiable room, Vector3d roomNorm, UnitPoint3D loc) {
        if (room == this.d_room && loc.equals(this.d_loc) && roomNorm.equals(this.d_roomNormal)) {
            return;
        }
        if (!this.lock()) {
            return;
        }
        this.d_room = room;
        this.d_loc = loc;
        this.d_roomNormal = roomNorm;
        this.pause();
        this.firePropChanged(LOCATION_CHANGED);
        this.firePropChanged(VALIDITY);
        this.resume();
        this.release();
    }

    @Override
    public boolean isValid() {
        if (this.d_attractors.isEmpty()) {
            return false;
        }
        if (this.d_locationMode == CreateAttractor.LocationMode.FIXED_LOCATION) {
            return this.d_locFinalized && this.d_room != null && this.d_roomNormal != null && this.d_loc != null;
        }
        return true;
    }

    @Override
    protected IBehaviorAction create() {
        if (this.d_locationMode == CreateAttractor.LocationMode.FIXED_LOCATION) {
            return new CreateAttractor(this.d_attractors, this.d_locationMode, this.d_loc.getPoint3dValue(Geometry.LENGTH_UNIT), this.d_room, this.d_roomNormal);
        }
        return new CreateAttractor(this.d_attractors, this.d_locationMode, null, null, null);
    }

    @Override
    protected void reset() {
        this.d_attractors = Collections.emptySet();
        this.d_locationMode = CreateAttractor.LocationMode.FOLLOW_OCC;
        this.d_room = null;
        this.d_roomNormal = null;
        this.d_loc = null;
    }
}

