/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions.copypaste;

import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.vecmath.Point3d;
import merlin.EntryPoint;
import merlin.EntryPointFactory;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.MerlinOp;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.actions.copypaste.AttractorPasteHandler;
import merlin.actions.copypaste.BehaviorPasteHandler;
import merlin.actions.copypaste.CopyPasteUtil;
import merlin.actions.copypaste.DefaultPasteHandler;
import merlin.actions.copypaste.FloorPasteHandler;
import merlin.actions.copypaste.GeomPasteHandler;
import merlin.actions.copypaste.OccSourceObjPasteHandler;
import merlin.actions.copypaste.PasteHandler;
import merlin.actions.copypaste.PasteHints;
import merlin.actions.copypaste.PthCopyDataContainer;
import merlin.data.Composite;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.data.egress.FloorComposite;
import merlin.io.MerlinIO;
import merlin.mv.gui.LocationPanel;
import merlin.util.MerlinDepSnapshot;
import org.jscience.physics.units.SI;
import thunderheadeng.dependencies.DLink;
import thunderheadeng.dependencies.DepSnapshot;
import thunderheadeng.dependencies.Dependency;
import thunderheadeng.geometry.objs.transform.ITransform;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.geometry.objs.transform.TransformUtil;
import thunderheadeng.gui.IDomainObject;
import thunderheadeng.gui.WarningDlg;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Warning;
import thunderheadeng.util.WarningReport;
import thunderheadeng.util.theUtil;

public class Paste
extends AMerlinOp
implements IEventObserver {
    public static final Icon ICON = UIHook.loadIcon("thunderheadeng/gui/graphics/Paste16.gif");
    public static final UIHook UI_HOOK = new UIHook((MerlinOp)new Paste(), Intl.intl("&Paste...,V,Paste selected objects"), ICON);

    public Paste() {
        this.update(null);
        Toolkit.getDefaultToolkit().getSystemClipboard().addFlavorListener(flavorEvent -> this.update(null));
    }

    public boolean canPaste(Map<IDomainObject, String> payload) {
        return !payload.isEmpty() && !payload.entrySet().stream().allMatch(entry -> Paste.isUnsupported((IDomainObject)entry.getKey(), (String)entry.getValue()));
    }

    public static boolean isUnsupported(IDomainObject obj, String mdRootClassName) {
        for (PasteHandler handler : Paste.getPasteHandlers()) {
            if (!handler.isHandlerFor(obj, mdRootClassName)) continue;
            return false;
        }
        return true;
    }

    private Map<IDomainObject, String> getClipboardPayload(MerlinApp app, MerlinData md) {
        block5: {
            Toolkit defaultToolkit = Toolkit.getDefaultToolkit();
            Clipboard systemClipboard = defaultToolkit.getSystemClipboard();
            try {
                if (!systemClipboard.isDataFlavorAvailable(PthCopyDataContainer.DATAFLAVOR_BINARY)) break block5;
                try {
                    PthCopyDataContainer pasteData = (PthCopyDataContainer)systemClipboard.getData(PthCopyDataContainer.DATAFLAVOR_BINARY);
                    if (pasteData.getVersion() == MerlinIO.Version.curr().num) {
                        return pasteData.getObjs();
                    }
                }
                catch (UnsupportedFlavorException | IOException e) {
                    e.printStackTrace();
                }
            }
            catch (IllegalStateException e) {
                if ("cannot open system clipboard".equals(e.getMessage())) break block5;
                e.printStackTrace();
            }
        }
        return Collections.emptyMap();
    }

    public static PasteHandler[] getPasteHandlers() {
        return new PasteHandler[]{new OccSourceObjPasteHandler(), new GeomPasteHandler(), new FloorPasteHandler(), new BehaviorPasteHandler(), new AttractorPasteHandler(), new DefaultPasteHandler()};
    }

    public Collection<Warning> performPaste(MerlinData md, MerlinApp app, Map<IDomainObject, String> payload) {
        Map<IDomainObject, Pair<PasteHandler, PasteHints>> handlerMap;
        PasteHandler[] handlers = Paste.getPasteHandlers();
        ArrayList<Warning> warnings = new ArrayList<Warning>();
        MerlinDepSnapshot pasteDeps = new MerlinDepSnapshot();
        payload.keySet().forEach(obj -> pasteDeps.takeSnapshot(obj));
        Paste.processUnsupportedDependencies(md, pasteDeps, warnings);
        Paste.processFloorPasteDependencies(md, app.getMainFrame(), payload, pasteDeps);
        Paste.resolvePasteDependencies(md, payload, pasteDeps, warnings);
        try (AutoCloseable lock = md.lockRead();){
            handlerMap = Paste.preparePasteHandlers(md, app.getMainFrame(), handlers, payload, warnings);
        }
        lock = md.lockWrite();
        try {
            Undo.begin(Intl.intl("Paste"));
            Paste.processPasteObjs(md, app, handlerMap, payload, warnings);
            Undo.end(md);
        }
        finally {
            if (lock != null) {
                ((MerlinData.WriteLock)lock).close();
            }
        }
        return warnings;
    }

    @Override
    public void run(MerlinApp app, MerlinData md) {
        Map<IDomainObject, String> payload = this.getClipboardPayload(app, md);
        Collection<Warning> warnings = this.performPaste(md, app, payload);
        Paste.showWarnings(app, warnings);
    }

    public static void showWarnings(MerlinApp app, Collection<Warning> warnings) {
        if (warnings.isEmpty()) {
            return;
        }
        WarningReport<Warning> rpt = new WarningReport<Warning>(Warning.class, Warning.getWarningInfoTypes(), Warning.getWarningInfoDescriptions(), 0);
        warnings.stream().forEachOrdered(rpt::addWarning);
        WarningDlg warnDlg = WarningDlg.create(app.getMainFrame(), Intl.intl("Warnings"), "", rpt);
        warnDlg.doModal();
    }

    @Override
    public void update(Events events) {
        MerlinApp app = MerlinApp.getApp();
        MerlinData md = app.getData();
        Map<IDomainObject, String> payload = this.getClipboardPayload(app, md);
        this.setEnabled(this.canPaste(payload));
    }

    public static Map<IDomainObject, Pair<PasteHandler, PasteHints>> preparePasteHandlers(MerlinData md, Window dlgParent, PasteHandler[] handlers, Map<IDomainObject, String> pasteObjMap, Collection<Warning> warnings) {
        boolean shouldPromptForTransform = false;
        HashMap<IDomainObject, Pair<PasteHandler, PasteHints>> handlerMap = new HashMap<IDomainObject, Pair<PasteHandler, PasteHints>>();
        for (Map.Entry<IDomainObject, String> mapEntry : pasteObjMap.entrySet()) {
            String mdRootClassName;
            IDomainObject obj = mapEntry.getKey();
            if (Paste.isUnsupported(obj, mdRootClassName = mapEntry.getValue())) {
                warnings.add(CopyPasteUtil.getPasteSupportWarning(obj, false));
                continue;
            }
            Optional<Object> result = Optional.empty();
            for (PasteHandler ph : handlers) {
                if (!ph.isHandlerFor(obj, mdRootClassName)) continue;
                result = Optional.of(ph);
                break;
            }
            if (result.isPresent()) {
                PasteHandler ph = (PasteHandler)result.get();
                PasteHints hints = ph.getPasteHints(md, pasteObjMap, obj);
                shouldPromptForTransform |= hints.geomTransformShouldPrompt;
                handlerMap.put(obj, new Pair<PasteHandler, PasteHints>(ph, hints));
                continue;
            }
            warnings.add(CopyPasteUtil.getPasteSupportWarning(obj, false));
        }
        if (shouldPromptForTransform) {
            TransformInfo moveInfo = Paste.promptForTransformParameter(dlgParent, md);
            handlerMap.values().forEach(pair -> {
                ((PasteHints)pair.v2).geomTransform = moveInfo;
            });
        }
        return handlerMap;
    }

    public static void processPasteObjs(MerlinData md, MerlinApp app, Map<IDomainObject, Pair<PasteHandler, PasteHints>> handlerMap, Map<IDomainObject, String> pasteObjMap, Collection<Warning> warnings) {
        LinkedIdentityHashSet pastedObjs = new LinkedIdentityHashSet();
        Set selectedCompositesIntenseGenerics = md.selection.getSelected(Composite.class);
        Collection selectedComposites = selectedCompositesIntenseGenerics;
        Set<IMerlinObj> selectedLeaves = md.selection.getSelected(IMerlinObj.class);
        for (Map.Entry<IDomainObject, String> pasteObjMapEntry : pasteObjMap.entrySet()) {
            Pair<PasteHandler, PasteHints> handlerPair = handlerMap.get(pasteObjMapEntry.getKey());
            if (handlerPair == null) continue;
            PasteHandler handler = (PasteHandler)handlerPair.v1;
            PasteHints hints = (PasteHints)handlerPair.v2;
            handler.pasteApply(md, app, pasteObjMap, pasteObjMapEntry, hints, selectedComposites, selectedLeaves, pastedObjs::add, warnings::add);
        }
        md.selection.set(pastedObjs);
    }

    private static boolean promptForPasteFloorDeps(MerlinData md, Window dlgParent) {
        Callable<Boolean> uiFunc = () -> {
            int option = JOptionPane.showConfirmDialog(dlgParent, Intl.intl("Geometry is referenced by pasted objects. Include the geometry in the paste?\n \"No\" will remove references of the geometry from paste objects."), Intl.intl("Paste Geometry"), 0);
            return option == 0;
        };
        return md.ui(uiFunc);
    }

    private static void processFloorPasteDependencies(MerlinData md, Window dlgParent, Map<IDomainObject, String> pasteMap, DepSnapshot pasteDeps) {
        ArrayList<DepPasteEntry> floorDeps = new ArrayList<DepPasteEntry>();
        IFilteredCollection<IDomainObject> floorDependencies = theUtil.filter(pasteDeps.getAllDirectDependedOn(), d -> CopyPasteUtil.getRootString(md, d).equals(FloorComposite.class.getName()));
        for (IDomainObject floorDep : floorDependencies) {
            EntryPoint<IDomainObject> ep = EntryPointFactory.get(floorDep);
            IDomainObject existing = ep.getConflict(md, floorDep);
            String mdRootClassName = FloorComposite.class.getName();
            if (existing != null) continue;
            for (Dependency dep : pasteDeps.getDependents(floorDep)) {
                floorDeps.add(new DepPasteEntry(dep, floorDep, mdRootClassName));
            }
        }
        boolean pasteFloorDeps = floorDeps.size() > 0 && Paste.promptForPasteFloorDeps(md, dlgParent);
        for (DepPasteEntry entry : floorDeps) {
            if (!pasteFloorDeps && entry.dep.link == DLink.WEAK) {
                entry.dep.source.replaceDependency(md, entry.dependency, null);
                continue;
            }
            pasteMap.put(entry.dependency, entry.mdRootClassName);
        }
    }

    private static void processUnsupportedDependencies(MerlinData md, DepSnapshot pasteDeps, List<Warning> warnings) {
        IFilteredCollection<IDomainObject> unsupportedDeps = theUtil.filter(pasteDeps.getAllDirectDependedOn(), d -> Paste.isUnsupported(d, CopyPasteUtil.getRootString(md, d)));
        for (IDomainObject unsupportedDep : unsupportedDeps) {
            for (Dependency dep : pasteDeps.getDependents(unsupportedDep)) {
                warnings.add(CopyPasteUtil.getPasteDependencySupportWarning(dep.source, unsupportedDep));
                dep.source.replaceDependency(md, unsupportedDep, null);
            }
        }
    }

    private static void resolvePasteDependencies(MerlinData md, Map<IDomainObject, String> pasteMap, DepSnapshot pasteDeps, List<Warning> warnings) {
        for (IDomainObject dependedOn : pasteDeps.getAllDirectDependedOn()) {
            EntryPoint<IDomainObject> ep = EntryPointFactory.get(dependedOn);
            IDomainObject existing = ep.getConflict(md, dependedOn);
            if (existing == null) {
                String mdRootClassName = CopyPasteUtil.getRootString(md, dependedOn);
                if (mdRootClassName.equals(FloorComposite.class.getName())) continue;
                if (!Paste.isUnsupported(dependedOn, mdRootClassName)) {
                    pasteMap.put(dependedOn, mdRootClassName);
                    continue;
                }
            }
            for (Dependency dep : pasteDeps.getDependents(dependedOn)) {
                if (existing == null && dep.link != DLink.WEAK) continue;
                dep.source.replaceDependency(md, dependedOn, existing);
            }
        }
    }

    private static TransformInfo promptForTransformParameter(Window dlgParent, MerlinData md) {
        Callable<TransformInfo> uiFunc = () -> {
            int option = JOptionPane.showConfirmDialog(dlgParent, Intl.intl("Geometry intersection detected.\nOffset pasted geometry?"), Intl.intl("Paste Offset"), 0);
            if (option != 0) {
                return TransformUtil.IDENTITY_INFO;
            }
            guiDialog dlg = new guiDialog(dlgParent, Intl.intl("Offset"), 1);
            LocationPanel panel = new LocationPanel();
            dlg.getDialogPane().add(panel, "Center");
            if (dlg.doModal() == 1) {
                UnitPoint3D xformUpt3d = panel.getValue();
                Point3d xformMeters = xformUpt3d.getValue(SI.METER);
                ITransform xform = TransformUtil.translate(xformMeters.x, xformMeters.y, xformMeters.z);
                return xform.getInfo();
            }
            return TransformUtil.IDENTITY_INFO;
        };
        return md.ui(uiFunc);
    }

    private static class DepPasteEntry {
        Dependency dep;
        IDomainObject dependency;
        String mdRootClassName;

        DepPasteEntry(Dependency dependency, IDomainObject dependent, String mdRootClassName) {
            this.dep = dependency;
            this.dependency = dependent;
            this.mdRootClassName = mdRootClassName;
        }
    }
}

