/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions.copypaste;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.function.Consumer;
import merlin.MerlinApp;
import merlin.actions.copypaste.CopyPasteUtil;
import merlin.actions.copypaste.PasteHandler;
import merlin.actions.copypaste.PasteHints;
import merlin.data.Composite;
import merlin.data.ICompElement;
import merlin.data.IMerlinObj;
import merlin.data.INamed;
import merlin.data.MerlinData;
import merlin.data.egress.scripting.attractors.AttractorRootComp;
import thunderheadeng.gui.IDomainObject;
import thunderheadeng.util.Warning;

public class AttractorPasteHandler
implements PasteHandler {
    @Override
    public boolean isHandlerFor(IDomainObject obj, String mdRootField) {
        return AttractorRootComp.class.getName().equals(mdRootField);
    }

    @Override
    public PasteHints getPasteHints(MerlinData md, Map<IDomainObject, String> pasteObjMap, IDomainObject pasteObj) {
        return new PasteHints();
    }

    @Override
    public void pasteApply(MerlinData md, MerlinApp app, Map<IDomainObject, String> pasteObjMap, Map.Entry<IDomainObject, String> pasteEntry, PasteHints hints, Collection<Composite<ICompElement>> selectedComposites, Collection<IMerlinObj> selectedLeaves, Consumer<? super IDomainObject> allPastedObjs, Consumer<? super Warning> warnings) {
        IDomainObject pasteObj = pasteEntry.getKey();
        ArrayList<IMerlinObj> candidateLeaves = new ArrayList<IMerlinObj>(selectedLeaves);
        candidateLeaves.add(md.attractorTemplates);
        candidateLeaves.add(md.attractors);
        Composite<ICompElement> defaultRoot = CopyPasteUtil.getDefaultRoot(md, pasteEntry);
        Composite insertRoot = CopyPasteUtil.getBestPasteTarget(md, pasteObj, defaultRoot, selectedComposites, candidateLeaves);
        if (!CopyPasteUtil.validInsertRoot(this.getClass(), pasteObj, insertRoot, warnings)) {
            return;
        }
        Collection<INamed> nameSibs = insertRoot.getMembers(INamed.class);
        CopyPasteUtil.renamePasteObj(nameSibs, pasteObj);
        CopyPasteUtil.pasteIntoAndTransform(md, app, pasteObj, hints, allPastedObjs, insertRoot, true);
        allPastedObjs.accept(pasteObj);
    }
}

