/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.swing.Icon;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.BoundedStack;
import merlin.actions.CompositeUndo;
import merlin.actions.UIHook;
import merlin.data.Composite;
import merlin.data.ICompElement;
import merlin.data.IRestorable;
import merlin.data.MerlinData;
import merlin.data.MerlinSelectionModel;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.LinkedIdentityHashMap;

public class Undo {
    private static final int STACK_SIZE = 10;
    private static final BoundedStack<CompositeUndo> STACK_UNDO = new BoundedStack(10);
    private static final BoundedStack<CompositeUndo> STACK_REDO = new BoundedStack(10);
    private static CompositeUndo CURRENT_OP = null;
    private static final Stack<Integer> CURRENT_OP_MARKERS = new Stack();
    private static boolean ACCEPTING = true;
    public static final Object UNDO_REDO = "Undo.UNDO_REDO";
    public static final UndoStatus UNDO_STATUS = new UndoStatus();
    public static final Icon ICON_UNDO = UIHook.loadIcon("thunderheadeng/gui/graphics/Undo16.gif");
    public static final UIHook UI_HOOK_UNDO = new UIHook(new UndoAction(), Intl.intl("&Undo,Z,Undo last action,Undo last action"), ICON_UNDO, 16);
    public static final Icon ICON_REDO = UIHook.loadIcon("thunderheadeng/gui/graphics/Redo16.gif");
    public static final UIHook UI_HOOK_REDO = new UIHook(new RedoAction(), Intl.intl("&Redo,Y,Redo last action,Redo last action"), ICON_REDO, 16);

    public static boolean canUndo() {
        return STACK_UNDO.size() > 0;
    }

    public static String getUndoName() {
        return !Undo.canUndo() ? Intl.intl("Undo") : String.format(Intl.intl("Undo %s"), STACK_UNDO.peek().getName());
    }

    public static boolean canRedo() {
        return STACK_REDO.size() > 0;
    }

    public static String getRedoName() {
        return !Undo.canRedo() ? Intl.intl("Redo") : String.format(Intl.intl("Redo %s"), STACK_REDO.peek().getName());
    }

    private static void fireChangeEvt(MerlinData md) {
        md.getEvents().changed(UNDO_STATUS, UNDO_REDO);
    }

    public static void undo(MerlinData md) {
        md.beginWrite();
        try {
            if (!Undo.canUndo()) {
                return;
            }
            UndoOp undoTo = STACK_UNDO.pop();
            UndoOp currentState = undoTo.perform(md.selection);
            STACK_REDO.push((CompositeUndo)currentState);
            Undo.fireChangeEvt(md);
        }
        finally {
            md.endWrite();
        }
    }

    public static void redo(MerlinData md) {
        md.beginWrite();
        try {
            if (!Undo.canRedo()) {
                return;
            }
            UndoOp redoTo = STACK_REDO.pop();
            UndoOp currentState = redoTo.perform(md.selection);
            STACK_UNDO.push((CompositeUndo)currentState);
            Undo.fireChangeEvt(md);
        }
        finally {
            md.endWrite();
        }
    }

    private static void pushNewOp(CompositeUndo op) {
        STACK_UNDO.push(op);
        STACK_REDO.clear();
    }

    public static void insertEntry_breakChain(MerlinData md) {
        if (Undo.accepting()) {
            ACCEPTING = false;
        }
        STACK_UNDO.clear();
        STACK_REDO.clear();
        CURRENT_OP = null;
        Undo.fireChangeEvt(md);
    }

    private static void print(String s) {
    }

    public static boolean accepting() {
        return ACCEPTING && CURRENT_OP != null;
    }

    public static void insertEntry(MerlinData md, UndoOp op) {
        if (!Undo.accepting()) {
            return;
        }
        Undo.print("insertEntry: " + op.toString());
        CURRENT_OP.insertEntry(op);
    }

    public static void clearCurrentOp() {
        if (!Undo.accepting()) {
            return;
        }
        CURRENT_OP.clear();
    }

    public static void begin(String actionName) {
        if (CURRENT_OP == null && ACCEPTING) {
            CURRENT_OP = new CompositeUndo(actionName);
        }
        int marker = CURRENT_OP == null ? 0 : CURRENT_OP.marker();
        CURRENT_OP_MARKERS.push(marker);
        if (Undo.accepting()) {
            Undo.print("begin()");
        }
    }

    public static void end(MerlinData md) {
        Undo.end(md, true);
    }

    public static void end(MerlinData md, boolean keepLast) {
        int lastMarker = CURRENT_OP_MARKERS.pop();
        if (CURRENT_OP_MARKERS.isEmpty()) {
            ACCEPTING = true;
        }
        if (!Undo.accepting()) {
            return;
        }
        Undo.print("end()");
        if (!keepLast) {
            md.beginWrite();
            try {
                CURRENT_OP.cancel(lastMarker, null);
            }
            finally {
                md.endWrite();
            }
        }
        if (CURRENT_OP_MARKERS.isEmpty()) {
            CompositeUndo op = CURRENT_OP;
            CURRENT_OP = null;
            if (!op.isEmpty()) {
                op.complete();
                Undo.pushNewOp(op);
                Undo.fireChangeEvt(md);
            }
        }
    }

    public static void insertUndoEntry_delete(MerlinData md, Composite<?> parent, Collection<?> objs) {
        if (!Undo.accepting()) {
            return;
        }
        Undo.insertEntry(md, new DelOp(parent, objs));
    }

    public static void insertUndoEntry_delete(MerlinData md, Composite<?> parent, Object ... objs) {
        if (!Undo.accepting()) {
            return;
        }
        Undo.insertUndoEntry_delete(md, parent, Arrays.asList(objs));
    }

    public static void insertUndoEntry_add(MerlinData md, Object ... objs) {
        if (!Undo.accepting()) {
            return;
        }
        Undo.insertUndoEntry_add(md, Arrays.asList(objs));
    }

    public static void insertUndoEntry_add(MerlinData md, Collection<?> objs) {
        if (!Undo.accepting()) {
            return;
        }
        for (Object child : objs) {
            Object parent = md.hierarchy.getParent(child);
            if (!(parent instanceof Composite)) continue;
            Undo.insertEntry(md, new AddOp((Composite)parent, Arrays.asList(child)));
        }
    }

    public static void insertUndoEntry_insert(MerlinData md, Object obj) {
        if (!Undo.accepting()) {
            return;
        }
        Object parent = md.hierarchy.getParent(obj);
        if (parent instanceof Composite) {
            Composite cparent = (Composite)parent;
            Undo.insertEntry(md, new InsertOp(cparent, Arrays.asList(obj), cparent.indexOf((ICompElement)obj)));
        }
    }

    public static void insertUndoEntry_restore(MerlinData md, Collection<? extends IRestorable> objs) {
        if (!Undo.accepting()) {
            return;
        }
        for (IRestorable iRestorable : objs) {
            Undo.insertUndoEntry_restore(md, iRestorable);
        }
    }

    public static void insertUndoEntry_restore(MerlinData md, IRestorable obj) {
        if (!Undo.accepting()) {
            return;
        }
        Undo.insertEntry(md, new RestoreOp(obj, obj.getRestoreObj(), md.selection.isSelected(obj)));
    }

    public static void insertUndoEntry_restore(MerlinData md, IRestorable obj, boolean select) {
        if (!Undo.accepting()) {
            return;
        }
        Undo.insertEntry(md, new RestoreOp(obj, obj.getRestoreObj(), select));
    }

    public static void insertUndoEntry_restore(MerlinData md, IRestorable obj, Object momento, boolean select) {
        if (!Undo.accepting()) {
            return;
        }
        Undo.insertEntry(md, new RestoreOp(obj, momento, select));
    }

    public static void insertUndoEntry_propRestore(MerlinData md, Collection<? extends ICompElement> objs, Object prop) {
        if (!Undo.accepting()) {
            return;
        }
        Undo.insertEntry(md, new PropRestoreOp(prop, objs));
    }

    private static byte[] getBytesForObject(Serializable s) {
        ByteArrayOutputStream osMemState = new ByteArrayOutputStream();
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(osMemState);
            oos.writeObject(s);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return osMemState.toByteArray();
    }

    public static Serializable getObjectFromBytes(byte[] bytes) {
        ByteArrayInputStream isMemState = new ByteArrayInputStream(bytes);
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(isMemState);
            return (Serializable)ois.readObject();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static class PropRestoreOp
    implements UndoOp {
        private Object d_prop;
        private Collection<? extends ICompElement> d_objs;
        private Map<ICompElement, Object> d_vals;

        public PropRestoreOp(Object prop, Collection<? extends ICompElement> objs) {
            this.d_prop = prop;
            this.d_objs = objs;
            this.d_vals = new LinkedIdentityHashMap<ICompElement, Object>();
            for (ICompElement iCompElement : this.d_objs) {
                this.d_vals.put(iCompElement, iCompElement.getProperty(this.d_prop));
            }
        }

        @Override
        public UndoOp perform(MerlinSelectionModel sel) {
            PropRestoreOp undo = new PropRestoreOp(this.d_prop, this.d_objs);
            for (ICompElement iCompElement : this.d_objs) {
                iCompElement.setProperty(this.d_prop, this.d_vals.get(iCompElement));
            }
            return undo;
        }
    }

    public static class RestoreOp
    implements UndoOp {
        private IRestorable d_obj;
        private Object d_momento;
        private boolean d_select;

        public RestoreOp(IRestorable obj, Object momento, boolean select) {
            this.d_obj = obj;
            this.d_momento = momento;
            this.d_select = select;
        }

        public IRestorable getObj() {
            return this.d_obj;
        }

        public Object getMomento() {
            return this.d_momento;
        }

        public boolean getSelect() {
            return this.d_select;
        }

        @Override
        public RestoreOp perform(MerlinSelectionModel sel) {
            RestoreOp undo = new RestoreOp(this.d_obj, this.d_obj.getRestoreObj(), this.d_select);
            this.d_obj.restoreFrom(this.d_momento);
            if (sel != null && this.d_select) {
                sel.clear();
                sel.select(this.d_obj);
            }
            return undo;
        }

        public String toString() {
            return this.getClass().getName() + "[obj=" + this.d_obj.getClass().getName() + ",momento=" + this.d_momento.getClass().getName() + "]";
        }
    }

    public static class DelOp
    implements UndoOp {
        private Composite<?> d_delFrom;
        private Collection<?> d_objs;

        public DelOp(Composite<?> delFrom, Collection<?> objs) {
            this.d_delFrom = delFrom;
            this.d_objs = objs;
        }

        @Override
        public UndoOp perform(MerlinSelectionModel sel) {
            sel.clear();
            this.d_delFrom.removeAll(this.d_objs);
            return new AddOp(this.d_delFrom, this.d_objs);
        }

        public String toString() {
            return this.getClass().getName() + "[delFrom=" + this.d_delFrom.getName() + ",|objs|=" + this.d_objs.size() + "]";
        }
    }

    public static class InsertOp<T extends ICompElement>
    implements UndoOp {
        private final Composite<? super T> d_parent;
        private final Object d_objects;
        private final int d_ix;

        public InsertOp(Composite<? super T> parent, Collection<? extends ICompElement> objs, int ix) {
            assert (objs.stream().allMatch(o -> parent.getFilter().test((ICompElement)o)));
            this.d_parent = parent;
            this.d_objects = objs.size() == 1 ? objs.iterator().next() : objs;
            this.d_ix = ix;
        }

        protected Collection<? extends ICompElement> getObjs() {
            return this.d_objects instanceof Collection ? (List<ICompElement>)this.d_objects : Collections.singletonList((ICompElement)this.d_objects);
        }

        @Override
        public UndoOp perform(MerlinSelectionModel sel) {
            InsertOp<? super T> undo = new InsertOp<T>(this.d_parent, this.getObjs(), this.d_ix);
            Collection<ICompElement> objs = this.getObjs();
            if (objs.isEmpty()) {
                return undo;
            }
            ICompElement first = objs.iterator().next();
            if (this.d_parent.contains(first)) {
                sel.clear();
                this.d_parent.removeAll(objs);
            } else {
                this.d_parent.insert(objs, this.d_ix);
                sel.set(objs);
            }
            return undo;
        }
    }

    public static class AddOp
    implements UndoOp {
        private Composite<?> d_addTo;
        private Collection<?> d_objs;

        public AddOp(Composite<?> addTo, Collection<?> objs) {
            this.d_addTo = addTo;
            this.d_objs = objs;
        }

        @Override
        public UndoOp perform(MerlinSelectionModel sel) {
            DelOp undo = new DelOp(this.d_addTo, this.d_objs);
            this.d_addTo.addAll(this.d_objs);
            if (sel != null) {
                sel.clear();
                sel.selectAll(this.d_objs);
            }
            return undo;
        }

        public String toString() {
            return this.getClass().getName() + "[addTo=" + this.d_addTo.getName() + ",|objs|=" + this.d_objs.size() + "]";
        }
    }

    public static interface UndoOp {
        public UndoOp perform(MerlinSelectionModel var1);
    }

    private static class RedoAction
    extends AMerlinOp
    implements IEventObserver {
        public RedoAction() {
            MerlinApp.getApp().getData().getEvents().addObserver(this);
            this.setEnabled(Undo.canRedo());
        }

        @Override
        public void run(MerlinApp app, MerlinData md) {
            Undo.redo(md);
        }

        @Override
        public void update(Events events) {
            if (events.isAffected(UndoStatus.class)) {
                this.setEnabled(Undo.canRedo());
                String newName = Undo.getRedoName();
                UI_HOOK_REDO.setName(newName);
                UI_HOOK_REDO.setShortDesc(newName);
                UI_HOOK_REDO.setLongDesc(newName);
            }
        }
    }

    private static class UndoAction
    extends AMerlinOp
    implements IEventObserver {
        public UndoAction() {
            MerlinApp.getApp().getData().getEvents().addObserver(this);
            this.setEnabled(Undo.canUndo());
        }

        @Override
        public void run(MerlinApp app, MerlinData md) {
            Undo.undo(md);
        }

        @Override
        public void update(Events events) {
            if (events.isAffected(UndoStatus.class)) {
                this.setEnabled(Undo.canUndo());
                String newName = Undo.getUndoName();
                UI_HOOK_UNDO.setName(newName);
                UI_HOOK_UNDO.setShortDesc(newName);
                UI_HOOK_UNDO.setLongDesc(newName);
            }
        }
    }

    public static class UndoStatus {
    }
}

