/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import java.util.Map;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.SelectionObserver;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.data.MerlinData;
import merlin.data.OccGroupObj;
import merlin.data.egress.agents.EgressAgent;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.LinkedIdentityHashMap;

public class SetGroupLeaderAction
extends AMerlinOp
implements IEventObserver {
    public static final String actionName = Intl.intl("Set Group Leader");
    public static final UIHook UI_HOOK = new UIHook(new SetGroupLeaderAction(), actionName);

    public SetGroupLeaderAction() {
        SelectionObserver.add(this, EgressAgent.class);
        this.update(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(MerlinApp app, MerlinData md) {
        md.beginWrite();
        try {
            OccGroupObj group;
            LinkedIdentityHashMap<OccGroupObj, EgressAgent> groupLeaders = new LinkedIdentityHashMap<OccGroupObj, EgressAgent>();
            for (EgressAgent egressAgent : md.selection.flatten(EgressAgent.class)) {
                group = egressAgent.getMovementGroup();
                if (group == null) continue;
                groupLeaders.putIfAbsent(group, egressAgent);
            }
            Undo.begin(Intl.intl("Set Group Leader"));
            Undo.insertUndoEntry_propRestore(md, groupLeaders.keySet(), OccGroupObj.PROP_GROUP_LEADER);
            Undo.insertUndoEntry_propRestore(md, groupLeaders.keySet(), OccGroupObj.PROP_REQUIRES_GROUP_LEADER);
            for (Map.Entry entry : groupLeaders.entrySet()) {
                group = (OccGroupObj)entry.getKey();
                EgressAgent agent = (EgressAgent)entry.getValue();
                group.setProperty(OccGroupObj.PROP_GROUP_LEADER, agent);
                group.setProperty(OccGroupObj.PROP_REQUIRES_GROUP_LEADER, Boolean.valueOf(true));
            }
            Undo.end(md);
        }
        finally {
            md.endWrite();
        }
    }

    @Override
    public void update(Events events) {
        MerlinApp app = MerlinApp.getApp();
        MerlinData data = app.getData();
        boolean hasGroupAgent = !data.selection.flatten(EgressAgent.class, a -> a.getMovementGroup() != null).isEmpty();
        this.setEnabled(hasGroupAgent);
    }
}

