/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import inferno.sim.Engine;
import inferno.sim.Param;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.SecondaryLoop;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntPredicate;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.vecmath.Point3d;
import merlin.EntryPoint;
import merlin.EntryPointFactory;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.Behemoth;
import merlin.actions.CancelledException;
import merlin.actions.InfernoUtil;
import merlin.actions.MerlinOp;
import merlin.actions.Save;
import merlin.actions.UIHook;
import merlin.actions.WriteMesh;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.data.OccSourceObj;
import merlin.data.egress.SimError;
import merlin.data.egress.agents.EgressAgent;
import merlin.data.egress.agents.OccProfile;
import merlin.data.egress.geom.AEgressComp;
import merlin.data.egress.geom.IEgressComp;
import merlin.data.egress.geom.IEgressConnector;
import merlin.data.egress.geom.IEgressOccupiable;
import merlin.data.egress.scripting.Behavior;
import merlin.data.egress.scripting.GotoExits;
import merlin.data.egress.scripting.GotoQueue;
import merlin.data.egress.scripting.IDestination;
import merlin.data.egress.scripting.IDestinationAction;
import merlin.data.egress.scripting.IUnreachable;
import merlin.data.egress.scripting.queues.QueueObject;
import merlin.data.stat.DisabledCurve;
import merlin.gui.RunSimDlg;
import merlin.mv.ModelView;
import merlin.util.Dependencies;
import merlin.util.MerlinUtil;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.AABoxTest;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.nmt.Edge;
import thunderheadeng.geometry.nmt.Face;
import thunderheadeng.geometry.nmt.Model;
import thunderheadeng.geometry.nmt.NmtUtil;
import thunderheadeng.geometry.search.IResult;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.CrashCatcher;
import thunderheadeng.gui.WarningDlg;
import thunderheadeng.gui.guiJFXFileChooser;
import thunderheadeng.gui.guiUtil;
import thunderheadeng.io.ExampleFileFilter;
import thunderheadeng.scene3d.geom.IDisplayableGeomSrc;
import thunderheadeng.util.FileFilters;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IEventRecord;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.SmvParseUtil;
import thunderheadeng.util.TriConsumer;
import thunderheadeng.util.WarningReport;
import thunderheadeng.util.theTimer;
import thunderheadeng.util.theUtil;

public class RunInferno
extends AMerlinOp {
    public static final Icon ICON = UIHook.loadIcon("merlin/icons/run16.png");
    public static final UIHook UI_HOOK_RUN = new UIHook((MerlinOp)new RunInferno(false), Intl.intl("&Run Simulation...,-,Run Simulation"), ICON);
    public static final UIHook UI_HOOK_DEBUG = new UIHook((MerlinOp)new RunInferno(true), Intl.intl("&Debug Simulation...,-,Debug Simulation"), null);
    private static final Logger LOGGER = Logger.getLogger(RunInferno.class.getName());
    public static AtomicInteger COUNT = new AtomicInteger(0);
    public static boolean d_closeOnFinish = false;
    private final boolean d_debug;

    public RunInferno(boolean debug) {
        this.d_debug = debug;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(MerlinApp app, MerlinData md) {
        InfernoData inferno;
        JFrame parentFrame = app.getActiveFrame();
        final RunSimDlg dlg = new RunSimDlg(parentFrame);
        dlg.beginWaitCursor();
        Runnable showDlg = new Runnable(){

            @Override
            public void run() {
                dlg.doModeless();
            }
        };
        final Handler dlgHandler = dlg.createLogHandler();
        dlgHandler.setLevel(Level.INFO);
        Logger.getLogger("").addHandler(dlgHandler);
        try {
            inferno = RunInferno.prepareEngine(app, md, showDlg, this.d_debug);
            if (inferno == null) {
                return;
            }
            dlg.setTitleFromPath(inferno.filename);
        }
        catch (CancelledException e) {
            dlg.setVisible(false);
            return;
        }
        finally {
            dlg.endWaitCursor();
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    RunInferno.run(dlg, inferno.filename, inferno.dir, inferno.engine, new RunSimDlg.DlgListener[0]);
                }
                finally {
                    Logger.getLogger("").removeHandler(dlgHandler);
                }
            }
        }).start();
    }

    private static void getRoomFaces(AABox bounds, IEgressOccupiable room, Consumer<Face> result) {
        int[] boxid = new int[]{10463731};
        IntPredicate gtest = g -> g != boxid[0];
        try {
            Model model = room.getModel().clone();
            boolean allAdded = true;
            for (Point3d[] face : bounds.getFaces()) {
                Plane3d plane = Util3D.simplePolygonPlane(Arrays.asList(face), true);
                if (plane != null && model.addPolygonFace(plane, new Point3d[][]{face}, boxid, Collections.nCopies(4, boxid), Collections.emptyList())) continue;
                allAdded = false;
                break;
            }
            if (!allAdded) {
                return;
            }
            IdentityHashSet closedFaces = new IdentityHashSet();
            for (Edge edge : model.getEdges(boxid[0])) {
                for (Face eface : edge.faces) {
                    Point3d tp;
                    if (!closedFaces.add(eface) || !NmtUtil.testGroups(eface.groups, gtest) || (tp = model.findPointInFace(eface)) == null || !bounds.contains(tp, 1.0E-6)) continue;
                    result.accept(eface);
                }
            }
        }
        catch (CancellationException e) {
            throw e;
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private static void getRoomLineSegs(AABox bounds, IEgressOccupiable room, Consumer<Edge> result) {
        int[] boxid = new int[]{10463731};
        try {
            Model model = room.getModel().clone();
            boolean anyAdded = false;
            for (Point3d[] face : bounds.getFaces()) {
                Plane3d plane = Util3D.simplePolygonPlane(Arrays.asList(face), true);
                anyAdded |= plane != null && model.addPolygonFace(plane, new Point3d[][]{face}, boxid, Collections.nCopies(4, boxid), Collections.emptyList());
            }
            if (!anyAdded) {
                return;
            }
            IntPredicate gtest = g -> g != boxid[0];
            for (Edge edge : model.getEdges(boxid[0])) {
                if (!NmtUtil.testGroups(edge.groups, gtest)) continue;
                result.accept(edge);
            }
        }
        catch (CancellationException e) {
            throw e;
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private static boolean isArea(AABox box) {
        return !theUtil.eq0(box.getWidth(), 1.0E-6) && !theUtil.eq0(box.getDepth(), 1.0E-6);
    }

    private static boolean testAABoxPartiallyContainsRoom(AABox bounds, IEgressOccupiable room) {
        boolean[] result = new boolean[]{false};
        try {
            RunInferno.getRoomFaces(bounds, room, f -> {
                result[0] = true;
                throw new CancellationException();
            });
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
        return result[0];
    }

    private static boolean testAABoxIntersectsRoom(AABox bounds, IEgressOccupiable room) {
        boolean[] result = new boolean[]{false};
        try {
            RunInferno.getRoomLineSegs(bounds, room, e -> {
                result[0] = true;
                throw new CancellationException();
            });
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
        return result[0];
    }

    private static void validateExits(MerlinData md, Consumer<SimError> addError) {
        IFilteredCollection<IEgressConnector> exits = theUtil.filter(md.getAllExits(), d -> !(d instanceof AEgressComp) || ((AEgressComp)((Object)d)).isEnabled());
        if (exits.isEmpty()) {
            IdentityHashSet closedBehaviors = new IdentityHashSet();
            Function<Behavior, SimError> getBehaviorError = behavior -> {
                Optional<GotoExits> badExit;
                if (closedBehaviors.add(behavior) && (badExit = behavior.deepFlatten(GotoExits.class).stream().filter(GotoExits::isGotoAny).findFirst()).isPresent()) {
                    return new SimError(SimError.Level.CRITICAL, Intl.intl("Simulation requires at least one exit door."), Intl.intl("Create at least one exit door."), badExit.get());
                }
                return null;
            };
            for (EgressAgent agent : md.agents.flatten(EgressAgent.class)) {
                Behavior behavior2 = agent.getBehavior();
                SimError error = getBehaviorError.apply(behavior2);
                addError.accept(error);
            }
            for (OccSourceObj os : md.occSources.flatten(OccSourceObj.class)) {
                List behaviors = os.get(OccSourceObj.PROP_BEHAVIOR_DIST).getUnique(ArrayList.class);
                for (Behavior behavior3 : behaviors) {
                    SimError error = getBehaviorError.apply(behavior3);
                    addError.accept(error);
                }
            }
        }
    }

    private static void validateSocialDistance(MerlinData md, Consumer<SimError> addError, Param p) {
        if (p.force_separation) {
            LinkedIdentityHashSet badObjs = new LinkedIdentityHashSet();
            for (EgressAgent agent : md.agents.flatten(EgressAgent.class)) {
                OccProfile occProfile = agent.getProfile();
                if (occProfile.getProperty(OccProfile.PROP_SOCIAL_DIST) instanceof DisabledCurve) continue;
                if (occProfile.isDefinedLocally(OccProfile.PROP_SOCIAL_DIST)) {
                    badObjs.add(agent);
                    continue;
                }
                badObjs.add(occProfile.getProfParent());
            }
            if (!badObjs.isEmpty()) {
                addError.accept(new SimError(SimError.Level.MODERATE, Intl.intl("Both Forced Separation and Social Distancing are enabled."), Intl.intl("Disable Forced Separation in the Simulation Parameters, or disable Social Distancing on affected Occupants."), badObjs));
            }
        }
    }

    private static void validateQueues(MerlinData md, Consumer<SimError> addError) throws CancellationException {
        HashSet<GotoQueue> gotosToCheck = new HashSet<GotoQueue>();
        for (EgressAgent occ : MerlinUtil.getEnabledMembers(md, md.agents, EgressAgent.class, true)) {
            gotosToCheck.addAll(occ.getBehavior().deepFlatten(GotoQueue.class));
        }
        for (OccSourceObj src : MerlinUtil.getEnabledMembers(md, md.occSources, OccSourceObj.class, true)) {
            for (Behavior behavior : src.getAllBehaviors()) {
                gotosToCheck.addAll(behavior.deepFlatten(GotoQueue.class));
            }
        }
        for (GotoQueue gotoQ : gotosToCheck) {
            if (gotoQ.getQueues().isEmpty()) {
                addError.accept(new SimError(SimError.Level.CRITICAL, Intl.intl("No queues are selected."), Intl.intl("Specify queues to go to."), gotoQ));
            }
            Collection<QueueObject> needToTestQueues = gotoQ.getQueues();
            for (QueueObject qo : needToTestQueues) {
                qo.validate(md, SimError.Level.CRITICAL, addError);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void validateDestinations(MerlinData md, Consumer<SimError> addError) throws CancelledException {
        Collection<EgressAgent> agents = md.agents.getDeepMembers(EgressAgent.class);
        ExecutorService runner = Executors.newFixedThreadPool(Engine.getNumProcThreads());
        try {
            HashMap uniqueFutures = new HashMap();
            ArrayList futures = new ArrayList();
            Function<Pair, Future> newFuture = key -> runner.submit(() -> ((IDestination)key.v2).getUnreachable((IEgressComp)key.v1));
            Consumer<Tuple3> submitTest = t -> {
                Pair<IEgressComp, IDestination> key = new Pair<IEgressComp, IDestination>((IEgressComp)t.v2, (IDestination)t.v3);
                Future future = (Future)uniqueFutures.computeIfAbsent(key, newFuture);
                futures.add(new Pair<IMerlinObj, Future>((IMerlinObj)t.v1, future));
            };
            LinkedIdentityHashMap behaviorDestMap = new LinkedIdentityHashMap();
            LinkedIdentityHashSet<Behavior> usedBehaviors = Dependencies.getObjReferences(md, Behavior.class, Predicates.alwaysTrue());
            for (Behavior behavior : usedBehaviors) {
                ArrayList<Pair<IDestinationAction, IDestination>> dests = new ArrayList<Pair<IDestinationAction, IDestination>>();
                for (IDestinationAction destAction : behavior.getMembers(IDestinationAction.class)) {
                    dests.add(new Pair<IDestinationAction, IDestination>(destAction, destAction.getDestination()));
                }
                for (int m = 0; m < dests.size() - 1; ++m) {
                    Collection<? extends IEgressComp> exitComps;
                    Pair dest1 = (Pair)dests.get(m);
                    try {
                        exitComps = ((IDestination)dest1.v2).getExitComponents();
                    }
                    catch (Exception e) {
                        break;
                    }
                    if (exitComps.isEmpty()) {
                        addError.accept(new SimError(SimError.Level.CRITICAL, Intl.intl("Invalid destination."), "", behavior));
                        continue;
                    }
                    Pair dest2 = (Pair)dests.get(m + 1);
                    for (IEgressComp iEgressComp : exitComps) {
                        Behavior source = dest1.v1 instanceof IMerlinObj ? (IMerlinObj)dest1.v1 : behavior;
                        submitTest.accept(new Tuple3<Behavior, IEgressComp, IDestination>(source, iEgressComp, (IDestination)dest2.v2));
                    }
                }
                behaviorDestMap.put(behavior, dests);
            }
            for (EgressAgent occ : agents) {
                if (!occ.isEnabled()) continue;
                IEgressOccupiable room = occ.getRoom();
                List dests = (List)behaviorDestMap.get(occ.getBehavior());
                if (dests.isEmpty()) continue;
                IDestination firstDest = (IDestination)((Pair)dests.get((int)0)).v2;
                submitTest.accept(new Tuple3<EgressAgent, IEgressOccupiable, IDestination>(occ, room, firstDest));
            }
            TriConsumer<IMerlinObj, IEgressComp, Collection> addTests = (obj, comp, behaviors) -> {
                for (Behavior behavior : behaviors) {
                    List dests = (List)behaviorDestMap.get(behavior);
                    if (dests.isEmpty()) continue;
                    IDestination firstDest = (IDestination)((Pair)dests.get((int)0)).v2;
                    submitTest.accept(new Tuple3<IMerlinObj, IEgressComp, IDestination>((IMerlinObj)obj, (IEgressComp)comp, firstDest));
                }
            };
            for (OccSourceObj os : md.occSources.flatten(OccSourceObj.class)) {
                if (!os.isEnabled()) continue;
                IEgressComp comp2 = os.getComponent();
                List behaviors2 = os.get(OccSourceObj.PROP_BEHAVIOR_DIST).getUnique(ArrayList.class);
                if (comp2 != null) {
                    addTests.accept(os, comp2, behaviors2);
                    continue;
                }
                AABox bounds = os.getGeom().getBoundingBox(new AABox());
                IResult<IDisplayableGeomSrc> searchResult = (obj, ctmt) -> {
                    if (!(obj instanceof IEgressOccupiable) || !((IEgressOccupiable)obj).getOccupantsAllowed()) {
                        return;
                    }
                    IEgressOccupiable room = (IEgressOccupiable)obj;
                    boolean isArea = RunInferno.isArea(bounds);
                    if (isArea && RunInferno.testAABoxPartiallyContainsRoom(bounds, room) || !isArea && RunInferno.testAABoxIntersectsRoom(bounds, room)) {
                        addTests.accept(os, room, behaviors2);
                    }
                };
                md.geomLocation.getLocator().find((ITest<AABox>)new AABoxTest(bounds, 1.0E-6), searchResult, 1);
            }
            for (Pair entry : futures) {
                try {
                    IUnreachable result = (IUnreachable)((Future)entry.v2).get();
                    if (result == null) continue;
                    addError.accept(result.getError((IMerlinObj)entry.v1));
                }
                catch (ExecutionException e) {
                    throw new RuntimeException(e.getCause());
                }
                catch (InterruptedException e) {
                }
            }
            for (EgressAgent occ : agents) {
                EntryPoint<EgressAgent> ep = EntryPointFactory.get(occ);
                for (SimError err : ep.tvEntryPoint.getErrors(md, occ)) {
                    addError.accept(err);
                }
            }
        }
        finally {
            try {
                runner.shutdownNow();
            }
            catch (Throwable t2) {
                t2.printStackTrace();
            }
        }
    }

    private static void validateBehaviors(MerlinData md, Consumer<SimError> addError) {
        for (EgressAgent agent : MerlinUtil.getEnabledMembers(md, md.agents.flatten(), EgressAgent.class)) {
            Behavior behavior = agent.getBehavior();
            if (behavior.getDomain() != null) continue;
            addError.accept(new SimError(SimError.Level.CRITICAL, Intl.intl("Invalid behavior detected in the model."), Intl.intl("Reassign agent's behavior."), agent));
        }
    }

    private static List<SimError> validate(MerlinData md, Param p) throws CancelledException {
        ArrayList<SimError> errors = new ArrayList<SimError>();
        Consumer<SimError> addError = e -> {
            if (e != null) {
                errors.add((SimError)e);
            }
        };
        RunInferno.validateExits(md, addError);
        RunInferno.validateSocialDistance(md, addError, p);
        RunInferno.validateDestinations(md, addError);
        RunInferno.validateQueues(md, addError);
        RunInferno.validateBehaviors(md, addError);
        return errors;
    }

    public static void quickCheckForErrors(MerlinApp app, MerlinData md) throws CancelledException {
        String msg;
        Collection<SimError> errors = EntryPointFactory.get(md).tvEntryPoint.getErrors(md, md);
        if (!errors.isEmpty()) {
            SimError.Level maxLevel = SimError.Level.MODERATE;
            for (SimError error : errors) {
                if (error.level.severity <= maxLevel.severity) continue;
                maxLevel = error.level;
            }
            if (maxLevel == SimError.Level.CRITICAL) {
                msg = Intl.intl("The model contains errors.  Expand the tree on the left to identify the errors.");
                JOptionPane.showMessageDialog(app.getActiveFrame(), msg, Intl.intl("Model Errors"), 0);
                throw CancelledException.INSTANCE;
            }
            msg = Intl.intl("The model contains warnings.  Expand the tree on the left to identify the warnings.\nWould you like to ignore the warnings and continue?");
            int option = JOptionPane.showConfirmDialog(app.getActiveFrame(), msg, Intl.intl("Model Problems"), 0, 2);
            if (option != 0) {
                throw CancelledException.INSTANCE;
            }
        }
        if (md.simParams.smvDataEnable) {
            File f = MerlinUtil.resolveFile(md.simParams.smvDataFileName).toFile();
            if (!f.exists() || !f.canRead()) {
                if (!RunInferno.retryCheckingForResultsFiles(f, md.filename, md)) {
                    msg = Intl.intl("FDS integration is enabled, but FDS output data not found:\n" + md.simParams.smvDataFileName + "\n\nDisable FDS integration to continue.");
                    JOptionPane.showMessageDialog(app.getActiveFrame(), msg, Intl.intl("Model Error"), 0);
                    throw CancelledException.INSTANCE;
                }
            } else if (!SmvParseUtil.isSmvValid(f)) {
                msg = Intl.intl("FDS integration is enabled, but FDS results files are missing:\n" + md.simParams.smvDataFileName + "\n\nDisable FDS integration to continue.");
                JOptionPane.showMessageDialog(app.getActiveFrame(), msg, Intl.intl("Model Error"), 0);
                throw CancelledException.INSTANCE;
            }
        }
    }

    private static boolean retryCheckingForResultsFiles(File smvFile, String pthFileName, MerlinData md) {
        File pthFile = new File(pthFileName);
        if (pthFile.getParentFile().exists()) {
            String smvFolderGuess = pthFile.getName().replace(" ", "_");
            int ix = smvFolderGuess.indexOf(".");
            if (ix == -1) {
                return false;
            }
            String smvPathGuess = pthFile.getParent() + File.separator + smvFolderGuess.substring(0, ix) + File.separator + smvFile.getName();
            System.out.println("smv path guess: " + smvPathGuess);
            File smvPathGuessFile = new File(smvPathGuess);
            if (SmvParseUtil.isSmvValid(smvPathGuessFile)) {
                LOGGER.warning(String.format("Original SMV file path invalid, replacing with %s", smvPathGuess));
                md.simParams.smvDataFileName = smvPathGuess;
                return true;
            }
            return false;
        }
        return false;
    }

    public static void thoroughCheckForErrors(MerlinApp app, MerlinData md, Param p) throws CancelledException {
        List<SimError> errors = RunInferno.validate(md, p);
        if (errors.isEmpty()) {
            return;
        }
        RunInferno.validateErrors(app, md, errors);
    }

    private static void validateErrors(MerlinApp app, final MerlinData md, Collection<? extends SimError> errors) throws CancelledException {
        if (errors.isEmpty()) {
            return;
        }
        IFilteredCollection<SimError> criticalErrors = theUtil.filter(errors, e -> e.level == SimError.Level.CRITICAL);
        IFilteredCollection<SimError> moderateErrors = theUtil.filter(errors, e -> e.level == SimError.Level.MODERATE);
        IFilteredCollection<SimError> showErrors = !criticalErrors.isEmpty() ? criticalErrors : moderateErrors;
        WarningReport<SimError> report = new WarningReport<SimError>(SimError.class, new int[]{0, 1, 2}, new String[]{Intl.intl("Message"), Intl.intl("How to Fix"), Intl.intl("Components")}, 0);
        for (SimError error : showErrors) {
            report.addWarning(error);
        }
        int investigateBtn = 2;
        WarningDlg<SimError> dlg = new WarningDlg<SimError>(app.getActiveFrame(), !criticalErrors.isEmpty() ? Intl.intl("Model Errors") : Intl.intl("Model Warnings"), !criticalErrors.isEmpty() ? Intl.intl("The following errors must be fixed before continuing.") : Intl.intl("The following issues might cause problems with the simulation. What would you like to do?"), report, !criticalErrors.isEmpty() ? investigateBtn | 0x10 : investigateBtn | 1 | 8 | 0x10, !criticalErrors.isEmpty() ? WarningDlg.Severity.ERROR : WarningDlg.Severity.WARNING);
        JButton resetToSelectedBtn = new JButton(Intl.intl("Show Selected Objects"));
        resetToSelectedBtn.setToolTipText(Intl.intl("Reset the view to the objects that may have caused the problems."));
        Consumer<List> selectObjs = objs -> {
            AMerlinOp selOp = new AMerlinOp((List)objs){
                final /* synthetic */ List val$objs;
                {
                    this.val$objs = list;
                }

                @Override
                public void run(MerlinApp app, MerlinData md) {
                    md.beginWrite();
                    try {
                        md.selection.set(this.val$objs);
                    }
                    finally {
                        md.endWrite();
                    }
                }
            };
            UIHook.run(resetToSelectedBtn, "Select Warning Objects", selOp, 0);
        };
        resetToSelectedBtn.addActionListener(e -> {
            List warnings = dlg.getSelectedWarnings();
            if (warnings.isEmpty()) {
                JOptionPane.showMessageDialog(dlg, Intl.intl("Select at least one row first."), Intl.intl("Select a Row"), 2);
                return;
            }
            List objs = warnings.stream().flatMap(se -> se.causeObjs.stream()).collect(Collectors.toList());
            if (objs.isEmpty()) {
                JOptionPane.showMessageDialog(dlg, Intl.intl("There are no objects associated with the selected rows."), Intl.intl("No Objects"), 2);
                return;
            }
            selectObjs.accept(objs);
            ModelView mv = app.getModelView();
            mv.getResetViewToSelOp().run(UIHook.getComponent(e));
        });
        dlg.getActionPanel().add((Component)resetToSelectedBtn, 0);
        resetToSelectedBtn.setVisible(false);
        BiConsumer<Integer, String> changeBtnText = (i, text) -> {
            JButton btn = dlg.getButton((int)i);
            if (btn == null) {
                return;
            }
            btn.setPreferredSize(null);
            btn.setText((String)text);
        };
        BiConsumer<Integer, Boolean> setBtnVisible = (i, vis) -> {
            JButton btn = dlg.getButton((int)i);
            if (btn != null) {
                btn.setVisible((boolean)vis);
            }
        };
        setBtnVisible.accept(16, false);
        if (criticalErrors.isEmpty()) {
            dlg.getButton(1).setText(Intl.intl("Ignore"));
            dlg.getButton(1).setToolTipText(Intl.intl("Ignore the errors and continue with the simulation."));
            dlg.getButton(8).setToolTipText(Intl.intl("Cancel the simulation."));
        }
        changeBtnText.accept(investigateBtn, Intl.intl("Investigate"));
        dlg.getButton(investigateBtn).setToolTipText(Intl.intl("Cancel the simulation and investigate errors."));
        final IEventObserver cancelObserver = events -> {
            IEventRecord<IMerlinObj> oevts = events.getEvents(IMerlinObj.class, new Class[0]);
            if (oevts.hasRemovedObjs()) {
                Set<IMerlinObj> removed = oevts.getRemovedObjs();
                dlg.removeIf(err -> err.causeObjs.stream().anyMatch(removed::contains));
            }
        };
        md.getEvents().addObserver(cancelObserver);
        EventQueue eq = Toolkit.getDefaultToolkit().getSystemEventQueue();
        final SecondaryLoop waitLoop = eq.createSecondaryLoop();
        boolean[] investigating = new boolean[]{false};
        dlg.getButton(investigateBtn).addActionListener(e -> {
            int opt;
            if (criticalErrors.isEmpty() && (opt = JOptionPane.showConfirmDialog(dlg, Intl.intl("Are you sure you want to cancel the simulation and investigate errors?"), Intl.intl("Cancel Simulation?"), 0, 3)) != 0) {
                return;
            }
            resetToSelectedBtn.setVisible(true);
            setBtnVisible.accept(16, true);
            setBtnVisible.accept(investigateBtn, false);
            setBtnVisible.accept(8, false);
            setBtnVisible.accept(1, false);
            dlg.setMessage(Intl.intl("Investigate the following errors:"));
            dlg.getTable().getSelectionModel().addListSelectionListener(le -> {
                if (!le.getValueIsAdjusting()) {
                    List objs = dlg.getSelectedWarnings().stream().flatMap(se -> se.causeObjs.stream()).collect(Collectors.toList());
                    if (objs.isEmpty()) {
                        return;
                    }
                    selectObjs.accept(objs);
                }
            });
            investigating[0] = true;
            waitLoop.exit();
        });
        dlg.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                md.getEvents().removeObserver(cancelObserver);
                waitLoop.exit();
            }
        });
        dlg.doModeless();
        waitLoop.enter();
        int status = dlg.getStatus();
        if (investigating[0] || status != 1 || !criticalErrors.isEmpty()) {
            throw new CancelledException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InfernoData prepareEngine(MerlinApp app, MerlinData md, Runnable preCheckCompleted, boolean debug) throws CancelledException {
        theTimer timer = new theTimer();
        Consumer<String> profileBegin = msg -> {
            LOGGER.info((String)msg);
            timer.reset();
        };
        Runnable profileEnd = () -> {
            LOGGER.info(String.format("Done (%.2f s)", timer.curr()));
            timer.reset();
        };
        try {
            Engine inferno;
            app.beginWaitCursor();
            profileBegin.accept(Intl.intl("Checking errors..."));
            RunInferno.quickCheckForErrors(app, md);
            profileEnd.run();
            String filename = md.filename;
            if (filename == null) {
                profileBegin.accept(Intl.intl("Saving model..."));
                if (!Save.saveToFile(app, md, false)) {
                    throw new CancelledException();
                }
                profileEnd.run();
            }
            String rootFn = InfernoUtil.rootFn(md.filename);
            File dir = new File(md.filename).getParentFile();
            Param p = InfernoUtil.mkInfernoParam(app, md, dir, rootFn, debug);
            List<File> efiles = RunInferno.getExistingFiles(p.getOuputFiles());
            if (!efiles.isEmpty()) {
                String msg2 = Intl.intl("Existing output files will be overwritten.\nWould you like to continue?");
                int option = JOptionPane.showConfirmDialog(MerlinApp.getApp().getActiveFrame(), msg2, Intl.intl("Overwrite Files?"), 0);
                if (option != 0) {
                    throw new CancelledException();
                }
            }
            if (preCheckCompleted != null) {
                preCheckCompleted.run();
            }
            profileBegin.accept(Intl.intl("Validating model..."));
            RunInferno.thoroughCheckForErrors(app, md, p);
            profileEnd.run();
            profileBegin.accept(Intl.intl("Creating simulation data"));
            ArrayList<SimError> errors = new ArrayList<SimError>();
            InfernoUtil.KBInfo kb = InfernoUtil.mkInfernoKB(md, p, errors);
            RunInferno.validateErrors(app, md, errors);
            profileEnd.run();
            md.beginRead();
            try {
                filename = md.filename;
                try {
                    profileBegin.accept(Intl.intl("Creating results files"));
                    WriteMesh.writeInputFile(md, dir, rootFn, kb, p);
                    profileEnd.run();
                }
                catch (IOException e) {
                    guiUtil.showError(app, Intl.intl("File Error"), Intl.intl("Could not write results files."), (Throwable)e);
                }
                kb.kb.init();
                try {
                    profileBegin.accept("Creating simulation engine...");
                    inferno = new Engine(app.getPrefs(), kb.kb, p, null);
                    profileEnd.run();
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace(p.err);
                    guiUtil.showError(app, Intl.intl("File Error"), Intl.intl("Could not write results files."), (Throwable)e);
                    InfernoData infernoData = null;
                    md.endRead();
                    app.endWaitCursor();
                    return infernoData;
                }
            }
            finally {
                md.endRead();
            }
            InfernoData infernoData = new InfernoData(dir, filename, inferno);
            return infernoData;
        }
        finally {
            app.endWaitCursor();
        }
    }

    private static List<File> getExistingFiles(File[] files) {
        ArrayList<File> efiles = new ArrayList<File>();
        for (File file : files) {
            if (!file.exists()) continue;
            efiles.add(file);
        }
        return efiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void run(RunSimDlg dlg, String filename, File runDir, Engine inferno, RunSimDlg.DlgListener ... listeners) {
        COUNT.incrementAndGet();
        try {
            Responder resp = new Responder();
            resp.filename = filename;
            dlg.addListener(resp);
            for (RunSimDlg.DlgListener list : listeners) {
                dlg.addListener(list);
            }
            dlg.setState(0);
            resp.inferno = inferno;
            dlg.setOccsTotal(inferno.getAgentCount());
            inferno.addObserver(new RunSimDlgUpdater(dlg));
            dlg.printToLog("running simulation");
            inferno.run();
            try {
                inferno.waitUntilFinished(100L);
                if (dlg.getResultsOnFinish() && !dlg.isCanceled()) {
                    RunInferno.showResults(filename);
                }
                if (d_closeOnFinish) {
                    dlg.setVisible(false);
                }
            }
            catch (FileNotFoundException e) {
                LOGGER.severe(Intl.intl("The simulation cannot continue:"));
                RunInferno.logExceptionChain(e);
            }
            catch (ExecutionException e) {
                Thread.UncaughtExceptionHandler handler = Thread.getDefaultUncaughtExceptionHandler();
                if (handler instanceof CrashCatcher) {
                    RunInferno.logExceptionChain(e);
                    String title = String.format(Intl.intl("An error occurred during the simulation."), new Object[0]);
                    ((CrashCatcher)handler).report(dlg, title, Thread.currentThread(), e.getCause());
                }
                throw new RuntimeException(e.getCause());
            }
            resp.inferno = null;
        }
        finally {
            COUNT.decrementAndGet();
        }
    }

    private static void logExceptionChain(Throwable t) {
        if (t != null) {
            String message = String.format("[%s] %s", t.getClass().getSimpleName(), t.getMessage());
            LOGGER.severe(message);
            RunInferno.logExceptionChain(t.getCause());
        }
    }

    private static void showResults(final String filename) {
        Thread t = new Thread(){

            @Override
            public void run() {
                Behemoth.run(filename);
            }
        };
        t.start();
    }

    private static class RunSimDlgUpdater
    implements Observer {
        private RunSimDlg d_dlg;

        public RunSimDlgUpdater(RunSimDlg dlg) {
            this.d_dlg = dlg;
        }

        @Override
        public void update(Observable o, Object arg) {
            int dlgState;
            assert (o instanceof Engine);
            IPropertySet meta = (IPropertySet)arg;
            double t = meta.get(Engine.META_TIME_SIM);
            int occs = meta.get(Engine.META_OCCS_REM);
            int occsTotal = meta.get(Engine.META_OCCS_TOTAL);
            double maxDTG = meta.get(Engine.META_DTG_MAX);
            double avgDTG = meta.get(Engine.META_DTG_AVG);
            double minDTG = meta.get(Engine.META_DTG_MIN);
            boolean stuck = meta.get(Engine.META_STUCK_STATUS);
            Engine.State state = meta.get(Engine.META_STATE);
            this.d_dlg.setSimTime(t);
            this.d_dlg.setOccsRem(occs);
            this.d_dlg.setOccsTotal(occsTotal);
            this.d_dlg.setDTGMax(maxDTG);
            this.d_dlg.setDTGAvg(avgDTG);
            this.d_dlg.setDTGMin(minDTG);
            this.d_dlg.setStuckStatus(stuck);
            switch (state) {
                case RUNNING: {
                    dlgState = 1;
                    break;
                }
                case PAUSED: {
                    dlgState = 2;
                    break;
                }
                default: {
                    dlgState = 3;
                }
            }
            this.d_dlg.setState(dlgState);
        }
    }

    private static class Responder
    implements RunSimDlg.DlgListener {
        public volatile String filename = null;
        public volatile Engine inferno = null;

        private Responder() {
        }

        @Override
        public void actionCancel(RunSimDlg dlg) {
            if (this.inferno != null && !this.inferno.isFinished()) {
                this.inferno.cancel();
            }
        }

        @Override
        public void actionOK(RunSimDlg dlg) {
        }

        @Override
        public void actionShowVis(RunSimDlg dlg) {
            this.inferno.showVis();
        }

        @Override
        public void actionPause(RunSimDlg dlg) {
            this.inferno.pause();
        }

        @Override
        public void actionResults(RunSimDlg dlg) {
            RunInferno.showResults(this.filename);
        }

        @Override
        public void actionResume(RunSimDlg dlg) {
            this.inferno.resume();
        }

        @Override
        public void actionLog(RunSimDlg dlg) {
            ExampleFileFilter txt = new ExampleFileFilter(new String[]{"txt"}, Intl.intl("Text File"));
            guiJFXFileChooser chooser = new guiJFXFileChooser("log.txt", null, null, (Boolean)false, (Boolean)false, (Boolean)true, FileFilters.EXT_FILTER_TEXT);
            File f = chooser.showSaveDialog();
            if (f == null) {
                return;
            }
            if (Application.getApp() != null) {
                Application.getApp().setWorkingDir(f.getPath());
            }
            try {
                PrintStream ps = new PrintStream(f);
                dlg.writeLogText(ps);
                ps.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        @Override
        public void actionStop(RunSimDlg dlg) {
            if (this.inferno != null && !this.inferno.isFinished()) {
                dlg.setCancelled(true);
                this.inferno.scheduleSnapshot();
                this.inferno.cancel();
            }
        }

        @Override
        public void changeState(RunSimDlg dlg, int newState) {
        }
    }

    private static class Tuple3<T1, T2, T3> {
        public final T1 v1;
        public final T2 v2;
        public final T3 v3;

        public Tuple3(T1 v1, T2 v2, T3 v3) {
            this.v1 = v1;
            this.v2 = v2;
            this.v3 = v3;
        }
    }

    public static class InfernoData {
        public final String filename;
        public final File dir;
        public final Engine engine;

        public InfernoData(File dir, String filename, Engine engine) {
            this.dir = dir;
            this.filename = filename;
            this.engine = engine;
        }
    }

    private static class RunDlgEchoStream
    extends FilterOutputStream {
        public final PrintStream out;
        public final RunSimDlg dlg;
        private StringBuffer d_buffer;

        public RunDlgEchoStream(PrintStream consoleOut, RunSimDlg dlg) {
            super(consoleOut);
            this.out = consoleOut;
            this.dlg = dlg;
            this.d_buffer = new StringBuffer();
        }

        @Override
        public synchronized void flush() throws IOException {
            super.flush();
            if (0 < this.d_buffer.length()) {
                this.dlg.printToLog(this.d_buffer.toString());
                this.d_buffer.delete(0, this.d_buffer.length());
            }
        }

        @Override
        public synchronized void write(int b) throws IOException {
            super.write(b);
            if (b == 10) {
                this.dlg.printToLog(this.d_buffer.toString());
                this.d_buffer.delete(0, this.d_buffer.length());
            } else {
                this.d_buffer.append((char)b);
            }
        }
    }
}

