/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import java.util.Set;
import merlin.EntryPointFactory;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.MerlinOp;
import merlin.actions.SelectionObserver;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.data.egress.scripting.queues.QueueObject;
import merlin.data.egress.scripting.queues.QueueObjectComp;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;

public class NewQueueObject
extends AMerlinOp
implements IEventObserver {
    private static final String s_uiHookLbl = Intl.intl("New Queue...");
    public static final UIHook MENU_HOOK = new UIHook((MerlinOp)new NewQueueObject(true), s_uiHookLbl, EntryPointFactory.queueIcon);
    public static final UIHook CONTEXT_HOOK = new UIHook(new NewQueueObject(false), s_uiHookLbl);
    private final boolean d_mainMenu;

    public NewQueueObject(boolean mainMenu) {
        this.d_mainMenu = mainMenu;
        if (!this.d_mainMenu) {
            SelectionObserver.add(this, IMerlinObj.class);
            this.update(null);
        }
    }

    @Override
    public void update(Events events) {
        MerlinData md = MerlinApp.getApp().getData();
        this.setEnabled(md.selection.isSingleExclusive(QueueObjectComp.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(MerlinApp app, MerlinData md) {
        md.beginWrite();
        Undo.begin(Intl.intl("Add Queue"));
        try {
            Set selQueueGroups;
            QueueObjectComp group = null;
            if (!this.d_mainMenu && !(selQueueGroups = md.selection.getSelected(QueueObjectComp.class)).isEmpty()) {
                group = (QueueObjectComp)selQueueGroups.iterator().next();
            }
            if (group == null) {
                group = md.queues;
            }
            QueueObject newQ = new QueueObject(md.queueObjectNameGen.getCurrentName());
            md.queueObjectNameGen.nextName();
            Undo.insertUndoEntry_delete(md, group, newQ);
            group.add(newQ);
            md.selection.set(newQ);
        }
        finally {
            Undo.end(md);
            md.endWrite();
        }
    }
}

