/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.function.BiConsumer;
import java.util.function.Function;
import merlin.EntryPointFactory;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.UIHook;
import merlin.data.AssistedEvacTeam;
import merlin.data.Composite;
import merlin.data.ICompElement;
import merlin.data.MerlinData;
import merlin.data.OccGroupTypeObj;
import merlin.data.egress.agents.OccProfile;
import merlin.data.egress.agents.VehicleShape;
import merlin.gui.AssistedEvacTeamsDlg;
import merlin.gui.LibraryDlg;
import merlin.gui.ManagerDlg;
import merlin.gui.OccGroupTypesDlg;
import merlin.gui.ProfilesDlg;
import merlin.gui.VehicleShapesDlg;

public class EditObjects<T extends ICompElement>
extends AMerlinOp {
    public static final UIHook UI_HOOK_PROFILE = new UIHook(new EditObjects<OccProfile>(OccProfile.PROP_NAME, md -> md.profiles, (mgr, obj) -> {
        ProfilesDlg dlg = new ProfilesDlg(MerlinApp.getApp().getMainFrame(), MerlinApp.getApp().getUnitSystem());
        dlg.init(MerlinApp.getApp().getData(), (ManagerDlg.IManager<OccProfile>)mgr, (OccProfile)obj);
        dlg.doModal();
    }, OccProfile.class), Intl.intl("Edit &Profiles..."), EntryPointFactory.occupantProfileIcon);
    public static final UIHook UI_HOOK_VEHICLE_SHAPE = new UIHook(new EditObjects<VehicleShape>(VehicleShape.PROP_NAME, md -> md.vehicleShapes, (mgr, obj) -> {
        VehicleShapesDlg dlg = new VehicleShapesDlg(MerlinApp.getApp().getMainFrame(), MerlinApp.getApp().getData(), MerlinApp.getApp().getUnitSystem());
        dlg.init(MerlinApp.getApp().getData(), (ManagerDlg.IManager<VehicleShape>)mgr, (VehicleShape)obj);
        dlg.doModal();
    }, VehicleShape.class), Intl.intl("Edit Vehicle Shapes..."), EntryPointFactory.vehicleIcon);
    public static final UIHook UI_HOOK_ASSISTED_EVAC_TEAM = new UIHook(new EditObjects<AssistedEvacTeam>(AssistedEvacTeam.PROP_NAME, md -> md.assistedEvacTeams, (mgr, obj) -> {
        AssistedEvacTeamsDlg dlg = new AssistedEvacTeamsDlg(MerlinApp.getApp().getMainFrame(), MerlinApp.getApp().getUnitSystem());
        dlg.init(MerlinApp.getApp().getData(), (CompositeManager<?>)mgr, (AssistedEvacTeam)obj);
        dlg.doModal();
    }, AssistedEvacTeam.class), Intl.intl("Edit Assisted Evacuation Teams..."), EntryPointFactory.assistedEvacTeamIcon);
    public static final UIHook UI_HOOK_OCC_GROUP_TYPES = new UIHook(new EditObjects<OccGroupTypeObj>(OccGroupTypeObj.PROP_NAME, md -> md.occGroupTypes, (mgr, obj) -> {
        OccGroupTypesDlg dlg = new OccGroupTypesDlg(MerlinApp.getApp().getMainFrame(), MerlinApp.getApp().getUnitSystem());
        dlg.init(MerlinApp.getApp().getData(), (CompositeManager<?>)mgr, (OccGroupTypeObj)obj);
        dlg.doModal();
    }, OccGroupTypeObj.class), Intl.intl("Edit Movement Group Templates..."), EntryPointFactory.occupantGroupIcon);
    public static final UIHook UI_HOOK_LIBRARIES = new UIHook(new EditObjects<OccProfile>(OccProfile.PROP_NAME, md -> md.profiles, (mgr, obj) -> {
        LibraryDlg dlg = new LibraryDlg(MerlinApp.getApp().getMainFrame(), MerlinApp.getApp().getData());
        dlg.doModal();
    }, OccProfile.class), Intl.intl("Edit Profile Libraries..."));
    private Object d_propName;
    private Function<MerlinData, Composite<? super T>> d_getRoot;
    private BiConsumer<CompositeManager<T>, T> d_createDlg;
    private Class<T> d_clazz;

    public EditObjects(Object propName, Function<MerlinData, Composite<? super T>> getRoot, BiConsumer<CompositeManager<T>, T> createDlg, Class<T> clazz) {
        this.d_propName = propName;
        this.d_getRoot = getRoot;
        this.d_createDlg = createDlg;
        this.d_clazz = clazz;
    }

    @Override
    public void run(MerlinApp app, MerlinData md) {
        Composite<? super T> group = this.d_getRoot.apply(md);
        EditObjects.editObject(app, md, null, this.d_propName, group, this.d_createDlg, this.d_clazz);
    }

    public static <T extends ICompElement, TDlg extends ManagerDlg<?, ?>> void editObject(MerlinApp app, final MerlinData md, final T init, final Object propName, final Composite<? extends ICompElement> group, final BiConsumer<CompositeManager<T>, T> createDlg, final Class<T> clazz) {
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                Comparator cmp = new Comparator<T>(){

                    @Override
                    public int compare(T o1, T o2) {
                        String n1 = (String)o1.getProperty(propName);
                        String n2 = (String)o2.getProperty(propName);
                        return n1.compareToIgnoreCase(n2);
                    }
                };
                CompositeManager mgr = new CompositeManager(md, group, cmp, clazz);
                createDlg.accept(mgr, init);
            }
        };
        md.uiLater(runner);
    }

    public static class CompositeManager<T extends ICompElement>
    implements ManagerDlg.IManager<T> {
        private final MerlinData d_md;
        private Composite<?> d_objs;
        private Class<T> d_clazz;
        private Comparator<T> d_cmp;

        public CompositeManager(MerlinData md, Composite<?> objs, Comparator<T> cmp, Class<T> clazz) {
            this.d_md = md;
            this.d_objs = objs;
            this.d_clazz = clazz;
            this.d_cmp = cmp;
        }

        @Override
        public String describe(T obj) {
            this.d_md.beginRead();
            String name = obj.getName();
            this.d_md.endRead();
            return name;
        }

        @Override
        public Collection<T> getSorted() {
            this.d_md.beginRead();
            ArrayList<T> sorted = new ArrayList<T>(this.d_objs.flatten(this.d_clazz));
            Collections.sort(sorted, this.d_cmp);
            this.d_md.endRead();
            return sorted;
        }

        @Override
        public int size() {
            this.d_md.beginRead();
            int size = this.d_objs.flatten(this.d_clazz).size();
            this.d_md.endRead();
            return size;
        }
    }
}

