/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import java.util.ArrayList;
import java.util.Collection;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.UIHook;
import merlin.data.Composite;
import merlin.data.ICompElement;
import merlin.data.JsonObj;
import merlin.data.MerlinData;
import merlin.gui.JsonDlg;
import merlin.gui.ManagerDlg;

public class EditJsonObjs
extends AMerlinOp {
    public static final UIHook UI_HOOK = new UIHook(new EditJsonObjs(), Intl.intl("Edit &Json Objects..."));

    @Override
    public void run(MerlinApp app, MerlinData md) {
        EditJsonObjs.edit(app, md, null);
    }

    public static void edit(final MerlinApp app, final MerlinData md, final JsonObj init) {
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                CompositeManager mgr = new CompositeManager(md, md.json);
                JsonDlg dlg = new JsonDlg(app.getMainFrame(), app.getUnitSystem());
                dlg.init(md, mgr, init);
                dlg.doModal();
            }
        };
        md.uiLater(runner);
    }

    public static class CompositeManager
    implements ManagerDlg.IManager<JsonObj> {
        private final MerlinData d_md;
        private Composite<? super JsonObj> d_objs;

        public CompositeManager(MerlinData md, Composite<? super JsonObj> objs) {
            this.d_md = md;
            this.d_objs = objs;
        }

        @Override
        public String describe(JsonObj oProf) {
            this.d_md.beginRead();
            String name = oProf.getName();
            this.d_md.endRead();
            return name;
        }

        @Override
        public Collection<JsonObj> getSorted() {
            this.d_md.beginRead();
            ArrayList<ICompElement> sorted = new ArrayList<ICompElement>(this.d_objs.getMembers());
            this.d_md.endRead();
            return sorted;
        }

        @Override
        public int size() {
            this.d_md.beginRead();
            int size = this.d_objs.getMembers().size();
            this.d_md.endRead();
            return size;
        }
    }
}

