/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import java.util.HashSet;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.AddObject;
import merlin.actions.CreateGroupsAction;
import merlin.actions.SelectionObserver;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.data.Composite;
import merlin.data.ICompElement;
import merlin.data.MerlinData;
import merlin.data.MerlinSelectionModel;
import merlin.data.OccGroupObj;
import merlin.data.egress.agents.EgressAgent;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.LinkedIdentityHashSet;

public class CreateSingleGroupAction
extends AMerlinOp
implements IEventObserver {
    public static final String actionName = Intl.intl("New Movement Group from Selection");
    public static final UIHook UI_HOOK = new UIHook(new CreateSingleGroupAction(), actionName);

    public CreateSingleGroupAction() {
        SelectionObserver.add(this, EgressAgent.class);
        this.update(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(MerlinApp app, MerlinData md) {
        md.beginRead();
        HashSet<EgressAgent> agents = new HashSet();
        try {
            agents = md.selection.getDeepSelected(EgressAgent.class);
            if (!CreateGroupsAction.verifySingleBehavior(agents, app)) {
                return;
            }
            if (!CreateGroupsAction.verifyDeletingEmptyGroups(agents, app)) {
                return;
            }
        }
        finally {
            md.endRead();
        }
        md.beginWrite();
        Undo.begin(actionName);
        try {
            LinkedIdentityHashSet<OccGroupObj> oldGroups = new LinkedIdentityHashSet<OccGroupObj>();
            for (EgressAgent agt : agents) {
                if (agt.getMovementGroup() == null) continue;
                oldGroups.add(agt.getMovementGroup());
                CreateGroupsAction.removeAgentFromCurrentMovementGroup(agt, md);
            }
            CreateGroupsAction.resetOldGroupLeaders(oldGroups, agents, md);
            OccGroupObj newGroup = OccGroupObj.newGroup(md.occGroupNameGen.nextName(), agents, null, null);
            AddObject.add((MerlinData)md, (Composite)md.occGroups, (int)md.occGroups.getChildren().size(), (ICompElement[])new OccGroupObj[]{newGroup});
            CreateGroupsAction.deleteOldGroupsIfEmpty(oldGroups, md);
        }
        finally {
            Undo.end(md);
            md.endWrite();
        }
    }

    @Override
    public void update(Events events) {
        MerlinApp app = MerlinApp.getApp();
        MerlinData data = app.getData();
        MerlinSelectionModel sel = data.selection;
        this.setEnabled(!sel.isDeepEmpty(EgressAgent.class));
    }
}

