/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import java.util.ArrayList;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.SelectionObserver;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.data.egress.scripting.attractors.Attractor;
import merlin.data.egress.scripting.attractors.AttractorComp;
import merlin.data.egress.scripting.attractors.AttractorRootComp;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;

public class ConvertToAttractorTemplate
extends AMerlinOp
implements IEventObserver {
    private static final String s_uiHookLbl = Intl.intl("Copy to Trigger Template");
    public static final UIHook CONTEXT_HOOK = new UIHook(new ConvertToAttractorTemplate(), s_uiHookLbl);

    public ConvertToAttractorTemplate() {
        SelectionObserver.add(this, IMerlinObj.class);
        this.update(null);
    }

    @Override
    public void update(Events events) {
        MerlinData md = MerlinApp.getApp().getData();
        this.setEnabled(md.selection.isExclusive(Attractor.class, AttractorRootComp.class, AttractorComp.class) && md.selection.getDeepSelected(Attractor.class).stream().noneMatch(Attractor::isTemplate));
    }

    @Override
    public void run(MerlinApp app, MerlinData md) {
        ArrayList<Attractor> newAttractors = new ArrayList<Attractor>();
        try (AutoCloseable lock = md.lockRead();){
            for (Attractor selectedAttractor : md.selection.getDeepSelected(Attractor.class)) {
                Attractor newAttractor = selectedAttractor.clone();
                newAttractor.setName(String.format(Intl.intl("%s_template"), selectedAttractor.getName()));
                newAttractor.setProperty(Attractor.TYPE, Attractor.PlaceType.TEMPLATE);
                newAttractors.add(newAttractor);
            }
        }
        lock = md.lockWrite();
        try {
            Undo.begin(Intl.intl("Add Trigger Templates"));
            Undo.insertUndoEntry_delete(md, md.attractorTemplates, newAttractors);
            md.attractorTemplates.addAll(newAttractors);
            md.selection.set(newAttractors);
            Undo.end(md);
        }
        finally {
            if (lock != null) {
                ((MerlinData.WriteLock)lock).close();
            }
        }
    }
}

