/*
 * Decompiled with CFR 0.152.
 */
package merlin;

import inferno.sim.KnownFuncs;
import java.awt.Font;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.vecmath.Point3d;
import merlin.EntryPoint;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.RenameAction;
import merlin.data.AMerlinObj;
import merlin.data.AssistedEvacTeam;
import merlin.data.AssistedEvacTeamComp;
import merlin.data.Composite;
import merlin.data.GeomComposite;
import merlin.data.ICompElement;
import merlin.data.IMerlinObj;
import merlin.data.INamed;
import merlin.data.ImportedGeom;
import merlin.data.JsonObj;
import merlin.data.MeasurementRegionObj;
import merlin.data.MeasurementRegions;
import merlin.data.MerlinData;
import merlin.data.OccGroupObj;
import merlin.data.OccGroupTypeObj;
import merlin.data.OccSourceObj;
import merlin.data.Proxy;
import merlin.data.SequentialNameGen;
import merlin.data.camera.Camera;
import merlin.data.camera.CameraList;
import merlin.data.camera.CameraTour;
import merlin.data.camera.ICameraObj;
import merlin.data.egress.Floor;
import merlin.data.egress.FloorComposite;
import merlin.data.egress.SimError;
import merlin.data.egress.agents.EgressAgent;
import merlin.data.egress.agents.EgressAgentComp;
import merlin.data.egress.agents.OccLocation;
import merlin.data.egress.agents.OccProfile;
import merlin.data.egress.agents.OccProfileComp;
import merlin.data.egress.agents.OccTarget;
import merlin.data.egress.agents.OccTargetComp;
import merlin.data.egress.agents.PredefOccArea;
import merlin.data.egress.agents.VehicleShape;
import merlin.data.egress.agents.VehicleShapeComp;
import merlin.data.egress.blockages.EgressBlockage;
import merlin.data.egress.blockages.EgressBlockageComp;
import merlin.data.egress.elevators.Elevator;
import merlin.data.egress.elevators.ElevatorDoor;
import merlin.data.egress.elevators.ElevatorGroup;
import merlin.data.egress.elevators.ElevatorRoom;
import merlin.data.egress.elevators.ElevatorUtil;
import merlin.data.egress.elevators.IElevatorComp;
import merlin.data.egress.geom.AEgressComp;
import merlin.data.egress.geom.EgressConnectorState;
import merlin.data.egress.geom.EgressCorridor;
import merlin.data.egress.geom.EgressDoor;
import merlin.data.egress.geom.EgressRoom;
import merlin.data.egress.geom.EgressStair;
import merlin.data.egress.geom.IEgressComp;
import merlin.data.egress.geom.IEgressConnector;
import merlin.data.egress.geom.IEgressOccupiable;
import merlin.data.egress.scripting.AbandonOccTargets;
import merlin.data.egress.scripting.AssistOccupants;
import merlin.data.egress.scripting.Behavior;
import merlin.data.egress.scripting.BehaviorRoot;
import merlin.data.egress.scripting.ChangeBehavior;
import merlin.data.egress.scripting.ChangeProfile;
import merlin.data.egress.scripting.ChangeProfileProp;
import merlin.data.egress.scripting.ChangeTags;
import merlin.data.egress.scripting.CreateAttractor;
import merlin.data.egress.scripting.DestroyAttractor;
import merlin.data.egress.scripting.DetachAssistants;
import merlin.data.egress.scripting.GotoCurrentAttractor;
import merlin.data.egress.scripting.GotoElevators;
import merlin.data.egress.scripting.GotoExits;
import merlin.data.egress.scripting.GotoOcc;
import merlin.data.egress.scripting.GotoOccTarget;
import merlin.data.egress.scripting.GotoQueue;
import merlin.data.egress.scripting.GotoRooms;
import merlin.data.egress.scripting.GotoWaypoint;
import merlin.data.egress.scripting.IBehaviorAction;
import merlin.data.egress.scripting.IDestinationAction;
import merlin.data.egress.scripting.JoinOccGroup;
import merlin.data.egress.scripting.RefugeFilter;
import merlin.data.egress.scripting.RemoveOcc;
import merlin.data.egress.scripting.ResumePrior;
import merlin.data.egress.scripting.RevertProfileProp;
import merlin.data.egress.scripting.Wait;
import merlin.data.egress.scripting.WaitForAssistance;
import merlin.data.egress.scripting.WaitUntil;
import merlin.data.egress.scripting.WaitUntilEnd;
import merlin.data.egress.scripting.attractors.Attractor;
import merlin.data.egress.scripting.attractors.AttractorComp;
import merlin.data.egress.scripting.attractors.AttractorRootComp;
import merlin.data.egress.scripting.attractors.AttractorTemplateComp;
import merlin.data.egress.scripting.queues.IQueueElement;
import merlin.data.egress.scripting.queues.QueueObject;
import merlin.data.egress.scripting.queues.QueueObjectComp;
import merlin.data.egress.scripting.queues.QueuePath;
import merlin.data.egress.scripting.queues.QueuePathNode;
import merlin.data.egress.scripting.queues.QueueService;
import merlin.data.image.RasterImage;
import merlin.data.material.Material;
import merlin.data.material.MaterialDB;
import merlin.data.scripting.ScriptObj;
import merlin.data.value.DiscreteVariant;
import merlin.data.value.IFunction1d;
import merlin.data.value.ImpulseFunction1d;
import merlin.data.value.RandomizedImpulseFunction1d;
import merlin.data.value.VariantUtil;
import merlin.gui.OccGroupsPanel;
import merlin.gui.guiUtil;
import merlin.mv.ModelView;
import merlin.mv.displays.IMerlinDispMgr;
import merlin.treeview.TVEntryPoint;
import merlin.unitsystem.SIUS;
import merlin.util.MerlinUtil;
import org.jscience.physics.units.Unit;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.gui.DecoratedIcon;
import thunderheadeng.gui.guiUtil;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IEventRecord;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.TriFunction;
import thunderheadeng.util.stat.ConstantCurve;
import thunderheadeng.util.stat.IUrn;
import thunderheadeng.util.theUtil;

public class EntryPointFactory {
    private static final Map<Class<?>, EntryPoint> s_entryPoints = new LinkedHashMap();
    private static final Map<Pair<Class<?>, FuncType>, EntryPoint.Func<?>> s_funcs = new LinkedHashMap();
    private static final Map<FuncType, EntryPoint.Func> s_defaults = new HashMap<FuncType, EntryPoint.Func>();
    private static final Set<AssistedEvacTeam> unassistedTeamsCache = new IdentityHashSet<AssistedEvacTeam>();
    private static final Map<IMerlinObj, List<SimError>> notEnoughAssistingCached = new IdentityHashMap<IMerlinObj, List<SimError>>();
    private static final Map<IMerlinObj, List<SimError>> vehicleNotFitInElevatorCache = new IdentityHashMap<IMerlinObj, List<SimError>>();
    private static final CachedWarningsUpdator cachedWarningsUpdator = new CachedWarningsUpdator();
    private static final Map<IMerlinObj, List<SimError>> occSourceExitDoorWarnings = new IdentityHashMap<IMerlinObj, List<SimError>>();
    private static final Map<IMerlinObj, List<SimError>> doubleDeckElevatorWarnings = new IdentityHashMap<IMerlinObj, List<SimError>>();
    private static final Map<IMerlinObj, List<SimError>> occGroupWarnings = new IdentityHashMap<IMerlinObj, List<SimError>>();
    private static final Map<IMerlinObj, List<SimError>> changeBehaviorWarnings = new IdentityHashMap<IMerlinObj, List<SimError>>();
    private static final Map<IMerlinObj, List<SimError>> refugeRoomSizeWarnings = new IdentityHashMap<IMerlinObj, List<SimError>>();
    private static final Set<Behavior> behaviorGoesToOccTargets = new IdentityHashSet<Behavior>();
    private static final Map<Pair<Behavior, AssistState>, List<Function<IMerlinObj, SimError>>> assistWarnings = new HashMap<Pair<Behavior, AssistState>, List<Function<IMerlinObj, SimError>>>();
    public static final Icon mgrIcon = guiUtil.loadMerlinIcon("manager8.png");
    public static final Icon occupantIcon = guiUtil.loadMerlinIcon("occupant16.png", 16);
    public static final Icon occupantGroupIcon = guiUtil.loadMerlinIcon("occ_group16.png", 16);
    public static final Icon occupantProfileIcon = guiUtil.loadMerlinIcon("occ_profile16.png", 16);
    public static final Icon changeOccProfilePropIcon = guiUtil.loadMerlinIcon("change_profile_prop16.png", 16);
    public static final Icon revertOccProfilePropIcon = guiUtil.loadMerlinIcon("reset_profile_prop16.png", 16);
    public static final Icon changeTagsIcon = guiUtil.loadMerlinIcon("tag16.png", 16);
    public static final Icon vehicleGroupIcon = guiUtil.loadMerlinIcon("vehicleShapes_16.png", 16);
    public static final Icon assistedEvacTeamGroupIcon = guiUtil.loadMerlinIcon("ae_team16.png", 16);
    public static final Icon vehicleIcon = guiUtil.loadMerlinIcon("vehicleShapes_16.png", 16);
    public static final Icon assistedEvacTeamIcon = guiUtil.loadMerlinIcon("ae_team16.png", 16);
    public static final Icon cameraListIcon = guiUtil.loadMerlinIcon("cameras16.png", 16);
    public static final Icon cameraIcon = guiUtil.loadMerlinIcon("camera16.png", 16);
    public static final Icon cameraTourIcon = guiUtil.loadMerlinIcon("camera_tour16.png", 16);
    public static final Icon floorIcon = guiUtil.loadMerlinIcon("floor16.png", 16);
    public static final Icon stairsIcon = guiUtil.loadMerlinIcon("stairs216.png", 16);
    public static final Icon exitIcon = guiUtil.loadMerlinIcon("exit16.png", 16);
    public static final Icon doorIcon = guiUtil.loadMerlinIcon("door216.png", 16);
    public static final Icon rampIcon = guiUtil.loadMerlinIcon("ramp16.png", 16);
    public static final Icon roomIcon = guiUtil.loadMerlinIcon("openrect16.png", 16);
    public static final Icon removeOccIcon = guiUtil.loadMerlinIcon("remove_occ16.png", 16);
    public static final Icon resumePriorIcon = guiUtil.loadMerlinIcon("return16.png", 16);
    public static final Icon refugeRoomIcon = guiUtil.loadMerlinIcon("refugeRoom16.png", 16);
    public static final Icon importedGeometry2DIcon = guiUtil.loadMerlinIcon("2Dgeometry16.png", 16);
    public static final Icon importedGeometry3DIcon = guiUtil.loadMerlinIcon("block16_2.gif", 16);
    public static final Icon importedGeometryGroupIcon = guiUtil.loadMerlinIcon("composite16.png", 16);
    public static final Icon floorGroupIcon = guiUtil.loadMerlinIcon("mesh16.png", 16);
    public static final Icon backgroundImageIcon = guiUtil.loadMerlinIcon("backgroundImage16.gif", 16);
    public static final Icon blankIcon = null;
    public static final Icon behaviorIcon = guiUtil.loadMerlinIcon("script16.png", 16);
    public static final Icon gotoIcon = guiUtil.loadMerlinIcon("flag16.png", 16);
    public static final Icon attractorIcon = guiUtil.loadMerlinIcon("attractor16.png", 16);
    public static final Icon attractorGroupIcon = EntryPointFactory.getManagerIcon(attractorIcon);
    public static final Icon abandonOccTargetsIcon = guiUtil.loadMerlinIcon("abandon_occloc16.png", 16);
    public static final Icon occTargetIcon;
    public static final Icon gotoOccTargetIcon;
    public static final Icon gotoOccIcon;
    public static final Icon gotoCurrentAttractorIcon;
    public static final Icon occTargetGroupIcon;
    public static final Icon waitIcon;
    public static final Icon waitUntilEndIcon;
    public static final Icon elevatorIcon;
    public static final Icon measurementRegionGroupIcon;
    public static final Icon measurementRegionIcon;
    public static final Icon occupantSourceGroupIcon;
    public static final Icon occupantSourceIcon;
    public static final Icon assistIcon;
    public static final Icon waitForAssistanceIcon;
    public static final Icon detachIcon;
    public static final Icon joinGroupIcon;
    public static final Icon leaveGroupIcon;
    public static final Icon queueIcon;
    public static final Icon queueGroupIcon;
    public static final Icon queuePathIcon;
    public static final Icon queueServiceIcon;
    public static final Icon queuePathNodeIcon;
    public static final Icon blockageIcon;
    public static final Icon blockageGroupIcon;
    public static final Icon createAttractorIcon;
    public static final Icon destroyAtttractorIcon;
    private static final Font s_plain;
    private static final Font s_bold;
    private static final Font s_italic;
    private static final Font s_italicBold;

    private static Icon getManagerIcon(Icon itemIcon) {
        return itemIcon == null ? null : new DecoratedIcon(itemIcon, mgrIcon, 3);
    }

    private static void registerDefault(FuncType funcType, EntryPoint.Func<?> func) {
        s_defaults.put(funcType, func);
    }

    private static <T> void register(Class<T> type, FuncType funcType, EntryPoint.Func<?> func) {
        s_funcs.put(new Pair<Class<T>, FuncType>(type, funcType), func);
    }

    private static <T, ReturnT> void register(Class<T> type, FuncType funcType, EntryPoint.Getter<T, ReturnT> getter) {
        EntryPointFactory.register(type, funcType, getter);
    }

    private static <T, ReturnT, ArgT> void register(Class<T> type, FuncType funcType, EntryPoint.Action<T, ReturnT, ArgT> action) {
        EntryPointFactory.register(type, funcType, action);
    }

    private static <T, ArgT> void register(Class<T> type, FuncType funcType, EntryPoint.Setter<T, ArgT> setter) {
        EntryPointFactory.register(type, funcType, setter);
    }

    private static void registerIcon(Class<?> type, Icon icon) {
        EntryPointFactory.register(type, FuncType.TV_GetIcon, new ConstantAsyncGetter(icon));
    }

    public static <T> EntryPoint<T> get(T obj) {
        return EntryPointFactory.get(obj.getClass());
    }

    public static synchronized <T> EntryPoint<T> get(Class<T> clazz) {
        EntryPoint<T> ep = s_entryPoints.get(clazz);
        if (ep != null) {
            return ep;
        }
        TVEntryPoint tvep = new TVEntryPoint((EntryPoint.Getter)EntryPointFactory.findFunc(clazz, FuncType.TV_GetErrors), (EntryPoint.Getter)EntryPointFactory.findFunc(clazz, FuncType.TV_GetName), (EntryPoint.Setter)EntryPointFactory.findFunc(clazz, FuncType.TV_SetName), (EntryPoint.Getter)EntryPointFactory.findFunc(clazz, FuncType.TV_CanRename), (EntryPoint.AsyncGetter)EntryPointFactory.findFunc(clazz, FuncType.TV_GetIcon), (EntryPoint.Getter)EntryPointFactory.findFunc(clazz, FuncType.TV_GetBaseFont), (EntryPoint.Getter)EntryPointFactory.findFunc(clazz, FuncType.TV_IsVisible), (EntryPoint.Getter)EntryPointFactory.findFunc(clazz, FuncType.TV_IsEnabled), (EntryPoint.Getter)EntryPointFactory.findFunc(clazz, FuncType.TV_GetForcedAutoexpand), (EntryPoint.Getter)EntryPointFactory.findFunc(clazz, FuncType.TV_IsLeaf), (EntryPoint.Getter)EntryPointFactory.findFunc(clazz, FuncType.TV_GetChildren), (EntryPoint.Getter)EntryPointFactory.findFunc(clazz, FuncType.TV_GetParent));
        ep = new EntryPoint<T>(clazz, tvep, (EntryPoint.Action)EntryPointFactory.findFunc(clazz, FuncType.CheckDelete), (EntryPoint.Getter)EntryPointFactory.findFunc(clazz, FuncType.GetOtherDeleteObjs), (EntryPoint.Getter)EntryPointFactory.findFunc(clazz, FuncType.GetConflict), (EntryPoint.Action)EntryPointFactory.findFunc(clazz, FuncType.Delete), (EntryPoint.Getter)EntryPointFactory.findFunc(clazz, FuncType.IsAutoDeleteGroup), (EntryPoint.Getter)EntryPointFactory.findFunc(clazz, FuncType.IsVisible), (EntryPoint.Setter)EntryPointFactory.findFunc(clazz, FuncType.SetVisible), (EntryPoint.Getter)EntryPointFactory.findFunc(clazz, FuncType.GetCompositeRoot), (EntryPoint.Getter)EntryPointFactory.findFunc(clazz, FuncType.GetNameGenerator), (EntryPoint.Getter)EntryPointFactory.findFunc(clazz, FuncType.IsIndexed), (EntryPoint.Getter)EntryPointFactory.findFunc(clazz, FuncType.IsMovable), (EntryPoint.Getter)EntryPointFactory.findFunc(clazz, FuncType.ShowBounds));
        s_entryPoints.put(clazz, ep);
        return ep;
    }

    private static Collection<SimError> lazyAdd(Collection<SimError> coll, SimError err) {
        if (coll.isEmpty()) {
            coll = new ArrayDeque<SimError>();
        }
        coll.add(err);
        return coll;
    }

    private static <T extends IMerlinObj> EntryPoint.Func<T> findFunc(Class<?> clazz, FuncType funcType) {
        EntryPoint.Func func = EntryPointFactory.findFuncHelper(clazz, funcType);
        return func != null ? func : s_defaults.get((Object)funcType);
    }

    private static <T extends IMerlinObj> EntryPoint.Func<T> findFuncHelper(Class<?> clazz, FuncType funcType) {
        if (clazz == null) {
            return null;
        }
        EntryPoint.Func<Object> func = s_funcs.get(new Pair(clazz, funcType));
        if (func != null) {
            return func;
        }
        func = EntryPointFactory.findFuncHelper(clazz.getSuperclass(), funcType);
        if (func != null) {
            return func;
        }
        for (Class<?> ifaceClass : clazz.getInterfaces()) {
            func = EntryPointFactory.findFuncHelper(ifaceClass, funcType);
            if (func == null) continue;
            return func;
        }
        return null;
    }

    public static synchronized Collection<EntryPoint> getAll() {
        return s_entryPoints.values();
    }

    private static <T> EntryPoint.Getter<T, T> getStandardConflictGetter(final Class<T> clazz) {
        return new EntryPoint.Getter<T, T>(){

            @Override
            public T get(MerlinData md, T comparable) {
                Collection members = EntryPointFactory.get(comparable).getRootComposite(md, comparable).flatten(clazz);
                for (Object conflict : members) {
                    if (!theUtil.equal(comparable, conflict)) continue;
                    return conflict;
                }
                return null;
            }
        };
    }

    private static <T> boolean deletingAllOfType(MerlinData md, Set<? extends IMerlinObj> delObjs, Class<T> type, Composite<? super T> root) {
        return root.flatten(type).stream().allMatch(obj -> {
            Object mobj = obj;
            while (mobj != null) {
                if (delObjs.contains(mobj)) {
                    return true;
                }
                mobj = md.hierarchy.getParent(mobj);
            }
            return false;
        });
    }

    private static void getGotoOccTargetErrors(Collection<SimError> errors, IMerlinObj source, boolean isInGroup, Behavior behavior) {
        if (isInGroup && behaviorGoesToOccTargets.contains(behavior)) {
            errors.add(new SimError(SimError.Level.MODERATE, String.format(Intl.intl("Occupants in movement groups cannot use a behavior that goes to occupant targets. See behavior, %1$s."), MerlinUtil.getName(behavior)), Intl.intl("Use a different behavior or change the referenced behavior."), source, behavior));
        }
    }

    private static void getBadDirectBehaviorErrors(List<SimError> errors, IMerlinObj source, Behavior behavior) {
        Optional<IBehaviorAction> taction = behavior.getLastAction();
        if (taction.isPresent() && taction.get() instanceof ResumePrior) {
            errors.add(new SimError(SimError.Level.CRITICAL, String.format(Intl.intl("%1$s cannot directly reference a behavior that ends with a \"Resume Prior\" action."), MerlinUtil.getName(source)), Intl.intl("Use a different behavior or change the referenced behavior."), source, behavior));
        }
    }

    private static boolean requiresAssistance(OccProfile prof) {
        return EntryPointFactory.requiresAssistance(prof.getProperty(OccProfile.PROP_REQUIRES_ASSISTANCE));
    }

    private static boolean requiresAssistance(IUrn<Boolean> requiresAssistance) {
        assert (requiresAssistance.isConstant());
        return requiresAssistance.stream().findFirst().orElse(false);
    }

    private static boolean hasVehicle(OccProfile prof) {
        return prof.getProperty(OccProfile.PROP_VEHICLE_SHAPE) != null;
    }

    private static boolean requiresAssistanceWithNoVehicle(OccProfile prof) {
        return !EntryPointFactory.hasVehicle(prof) && EntryPointFactory.requiresAssistance(prof);
    }

    private static void getResolvedProfileErrors(IMerlinObj obj, OccProfile profile, List<SimError> errors, String fixProfile) {
        if (EntryPointFactory.requiresAssistanceWithNoVehicle(profile)) {
            if (obj instanceof EgressAgent) {
                String error = Intl.intl("Only occupants with vehicle shapes can receive assistance.");
                errors.add(new SimError(SimError.Level.CRITICAL, error, fixProfile, obj));
            } else {
                String error = String.format(Intl.intl("Profile, \"%s\", requires assistance but has no vehicle shape."), profile.getName());
                errors.add(new SimError(SimError.Level.CRITICAL, error, fixProfile, obj));
            }
        }
    }

    private static void getAssistedEvacErrors(IMerlinObj obj, OccProfile profile, Behavior behavior, List<SimError> errors) {
        Pair<Behavior, AssistState> key = new Pair<Behavior, AssistState>(behavior, new AssistState(profile));
        List gens = assistWarnings.computeIfAbsent(key, p -> {
            ArrayList<Function<IMerlinObj, SimError>> errGens = new ArrayList<Function<IMerlinObj, SimError>>();
            if (p.v1 != null) {
                EntryPointFactory.getAssistedEvacErrors((AssistState)p.v2, (Behavior)p.v1, errGens);
            }
            return errGens;
        });
        for (Function gen : gens) {
            errors.add((SimError)gen.apply(obj));
        }
    }

    private static void getAssistedEvacErrors(AssistState initState, Behavior behavior, List<Function<IMerlinObj, SimError>> errors) {
        try {
            AssistState state = initState.clone();
            behavior.tracePath(bnode -> {
                if (bnode.action instanceof ChangeBehavior && ((ChangeBehavior)bnode.action).getAllTargetBehaviors().size() > 1 || bnode.action instanceof ChangeProfile && ((ChangeProfile)bnode.action).getAllTargetProfiles().size() > 1) {
                    throw new CannotTraceException();
                }
                if (bnode.action instanceof ChangeProfile) {
                    ChangeProfile cp = (ChangeProfile)bnode.action;
                    if (cp.getAllTargetProfiles().isEmpty()) {
                        return null;
                    }
                    OccProfile prof = cp.getAllTargetProfiles().iterator().next();
                    state.update(prof);
                } else if (bnode.action instanceof ChangeProfileProp) {
                    state.update((ChangeProfileProp)bnode.action);
                } else if (bnode.action instanceof RevertProfileProp) {
                    state.update((RevertProfileProp)bnode.action);
                } else if (bnode.action instanceof DetachAssistants) {
                    if (!state.waitingForOrReceivingAssistance) {
                        String error = Intl.intl("Detach from Assistants action must be preceded by a Wait for Assistance action.");
                        String fix = Intl.intl("Add a Wait for Assistance action before the Detach from Assistants action.");
                        errors.add(o -> new SimError(SimError.Level.CRITICAL, error, fix, (IMerlinObj)o));
                    }
                    state.waitingForOrReceivingAssistance = false;
                } else if (bnode.action instanceof WaitForAssistance) {
                    if (state.waitingForOrReceivingAssistance) {
                        String error = Intl.intl("Assistance doesn't end before another Wait for Assistance action starts.");
                        String fix = Intl.intl("Remove the second Wait for Assistance action, or add a Detach from Assistants action.");
                        errors.add(o -> new SimError(SimError.Level.CRITICAL, error, fix, (IMerlinObj)o));
                    } else if (state.numVehicleAttachPoints == -1) {
                        String err = Intl.intl("Occupants must have a polygon shape when they request assistance.");
                        String fix = Intl.intl("Change shape to a polygon before requesting assistance or do not request assistance in the occupant's behavior.");
                        errors.add(o -> new SimError(SimError.Level.CRITICAL, err, fix, (IMerlinObj)o));
                    } else if (state.numVehicleAttachPoints == 0) {
                        errors.add(o -> {
                            boolean generatedOccs = o instanceof OccSourceObj;
                            String err = generatedOccs ? Intl.intl("Generated occupants do not have any positions defined for attached occupants.") : Intl.intl("Occupant vehicle does not have any positions defined for attached occupants.");
                            String fix = Intl.intl("In vehicle shape, define attached occupant positions.");
                            return new SimError(SimError.Level.MODERATE, err, fix, (IMerlinObj)o);
                        });
                    }
                    state.waitingForOrReceivingAssistance = true;
                } else if (bnode.action instanceof IDestinationAction && state.requiresAssistance && !state.waitingForOrReceivingAssistance) {
                    errors.add(o -> {
                        String fix;
                        String err;
                        boolean generatedOccs = o instanceof OccSourceObj;
                        if (generatedOccs) {
                            err = Intl.intl("Generated occupants require assistance to move but do not request assistance through their behavior.");
                            fix = Intl.intl("Change behavior or change profile so occupants do not require assistance.");
                        } else {
                            err = Intl.intl("Occupant requires assistance to move but does not request assistance through its behavior.");
                            fix = Intl.intl("Change behavior or change profile so occupant does not require assistance.");
                        }
                        return new SimError(SimError.Level.MODERATE, err, fix, (IMerlinObj)o);
                    });
                }
                return null;
            });
        }
        catch (CannotTraceException cannotTraceException) {
            // empty catch block
        }
    }

    static void registerCameraTour() {
        EntryPointFactory.registerIcon(CameraTour.class, cameraTourIcon);
    }

    private static void getOccGroupErrors(OccGroupObj group, Collection<SimError> errors, MerlinData md) {
        String fix;
        Object errorMsg;
        boolean groupEnabled;
        String disabledLeaderErrorMsg = Intl.intl("Movement group leader is disabled.");
        String disabledLeaderFix = Intl.intl("Enable the movement group leader.");
        boolean multipleBehaviors = false;
        Object groupEnabledObj = group.getProperty(MerlinData.ENABLED);
        boolean bl = groupEnabled = groupEnabledObj instanceof Boolean && (Boolean)groupEnabledObj != false;
        if (groupEnabled) {
            Behavior b = null;
            for (Proxy proxy : group.flatten(Proxy.class)) {
                Object obj;
                Object enabled = proxy.getProperty(MerlinData.ENABLED);
                if (!(enabled instanceof Boolean) || !((obj = proxy.getObj()) instanceof EgressAgent)) continue;
                EgressAgent a = (EgressAgent)obj;
                if (!((Boolean)enabled).booleanValue()) {
                    if (group instanceof OccGroupTypeObj || !group.getProperty(OccGroupObj.PROP_REQUIRES_GROUP_LEADER).booleanValue() || group.getProperty(OccGroupObj.PROP_GROUP_LEADER) != a) continue;
                    errors.add(new SimError(SimError.Level.CRITICAL, disabledLeaderErrorMsg, disabledLeaderFix, group));
                    continue;
                }
                if (b == null) {
                    b = a.getBehavior();
                    continue;
                }
                if (multipleBehaviors || a.getBehavior() == b) continue;
                String errorMsg2 = Intl.intl("Occupants in the movement group have multiple behaviors. Movement group members must share the same behavior.");
                String fix2 = Intl.intl("Change the behavior of selected occupants.");
                errors.add(new SimError(SimError.Level.CRITICAL, errorMsg2, fix2, group));
                multipleBehaviors = true;
            }
            if (b != null) {
                Collection<ChangeBehavior> changeBehaviorActions = b.deepFlatten(ChangeBehavior.class);
                for (ChangeBehavior changeBehavior : changeBehaviorActions) {
                    if (changeBehavior.getAllTargetBehaviors().size() <= 1) continue;
                    errorMsg = String.format(Intl.intl("Occupants in the movement group have behavior change with multiple options in behavior %s. Only a single-option behavior change is allowed for movement group members."), ((Behavior)md.hierarchy.getParent(changeBehavior)).getName());
                    fix = Intl.intl("Change the behavior of movement group members.");
                    errors.add(new SimError(SimError.Level.CRITICAL, (String)errorMsg, fix, group));
                    break;
                }
                EntryPointFactory.getGotoOccTargetErrors(errors, group, true, b);
            }
            if (!(group instanceof OccGroupTypeObj) && group.getProperty(OccGroupObj.PROP_REQUIRES_GROUP_LEADER).booleanValue()) {
                EgressAgent leader = group.getProperty(OccGroupObj.PROP_GROUP_LEADER);
                if (leader == null) {
                    String string = Intl.intl("Movement group leader is not set.");
                    String fix3 = Intl.intl("Set the movement group leader to one of the movement group members.");
                    errors.add(new SimError(SimError.Level.CRITICAL, string, fix3, group));
                } else if (!leader.isEnabled()) {
                    errors.add(new SimError(SimError.Level.CRITICAL, disabledLeaderErrorMsg, disabledLeaderFix, group));
                }
            }
        }
        if (group instanceof OccGroupTypeObj) {
            OccGroupTypeObj groupType = (OccGroupTypeObj)group;
            if (groupType.getProperty(OccGroupTypeObj.PROP_SPECIFY_PROFILES).booleanValue()) {
                Map<OccProfile, OccGroupTypeObj.GroupCreationDataObj> profData = groupType.getProperty(OccGroupTypeObj.PROP_PROFILE_DATA);
                double d = 0.0;
                for (OccProfile prof : profData.keySet()) {
                    if (!((d += profData.get((Object)prof).prefNumberOfMembers.getMin().get(Unit.ONE)) >= 1.0)) continue;
                    break;
                }
                if (d < 1.0) {
                    errorMsg = OccGroupsPanel.MIN_WARNING;
                    fix = Intl.intl("Review movement group creation parameters.");
                    errors.add(new SimError(SimError.Level.CRITICAL, (String)errorMsg, fix, group));
                }
            } else {
                double min = groupType.getProperty(OccGroupTypeObj.PROP_PREF_NUMBER_OF_MEMBERS).getMin().get(Unit.ONE);
                if (min < 1.0) {
                    String errorMsg4 = OccGroupsPanel.MIN_WARNING;
                    String fix4 = Intl.intl("Review group creation parameters.");
                    errors.add(new SimError(SimError.Level.CRITICAL, errorMsg4, fix4, group));
                }
            }
        }
    }

    private static void getBehaviorActionErrors(MerlinData md, IBehaviorAction obj, List<SimError> errors) {
        Behavior behavior = (Behavior)md.hierarchy.getParent(obj);
        if (behavior == null) {
            return;
        }
        int tindex = 0;
        for (IBehaviorAction action : behavior.flatten(IBehaviorAction.class)) {
            if (action == obj) break;
            if (action instanceof ChangeBehavior) {
                ChangeBehavior cb = (ChangeBehavior)action;
                for (Behavior targetBehavior : cb.getAllTargetBehaviors()) {
                    Optional<IBehaviorAction> targetLast = targetBehavior.getLastAction();
                    if (!targetLast.isPresent() || targetLast.get() instanceof ResumePrior) continue;
                    errors.add(new SimError(SimError.Level.MODERATE, String.format(Intl.intl("Behavior action, %s, might not be reached because of a prior Change Behavior action."), obj.getName()), Intl.intl("Change the prior Change Behavior action so all its target behaviors end with a \"Resume Prior\" action."), obj, targetBehavior));
                    break;
                }
            }
            ++tindex;
        }
        if (obj.mustBeLast() && tindex != behavior.getMembers().size() - 1) {
            String error = String.format(Intl.intl("%s must be last in the behavior list."), obj.getName());
            String fix = String.format(Intl.intl("Delete %s or drag it until it is the last action in the behavior list."), obj.getName());
            errors.add(new SimError(SimError.Level.CRITICAL, error, fix, obj));
        }
    }

    private static void forEachSuperclass(Class<?> clazz, Consumer<EntryPoint> consumer) {
        EntryPoint superEP = EntryPointFactory.get(GotoExits.class.getSuperclass());
        consumer.accept(superEP);
    }

    static {
        gotoOccTargetIcon = occTargetIcon = guiUtil.loadMerlinIcon("occloc16.png", 16);
        gotoOccIcon = occupantIcon;
        gotoCurrentAttractorIcon = attractorIcon;
        occTargetGroupIcon = EntryPointFactory.getManagerIcon(occTargetIcon);
        waitUntilEndIcon = waitIcon = guiUtil.loadMerlinIcon("clock16.png", 16);
        elevatorIcon = guiUtil.loadMerlinIcon("elevator16.png", 16);
        measurementRegionGroupIcon = guiUtil.loadMerlinIcon("measure-area16.png", 16);
        measurementRegionIcon = guiUtil.loadMerlinIcon("measure-area-obj16.png", 16);
        occupantSourceGroupIcon = guiUtil.loadMerlinIcon("occ_source_group16.png", 16);
        occupantSourceIcon = guiUtil.loadMerlinIcon("occ_source16.png", 16);
        assistIcon = guiUtil.loadMerlinIcon("assist16.png", 16);
        waitForAssistanceIcon = guiUtil.loadMerlinIcon("waitForAssistance16.png", 16);
        detachIcon = guiUtil.loadMerlinIcon("detach16.png", 16);
        joinGroupIcon = guiUtil.loadMerlinIcon("occ_group16.png", 16);
        leaveGroupIcon = guiUtil.loadMerlinIcon("occ_group16.png", 16);
        queueIcon = guiUtil.loadMerlinIcon("queue16.png", 16);
        queueGroupIcon = guiUtil.loadMerlinIcon("queue16.png", 16);
        queuePathIcon = guiUtil.loadMerlinIcon("path16.png", 16);
        queueServiceIcon = guiUtil.loadMerlinIcon("service16.png", 16);
        queuePathNodeIcon = guiUtil.loadMerlinIcon("Node16.png", 16);
        blockageIcon = guiUtil.loadMerlinIcon("blockage.png");
        blockageGroupIcon = EntryPointFactory.getManagerIcon(blockageIcon);
        createAttractorIcon = guiUtil.loadMerlinIcon("createattractor16.png", 16);
        destroyAtttractorIcon = guiUtil.loadMerlinIcon("destroyattractor16.png", 16);
        s_plain = new Font("Sans Serif", 0, 11);
        s_bold = new Font("Sans Serif", 1, 11);
        s_italic = new Font("Sans Serif", 2, 11);
        s_italicBold = s_italic.deriveFont(1);
        EntryPointFactory.registerDefault(FuncType.CheckDelete, new NullAction(null));
        EntryPointFactory.registerDefault(FuncType.GetOtherDeleteObjs, new ConstantGetter(Collections.EMPTY_LIST));
        EntryPointFactory.registerDefault(FuncType.GetConflict, new ConstantGetter(null));
        EntryPointFactory.registerDefault(FuncType.Delete, new NullAction(false));
        EntryPointFactory.registerDefault(FuncType.IsAutoDeleteGroup, new ConstantGetter(false));
        EntryPointFactory.registerDefault(FuncType.IsVisible, new ConstantGetter(true));
        EntryPointFactory.registerDefault(FuncType.SetVisible, new NullSetter());
        EntryPointFactory.registerDefault(FuncType.GetCompositeRoot, new ConstantGetter(null));
        EntryPointFactory.registerDefault(FuncType.GetNameGenerator, new ConstantGetter(null));
        EntryPointFactory.registerDefault(FuncType.IsIndexed, new ConstantGetter(false));
        EntryPointFactory.registerDefault(FuncType.IsMovable, new ConstantGetter(true));
        EntryPointFactory.registerDefault(FuncType.ShowBounds, new ConstantGetter(true));
        EntryPointFactory.registerDefault(FuncType.TV_GetErrors, new ConstantGetter(Collections.EMPTY_LIST));
        EntryPointFactory.registerDefault(FuncType.TV_GetName, new ConstantGetter(""));
        EntryPointFactory.registerDefault(FuncType.TV_SetName, new NullSetter());
        EntryPointFactory.registerDefault(FuncType.TV_CanRename, new ConstantGetter(false));
        EntryPointFactory.registerDefault(FuncType.TV_GetIcon, new ConstantAsyncGetter(null));
        EntryPointFactory.registerDefault(FuncType.TV_GetBaseFont, new ConstantGetter(s_plain));
        EntryPointFactory.registerDefault(FuncType.TV_IsVisible, new ConstantGetter(true));
        EntryPointFactory.registerDefault(FuncType.TV_IsEnabled, new ConstantGetter(true));
        EntryPointFactory.registerDefault(FuncType.TV_GetForcedAutoexpand, new ConstantGetter(false));
        EntryPointFactory.registerDefault(FuncType.TV_IsLeaf, new ConstantGetter(true));
        EntryPointFactory.registerDefault(FuncType.TV_GetChildren, new ConstantGetter(Collections.EMPTY_LIST));
        EntryPointFactory.registerDefault(FuncType.TV_GetParent, new ConstantGetter(null));
        EntryPointFactory.register(MerlinData.class, FuncType.TV_GetChildren, (MerlinData md, T obj) -> Arrays.asList(md.cameras, md.sceneGeom, md.profiles, md.vehicleShapes, md.assistedEvacTeams, md.behaviors, md.queues, md.occSources, md.agents, md.occGroups, md.occGroupTypes, md.occTargets, md.attractorsRoot, md.elevators, md.regions, md.blockages, md.floors));
        EntryPointFactory.register(MerlinData.class, FuncType.TV_GetErrors, (MerlinData md, T obj) -> {
            ArrayList<SimError> errors = new ArrayList<SimError>();
            for (IMerlinObj iMerlinObj : md.getChildren()) {
                errors.addAll(EntryPointFactory.get(iMerlinObj).tvEntryPoint.getErrors(md, iMerlinObj));
            }
            return errors;
        });
        EntryPointFactory.register(INamed.class, FuncType.TV_GetName, new EntryPoint.Getter<INamed, String>(){

            @Override
            public String get(MerlinData md, INamed obj) {
                return obj.getName();
            }
        });
        EntryPointFactory.register(INamed.class, FuncType.TV_SetName, new EntryPoint.Setter<INamed, String>(){

            @Override
            public void set(MerlinData md, INamed obj, String arg) {
                RenameAction.rename(md, Arrays.asList(obj), arg);
            }
        });
        EntryPointFactory.register(INamed.class, FuncType.TV_CanRename, new EntryPoint.Getter<INamed, Boolean>(){

            @Override
            public Boolean get(MerlinData md, INamed obj) {
                return obj.isSetNameSupported();
            }
        });
        EntryPointFactory.register(IMerlinObj.class, FuncType.TV_GetChildren, (MerlinData md, T obj) -> obj.getChildren());
        EntryPointFactory.register(IMerlinObj.class, FuncType.TV_GetParent, (MerlinData md, T obj) -> md.hierarchy.getParent(obj));
        EntryPointFactory.register(IMerlinObj.class, FuncType.TV_IsLeaf, (MerlinData md, T obj) -> obj.getChildren().isEmpty());
        EntryPointFactory.register(OccProfile.class, FuncType.GetCompositeRoot, (MerlinData md, T obj) -> md.profiles);
        EntryPointFactory.register(OccProfile.class, FuncType.GetNameGenerator, (MerlinData md, T obj) -> md.profNameGen);
        EntryPointFactory.registerIcon(OccProfile.class, occupantProfileIcon);
        EntryPointFactory.register(OccProfile.class, FuncType.CheckDelete, new EntryPoint.Action<OccProfile, Exception, Set<? extends IMerlinObj>>(){

            @Override
            public Exception perform(MerlinData md, OccProfile obj, Set<? extends IMerlinObj> delObjs) {
                if (EntryPointFactory.deletingAllOfType(md, delObjs, OccProfile.class, md.profiles)) {
                    return new Exception(Intl.intl("You must have at least one profile defined at all times."));
                }
                return null;
            }
        });
        EntryPointFactory.register(OccProfile.class, FuncType.TV_GetForcedAutoexpand, new ConstantGetter(true));
        EntryPointFactory.register(OccProfile.class, FuncType.GetConflict, new EntryPoint.Getter<OccProfile, OccProfile>(){

            @Override
            public OccProfile get(MerlinData md, OccProfile comparable) {
                if (theUtil.equal(comparable, md.profiles.NO_CHANGE)) {
                    return md.profiles.NO_CHANGE;
                }
                return EntryPointFactory.getStandardConflictGetter(OccProfile.class).get(md, comparable);
            }
        });
        EntryPointFactory.register(OccProfileComp.class, FuncType.GetCompositeRoot, (MerlinData md, T obj) -> md.profiles);
        EntryPointFactory.registerIcon(OccProfileComp.class, occupantProfileIcon);
        EntryPointFactory.register(VehicleShape.class, FuncType.GetCompositeRoot, (MerlinData md, T obj) -> md.vehicleShapes);
        EntryPointFactory.register(VehicleShape.class, FuncType.GetNameGenerator, (MerlinData md, T obj) -> md.vehicleShapeNameGen);
        EntryPointFactory.registerIcon(VehicleShape.class, vehicleIcon);
        EntryPointFactory.register(VehicleShape.class, FuncType.CheckDelete, new EntryPoint.Action<VehicleShape, Exception, Set<? extends IMerlinObj>>(){

            @Override
            public Exception perform(MerlinData md, VehicleShape obj, Set<? extends IMerlinObj> delObjs) {
                if (EntryPointFactory.deletingAllOfType(md, delObjs, VehicleShape.class, md.vehicleShapes)) {
                    return new Exception(Intl.intl("You must have at least one vehicle shape defined at all times."));
                }
                return null;
            }
        });
        EntryPointFactory.register(VehicleShape.class, FuncType.TV_GetForcedAutoexpand, new ConstantGetter(true));
        EntryPointFactory.register(VehicleShape.class, FuncType.GetConflict, EntryPointFactory.getStandardConflictGetter(VehicleShape.class));
        EntryPointFactory.register(VehicleShapeComp.class, FuncType.GetCompositeRoot, (MerlinData md, T obj) -> md.vehicleShapes);
        EntryPointFactory.registerIcon(VehicleShapeComp.class, vehicleGroupIcon);
        EntryPointFactory.register(QueueObject.class, FuncType.GetCompositeRoot, (MerlinData md, T obj) -> md.queues);
        EntryPointFactory.register(QueueObject.class, FuncType.GetNameGenerator, (MerlinData md, T obj) -> md.queueObjectNameGen);
        EntryPointFactory.registerIcon(QueueObject.class, queueIcon);
        EntryPointFactory.register(QueueObject.class, FuncType.TV_GetErrors, new EntryPoint.Getter<QueueObject, Collection<? extends SimError>>(){

            @Override
            public Collection<? extends SimError> get(MerlinData md, QueueObject obj) {
                ArrayList<SimError> errors = new ArrayList<SimError>(2);
                EntryPoint<?> superep = EntryPointFactory.get(obj.getClass().getSuperclass());
                errors.addAll(superep.tvEntryPoint.getErrors(md, obj));
                obj.validate(md, SimError.Level.MODERATE, errors::add);
                return errors;
            }
        });
        EntryPointFactory.register(QueueObject.class, FuncType.GetConflict, EntryPointFactory.getStandardConflictGetter(QueueObject.class));
        EntryPointFactory.register(IQueueElement.class, FuncType.GetCompositeRoot, (MerlinData md, T obj) -> md.queues);
        EntryPointFactory.register(IQueueElement.class, FuncType.TV_GetForcedAutoexpand, new ConstantGetter(true));
        EntryPointFactory.register(QueuePath.class, FuncType.GetCompositeRoot, (MerlinData md, T obj) -> md.queues);
        EntryPointFactory.register(QueuePath.class, FuncType.GetNameGenerator, (MerlinData md, T obj) -> md.queuePathNameGen);
        EntryPointFactory.registerIcon(QueuePath.class, queuePathIcon);
        EntryPointFactory.registerIcon(QueuePathNode.class, queuePathNodeIcon);
        EntryPointFactory.register(QueuePathNode.class, FuncType.IsIndexed, new ConstantGetter(true));
        EntryPointFactory.register(QueuePathNode.class, FuncType.TV_GetErrors, new EntryPoint.Getter<QueuePathNode, Collection<? extends SimError>>(){

            @Override
            public Collection<? extends SimError> get(MerlinData md, QueuePathNode obj) {
                if (obj.getRoom() == null) {
                    return Arrays.asList(new SimError(SimError.Level.CRITICAL, Intl.intl("Queue Path Node is not in a room."), Intl.intl("Move Queue Path Node to a room."), obj));
                }
                return Collections.emptyList();
            }
        });
        EntryPointFactory.register(QueueService.class, FuncType.GetNameGenerator, (MerlinData md, T obj) -> md.queueServiceNameGen);
        EntryPointFactory.registerIcon(QueueService.class, queueServiceIcon);
        EntryPointFactory.register(QueueService.class, FuncType.TV_GetErrors, new EntryPoint.Getter<QueueService, Collection<? extends SimError>>(){

            @Override
            public Collection<? extends SimError> get(MerlinData md, QueueService obj) {
                if (obj.getRoom() == null) {
                    return Arrays.asList(new SimError(SimError.Level.CRITICAL, Intl.intl("Queue Service is not in a room."), Intl.intl("Move Queue Service to a room."), obj));
                }
                return Collections.emptyList();
            }
        });
        EntryPointFactory.register(QueueObjectComp.class, FuncType.GetCompositeRoot, (MerlinData md, T obj) -> md.queues);
        EntryPointFactory.register(QueueObjectComp.class, FuncType.GetNameGenerator, (MerlinData md, T obj) -> md.queueObjectNameGen);
        EntryPointFactory.registerIcon(QueueObjectComp.class, queueGroupIcon);
        EntryPointFactory.register(OccTargetComp.class, FuncType.GetCompositeRoot, (MerlinData md, T obj) -> md.occTargets);
        EntryPointFactory.register(OccTargetComp.class, FuncType.GetNameGenerator, (MerlinData md, T obj) -> md.occTargetsNameGen);
        EntryPointFactory.registerIcon(OccTargetComp.class, occTargetGroupIcon);
        EntryPointFactory.register(OccTarget.class, FuncType.GetCompositeRoot, (MerlinData md, T obj) -> md.occTargets);
        EntryPointFactory.register(OccTarget.class, FuncType.GetNameGenerator, (MerlinData md, T obj) -> md.occTargetsNameGen);
        EntryPointFactory.registerIcon(OccTarget.class, occTargetIcon);
        EntryPointFactory.register(OccTarget.class, FuncType.GetConflict, EntryPointFactory.getStandardConflictGetter(OccTarget.class));
        EntryPointFactory.register(OccTarget.class, FuncType.TV_GetErrors, new EntryPoint.Getter<OccTarget, Collection<? extends SimError>>(){

            @Override
            public Collection<? extends SimError> get(MerlinData md, OccTarget obj) {
                if (!obj.isEnabled()) {
                    return Collections.emptyList();
                }
                ArrayList<SimError> errors = new ArrayList<SimError>();
                if (obj.getRoom() == null) {
                    errors.add(new SimError(SimError.Level.CRITICAL, Intl.intl("Occupant target is not in a room."), Intl.intl("Move occupant target to a room."), obj));
                }
                return errors;
            }
        });
        EntryPointFactory.register(AttractorRootComp.class, FuncType.GetCompositeRoot, (MerlinData md, T obj) -> md.attractorsRoot);
        EntryPointFactory.register(AttractorRootComp.class, FuncType.GetNameGenerator, (MerlinData md, T obj) -> md.attractorsNameGen);
        EntryPointFactory.registerIcon(AttractorRootComp.class, attractorGroupIcon);
        EntryPointFactory.register(AttractorComp.class, FuncType.GetCompositeRoot, (MerlinData md, T obj) -> md.attractors);
        EntryPointFactory.register(AttractorComp.class, FuncType.GetNameGenerator, (MerlinData md, T obj) -> md.attractorsNameGen);
        EntryPointFactory.registerIcon(AttractorComp.class, attractorGroupIcon);
        EntryPointFactory.register(AttractorTemplateComp.class, FuncType.GetCompositeRoot, (MerlinData md, T obj) -> md.attractorTemplates);
        EntryPointFactory.register(AttractorTemplateComp.class, FuncType.GetNameGenerator, (MerlinData md, T obj) -> md.attractorsNameGen);
        EntryPointFactory.registerIcon(AttractorTemplateComp.class, attractorGroupIcon);
        EntryPointFactory.register(Attractor.class, FuncType.GetCompositeRoot, (MerlinData md, T obj) -> md.attractorsRoot);
        EntryPointFactory.register(Attractor.class, FuncType.GetNameGenerator, (MerlinData md, T obj) -> md.attractorsNameGen);
        EntryPointFactory.registerIcon(Attractor.class, attractorIcon);
        EntryPointFactory.register(Attractor.class, FuncType.GetConflict, EntryPointFactory.getStandardConflictGetter(Attractor.class));
        EntryPointFactory.register(Attractor.class, FuncType.ShowBounds, new ConstantGetter(false));
        EntryPointFactory.register(Attractor.class, FuncType.TV_GetErrors, new EntryPoint.Getter<Attractor, Collection<? extends SimError>>(){

            @Override
            public Collection<? extends SimError> get(MerlinData md, Attractor obj) {
                if (!obj.isEnabled()) {
                    return Collections.emptyList();
                }
                ArrayList<SimError> errors = new ArrayList<SimError>();
                if (obj.getRoom() == null && obj.requiresLocation()) {
                    errors.add(new SimError(SimError.Level.CRITICAL, Intl.intl("Trigger is not in a room."), Intl.intl("Move trigger to a room."), obj));
                }
                if (obj.get(Attractor.AWARENESS) == Attractor.Awareness.ROOMS && obj.get(Attractor.ROOMS).isEmpty()) {
                    errors.add(new SimError(SimError.Level.MODERATE, Intl.intl("No rooms are specified. Trigger will not be visible to any occupants."), Intl.intl("Specify rooms for the trigger."), obj));
                }
                return errors;
            }
        });
        EntryPointFactory.register(AssistedEvacTeam.class, FuncType.GetCompositeRoot, (MerlinData md, T obj) -> md.assistedEvacTeams);
        EntryPointFactory.register(AssistedEvacTeam.class, FuncType.GetNameGenerator, (MerlinData md, T obj) -> md.assistedEvacTeamNameGen);
        EntryPointFactory.registerIcon(AssistedEvacTeam.class, assistedEvacTeamIcon);
        EntryPointFactory.register(AssistedEvacTeam.class, FuncType.CheckDelete, new EntryPoint.Action<AssistedEvacTeam, Exception, Set<? extends IMerlinObj>>(){

            @Override
            public Exception perform(MerlinData md, AssistedEvacTeam obj, Set<? extends IMerlinObj> delObjs) {
                if (EntryPointFactory.deletingAllOfType(md, delObjs, AssistedEvacTeam.class, md.assistedEvacTeams)) {
                    return new Exception(Intl.intl("You must have at least one assisted evacuation team defined at all times."));
                }
                return null;
            }
        });
        EntryPointFactory.register(AssistedEvacTeam.class, FuncType.TV_GetErrors, new EntryPoint.Getter<AssistedEvacTeam, Collection<? extends SimError>>(){

            @Override
            public Collection<? extends SimError> get(MerlinData md, AssistedEvacTeam obj) {
                ArrayList errors = new ArrayList();
                if (unassistedTeamsCache.contains(obj)) {
                    // empty if block
                }
                return errors;
            }
        });
        EntryPointFactory.register(AssistedEvacTeam.class, FuncType.TV_GetForcedAutoexpand, new ConstantGetter(true));
        EntryPointFactory.register(AssistedEvacTeam.class, FuncType.GetConflict, EntryPointFactory.getStandardConflictGetter(AssistedEvacTeam.class));
        EntryPointFactory.register(AssistedEvacTeamComp.class, FuncType.GetCompositeRoot, (MerlinData md, T obj) -> md.assistedEvacTeams);
        EntryPointFactory.register(AssistedEvacTeamComp.class, FuncType.GetNameGenerator, (MerlinData md, T obj) -> md.assistedEvacTeamNameGen);
        EntryPointFactory.registerIcon(AssistedEvacTeamComp.class, assistedEvacTeamGroupIcon);
        EntryPointFactory.register(ICompElement.class, FuncType.GetCompositeRoot, (MerlinData md, T obj) -> md.floors);
        EntryPointFactory.register(ICompElement.class, FuncType.GetNameGenerator, new ConstantGetter(new SequentialNameGen("Geom", 2)));
        EntryPointFactory.register(ICompElement.class, FuncType.Delete, new EntryPoint.Action<ICompElement, Boolean, Object>(){

            @Override
            public Boolean perform(MerlinData md, ICompElement obj, Object arg) {
                Object parentObj = md.hierarchy.getParent(obj);
                if (!(parentObj instanceof Composite)) {
                    return false;
                }
                Composite parent = (Composite)parentObj;
                return parent.remove(obj);
            }
        });
        EntryPointFactory.register(ICompElement.class, FuncType.IsVisible, new EntryPoint.Getter<ICompElement, Boolean>(){

            @Override
            public Boolean get(MerlinData md, ICompElement obj) {
                Object value = obj.getProperty(MerlinData.VISIBILITY);
                boolean basevis = value instanceof Boolean ? (Boolean)value : true;
                return basevis && !md.displayFilter.filter(obj);
            }
        });
        EntryPointFactory.register(ICompElement.class, FuncType.TV_IsEnabled, new EntryPoint.Getter<ICompElement, Boolean>(){

            @Override
            public Boolean get(MerlinData md, ICompElement obj) {
                Object val = obj.getProperty(MerlinData.ENABLED);
                return val instanceof Boolean ? (Boolean)val : true;
            }
        });
        EntryPointFactory.register(ICompElement.class, FuncType.SetVisible, new EntryPoint.Setter<ICompElement, Boolean>(){

            @Override
            public void set(MerlinData md, ICompElement obj, Boolean arg) {
                obj.setProperty(MerlinData.VISIBILITY, arg);
            }
        });
        EntryPointFactory.register(ICompElement.class, FuncType.TV_IsVisible, new EntryPoint.Getter<ICompElement, Boolean>(){

            @Override
            public Boolean get(MerlinData md, ICompElement obj) {
                Object value = obj.getProperty(MerlinData.VISIBILITY);
                return value instanceof Boolean ? (Boolean)value : true;
            }
        });
        EntryPointFactory.register(Composite.class, FuncType.GetOtherDeleteObjs, new EntryPoint.Getter<Composite<?>, Collection<? extends IMerlinObj>>(){

            @Override
            public Collection<? extends IMerlinObj> get(MerlinData md, Composite<?> obj) {
                LinkedIdentityHashSet<IMerlinObj> otherObjs = new LinkedIdentityHashSet<IMerlinObj>();
                for (IMerlinObj child : obj.getChildren()) {
                    EntryPoint<IMerlinObj> ep = EntryPointFactory.get(child);
                    ep.getOtherDeleteObjs(md, otherObjs, child);
                }
                return otherObjs;
            }
        });
        EntryPointFactory.register(Composite.class, FuncType.CheckDelete, new EntryPoint.Action<Composite<?>, Exception, Set<? extends IMerlinObj>>(){

            @Override
            public Exception perform(MerlinData md, Composite<?> obj, Set<? extends IMerlinObj> delObjs) {
                for (IMerlinObj child : obj.getChildren()) {
                    EntryPoint<IMerlinObj> ep = EntryPointFactory.get(child);
                    try {
                        ep.checkDelete(md, child, delObjs);
                    }
                    catch (Exception e) {
                        return e;
                    }
                }
                return null;
            }
        });
        EntryPointFactory.register(Composite.class, FuncType.TV_GetErrors, new EntryPoint.Getter<Composite<?>, Collection<? extends SimError>>(){

            @Override
            public Collection<? extends SimError> get(MerlinData md, Composite<?> obj) {
                int moderateErrors = 0;
                int criticalErrors = 0;
                ArrayList<? extends IMerlinObj> moderateObjs = new ArrayList<IMerlinObj>();
                ArrayList<? extends IMerlinObj> criticalObjs = new ArrayList<IMerlinObj>();
                for (ICompElement eobj : obj.getMembers(ICompElement.class)) {
                    for (SimError se : EntryPointFactory.get(eobj).tvEntryPoint.getErrors(md, eobj)) {
                        int numErrors;
                        int n = numErrors = se instanceof CompositeSimError ? ((CompositeSimError)se).errorCount : 1;
                        if (se.level == SimError.Level.CRITICAL) {
                            criticalErrors += numErrors;
                            criticalObjs.addAll(se.causeObjs);
                            continue;
                        }
                        moderateErrors += numErrors;
                        moderateObjs.addAll(se.causeObjs);
                    }
                }
                if (moderateErrors > 0 || criticalErrors > 0) {
                    ArrayList<CompositeSimError> errors = new ArrayList<CompositeSimError>(2);
                    if (moderateErrors > 0) {
                        errors.add(new CompositeSimError(SimError.Level.MODERATE, moderateErrors, moderateObjs));
                    }
                    if (criticalErrors > 0) {
                        errors.add(new CompositeSimError(SimError.Level.CRITICAL, criticalErrors, criticalObjs));
                    }
                    return errors;
                }
                return Collections.EMPTY_LIST;
            }
        });
        EntryPointFactory.register(Composite.class, FuncType.TV_GetForcedAutoexpand, new ConstantGetter(true));
        EntryPointFactory.register(GeomComposite.class, FuncType.TV_GetBaseFont, new EntryPoint.Getter<GeomComposite<?>, Font>(){

            @Override
            public Font get(MerlinData md, GeomComposite<?> obj) {
                if (md.floors.getActive().getWorkingGeomGroup() == obj) {
                    return s_italic;
                }
                return EntryPointFactory.get(GeomComposite.class.getSuperclass()).tvEntryPoint.getBaseFont(md, obj);
            }
        });
        EntryPointFactory.register(GeomComposite.class, FuncType.TV_GetIcon, new EntryPoint.AsyncGetter<GeomComposite<?>, Icon>(){

            @Override
            public Icon get(MerlinData md, GeomComposite<?> obj, Consumer<Icon> whenReady) {
                if (md.hierarchy.isDescendent(md.sceneGeom, obj)) {
                    return importedGeometryGroupIcon;
                }
                if (md.hierarchy.isDescendent(md.floors, obj)) {
                    return floorGroupIcon;
                }
                if (md.hierarchy.isDescendent(md.elevators, obj)) {
                    return elevatorIcon;
                }
                return blankIcon;
            }
        });
        EntryPointFactory.register(EgressAgent.class, FuncType.GetCompositeRoot, (MerlinData md, T obj) -> md.agents);
        EntryPointFactory.register(EgressAgent.class, FuncType.GetNameGenerator, new ConstantGetter(new SequentialNameGen("Occupant", 2)));
        EntryPointFactory.registerIcon(EgressAgent.class, occupantIcon);
        EntryPointFactory.register(EgressAgent.class, FuncType.TV_GetErrors, new EntryPoint.Getter<EgressAgent, Collection<? extends SimError>>(){

            @Override
            public Collection<? extends SimError> get(MerlinData md, EgressAgent obj) {
                String fix;
                String error;
                OccLocation location = obj.getLocInfo();
                ArrayList<SimError> errors = new ArrayList<SimError>(3);
                if (!obj.isEnabled()) {
                    return errors;
                }
                if (location.room == null || location.room instanceof AEgressComp && !((AEgressComp)((Object)location.room)).isEnabled()) {
                    error = String.format(Intl.intl("%s is not in a room."), obj.getName());
                    fix = Intl.intl("Delete or move to a room.");
                    errors.add(new SimError(SimError.Level.CRITICAL, error, fix, obj));
                }
                if (location.isOverlappingAgents()) {
                    error = String.format(Intl.intl("%s is overlapping other occupants."), obj.getName());
                    fix = Intl.intl("Delete or move to avoid overlap.");
                    errors.add(new SimError(SimError.Level.MODERATE, error, fix, obj));
                }
                if (location.overlapsWalls) {
                    error = String.format(Intl.intl("%s is overlapping a room boundary."), obj.getName());
                    fix = Intl.intl("Delete or move to avoid overlap.");
                    errors.add(new SimError(SimError.Level.CRITICAL, error, fix, obj));
                }
                if (location.failsFilter) {
                    error = String.format(Intl.intl("%s is placed in a rejected component."), obj.getName());
                    fix = Intl.intl("Delete or move to another location, or change rejected components.");
                    errors.add(new SimError(SimError.Level.MODERATE, error, fix, obj));
                }
                EntryPointFactory.getResolvedProfileErrors(obj, obj.getProfile(), errors, Intl.intl("Change shape or change profile so the occupant can move without assistance."));
                EntryPointFactory.getAssistedEvacErrors(obj, obj.getProfile(), obj.getBehavior(), errors);
                List notEnoughAssistErrors = notEnoughAssistingCached.getOrDefault(obj, Collections.emptyList());
                errors.addAll(notEnoughAssistErrors);
                List vehicleElevErrors = vehicleNotFitInElevatorCache.getOrDefault(obj, Collections.emptyList());
                errors.addAll(vehicleElevErrors);
                for (GotoQueue gotoQueue : obj.getBehavior().flatten(GotoQueue.class)) {
                    ArrayList<QueueObject> naughtyQueues = new ArrayList<QueueObject>();
                    boolean allowedIn = false;
                    for (QueueObject q : gotoQueue.getQueues()) {
                        boolean allowedHere = !q.getRestrictedProfiles().contains(obj.getProfile().getProfParent());
                        boolean bl = allowedIn = allowedIn || allowedHere;
                        if (allowedIn) break;
                        if (allowedHere) continue;
                        naughtyQueues.add(q);
                    }
                    if (allowedIn) continue;
                    String error2 = String.format(Intl.intl("%s is being directed to a queue their Profile restricts them from."), obj.getName());
                    String fix2 = Intl.intl("Allow this occupant's profile in the target queue, or uncheck the queue in the Behavior's GoToQueue action.");
                    ArrayList<AMerlinObj> errObjs = new ArrayList<AMerlinObj>(Arrays.asList(obj, gotoQueue));
                    errObjs.addAll(naughtyQueues);
                    errors.add(new SimError(SimError.Level.MODERATE, error2, fix2, errObjs));
                }
                EntryPointFactory.getBadDirectBehaviorErrors(errors, obj, obj.getBehavior());
                return errors;
            }
        });
        MerlinApp app = MerlinApp.getApp();
        if (app != null) {
            app.getData().getEvents().addObserver(cachedWarningsUpdator);
        }
        EntryPointFactory.register(EgressAgent.class, FuncType.GetConflict, EntryPointFactory.getStandardConflictGetter(EgressAgent.class));
        EntryPointFactory.register(EgressAgentComp.class, FuncType.GetCompositeRoot, (MerlinData md, T obj) -> md.agents);
        EntryPointFactory.register(EgressAgentComp.class, FuncType.GetNameGenerator, new ConstantGetter(new SequentialNameGen("OccupantGroup", 2)));
        EntryPointFactory.registerIcon(EgressAgentComp.class, occupantGroupIcon);
        EntryPointFactory.register(EgressAgentComp.class, FuncType.IsAutoDeleteGroup, new EntryPoint.Getter<EgressAgentComp, Boolean>(){

            @Override
            public Boolean get(MerlinData md, EgressAgentComp obj) {
                return obj != md.agents;
            }
        });
        EntryPointFactory.register(CameraList.class, FuncType.GetCompositeRoot, (MerlinData md, T obj) -> md.cameras);
        EntryPointFactory.register(CameraList.class, FuncType.GetNameGenerator, (MerlinData md, T obj) -> md.cameraNameGen);
        EntryPointFactory.registerIcon(CameraList.class, cameraListIcon);
        EntryPointFactory.register(CameraList.class, FuncType.IsAutoDeleteGroup, new EntryPoint.Getter<CameraList, Boolean>(){

            @Override
            public Boolean get(MerlinData md, CameraList obj) {
                return md.cameras != obj;
            }
        });
        EntryPointFactory.registerIcon(Camera.class, cameraIcon);
        EntryPointFactory.registerCameraTour();
        EntryPointFactory.register(ICameraObj.class, FuncType.GetCompositeRoot, (MerlinData md, T obj) -> md.cameras);
        EntryPointFactory.register(ICameraObj.class, FuncType.GetNameGenerator, (MerlinData md, T obj) -> md.cameraNameGen);
        EntryPointFactory.register(ICameraObj.class, FuncType.TV_GetForcedAutoexpand, new ConstantGetter(true));
        EntryPointFactory.register(Floor.class, FuncType.GetCompositeRoot, (MerlinData md, T obj) -> md.floors);
        EntryPointFactory.register(Floor.class, FuncType.GetNameGenerator, (MerlinData md, T obj) -> new ConstantGetter(new SequentialNameGen("Floor", 2)));
        EntryPointFactory.register(Floor.class, FuncType.IsMovable, new ConstantGetter(false));
        EntryPointFactory.registerIcon(Floor.class, floorIcon);
        EntryPointFactory.register(Floor.class, FuncType.TV_GetBaseFont, new EntryPoint.Getter<Floor, Font>(){

            @Override
            public Font get(MerlinData md, Floor obj) {
                boolean working;
                boolean active = md.floors.getActive() == obj;
                boolean bl = working = md.floors.getActive().getWorkingGeomGroup() == obj;
                if (active && working) {
                    return s_italicBold;
                }
                if (active) {
                    return s_bold;
                }
                if (working) {
                    return s_italic;
                }
                return EntryPointFactory.get(Floor.class.getSuperclass()).tvEntryPoint.getFont(md, obj);
            }
        });
        EntryPointFactory.register(Floor.class, FuncType.CheckDelete, new EntryPoint.Action<Floor, Exception, Set<? extends IMerlinObj>>(){

            @Override
            public Exception perform(MerlinData md, Floor obj, Set<? extends IMerlinObj> selObjs) {
                if (obj == md.activeFloor()) {
                    return new Exception(Intl.intl("The active floor cannot be deleted."));
                }
                return null;
            }
        });
        EntryPointFactory.register(Floor.class, FuncType.GetOtherDeleteObjs, new EntryPoint.Getter<Floor, Collection<? extends IMerlinObj>>(){

            @Override
            public Collection<? extends IMerlinObj> get(MerlinData md, Floor obj) {
                if (obj == md.activeFloor()) {
                    return obj.getChildren();
                }
                return Collections.EMPTY_LIST;
            }
        });
        EntryPointFactory.registerIcon(FloorComposite.class, floorIcon);
        EntryPointFactory.register(IEgressComp.class, FuncType.TV_GetErrors, new EntryPoint.Getter<IEgressComp, Collection<? extends SimError>>(){

            @Override
            public Collection<? extends SimError> get(MerlinData md, IEgressComp obj) {
                Collection<Object> errors = Collections.EMPTY_LIST;
                boolean nonManifold = false;
                Collection<Pair<IEgressComp, IEgressComp.ConflictType>> overlaps = obj.getConflicts();
                for (Pair<IEgressComp, IEgressComp.ConflictType> overlap : overlaps) {
                    String msg = "";
                    String fix = "";
                    switch ((IEgressComp.ConflictType)((Object)overlap.v2)) {
                        case EDGE: {
                            msg = String.format(Intl.intl("%1$s overlaps %2$s."), obj.getName(), ((IEgressComp)overlap.v1).getName());
                            fix = Intl.intl("Adjust edges so components no longer overlap.");
                            break;
                        }
                        case NON_MANIFOLD: {
                            nonManifold = true;
                        }
                    }
                    if (msg.isEmpty()) continue;
                    errors = EntryPointFactory.lazyAdd(errors, new SimError(SimError.Level.MODERATE, msg, fix, obj));
                }
                if (nonManifold) {
                    String msg = "";
                    String fix = "";
                    if (obj instanceof EgressDoor) {
                        msg = String.format(Intl.intl("%s must be connected to exactly one or two rooms."), obj.getName());
                    } else if (obj instanceof EgressCorridor) {
                        msg = String.format(Intl.intl("Each end of %s must be connected to an outer edge of exactly one room."), obj.getName());
                    }
                    errors = EntryPointFactory.lazyAdd(errors, new SimError(SimError.Level.MODERATE, msg, fix, obj));
                }
                return errors;
            }
        });
        EntryPointFactory.registerIcon(IEgressOccupiable.class, roomIcon);
        EntryPointFactory.register(IEgressOccupiable.class, FuncType.GetOtherDeleteObjs, new EntryPoint.Getter<IEgressOccupiable, Collection<? extends IMerlinObj>>(){

            @Override
            public Collection<? extends IMerlinObj> get(MerlinData md, IEgressOccupiable obj) {
                ArrayList<AMerlinObj> objs = new ArrayList<AMerlinObj>(obj.getOccupants().size() + obj.getWaypoints().size());
                objs.addAll(obj.getOccupants());
                objs.addAll(obj.getWaypoints());
                return objs;
            }
        });
        EntryPointFactory.register(IEgressOccupiable.class, FuncType.GetConflict, EntryPointFactory.getStandardConflictGetter(IEgressOccupiable.class));
        EntryPointFactory.register(IEgressConnector.class, FuncType.TV_GetIcon, new EntryPoint.AsyncGetter<IEgressConnector, Icon>(){

            @Override
            public Icon get(MerlinData md, IEgressConnector obj, Consumer<Icon> whenReady) {
                return obj.isExit() ? exitIcon : doorIcon;
            }
        });
        EntryPointFactory.registerIcon(EgressStair.class, stairsIcon);
        EntryPointFactory.register(EgressStair.class, FuncType.GetConflict, EntryPointFactory.getStandardConflictGetter(EgressStair.class));
        EntryPointFactory.registerIcon(EgressCorridor.class, rampIcon);
        EntryPointFactory.register(EgressCorridor.class, FuncType.TV_GetErrors, new EntryPoint.Getter<EgressCorridor, Collection<? extends SimError>>(){

            @Override
            public Collection<? extends SimError> get(MerlinData md, EgressCorridor obj) {
                Collection<Object> errors = Collections.EMPTY_LIST;
                for (SimError error : EntryPointFactory.get(IEgressComp.class).tvEntryPoint.getErrors(md, obj)) {
                    errors = EntryPointFactory.lazyAdd(errors, error);
                }
                if (obj.isEnabled()) {
                    IEgressOccupiable d_conn1 = obj.getDoor1().getRoom();
                    IEgressOccupiable d_conn2 = obj.getDoor2().getRoom();
                    if (d_conn1 == null && d_conn2 == null) {
                        errors = EntryPointFactory.lazyAdd(errors, new SimError(SimError.Level.MODERATE, String.format(Intl.intl("%s is not connected to any rooms."), obj.getName()), Intl.intl("Delete or adjust handles to connect to a room."), obj));
                    } else if (d_conn1 instanceof ElevatorRoom || d_conn2 instanceof ElevatorRoom) {
                        errors = EntryPointFactory.lazyAdd(errors, new SimError(SimError.Level.MODERATE, Intl.intl("Stairs and ramps may not be connected to elevators."), Intl.intl("Remove this object or reconnect to a non-elevator room."), obj));
                    }
                    if (d_conn1 == null || d_conn2 == null) {
                        String msg = obj instanceof EgressStair ? Intl.intl("Disconnected Stairway") : Intl.intl("Disconnected Ramp");
                        errors = EntryPointFactory.lazyAdd(errors, new SimError(SimError.Level.MODERATE, msg, Intl.intl("Modify geometry or add a landing."), obj));
                    }
                }
                return errors;
            }
        });
        EntryPointFactory.register(EgressCorridor.class, FuncType.GetConflict, EntryPointFactory.getStandardConflictGetter(EgressCorridor.class));
        EntryPointFactory.register(EgressDoor.class, FuncType.TV_GetErrors, new EntryPoint.Getter<EgressDoor, Collection<? extends SimError>>(){

            @Override
            public Collection<? extends SimError> get(MerlinData md, EgressDoor obj) {
                Collection<Object> errors = Collections.EMPTY_SET;
                for (SimError error : EntryPointFactory.get(IEgressComp.class).tvEntryPoint.getErrors(md, obj)) {
                    errors = EntryPointFactory.lazyAdd(errors, error);
                }
                if (!obj.isEnabled()) {
                    return errors;
                }
                String error = null;
                String fix = null;
                IEgressOccupiable room1 = obj.getRoom1();
                IEgressOccupiable room2 = obj.getRoom2();
                if (room1 == null && room2 == null) {
                    error = String.format(Intl.intl("%s is not connected to any elements."), obj.getName());
                    fix = Intl.intl("Delete door.");
                } else if (!(room1 != null && room2 != null || obj.isExit())) {
                    error = String.format(Intl.intl("Non-exit, %s, is only connected to one room."), obj.getName());
                    fix = Intl.intl("Delete or adjust handles to connect to another room.");
                } else if (!(obj instanceof ElevatorDoor) && (room1 instanceof ElevatorRoom || room2 instanceof ElevatorRoom)) {
                    error = String.format(Intl.intl("Doors may not be connected to an existing elevator."), new Object[0]);
                    fix = Intl.intl("Remove this door or reconnect to a non-elevator room.");
                }
                if (error != null) {
                    errors = EntryPointFactory.lazyAdd(errors, new SimError(SimError.Level.CRITICAL, error, fix, obj));
                }
                if (obj.isExit()) {
                    List<DiscreteVariant.Entry<EgressConnectorState>> state = VariantUtil.getDiscreteValues(obj.getRawState(), true);
                    for (DiscreteVariant.Entry<EgressConnectorState> entry : state) {
                        if (entry.val == EgressConnectorState.CONNECTOR_OPEN || entry.val == EgressConnectorState.CONNECTOR_CLOSED) continue;
                        String error2 = Intl.intl("One-way markings on exits are ignored.");
                        String fix2 = Intl.intl("Remove one-way marking on exit.");
                        errors = EntryPointFactory.lazyAdd(errors, new SimError(SimError.Level.MODERATE, error2, fix2, obj));
                        break;
                    }
                }
                return errors;
            }
        });
        EntryPointFactory.register(EgressDoor.class, FuncType.GetConflict, EntryPointFactory.getStandardConflictGetter(EgressDoor.class));
        EntryPointFactory.register(EgressRoom.class, FuncType.GetConflict, EntryPointFactory.getStandardConflictGetter(EgressRoom.class));
        EntryPointFactory.register(Elevator.class, FuncType.GetCompositeRoot, (MerlinData md, T obj) -> md.elevators);
        EntryPointFactory.register(Elevator.class, FuncType.GetNameGenerator, new ConstantGetter(new SequentialNameGen("Elevator", 2)));
        EntryPointFactory.register(Elevator.class, FuncType.IsAutoDeleteGroup, new ConstantGetter(true));
        EntryPointFactory.register(Elevator.class, FuncType.TV_GetErrors, new EntryPoint.Getter<Elevator, Collection<? extends SimError>>(){

            @Override
            public Collection<? extends SimError> get(MerlinData md, Elevator obj) {
                Object enabled;
                EntryPoint<?> superep = EntryPointFactory.get(obj.getClass().getSuperclass());
                ArrayList<SimError> errors = new ArrayList<SimError>(superep.tvEntryPoint.getErrors(md, obj));
                for (IMerlinObj child : obj.getChildren()) {
                    errors.addAll(EntryPointFactory.get(child).tvEntryPoint.getErrors(md, child));
                }
                Floor dischargeFloor = obj.getDischargeFloor();
                if (dischargeFloor == null && ((enabled = obj.getProperty(MerlinData.ENABLED)) instanceof Boolean && ((Boolean)enabled).booleanValue() || !(enabled instanceof Boolean))) {
                    errors.add(new SimError(SimError.Level.CRITICAL, Intl.intl("Elevator is not connected at its discharge floor."), Intl.intl("Make sure the elevator's doors are enabled at the discharge floor or change the elevator's discharge floor."), obj));
                }
                if (obj.getCloseDelay().getValueNoUnit() + obj.getOpenDelay().getValueNoUnit() < 1.0) {
                    errors.add(new SimError(SimError.Level.MODERATE, Intl.intl("Combined open delay and close delay is less than 1 second."), Intl.intl("Make sure either open delay or close delay are at least 1 second."), obj));
                }
                List cachedErrors = doubleDeckElevatorWarnings.getOrDefault(obj, Collections.emptyList());
                errors.addAll(cachedErrors);
                return errors;
            }
        });
        EntryPointFactory.register(Elevator.class, FuncType.GetConflict, EntryPointFactory.getStandardConflictGetter(Elevator.class));
        EntryPointFactory.register(ElevatorGroup.class, FuncType.GetCompositeRoot, (MerlinData md, T obj) -> md.elevators);
        EntryPointFactory.register(ElevatorGroup.class, FuncType.CheckDelete, (MerlinData md, T obj, ArgT delObjs) -> null);
        EntryPointFactory.register(ElevatorGroup.class, FuncType.TV_GetErrors, new EntryPoint.Getter<ElevatorGroup, Collection<? extends SimError>>(){

            @Override
            public Collection<? extends SimError> get(MerlinData md, ElevatorGroup obj) {
                EntryPoint<?> superep = EntryPointFactory.get(obj.getClass().getSuperclass());
                ArrayList<SimError> errors = new ArrayList<SimError>(superep.tvEntryPoint.getErrors(md, obj));
                for (IMerlinObj child : obj.getChildren()) {
                    errors.addAll(EntryPointFactory.get(child).tvEntryPoint.getErrors(md, child));
                }
                Optional<Object> dischargeFloor = Optional.empty();
                for (Elevator elevator : obj.flatten(Elevator.class)) {
                    Floor floor = elevator.getDischargeFloor();
                    if (floor == null) continue;
                    if (!dischargeFloor.isPresent()) {
                        dischargeFloor = Optional.of(floor);
                        continue;
                    }
                    if (dischargeFloor.get() == floor) continue;
                    errors.add(new SimError(SimError.Level.MODERATE, Intl.intl("Elevators in the same group (call set) should have the same discharge floor. Different floors may produce unknown behavior."), Intl.intl("Set all elevators in the group to the same discharge floor."), obj));
                    break;
                }
                return errors;
            }
        });
        EntryPointFactory.register(IElevatorComp.class, FuncType.CheckDelete, new EntryPoint.Action<IElevatorComp, Exception, Set<? extends IMerlinObj>>(){

            @Override
            public Exception perform(MerlinData md, IElevatorComp obj, Set<? extends IMerlinObj> delObjs) {
                Elevator elevator;
                Object parent = md.hierarchy.getParent(obj);
                if (parent instanceof Elevator && (delObjs.contains(elevator = (Elevator)parent) || delObjs.containsAll(elevator.getChildren()))) {
                    return null;
                }
                return new Exception(Intl.intl("Elevator rooms and doors cannot be individually deleted."));
            }
        });
        EntryPointFactory.register(ElevatorRoom.class, FuncType.GetCompositeRoot, (MerlinData md, T obj) -> md.elevators);
        EntryPointFactory.register(ElevatorRoom.class, FuncType.TV_GetBaseFont, new EntryPoint.Getter<ElevatorRoom, Font>(){

            @Override
            public Font get(MerlinData md, ElevatorRoom obj) {
                Object parent = md.hierarchy.getParent(obj);
                if (parent instanceof Elevator && ((Elevator)parent).getDischargeRoom() == obj) {
                    return s_bold;
                }
                return EntryPointFactory.get(ElevatorRoom.class.getSuperclass()).tvEntryPoint.getBaseFont(md, obj);
            }
        });
        EntryPointFactory.register(ElevatorRoom.class, FuncType.TV_GetErrors, new EntryPoint.Getter<ElevatorRoom, Collection<? extends SimError>>(){

            @Override
            public Collection<? extends SimError> get(MerlinData md, ElevatorRoom obj) {
                EntryPoint<?> superep = EntryPointFactory.get(obj.getClass().getSuperclass());
                ArrayList<SimError> errors = new ArrayList<SimError>(superep.tvEntryPoint.getErrors(md, obj));
                for (IMerlinObj iMerlinObj : obj.getChildren()) {
                    errors.addAll(EntryPointFactory.get(iMerlinObj).tvEntryPoint.getErrors(md, iMerlinObj));
                }
                LinkedIdentityHashSet connectedFloors = new LinkedIdentityHashSet();
                for (ElevatorDoor door : obj.getElevatorDoors()) {
                    Floor floor = ElevatorUtil.getFloor(md, obj, door);
                    if (floor == null) continue;
                    connectedFloors.add(floor);
                }
                if (connectedFloors.size() > 1) {
                    errors.add(new SimError(SimError.Level.CRITICAL, String.format(Intl.intl("Elevator level is connected to %d floors.  It must only be connected to one."), connectedFloors.size()), Intl.intl("Move all rooms connected to the elevator level to the same floor."), obj));
                }
                if (connectedFloors.size() >= 1) {
                    Elevator elevator = (Elevator)obj.getParent();
                    if (elevator != null) {
                        IdentityHashMap<Floor, Integer> floorUseCounts = new IdentityHashMap<Floor, Integer>();
                        for (ElevatorRoom level : elevator.getMembers(ElevatorRoom.class)) {
                            Floor floor = ElevatorUtil.getFloor(md, level);
                            if (floor == null) continue;
                            Integer count = (Integer)floorUseCounts.get(floor);
                            if (count == null) {
                                floorUseCounts.put(floor, 1);
                                continue;
                            }
                            count = count + 1;
                            floorUseCounts.put(floor, count);
                        }
                        Integer count = (Integer)floorUseCounts.get(connectedFloors.iterator().next());
                        if (count != null && count > 1) {
                            errors.add(new SimError(SimError.Level.CRITICAL, Intl.intl("Multiple elevator levels connected to one floor."), Intl.intl("This elevator level must be connected to its own floor."), obj));
                        }
                    } else {
                        errors.add(new SimError(SimError.Level.CRITICAL, Intl.intl("This elevator is in an invalid state."), Intl.intl("elevatorRoom.getParent() is returning null."), obj));
                    }
                }
                return errors;
            }
        });
        EntryPointFactory.register(ElevatorRoom.class, FuncType.GetConflict, EntryPointFactory.getStandardConflictGetter(ElevatorRoom.class));
        EntryPointFactory.register(ElevatorRoom.class, FuncType.GetCompositeRoot, (MerlinData md, T obj) -> md.elevators);
        EntryPointFactory.register(ElevatorDoor.class, FuncType.TV_GetErrors, new EntryPoint.Getter<ElevatorDoor, Collection<? extends SimError>>(){

            @Override
            public Collection<? extends SimError> get(MerlinData md, ElevatorDoor obj) {
                EntryPoint<?> superep = EntryPointFactory.get(obj.getClass().getSuperclass());
                Collection<SimError> errors = superep.tvEntryPoint.getErrors(md, obj);
                if (obj.getRoom1() instanceof ElevatorRoom && obj.getRoom2() != obj.getRoom1() && obj.getRoom2() instanceof ElevatorRoom) {
                    SimError error = new SimError(SimError.Level.CRITICAL, Intl.intl("Elevator doors can only be connected to one elevator."), Intl.intl("Delete one of the elevators."), obj);
                    ArrayList<SimError> newErrors = new ArrayList<SimError>(errors);
                    newErrors.add(error);
                    errors = newErrors;
                }
                return errors;
            }
        });
        EntryPointFactory.register(ElevatorDoor.class, FuncType.GetConflict, new EntryPoint.Getter<ElevatorDoor, ElevatorDoor>(){

            @Override
            public ElevatorDoor get(MerlinData md, ElevatorDoor comparable) {
                Collection<ElevatorRoom> elevatorRooms = md.elevators.flatten(ElevatorRoom.class);
                for (ElevatorRoom room : elevatorRooms) {
                    for (ElevatorDoor door : room.getElevatorDoors()) {
                        if (!theUtil.equal(comparable, door)) continue;
                        return door;
                    }
                }
                return null;
            }
        });
        EntryPointFactory.register(EgressBlockageComp.class, FuncType.GetCompositeRoot, (MerlinData md, T obj) -> md.blockages);
        EntryPointFactory.register(EgressBlockageComp.class, FuncType.GetNameGenerator, (MerlinData md, T obj) -> md.blkgNameGen);
        EntryPointFactory.registerIcon(EgressBlockageComp.class, blockageGroupIcon);
        EntryPointFactory.register(EgressBlockage.class, FuncType.GetCompositeRoot, (MerlinData md, T obj) -> md.blockages);
        EntryPointFactory.register(EgressBlockage.class, FuncType.GetNameGenerator, (MerlinData md, T obj) -> md.blkgNameGen);
        EntryPointFactory.registerIcon(EgressBlockage.class, blockageIcon);
        EntryPointFactory.register(EgressBlockage.class, FuncType.GetConflict, EntryPointFactory.getStandardConflictGetter(EgressBlockage.class));
        EntryPointFactory.register(EgressBlockage.class, FuncType.TV_GetErrors, new EntryPoint.Getter<EgressBlockage, Collection<? extends SimError>>(){

            @Override
            public Collection<? extends SimError> get(MerlinData md, EgressBlockage obj) {
                ArrayList<SimError> errs = new ArrayList<SimError>();
                if (obj.getDisplayType() == EgressBlockage.DisplayType.CAD_GEOM && obj.getProp(EgressBlockage.LINK_CAD_GEOM_TO_SEARCH).get().booleanValue() && obj.getProp(EgressBlockage.CAD_GEOM).get().node == GeomNodeUtil.EMPTY_NODE) {
                    errs.add(new SimError(SimError.Level.MODERATE, Intl.intl("No imported geometry has been picked for the obstacle."), Intl.intl("Select the obstacle and click <b>Pick</b> to choose imported geometry or uncheck <b>Link shape to CAD geometry</b>"), obj));
                }
                return errs;
            }
        });
        EntryPointFactory.register(ImportedGeom.class, FuncType.GetCompositeRoot, (MerlinData md, T obj) -> md.sceneGeom);
        EntryPointFactory.register(ImportedGeom.class, FuncType.GetNameGenerator, new ConstantGetter(new SequentialNameGen("Imported", 2)));
        EntryPointFactory.register(ImportedGeom.class, FuncType.TV_GetIcon, new EntryPoint.AsyncGetter<ImportedGeom, Icon>(){

            @Override
            public Icon get(MerlinData md, ImportedGeom obj, Consumer<Icon> whenReady) {
                if (obj.getGeom().getNumPrims(1) > 0) {
                    return importedGeometry3DIcon;
                }
                return importedGeometry2DIcon;
            }
        });
        EntryPointFactory.registerIcon(RasterImage.class, backgroundImageIcon);
        EntryPointFactory.register(MeasurementRegionObj.class, FuncType.GetCompositeRoot, (MerlinData md, T obj) -> md.regions);
        EntryPointFactory.register(MeasurementRegionObj.class, FuncType.GetNameGenerator, (MerlinData md, T obj) -> md.densityNameGen);
        EntryPointFactory.registerIcon(MeasurementRegionObj.class, measurementRegionIcon);
        EntryPointFactory.register(MeasurementRegions.class, FuncType.GetCompositeRoot, (MerlinData md, T obj) -> md.regions);
        EntryPointFactory.register(MeasurementRegions.class, FuncType.GetNameGenerator, (MerlinData md, T obj) -> md.densityNameGen);
        EntryPointFactory.registerIcon(MeasurementRegions.class, measurementRegionGroupIcon);
        EntryPointFactory.register(OccSourceObj.class, FuncType.GetCompositeRoot, (MerlinData md, T obj) -> md.occSources);
        EntryPointFactory.register(OccSourceObj.class, FuncType.GetNameGenerator, (MerlinData md, T obj) -> md.occSourceNameGen);
        EntryPointFactory.registerIcon(OccSourceObj.class, occupantSourceIcon);
        EntryPointFactory.register(OccSourceObj.class, FuncType.TV_GetForcedAutoexpand, new ConstantGetter(true));
        EntryPointFactory.register(OccSourceObj.class, FuncType.TV_GetErrors, new EntryPoint.Getter<OccSourceObj, Collection<? extends SimError>>(){

            @Override
            public Collection<? extends SimError> get(MerlinData md, OccSourceObj obj) {
                ArrayList<SimError> errors = new ArrayList<SimError>();
                Set<OccProfile> profs = ((IUrn)obj.getProperty(OccSourceObj.PROP_PROFILE_DIST)).getWeights().keySet();
                Set behaviors = ((IUrn)obj.getProperty(OccSourceObj.PROP_BEHAVIOR_DIST)).getWeights().keySet();
                profs.forEach(prof -> EntryPointFactory.getResolvedProfileErrors(obj, prof, errors, Intl.intl("Change profile or remove profile from occupant source.")));
                for (OccProfile profile : profs) {
                    for (Behavior behavior2 : behaviors) {
                        EntryPointFactory.getAssistedEvacErrors(obj, profile, behavior2, errors);
                    }
                }
                List notEnoughAssistErrors = notEnoughAssistingCached.getOrDefault(obj, Collections.emptyList());
                errors.addAll(notEnoughAssistErrors);
                List vehicleElevErrors = vehicleNotFitInElevatorCache.getOrDefault(obj, Collections.emptyList());
                errors.addAll(vehicleElevErrors);
                List exitDoorErrors = occSourceExitDoorWarnings.getOrDefault(obj, Collections.emptyList());
                errors.addAll(exitDoorErrors);
                if (obj.getType() == OccSourceObj.OccSourceType.EGRESS_COMPONENT && Objects.equals(obj.getProperty(OccSourceObj.PROP_COMPONENT), null)) {
                    SimError e = new SimError(SimError.Level.CRITICAL, Intl.intl("Component of this occupant source was deleted."), Intl.intl("Assign this occupant source to an existing component."), Collections.emptyList());
                    errors.add(e);
                }
                boolean inMovementGroup = obj.isGrouped(md);
                obj.get(OccSourceObj.PROP_BEHAVIOR_DIST).forEach(behavior -> {
                    EntryPointFactory.getBadDirectBehaviorErrors(errors, obj, behavior);
                    EntryPointFactory.getGotoOccTargetErrors(errors, obj, inMovementGroup, behavior);
                });
                if (obj.get(OccSourceObj.PROP_ENFORCE_FLOWRATE).stream().noneMatch(b -> b) && (obj.get(OccSourceObj.PROP_FLOW_RATE) instanceof RandomizedImpulseFunction1d || obj.get(OccSourceObj.PROP_FLOW_RATE) instanceof ImpulseFunction1d)) {
                    errors.add(new SimError(SimError.Level.MODERATE, Intl.intl("The flowrate is not being enforced. The occupant source might not produce the desired number of occupants."), "<html>" + Intl.intl("Set <b>Enforce Flow Rate</b> to <b>Yes</b>."), obj));
                }
                return errors;
            }
        });
        EntryPointFactory.register(OccSourceObj.OccSourceComp.class, FuncType.GetCompositeRoot, (MerlinData md, T obj) -> md.occSources);
        EntryPointFactory.register(OccSourceObj.OccSourceComp.class, FuncType.GetNameGenerator, (MerlinData md, T obj) -> md.occSourceNameGen);
        EntryPointFactory.registerIcon(OccSourceObj.OccSourceComp.class, occupantSourceGroupIcon);
        EntryPointFactory.register(OccGroupObj.class, FuncType.GetCompositeRoot, (MerlinData md, T obj) -> md.occGroups);
        EntryPointFactory.register(OccGroupObj.class, FuncType.GetNameGenerator, (MerlinData md, T obj) -> md.occGroupNameGen);
        EntryPointFactory.registerIcon(OccGroupObj.class, occupantGroupIcon);
        EntryPointFactory.register(OccGroupObj.class, FuncType.TV_GetForcedAutoexpand, new ConstantGetter(true));
        EntryPointFactory.register(OccGroupObj.class, FuncType.IsAutoDeleteGroup, new ConstantGetter(true));
        EntryPointFactory.register(OccGroupObj.class, FuncType.TV_GetErrors, new EntryPoint.Getter<OccGroupObj, Collection<? extends SimError>>(){

            @Override
            public Collection<? extends SimError> get(MerlinData md, OccGroupObj obj) {
                EntryPoint<?> superep = EntryPointFactory.get(obj.getClass().getSuperclass());
                ArrayList<SimError> errors = new ArrayList<SimError>(superep.tvEntryPoint.getErrors(md, obj));
                EntryPointFactory.getOccGroupErrors(obj, errors, md);
                return errors;
            }
        });
        EntryPointFactory.register(OccGroupObj.OccGroupComp.class, FuncType.GetCompositeRoot, (MerlinData md, T obj) -> md.occGroups);
        EntryPointFactory.register(OccGroupObj.OccGroupComp.class, FuncType.GetNameGenerator, (MerlinData md, T obj) -> md.occGroupNameGen);
        EntryPointFactory.registerIcon(OccGroupObj.OccGroupComp.class, occupantGroupIcon);
        EntryPointFactory.register(OccGroupTypeObj.class, FuncType.GetCompositeRoot, (MerlinData md, T obj) -> md.occGroupTypes);
        EntryPointFactory.register(OccGroupTypeObj.class, FuncType.GetNameGenerator, (MerlinData md, T obj) -> md.occGroupTypeNameGen);
        EntryPointFactory.registerIcon(OccGroupTypeObj.class, occupantGroupIcon);
        EntryPointFactory.register(OccGroupTypeObj.class, FuncType.TV_GetForcedAutoexpand, new ConstantGetter(true));
        EntryPointFactory.register(OccGroupTypeObj.class, FuncType.TV_GetErrors, new EntryPoint.Getter<OccGroupTypeObj, Collection<? extends SimError>>(){

            @Override
            public Collection<? extends SimError> get(MerlinData md, OccGroupTypeObj obj) {
                ArrayList<SimError> errors = new ArrayList<SimError>();
                EntryPointFactory.getOccGroupErrors(obj, errors, md);
                return errors;
            }
        });
        EntryPointFactory.register(OccGroupTypeObj.class, FuncType.GetConflict, new EntryPoint.Getter<OccGroupTypeObj, OccGroupTypeObj>(){

            @Override
            public OccGroupTypeObj get(MerlinData md, OccGroupTypeObj comparable) {
                if (theUtil.equal(comparable, md.occGroupTypes.NO_GROUP_TYPE)) {
                    return md.occGroupTypes.NO_GROUP_TYPE;
                }
                return EntryPointFactory.getStandardConflictGetter(OccGroupTypeObj.class).get(md, comparable);
            }
        });
        EntryPointFactory.registerIcon(OccGroupTypeObj.OccGroupTypeComp.class, occupantGroupIcon);
        EntryPointFactory.register(Proxy.class, FuncType.TV_GetForcedAutoexpand, new EntryPoint.Getter<Proxy<? extends ICompElement>, Boolean>(){

            @Override
            public Boolean get(MerlinData md, Proxy<? extends ICompElement> obj) {
                return md.selection.isSelected(obj);
            }
        });
        EntryPointFactory.register(Proxy.class, FuncType.TV_GetIcon, new EntryPoint.AsyncGetter<Proxy<? extends ICompElement>, Icon>(){

            @Override
            public Icon get(MerlinData md, Proxy<? extends ICompElement> proxy, Consumer<Icon> whenReady) {
                ICompElement obj = proxy.getObj();
                return ((EntryPoint.AsyncGetter)EntryPointFactory.findFunc(obj.getClass(), FuncType.TV_GetIcon)).get(md, obj, whenReady);
            }
        });
        EntryPointFactory.register(Proxy.class, FuncType.TV_GetErrors, new EntryPoint.Getter<Proxy, Collection<? extends SimError>>(){

            @Override
            public Collection<? extends SimError> get(MerlinData md, Proxy obj) {
                EntryPoint<?> superep = EntryPointFactory.get(obj.getClass().getSuperclass());
                ArrayList<SimError> errors = new ArrayList<SimError>(superep.tvEntryPoint.getErrors(md, obj));
                List cachedErrors = occGroupWarnings.getOrDefault(obj, Collections.emptyList());
                errors.addAll(cachedErrors);
                return errors;
            }
        });
        EntryPointFactory.register(BehaviorRoot.class, FuncType.GetCompositeRoot, (MerlinData md, T obj) -> md.behaviors);
        EntryPointFactory.register(Behavior.class, FuncType.GetCompositeRoot, (MerlinData md, T obj) -> md.behaviors);
        EntryPointFactory.register(Behavior.class, FuncType.GetNameGenerator, new ConstantGetter(new SequentialNameGen("Behavior", 2)));
        EntryPointFactory.registerIcon(Behavior.class, behaviorIcon);
        EntryPointFactory.register(Behavior.class, FuncType.CheckDelete, new EntryPoint.Action<Behavior, Exception, Set<? extends IMerlinObj>>(){

            @Override
            public Exception perform(MerlinData md, Behavior obj, Set<? extends IMerlinObj> delObjs) {
                if (EntryPointFactory.deletingAllOfType(md, delObjs, Behavior.class, md.behaviors)) {
                    return new Exception(Intl.intl("You must have at least one behavior defined at all times."));
                }
                return null;
            }
        });
        EntryPointFactory.register(Behavior.class, FuncType.TV_GetErrors, new EntryPoint.Getter<Behavior, Collection<? extends SimError>>(){

            @Override
            public Collection<? extends SimError> get(MerlinData md, Behavior obj) {
                ArrayList<SimError> errors = new ArrayList<SimError>(EntryPointFactory.get(Behavior.class.getSuperclass()).tvEntryPoint.getErrors(md, obj));
                Optional<IBehaviorAction> last = obj.getLastAction();
                if (!last.isPresent() || !last.get().mustBeLast() && !MerlinUtil.isBehaviorTerminal(obj)) {
                    String error = String.format(Intl.intl("Behavior, %s, does not have an ending action."), obj.getName());
                    String fix = Intl.intl("Add an ending action to the behavior, such as Goto Exit.");
                    errors.add(new SimError(SimError.Level.MODERATE, error, fix, obj));
                } else if (obj.getInitialDelay() instanceof ConstantCurve && ((ConstantCurve)obj.getInitialDelay()).getValue().getRawValue() == 0.0 && obj.getMembers().size() == 1 && last.map(a -> a.mustBeLast() && a.isImmediate()).orElse(false).booleanValue()) {
                    String error = String.format(Intl.intl("Behavior, %s, will end immediately after being started."), obj.getName());
                    String fix = Intl.intl("Set an initial delay or add intermediate actions for the occupants to perform.");
                    errors.add(new SimError(SimError.Level.MODERATE, error, fix, obj));
                }
                return errors;
            }
        });
        EntryPointFactory.register(Behavior.class, FuncType.GetConflict, new EntryPoint.Getter<Behavior, Behavior>(){

            @Override
            public Behavior get(MerlinData md, Behavior comparable) {
                if (theUtil.equal(comparable, md.behaviors.NO_CHANGE)) {
                    return md.behaviors.NO_CHANGE;
                }
                return EntryPointFactory.getStandardConflictGetter(Behavior.class).get(md, comparable);
            }
        });
        EntryPointFactory.register(IBehaviorAction.class, FuncType.GetCompositeRoot, (MerlinData md, T obj) -> md.behaviors);
        EntryPointFactory.register(IBehaviorAction.class, FuncType.TV_GetForcedAutoexpand, new ConstantGetter(true));
        EntryPointFactory.register(IBehaviorAction.class, FuncType.IsIndexed, new ConstantGetter(true));
        EntryPointFactory.register(IBehaviorAction.class, FuncType.TV_GetErrors, new EntryPoint.Getter<IBehaviorAction, Collection<? extends SimError>>(){

            @Override
            public Collection<? extends SimError> get(MerlinData md, IBehaviorAction obj) {
                ArrayList<SimError> errors = new ArrayList<SimError>();
                EntryPointFactory.forEachSuperclass(IBehaviorAction.class, superEP -> errors.addAll(superEP.tvEntryPoint.getErrors(md, obj)));
                EntryPointFactory.getBehaviorActionErrors(md, obj, errors);
                return errors;
            }
        });
        EntryPointFactory.registerIcon(Wait.class, waitIcon);
        EntryPointFactory.registerIcon(WaitUntil.class, waitIcon);
        EntryPointFactory.registerIcon(GotoWaypoint.class, gotoIcon);
        EntryPointFactory.register(GotoWaypoint.class, FuncType.TV_GetErrors, new EntryPoint.Getter<GotoWaypoint, Collection<? extends SimError>>(){

            @Override
            public Collection<? extends SimError> get(MerlinData md, GotoWaypoint obj) {
                ArrayList<SimError> errors = new ArrayList<SimError>();
                EntryPointFactory.forEachSuperclass(GotoExits.class, superEP -> errors.addAll(superEP.tvEntryPoint.getErrors(md, obj)));
                if (obj.getRoom() == null) {
                    errors.add(new SimError(SimError.Level.CRITICAL, Intl.intl("Waypoint is not in a room."), Intl.intl("Move waypoint to a room."), obj));
                }
                EntryPointFactory.getBehaviorActionErrors(md, obj, errors);
                return errors;
            }
        });
        EntryPointFactory.registerIcon(GotoExits.class, exitIcon);
        EntryPointFactory.register(GotoExits.class, FuncType.TV_GetErrors, new EntryPoint.Getter<GotoExits, Collection<? extends SimError>>(){

            @Override
            public Collection<? extends SimError> get(MerlinData md, GotoExits obj) {
                ArrayList<SimError> errors = new ArrayList<SimError>();
                EntryPointFactory.forEachSuperclass(GotoExits.class, superEP -> errors.addAll(superEP.tvEntryPoint.getErrors(md, obj)));
                boolean invalidExits = false;
                for (EgressDoor door : obj.get(GotoExits.PROP_EXITS)) {
                    if (door.isExit()) continue;
                    invalidExits = true;
                    break;
                }
                if (invalidExits) {
                    String error = String.format(Intl.intl("%s is set to exit out non-exit doors."), obj.getName());
                    String fix = Intl.intl("Edit exits.");
                    errors.add(new SimError(SimError.Level.CRITICAL, error, fix, obj));
                }
                EntryPointFactory.getBehaviorActionErrors(md, obj, errors);
                return errors;
            }
        });
        EntryPointFactory.registerIcon(RemoveOcc.class, removeOccIcon);
        EntryPointFactory.registerIcon(WaitUntilEnd.class, waitUntilEndIcon);
        EntryPointFactory.registerIcon(ResumePrior.class, resumePriorIcon);
        EntryPointFactory.registerIcon(GotoElevators.class, elevatorIcon);
        EntryPointFactory.registerIcon(GotoQueue.class, queueIcon);
        EntryPointFactory.register(GotoQueue.class, FuncType.TV_GetErrors, new EntryPoint.Getter<GotoQueue, Collection<? extends SimError>>(){

            @Override
            public Collection<? extends SimError> get(MerlinData md, GotoQueue obj) {
                ArrayList<SimError> errors = new ArrayList<SimError>();
                if (obj.getQueues().isEmpty()) {
                    String error = Intl.intl("No queues are selected.");
                    String fix = Intl.intl("Specify queues to go to.");
                    errors.add(new SimError(SimError.Level.MODERATE, error, fix, obj));
                }
                return errors;
            }
        });
        EntryPointFactory.register(GotoRooms.class, FuncType.TV_GetIcon, new EntryPoint.AsyncGetter<GotoRooms, Icon>(){

            @Override
            public Icon get(MerlinData md, GotoRooms obj, Consumer<Icon> whenReady) {
                return obj.mustBeLast() ? refugeRoomIcon : roomIcon;
            }
        });
        EntryPointFactory.register(GotoRooms.class, FuncType.TV_GetErrors, new EntryPoint.Getter<GotoRooms, Collection<? extends SimError>>(){

            @Override
            public Collection<? extends SimError> get(MerlinData md, GotoRooms obj) {
                ArrayList<SimError> errors = new ArrayList<SimError>();
                if (obj.getRooms().isEmpty() && !GotoRooms.getAnyAllowed(obj.getFilter())) {
                    String error = String.format(Intl.intl("No rooms are selected."), obj.getName());
                    String fix = Intl.intl("Specify rooms to go to.");
                    errors.add(new SimError(SimError.Level.CRITICAL, error, fix, obj));
                }
                errors.addAll(refugeRoomSizeWarnings.getOrDefault(obj, Collections.emptyList()));
                EntryPointFactory.getBehaviorActionErrors(md, obj, errors);
                return errors;
            }
        });
        EntryPointFactory.register(GotoOccTarget.class, FuncType.TV_GetIcon, new EntryPoint.AsyncGetter<GotoOccTarget, Icon>(){

            @Override
            public Icon get(MerlinData md, GotoOccTarget obj, Consumer<Icon> whenReady) {
                return gotoOccTargetIcon;
            }
        });
        EntryPointFactory.register(GotoOccTarget.class, FuncType.TV_GetErrors, new EntryPoint.Getter<GotoOccTarget, Collection<? extends SimError>>(){

            @Override
            public Collection<? extends SimError> get(MerlinData md, GotoOccTarget obj) {
                ArrayList<SimError> errors = new ArrayList<SimError>();
                EntryPointFactory.getBehaviorActionErrors(md, obj, errors);
                return errors;
            }
        });
        EntryPointFactory.registerIcon(GotoOcc.class, assistIcon);
        EntryPointFactory.registerIcon(GotoCurrentAttractor.class, gotoCurrentAttractorIcon);
        EntryPointFactory.registerIcon(AssistOccupants.class, assistIcon);
        EntryPointFactory.registerIcon(WaitForAssistance.class, waitForAssistanceIcon);
        EntryPointFactory.registerIcon(DetachAssistants.class, detachIcon);
        EntryPointFactory.registerIcon(AbandonOccTargets.class, abandonOccTargetsIcon);
        EntryPointFactory.registerIcon(JoinOccGroup.class, joinGroupIcon);
        EntryPointFactory.register(JoinOccGroup.class, FuncType.TV_GetErrors, new EntryPoint.Getter<JoinOccGroup, Collection<? extends SimError>>(){

            @Override
            public Collection<? extends SimError> get(MerlinData md, JoinOccGroup obj) {
                ArrayList<SimError> errors = new ArrayList<SimError>();
                if (obj.getGroup() == null) {
                    String error = Intl.intl("No movement group is selected.");
                    String fix = Intl.intl("Specify a movement group to join.");
                    errors.add(new SimError(SimError.Level.CRITICAL, error, fix, obj));
                } else if (obj.type.equals((Object)JoinOccGroup.Type.LEAD_GROUP) && !obj.getGroup().getProperty(OccGroupObj.PROP_REQUIRES_GROUP_LEADER).booleanValue()) {
                    String error = Intl.intl("This action must be used with a movement group or a movement group template that follows a leader.");
                    String fix = String.format(Intl.intl("Check the Follow Leader checkbox in the dialog for %s"), obj.getGroup().getName());
                    errors.add(new SimError(SimError.Level.CRITICAL, error, fix, obj));
                }
                EntryPointFactory.getBehaviorActionErrors(md, obj, errors);
                return errors;
            }
        });
        EntryPointFactory.registerIcon(ChangeBehavior.class, behaviorIcon);
        EntryPointFactory.register(ChangeBehavior.class, FuncType.TV_GetErrors, new EntryPoint.Getter<ChangeBehavior, Collection<? extends SimError>>(){

            @Override
            public Collection<? extends SimError> get(MerlinData md, ChangeBehavior obj) {
                List errors = changeBehaviorWarnings.getOrDefault(obj, Collections.emptyList());
                return errors;
            }
        });
        EntryPointFactory.registerIcon(ChangeProfile.class, occupantProfileIcon);
        EntryPointFactory.register(ChangeProfile.class, FuncType.TV_GetErrors, (MerlinData md, T obj) -> {
            ArrayList<SimError> errors = new ArrayList<SimError>();
            for (OccProfile prof : obj.getAllTargetProfiles()) {
                EntryPointFactory.getResolvedProfileErrors(obj, prof, errors, Intl.intl("Change profile or remove profile from target profiles list."));
            }
            return errors;
        });
        EntryPointFactory.registerIcon(ChangeProfileProp.class, changeOccProfilePropIcon);
        EntryPointFactory.register(ChangeProfileProp.class, FuncType.TV_GetErrors, (MerlinData md, T obj) -> {
            ArrayList errors = new ArrayList(2);
            Consumer<SimError> addError = errors::add;
            obj.getErrors(addError);
            return errors;
        });
        EntryPointFactory.registerIcon(RevertProfileProp.class, revertOccProfilePropIcon);
        EntryPointFactory.register(RevertProfileProp.class, FuncType.TV_GetErrors, (MerlinData md, T obj) -> {
            Collection<SimError> errors = Collections.emptyList();
            if (obj.get(RevertProfileProp.PROFILE_PROP) == null) {
                errors = EntryPointFactory.lazyAdd(errors, new SimError(SimError.Level.CRITICAL, Intl.intl("A property must be specified."), Intl.intl("Specify a property to change."), (IMerlinObj)obj));
            }
            return errors;
        });
        EntryPointFactory.registerIcon(ChangeTags.class, changeTagsIcon);
        EntryPointFactory.register(ChangeTags.class, FuncType.TV_GetErrors, (MerlinData md, T obj) -> {
            Collection<SimError> errors = Collections.emptyList();
            if (!obj.get(ChangeTags.OPERATION).tagsCanBeEmpty && obj.get(ChangeTags.TAGS).isEmpty()) {
                errors = EntryPointFactory.lazyAdd(errors, new SimError(SimError.Level.CRITICAL, "<html>" + Intl.intl("<i>Tags</i> must not be empty."), Intl.intl("Specify tags in the property panel."), (IMerlinObj)obj));
            }
            return errors;
        });
        EntryPointFactory.registerIcon(CreateAttractor.class, createAttractorIcon);
        EntryPointFactory.register(CreateAttractor.class, FuncType.TV_GetErrors, new EntryPoint.Getter<CreateAttractor, Collection<? extends SimError>>(){

            @Override
            public Collection<? extends SimError> get(MerlinData md, CreateAttractor obj) {
                ArrayList<SimError> errors = new ArrayList<SimError>();
                EntryPointFactory.forEachSuperclass(CreateAttractor.class, superEP -> errors.addAll(superEP.tvEntryPoint.getErrors(md, obj)));
                if (obj.getLocation() == CreateAttractor.LocationMode.FIXED_LOCATION && obj.getFixedRoom() == null) {
                    errors.add(new SimError(SimError.Level.CRITICAL, Intl.intl("Trigger create location is not in a room."), Intl.intl("Move trigger create location to a room."), obj));
                }
                if (obj.getAttractors().isEmpty()) {
                    errors.add(new SimError(SimError.Level.MODERATE, Intl.intl("No triggers selected to create."), Intl.intl("Select a trigger template to create."), obj));
                }
                EntryPointFactory.getBehaviorActionErrors(md, obj, errors);
                return errors;
            }
        });
        EntryPointFactory.registerIcon(DestroyAttractor.class, destroyAtttractorIcon);
        EntryPointFactory.register(DestroyAttractor.class, FuncType.TV_GetErrors, new EntryPoint.Getter<DestroyAttractor, Collection<? extends SimError>>(){

            @Override
            public Collection<? extends SimError> get(MerlinData md, DestroyAttractor obj) {
                ArrayList<SimError> errors = new ArrayList<SimError>();
                EntryPointFactory.forEachSuperclass(DestroyAttractor.class, superEP -> errors.addAll(superEP.tvEntryPoint.getErrors(md, obj)));
                if (obj.getAttractors().isEmpty()) {
                    errors.add(new SimError(SimError.Level.MODERATE, Intl.intl("No triggers selected to destroy."), Intl.intl("Select a trigger template to destroy."), obj));
                }
                EntryPointFactory.getBehaviorActionErrors(md, obj, errors);
                return errors;
            }
        });
        EntryPointFactory.registerIcon(BehaviorRoot.class, behaviorIcon);
        EntryPointFactory.register(MaterialDB.class, FuncType.TV_GetParent, (MerlinData md, T obj) -> null);
        EntryPointFactory.register(Material.class, FuncType.GetCompositeRoot, (MerlinData md, T obj) -> md.materials);
        EntryPointFactory.register(Material.class, FuncType.Delete, new EntryPoint.Action<Material, Boolean, Object>(){

            @Override
            public Boolean perform(MerlinData md, Material obj, Object arg) {
                MaterialDB db = md.materials;
                return db.remove(obj, true);
            }
        });
        EntryPointFactory.register(Material.class, FuncType.TV_GetIcon, new EntryPoint.AsyncGetter<Material, Icon>(){

            @Override
            public Icon get(MerlinData md, Material obj, Consumer<Icon> whenReady) {
                return guiUtil.getIconsAsync(icons -> whenReady.accept(icons[0]), obj, 16, 16, 0, guiUtil.ImageFilter.NORMAL)[0];
            }
        });
        EntryPointFactory.register(Material.class, FuncType.GetConflict, EntryPointFactory.getStandardConflictGetter(Material.class));
        EntryPointFactory.register(JsonObj.class, FuncType.GetCompositeRoot, (MerlinData md, T obj) -> md.json);
        EntryPointFactory.register(JsonObj.class, FuncType.GetNameGenerator, new ConstantGetter(new SequentialNameGen("JsonObj", 2)));
        EntryPointFactory.register(ScriptObj.class, FuncType.GetCompositeRoot, (MerlinData md, T obj) -> md.customScripts);
        EntryPointFactory.register(ScriptObj.class, FuncType.GetNameGenerator, (MerlinData md, T obj) -> md.customScriptNameGen);
        for (Pair<Class<?>, FuncType> funcEntry : s_funcs.keySet()) {
            EntryPointFactory.get((Class)funcEntry.v1);
        }
    }

    private static class CachedWarningsUpdator
    implements IEventObserver {
        private CachedWarningsUpdator() {
        }

        private void updateFitElevator() {
            vehicleNotFitInElevatorCache.clear();
            MerlinData md = MerlinApp.getApp().getData();
            Collection<Elevator> elevators = md.elevators.flatten(Elevator.class);
            if (elevators.isEmpty()) {
                return;
            }
            List vehicles = md.agents.flatten(EgressAgent.class).stream().filter(a -> a.getProfileProp(OccProfile.PROP_VEHICLE_SHAPE) != null).collect(Collectors.toList());
            HashMap<Pair, List> errorCache = new HashMap<Pair, List>();
            IdentityHashMap<List, List> msgCache = new IdentityHashMap<List, List>();
            Function<Pair, List> getError = p -> {
                Collection<GotoElevators> goToElevators = ((Behavior)p.v2).flatten(GotoElevators.class);
                Collection<IBehaviorAction> allActions = ((Behavior)p.v2).flatten(IBehaviorAction.class);
                if (goToElevators.isEmpty()) {
                    return Collections.emptyList();
                }
                Point3d[] points = ((VehicleShape)p.v1).getBodyPoints();
                double area = Util3D.simplePolygonArea(Arrays.asList(points));
                double occArea = Math.PI * Math.pow(0.24, 2.0);
                int correspondingOccCount = (int)Math.round(area / occArea);
                HashMap<Elevator, Boolean> checked = new HashMap<Elevator, Boolean>();
                int actionID = 1;
                int currentHelperCount = 0;
                ArrayList<Pair<Integer, Integer>> errorActionIDs = new ArrayList<Pair<Integer, Integer>>();
                for (IBehaviorAction action : allActions) {
                    if (action instanceof WaitForAssistance) {
                        currentHelperCount += ((VehicleShape)p.v1).getProperty(VehicleShape.PROP_ATTACHED_AGENTS_POSITIONS).length;
                        checked.clear();
                    } else if (action instanceof DetachAssistants) {
                        currentHelperCount = 0;
                        checked.clear();
                    } else if (action instanceof GotoElevators) {
                        GotoElevators gte = (GotoElevators)action;
                        boolean isError = true;
                        Set<Elevator> els = gte.getElevators();
                        if (els.isEmpty()) {
                            els = new HashSet<Elevator>(elevators);
                        }
                        if (els.isEmpty()) {
                            isError = false;
                        }
                        for (Elevator el : els) {
                            int chc;
                            boolean fit = checked.computeIfAbsent(el, arg_0 -> CachedWarningsUpdator.lambda$updateFitElevator$1(correspondingOccCount, chc = currentHelperCount, arg_0));
                            isError &= !fit;
                            if (!fit) continue;
                            break;
                        }
                        if (isError) {
                            errorActionIDs.add(new Pair<Integer, Integer>(actionID, correspondingOccCount + currentHelperCount));
                        }
                    }
                    ++actionID;
                }
                return errorActionIDs;
            };
            Function<List, List> getAgentErrorMsg = errorActionIDs -> {
                ArrayList<SimError> errors = new ArrayList<SimError>(errorActionIDs.size());
                for (Pair action : errorActionIDs) {
                    Integer actionID = (Integer)action.v1;
                    Integer minLoad = (Integer)action.v2;
                    String cause = String.format(Intl.intl("Occupant cannot fit into any elevator in behavior action %1$d, minimum nominal load required is %2$d."), actionID, minLoad);
                    String fix = String.format(Intl.intl("Increase nominal load of at least one elevator used in behavior action:%1$d to %2$d."), actionID, minLoad);
                    errors.add(new SimError(SimError.Level.MODERATE, cause, fix, new IMerlinObj[0]));
                }
                return errors;
            };
            TriFunction<List, OccProfile, Behavior, List> getOccSourceErrorMsg = (errorActionIDs, prof, behavior) -> {
                ArrayList<SimError> errors = new ArrayList<SimError>(errorActionIDs.size());
                for (Pair action : errorActionIDs) {
                    Integer actionID = (Integer)action.v1;
                    Integer minLoad = (Integer)action.v2;
                    String cause = String.format(Intl.intl("Occupants generated with profile, \"%1$s\", and behavior, \"%2$s\", cannot fit into any elevator in behavior action %3$d, minimum nominal load required is %4$d."), prof.getName(), behavior.getName(), actionID, minLoad);
                    String fix = String.format(Intl.intl("Increase Nominal Load of at least one elevator used in behavior action %1$d to %2$d."), actionID, minLoad);
                    errors.add(new SimError(SimError.Level.MODERATE, cause, fix, (IMerlinObj)prof, (IMerlinObj)behavior));
                }
                return errors;
            };
            for (EgressAgent a2 : vehicles) {
                Behavior b;
                VehicleShape vs = (VehicleShape)a2.getProfileProp(OccProfile.PROP_VEHICLE_SHAPE);
                List errorActions = errorCache.computeIfAbsent(new Pair<VehicleShape, Behavior>(vs, b = a2.getBehavior()), getError);
                if (errorActions.isEmpty()) continue;
                List errorMsg = msgCache.computeIfAbsent(errorActions, getAgentErrorMsg);
                vehicleNotFitInElevatorCache.put(a2, errorMsg);
            }
            errorCache.clear();
            msgCache.clear();
            for (OccSourceObj source : md.occSources.flatten(OccSourceObj.class)) {
                ArrayList errors = new ArrayList();
                for (OccProfile prof2 : ((IUrn)source.getProperty(OccSourceObj.PROP_PROFILE_DIST)).getWeights().keySet()) {
                    VehicleShape vs = prof2.getProperty(OccProfile.PROP_VEHICLE_SHAPE);
                    if (vs == null) continue;
                    for (Behavior b : ((IUrn)source.getProperty(OccSourceObj.PROP_BEHAVIOR_DIST)).getWeights().keySet()) {
                        List errorActions = errorCache.computeIfAbsent(new Pair<VehicleShape, Behavior>(vs, b), getError);
                        if (errorActions.isEmpty()) continue;
                        List errorMsg = (List)msgCache.get(errorActions);
                        if (errorMsg == null) {
                            errorMsg = getOccSourceErrorMsg.apply(errorActions, prof2, b);
                            msgCache.put(errorActions, errorMsg);
                        }
                        errors.addAll(errorMsg);
                    }
                }
                if (errors.isEmpty()) continue;
                vehicleNotFitInElevatorCache.put(source, errors);
            }
        }

        private void updateOccSourceExitDoorWarnings() {
            MerlinData md = MerlinApp.getApp().getData();
            occSourceExitDoorWarnings.clear();
            for (OccSourceObj occSource : md.occSources.flatten(OccSourceObj.class)) {
                IEgressComp comp;
                if (!occSource.isEnabled() || (comp = occSource.getComponent()) == null || !(comp instanceof EgressDoor) || !((EgressDoor)comp).isExit()) continue;
                ArrayList<SimError> errors = new ArrayList<SimError>();
                for (Behavior b : ((IUrn)occSource.getProperty(OccSourceObj.PROP_BEHAVIOR_DIST)).getWeights().keySet()) {
                    GotoExits gotoExits;
                    Collection<IBehaviorAction> goals = b.flatten(IBehaviorAction.class);
                    IBehaviorAction firstGoal = goals.iterator().next();
                    if (firstGoal == null || !(firstGoal instanceof GotoExits) || !(gotoExits = (GotoExits)firstGoal).isGotoAny() && !((Set)gotoExits.getProperty(GotoExits.PROP_EXITS)).contains(comp)) continue;
                    String cause = String.format(Intl.intl("Occupants generated with behavior:\"%s\" will immediately exit through the door to which this occupant source is attached."), b.getName());
                    String fix = String.format(Intl.intl("Change the first action in behavior:\"%s\" ."), b.getName());
                    errors.add(new SimError(SimError.Level.MODERATE, cause, fix, occSource, b, comp));
                }
                if (errors.isEmpty()) continue;
                occSourceExitDoorWarnings.put(occSource, errors);
            }
        }

        private static void updateDoubleDeckElevatorWarnings() {
            MerlinData md = MerlinApp.getApp().getData();
            doubleDeckElevatorWarnings.clear();
            for (Elevator elevator : md.elevators.getDeepMembers(Elevator.class)) {
                ElevatorRoom room;
                Object enabledObj = elevator.getProperty(MerlinData.ENABLED);
                boolean enabled = enabledObj instanceof Boolean && (Boolean)enabledObj != false || !(enabledObj instanceof Boolean);
                if (!enabled || !elevator.isDoubleDeck()) continue;
                ArrayList<SimError> errors = new ArrayList<SimError>();
                ElevatorRoom dischargeRoom = elevator.getDischargeRoom();
                ArrayList<ElevatorRoom> rooms = new ArrayList<ElevatorRoom>(elevator.getDeepMembers(ElevatorRoom.class));
                int index = 0;
                Iterator iterator = rooms.iterator();
                while (iterator.hasNext() && dischargeRoom != (room = (ElevatorRoom)iterator.next())) {
                    ++index;
                }
                assert (index < rooms.size());
                int beforeDischarge = index;
                int afterDischarge = rooms.size() - index - 2;
                boolean incorrectNumberOfLevels = false;
                if (rooms.size() < 4) {
                    errors.add(new SimError(SimError.Level.CRITICAL, Intl.intl("Double-deck elevator has to contain at least 4 levels."), Intl.intl("Connect the double-deck elevator to additional levels."), elevator));
                    incorrectNumberOfLevels = true;
                }
                if (beforeDischarge % 2 != 0) {
                    errors.add(new SimError(SimError.Level.CRITICAL, Intl.intl("Double-deck elevator has to contain an even number of levels under the discharge level."), Intl.intl("Make sure the double-deck elevator contains even number of levels under the discharge level."), elevator));
                    incorrectNumberOfLevels = true;
                }
                if (afterDischarge < 0) {
                    errors.add(new SimError(SimError.Level.CRITICAL, Intl.intl("Double-deck elevator has to contain at least one level above the discharge level."), Intl.intl("Make sure the double-deck elevator contains at least one level above the discharge level."), elevator));
                    incorrectNumberOfLevels = true;
                } else if (afterDischarge % 2 != 0) {
                    errors.add(new SimError(SimError.Level.CRITICAL, Intl.intl("Double-deck elevator has to contain an even number of levels above the upper discharge level."), Intl.intl("Make sure the double-deck elevator contains even number of levels above the upper discharge level."), elevator));
                    incorrectNumberOfLevels = true;
                }
                if (!incorrectNumberOfLevels) {
                    double dischargeBottomHeight = dischargeRoom.getBounds().getMinZ();
                    double dischargeTopHeight = ((ElevatorRoom)rooms.get(index + 1)).getBounds().getMinZ();
                    double dischargeTopToBottom = dischargeTopHeight - dischargeBottomHeight;
                    for (int i = 0; i < rooms.size(); i += 2) {
                        ElevatorRoom er1 = (ElevatorRoom)rooms.get(i);
                        ElevatorRoom er2 = (ElevatorRoom)rooms.get(i + 1);
                        double er1Height = er1.getBounds().getMinZ();
                        double er2Height = er2.getBounds().getMinZ();
                        double distanceTopToBottom = er2Height - er1Height;
                        if (theUtil.eq(distanceTopToBottom, dischargeTopToBottom, 1.0E-6)) continue;
                        errors.add(new SimError(SimError.Level.CRITICAL, Intl.intl("Distances between odd and even elevator levels within pairs of levels in a double-deck elevator have to be equal to the distance between discharge floors."), Intl.intl("Change height of floors to match the requirement."), elevator));
                        break;
                    }
                    if (elevator.getConnectedFloor((ElevatorRoom)rooms.get(index + 1)) == null) {
                        errors.add(new SimError(SimError.Level.CRITICAL, Intl.intl("Elevator is not connected at its upper discharge floor."), Intl.intl("Make sure the elevator's doors are enabled at the upper discharge floor or change the elevator's discharge floor."), elevator));
                    }
                }
                if (errors.isEmpty()) continue;
                doubleDeckElevatorWarnings.put(elevator, errors);
            }
        }

        /*
         * Exception decompiling
         */
        private static void updateNotEnoughAssistingAgentsTeams() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.UnsupportedOperationException
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
             *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public void update(Events events) {
            Predicate<Class> isModified = type -> {
                IEventRecord rec = events.getEvents(type, new Class[0]);
                return rec.isModified() && (!rec.areChangesOnly() || !rec.areChangesExclusiveTo(MerlinData.SELECTION_CHANGED));
            };
            if (isModified.test(OccProfile.class) || isModified.test(EgressAgent.class) || isModified.test(OccSourceObj.class) || isModified.test(Behavior.class) || isModified.test(VehicleShape.class)) {
                CachedWarningsUpdator.updateNotEnoughAssistingAgentsTeams();
                assistWarnings.clear();
            }
            if (isModified.test(OccProfile.class) || isModified.test(EgressAgent.class) || isModified.test(OccSourceObj.class) || isModified.test(Behavior.class) || isModified.test(VehicleShape.class) || isModified.test(Elevator.class)) {
                this.updateFitElevator();
            }
            if (isModified.test(OccSourceObj.class) || isModified.test(Behavior.class) || isModified.test(EgressDoor.class)) {
                this.updateOccSourceExitDoorWarnings();
            }
            if (isModified.test(Elevator.class)) {
                CachedWarningsUpdator.updateDoubleDeckElevatorWarnings();
            }
            if (isModified.test(OccGroupObj.class)) {
                this.updateOccsInMultipleGroupsWarnings();
            }
            if (isModified.test(Behavior.class) || isModified.test(ChangeBehavior.class)) {
                this.updateBehaviorGoesToOccTarget();
            }
            if (isModified.test(Behavior.class) || isModified.test(EgressAgent.class) || isModified.test(IEgressOccupiable.class)) {
                this.updateRefugeRoomSizeWarnings();
            }
        }

        private void updateBehaviorGoesToOccTarget() {
            MerlinData md = MerlinApp.getApp().getData();
            behaviorGoesToOccTargets.clear();
            for (Behavior behavior : md.behaviors.flatten(Behavior.class)) {
                if (!behavior.somePathsContain(GotoOccTarget.class)) continue;
                behaviorGoesToOccTargets.add(behavior);
            }
        }

        private void updateOccsInMultipleGroupsWarnings() {
            MerlinData md = MerlinApp.getApp().getData();
            occGroupWarnings.clear();
            LinkedIdentityHashMap<EgressAgent, List> groupMap = new LinkedIdentityHashMap<EgressAgent, List>();
            LinkedIdentityHashMap<EgressAgent, List> proxyMap = new LinkedIdentityHashMap<EgressAgent, List>();
            for (OccGroupObj group : md.occGroups.flatten(OccGroupObj.class)) {
                for (Proxy proxy : group.flatten(Proxy.class)) {
                    Object obj;
                    Object enabled = proxy.getProperty(MerlinData.ENABLED);
                    if (!(enabled instanceof Boolean) || !((Boolean)enabled).booleanValue() || !((obj = proxy.getObj()) instanceof EgressAgent)) continue;
                    EgressAgent a = (EgressAgent)obj;
                    groupMap.compute(a, (key, val) -> {
                        if (val == null) {
                            val = new ArrayList<OccGroupObj>();
                        }
                        val.add(group);
                        return val;
                    });
                    proxyMap.compute(a, (key, val) -> {
                        if (val == null) {
                            val = new ArrayList<Proxy>();
                        }
                        val.add(proxy);
                        return val;
                    });
                }
            }
            for (EgressAgent a : groupMap.keySet()) {
                List groups = (List)groupMap.get(a);
                List proxies = (List)proxyMap.get(a);
                assert (groups != null);
                if (groups.size() <= 1) continue;
                Object error = String.format(Intl.intl("Occupants can only participate in a single movement group. Occupant %s is a member of following movement groups: "), a.getName());
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < groups.size(); ++i) {
                    OccGroupObj group = (OccGroupObj)groups.get(i);
                    sb.append(group.getName());
                    if (i >= groups.size() - 1) continue;
                    sb.append(", ");
                }
                error = (String)error + sb.toString() + ".";
                String fix = String.format(Intl.intl("Make sure occupant %s is a member of at most one movement group."), a.getName());
                for (Proxy proxy : proxies) {
                    occGroupWarnings.put(proxy, Collections.singletonList(new SimError(SimError.Level.CRITICAL, (String)error, fix, proxy)));
                }
            }
        }

        private void updateRefugeRoomSizeWarnings() {
            MerlinData md = MerlinApp.getApp().getData();
            refugeRoomSizeWarnings.clear();
            Collection refugeRoomBehaviors = md.behaviors.flatten(Behavior.class).stream().filter(b -> {
                Optional<IBehaviorAction> last = b.getLastAction();
                if (!last.isPresent()) {
                    return false;
                }
                return last.get() instanceof GotoRooms && ((GotoRooms)last.get()).getFilter() instanceof RefugeFilter;
            }).collect(Collectors.toList());
            for (Behavior b1 : refugeRoomBehaviors) {
                GotoRooms b1Action = (GotoRooms)b1.getLastAction().get();
                Collection<Object> b1TargetRooms = Collections.emptyList();
                try {
                    b1TargetRooms = b1Action.getDestination().getExitComponents();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                int totalCapacity = 0;
                for (Object object : b1TargetRooms) {
                    if (!(object instanceof IEgressOccupiable)) continue;
                    IEgressOccupiable room = (IEgressOccupiable)object;
                    double density = 1.0 / PredefOccArea.Token.WAITING_SPACES.area.getValue(SIUS.unit(2));
                    double area = room.getArea().getValue(SIUS.unit(4));
                    totalCapacity += KnownFuncs.maxPersons(area, density);
                }
                int numAgents = md.agents.flatten(EgressAgent.class, a -> a.getBehavior() == b1).size();
                for (Behavior b2 : refugeRoomBehaviors) {
                    if (b2 == b1) continue;
                    GotoRooms b2Action = (GotoRooms)b2.getLastAction().get();
                    Collection<Object> b2TargetRooms = Collections.emptyList();
                    try {
                        b2TargetRooms = b2Action.getDestination().getExitComponents();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        continue;
                    }
                    if (b2TargetRooms.isEmpty() || !b1TargetRooms.containsAll(b2TargetRooms)) continue;
                    numAgents += md.agents.flatten(EgressAgent.class, a -> a.getBehavior() == b2).size();
                }
                if (numAgents <= totalCapacity) continue;
                String string = String.format(Intl.intl("Refuge rooms are not large enough for all occupants seeking refuge."), b1Action.getName());
                String fix = "";
                refugeRoomSizeWarnings.put(b1Action, Collections.singletonList(new SimError(SimError.Level.MODERATE, string, fix, b1Action)));
            }
        }

        private static /* synthetic */ List lambda$updateNotEnoughAssistingAgentsTeams$9(Map rounds, int[] noCount, Pair pair) {
            VehicleShape shape = (VehicleShape)pair.v1;
            Behavior behavior = (Behavior)pair.v2;
            List errors = Collections.emptyList();
            int goalIx = 0;
            for (IBehaviorAction action : behavior.flatten(IBehaviorAction.class)) {
                if (!(action instanceof WaitForAssistance)) {
                    ++goalIx;
                    continue;
                }
                WaitForAssistance wfa = (WaitForAssistance)action;
                int maxHelpersRemaining = 0;
                if (rounds.isEmpty()) {
                    maxHelpersRemaining = shape.getProperty(VehicleShape.PROP_ATTACHED_AGENTS_POSITIONS).length;
                } else {
                    Set<AssistedEvacTeam> requestedTeams = wfa.get(WaitForAssistance.TEAMS);
                    block1: for (Map teamAssists : rounds.values()) {
                        int helpersRemaining = shape.getProperty(VehicleShape.PROP_ATTACHED_AGENTS_POSITIONS).length;
                        Set<AssistedEvacTeam> teams = requestedTeams.isEmpty() ? teamAssists.keySet() : requestedTeams;
                        for (AssistedEvacTeam team : teams) {
                            int nassists = teamAssists.getOrDefault(team, noCount)[0];
                            if ((helpersRemaining -= nassists) > 0) continue;
                            maxHelpersRemaining = 0;
                            break block1;
                        }
                        maxHelpersRemaining = Math.max(maxHelpersRemaining, helpersRemaining);
                    }
                }
                if (maxHelpersRemaining > 0) {
                    if (errors.isEmpty()) {
                        errors = new ArrayList(1);
                    }
                    errors.add(new int[]{goalIx, maxHelpersRemaining});
                }
                ++goalIx;
            }
            return errors;
        }

        private static /* synthetic */ double lambda$updateNotEnoughAssistingAgentsTeams$8(MerlinData md, OccSourceObj os) {
            IFunction1d flowRate = os.get(OccSourceObj.PROP_FLOW_RATE);
            return flowRate.getMaxNumOccs(os.getSeed(), md.simParams.runTimeMax);
        }

        private static /* synthetic */ int[] lambda$updateNotEnoughAssistingAgentsTeams$7(Behavior b) {
            return new int[]{0};
        }

        private static /* synthetic */ Boolean lambda$updateFitElevator$1(int correspondingOccCount, int chc, Elevator elev) {
            double load = elev.getNominalLoad().get(Unit.ONE);
            return (double)(correspondingOccCount + chc) <= load;
        }
    }

    private static class AssistState
    implements Cloneable {
        public int numVehicleAttachPoints = -1;
        public boolean requiresAssistance = false;
        public boolean waitingForOrReceivingAssistance = false;
        public OccProfile lastProfile;

        public AssistState(OccProfile profile) {
            this.update(profile);
        }

        public void update(OccProfile prof) {
            this.lastProfile = prof;
            this.updateShape(prof.getProperty(OccProfile.PROP_VEHICLE_SHAPE));
            this.requiresAssistance = EntryPointFactory.requiresAssistance(prof);
        }

        public void update(ChangeProfileProp<?> changeProp) {
            IPropertySet.Prop<?> prop = changeProp.getProp();
            if (prop == OccProfile.PROP_SHAPE) {
                OccProfile.OccShape occShape = (OccProfile.OccShape)changeProp.getValue();
                this.updateShape(occShape.vehicleShape);
            } else if (prop == OccProfile.PROP_VEHICLE_SHAPE) {
                this.updateShape((VehicleShape)changeProp.getValue());
            } else if (prop == OccProfile.PROP_REQUIRES_ASSISTANCE) {
                this.requiresAssistance = EntryPointFactory.requiresAssistance((IUrn)changeProp.getValue());
            }
        }

        public void update(RevertProfileProp<?> resetProp) {
            IPropertySet.Prop<?> prop = resetProp.getProp();
            if (prop == OccProfile.PROP_SHAPE || prop == OccProfile.PROP_VEHICLE_SHAPE) {
                this.updateShape(this.lastProfile.getProperty(OccProfile.PROP_VEHICLE_SHAPE));
            } else if (prop == OccProfile.PROP_REQUIRES_ASSISTANCE) {
                this.requiresAssistance = EntryPointFactory.requiresAssistance(this.lastProfile);
            }
        }

        private void updateShape(VehicleShape shape) {
            this.numVehicleAttachPoints = shape == null ? -1 : shape.getProperty(VehicleShape.PROP_ATTACHED_AGENTS_POSITIONS).length;
        }

        public int hashCode() {
            return 0xB3234A ^ Objects.hash(this.numVehicleAttachPoints, this.requiresAssistance, this.waitingForOrReceivingAssistance);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof AssistState)) {
                return false;
            }
            AssistState as = (AssistState)obj;
            return as.numVehicleAttachPoints == this.numVehicleAttachPoints && as.requiresAssistance == this.requiresAssistance && as.waitingForOrReceivingAssistance == this.waitingForOrReceivingAssistance;
        }

        public AssistState clone() {
            try {
                return (AssistState)super.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }
    }

    private static class CannotTraceException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        private CannotTraceException() {
        }
    }

    public static class CompositeSimError
    extends SimError {
        public final int errorCount;

        public CompositeSimError(SimError.Level level, int errorCount, Collection<? extends IMerlinObj> causeObjs) {
            super(level, Integer.toString(errorCount), "", causeObjs);
            this.errorCount = errorCount;
        }
    }

    private static abstract class MVMgrConstructor<T>
    implements EntryPoint.Action<T, Collection<? extends IMerlinDispMgr<?>>, ModelView> {
        private Collection<? extends IMerlinDispMgr<?>> d_managers;

        private MVMgrConstructor() {
        }

        @Override
        public Collection<? extends IMerlinDispMgr<?>> perform(MerlinData md, T obj, ModelView mv) {
            if (this.d_managers != null) {
                return this.d_managers;
            }
            this.d_managers = this.create(md, obj, mv);
            return this.d_managers;
        }

        protected abstract Collection<? extends IMerlinDispMgr<?>> create(MerlinData var1, T var2, ModelView var3);
    }

    private static class NullAction<T, ReturnT, ArgT>
    implements EntryPoint.Action<T, ReturnT, ArgT> {
        private final ReturnT d_value;

        public NullAction(ReturnT defReturn) {
            this.d_value = defReturn;
        }

        @Override
        public ReturnT perform(MerlinData md, T obj, ArgT arg) {
            return this.d_value;
        }
    }

    private static class NullSetter<T, ArgT>
    implements EntryPoint.Setter<T, ArgT> {
        private NullSetter() {
        }

        @Override
        public void set(MerlinData md, T obj, ArgT arg) {
        }
    }

    private static class ConstantGetter<T, ReturnT>
    implements EntryPoint.Getter<T, ReturnT> {
        private final ReturnT d_value;

        public ConstantGetter(ReturnT value) {
            this.d_value = value;
        }

        @Override
        public ReturnT get(MerlinData md, T obj) {
            return this.d_value;
        }
    }

    private static class ConstantAsyncGetter<T, ReturnT>
    implements EntryPoint.AsyncGetter<T, ReturnT> {
        public final ReturnT value;

        public ConstantAsyncGetter(ReturnT value) {
            this.value = value;
        }

        @Override
        public ReturnT get(MerlinData md, T obj, Consumer<ReturnT> whenReady) {
            return this.value;
        }
    }

    private static enum FuncType {
        CheckDelete,
        GetOtherDeleteObjs,
        GetConflict,
        Delete,
        IsAutoDeleteGroup,
        IsVisible,
        SetVisible,
        GetCompositeRoot,
        GetNameGenerator,
        IsIndexed,
        IsMovable,
        ShowBounds,
        TV_GetErrors,
        TV_GetName,
        TV_SetName,
        TV_CanRename,
        TV_GetIcon,
        TV_GetBaseFont,
        TV_IsVisible,
        TV_IsEnabled,
        TV_GetForcedAutoexpand,
        TV_IsLeaf,
        TV_GetChildren,
        TV_GetParent;

    }
}

